<?php
function fn_unlag_tc($aql)
{	
	$list = $aql->Consume(2);
	$plist = array();
	
	$points = $list[1]->value;	
	$lagamount = $list[0]->value;	
	if (is_array($lagamount))
	{
		$lagamount = intval($lagamount[array_keys($lagamount)[0]]);
	}		
	else
		$lagamount = intval($lagamount);
	
	//print_r($lagamount);
	//print_r($points);
	
	if (count($points) == 0)
	{		
		array_push($aql->stack,$list[1]);
		return;
	}
	$fmt = "Y-m-d H:i:s";
	
	//Check for sub-second data...
	
	$diff = new DateInterval('PT'.abs($lagamount).'S');
	$tz = new DateTimeZone('UTC');
	for($px=0;$px < count($points);$px++)
	{
		//print_r($points[$px]);
		if ($points[$px]->history !== FALSE)
		{
			if (is_array($points[$px]->history))
			{
				for($hp=0;$hp<count($points[$px]->history);$hp++)
				{					
					$fmt = "Y-m-d H:i:s";
					if (strpos($points[$px]->history[$hp][0],'.') !== FALSE)
					{
						$fmt = "Y-m-d H:i:s.u";						
					}
					
					$dated = DateTimeImmutable::createFromFormat($fmt,$points[$px]->history[$hp][0],$tz);
					//echo 'Changing '.$dated->format($fmt).' to...';
					if ($lagamount < 0)
					{				
						$dated = $dated->sub($diff);
						$points[$px]->history[$hp][0] = $dated->format($fmt);
					}
					else
					{
						$dated = $dated->add($diff);
						$points[$px]->history[$hp][0] = $dated->format($fmt);		
					}
					//echo '...'.$dated->format($fmt).'<br/>';
				}
			}			
		}
	}
		
	$list[1]->value = $points;
		
	array_push($aql->stack,$list[1]);
	return;

}

function fn_unlag_tt($aql)
{	
	$list = $aql->Consume(2);
	$plist = array();
	
	$map = $list[1]->value;	
	$lagamount = $list[0]->value;
	if (!is_array($lagamount))
	{
		$lagamount = array($lagamount);
	}
	
	if (count($lagamount) > 0)
	{
		if ($lagamount[0]->dynamic == "")
		{
			LiveValuesForPoints($lagamount);
		}
	}
			
	$lagamount = $lagamount[0];	
	$lagamount = $lagamount->rawvalue;
	
	if (count($map) == 0)
	{		
		array_push($aql->stack,$list[1]);
		return;
	}
		
	if (isset($map['start']))
	{
		$datestart = DateTimeImmutable::createFromFormat("Y-m-d H:i:s",$map['start'],new DateTimeZone('UTC'));
		$dateend = DateTimeImmutable::createFromFormat("Y-m-d H:i:s",$map['end'],new DateTimeZone('UTC'));
	}
	else
	{
		if (isset($map['range']))
		{
			$dateend = DateTimeImmutable::createFromFormat("Y-m-d H:i:s",date("Y-m-d H:i:s"),new DateTimeZone('UTC'));			
			$range = DateInterval::createFromDateString($map['range']);				
			$datestart = $dateend->sub($range);
		}
	}
	
	if (isset($datestart))
	{
		if (is_array($lagamount))
		{
			$lagamount = intval($lagamount[array_keys($lagamount)[0]]);
		}		
		if ($lagamount > 0)
		{
			$diff = new DateInterval('PT'.abs($lagamount).'S');
			$datestart = $datestart->sub($diff);
			$dateend = $dateend->sub($diff);			
		}
		else
		{
			$diff = new DateInterval('PT'.abs($lagamount).'S');
			$datestart = $datestart->add($diff);
			$dateend = $dateend->add($diff);			
		}
		
		if (isset($map['range'])) unset($map['range']);
		$map['start'] = $datestart->format("Y-m-d H:i:s");
		$map['end'] = $dateend->format("Y-m-d H:i:s");
		
		$list[1]->value = $map;
	}
		
	array_push($aql->stack,$list[1]);
	return;

}
?>