<?php
header('Access-Control-Allow-Origin: *');
header('Content-Disposition: inline');
header("Content-Security-Policy: default-src *; connect-src 'self'; unsafe-inline");
session_write_close();
require('aql.php');
//set_time_limit(45);

$query = $_REQUEST['query'];

ob_start();
$aq = new AQLQuery();
$aq->Query($query);
$diagnostics = ob_get_clean();

global $debug;
$debug = false;
if (isset($_REQUEST['debug']))
{
	$debug = true;
}

require_once($installfolder.'/model/property.php');

$raw = false;
if (isset($_REQUEST['raw']))
{
	$raw = true;
}

$humanreadable = true;
if (isset($_REQUEST['ids']))
	$humanreadable = false;

class AQLTable
{
	public $columns;
	public $table;
	public $colstyle;
	public $coldefaults;
	public $aqlquery;
	public $sep = " ";
	
	public $groupby = "";
	public $aggregation = "";
	public $humanreadable = false;
	public $raw = false;
	
	function TrimQuotes($st)
	{
		return str_replace("'","",str_replace("`","",$st));
	}	
	
	function Tabulate($aq)
	{
		$allprops = Properties::GetAllProperties();
		
		$this->columns = array();
		$this->table = array();		
		
		$currenttime = new DateTime();
		$currenttime = $currenttime->format("Y-m-d h:i:s");
				
		$forcestepped = array();
		if (isset($_REQUEST['step']))
		{
			$forcestepped = explode(',',$_REQUEST['step']);
		}
				
		foreach($aq->base->stack as $result)
		{			
			//Gather all of the column names...
			if ($result->typename == "pointlist")
			{			
				$basename = "";
				if ($result->name != "") $basename = " ".$result->name;
				
				foreach($result->value as $val)
				{
					$ass = new Asset($val->assetid);
					$prop = FALSE;
					foreach($allprops as $px)
					{
						if ($px->id == $val->propertyid)
						{						
							$prop = $px;
							break;
						}
					}
					
					if ($prop === FALSE) 
					{					
						continue;
					}
					
					if ($this->humanreadable == true)
						$column = $ass->name.$this->sep.$prop->name.$basename;
					else
						$column = $ass->id.':'.$prop->id.$basename;
					
					$this->columns[] = $column;
					if (($prop->type == "STATUS") || ($prop->type == "LOOKUP") || ($prop->type == "ENUM") || ($prop->type == "TEXT") || ($prop->type == "ID"))
					{
						$this->colstyle[] = "D";	
					}
					else
					{
						if (in_array($prop->name,$forcestepped))
							$this->colstyle[] = "D";
						else
							$this->colstyle[] = "C";	
					}					
					if ($this->raw == true)
						$this->coldefaults[] = $val->rawvalue;
					else
						$this->coldefaults[] = $val->value;
				}
			}
		}
		
		//print_r($aq->base->stack);
		
		$bump = 0;
		foreach($aq->base->stack as $result)
		{						
			//echo 'New Result Set From '.$bump.'<br/>';
			if ($result->typename == "pointlist")
			{
					
				$indx = $bump-1;
				foreach($result->value as $val)
				{
					$indx++;
					if ($val->propertyid < 0) continue;
													
					if ((isset($val->history)) && ($val->history !== FALSE))
					{
						//This has history information...
						foreach($val->history as $tv)
						{
							//echo 'Write '.$indx.'<br/>';
							$this->Record($indx,$tv[0],$tv[1]);
						}
					}
					else
					{
						//Just channel data. We won't record this until we know when the first timestamp occurs.						
						$this->colstyle[$indx] = $this->colstyle[$indx].'E';						
						if ($this->raw == true)
							$this->coldefaults[] = $val->rawvalue;
						else
							$this->coldefaults[] = $val->value;
						//echo 'Raw Data @ '.$indx.' = '.$val->value;
						//print_r($val);
					}
				}
			}
			
			
			$keys = array_keys($this->table);
			sort($keys);
			if (count($this->table) > 0)
			{
				$currenttime = $keys[0];
			}
			
			
			for($x=$bump;$x<count($result->value);$x++)
			{			
				if (isset($this->colstyle[$x]))
				{
					if (($this->colstyle[$x] == 'CE') || ($this->colstyle[$x] == 'DE'))
					{
						$this->Record($bump + $x,$currenttime,$this->coldefaults[$x]);					
					}
				}
			}
			
			$bump += count($result->value);
		}		
		
		//usort($this->table,SortByIndex);
				
		$this->JoinChannels();
		
		return true;
	}
	
	function Record($col,$tm,$vl)
	{	
		if (!isset($this->table[$tm]))
		{			
			$this->table[$tm] = array_fill(0,count($this->columns),FALSE);			
		}
		$this->table[$tm][$col] = $vl;
	}
	
	function JoinChannels()
	{		
		$colcount = count($this->columns);
		$lastvalues = array_fill(0,$colcount,FALSE);
		$lastgoodvalues = array_fill(0,$colcount,FALSE);
		$lastvaluetime = array_fill(0,$colcount,FALSE);
		$laststampindex = array_fill(0,$colcount,0);
		
		//print_r($this->table);
		global $debug;
		if ($debug == true) $counter = 0;
		
		$lasttime = FALSE;
		$stamps = array_keys($this->table);		
		sort($stamps);
		//print_r($stamps);
		
		$stampindex = -1;
		foreach($stamps as $tm)
		{
			$stampindex++;
			/*if ($debug == true)
			{				
				$counter++;
				if ($counter > 9900)
					echo "Checking ".$tm;
				
				if ($counter > 10000)
				{
					break;
				}
			}*/
			//continue;
			
			for($x=0;$x<$colcount;$x++)
			{
				$v = $this->table[$tm][$x];
				if ($v === FALSE)
				{
					//Consider interpolation here...
					if ($lastvaluetime[$x] === FALSE)
					{
						//Can't interpolate - will need to backfill.
					}
					else
					{
						if ($this->colstyle[$x] == "D")
						{
							//If this is discrete, we can forward-fill...
							$this->table[$tm][$x] = $lastgoodvalues[$x];
							$v = $lastgoodvalues[$x];
							$lastvaluetime[$x] = $tm;
						}
						//Otherwise, we should wait until we have a new value we can work with...
					}
				}
				else
				{
					if ($lastvalues[$x] === FALSE) 
					{
						if (($this->colstyle == "D") || (!is_numeric($v)))
						{
							//Need to backfill discrete data.
							$frm = $lastvaluetime[$x];
							foreach($stamps as $tx)
							{
								if ($tx > $tm) break;
								if ($tx <= $frm) continue;
								$this->table[$tx][$x] = $v;
							}
							$this->table[$tm][$x] = $v;							
						}
						else
						{
							//Need to interpolate continuous data.
							$from = $lastvaluetime[$x];
							$dta = $lastvalues[$x];
							if ($dta === FALSE)
							{
								//There is no other side to interpolate between, so backfill...								
								for($q=$laststampindex[$x];$q<=$stampindex;$q++)
								{
									$tx = $stamps[$q];
									if ($tx > $tm) break;
									if ($tx <= $from) continue;
									$this->table[$tx][$x] = $v;
								}								
							}
							else
							{
								//Calculate individual points...
								$diff = ($tm - $frm).total_seconds();																
								for($q=$laststampindex[$x];$q<=$stampindex;$q++)
								{
									$tx = $stamps[$q];								
									if ($tx > $tm) break;
									if ($tx <= $from) continue;
																	
									$pc = ($tx - $from).total_seconds() / $diff;
									$calc = ($pc * $v) + ((1-$px) * $dta);
									
									$this->table[$tx][$x] = $calc;
								}								
							}
						}
					}
					
					$lastgoodvalues[$x] = $v;
					if ($v !== FALSE)
						$laststampindex[$x] = $stampindex;
					$lastvaluetime[$x] = $tm;
				}
				
				$lastvalues[$x] = $v;
			}
		}
		
		for($x=0;$x<$colcount;$x++)
		{
			if ($lastvalues[$x] === FALSE)
			{
				//Forward fill values...
				$frm = $lastvaluetime[$x];
				$v = $lastgoodvalues[$x];
				foreach($stamps as $tx)
				{
					if ($tx > $tm) break;
					if ($tx <= $frm) continue;
					$this->table[$tx][$x] = $v;
				}
				$this->table[$tm][$x] = $v;		
			}
		}
		
		ksort($this->table);
	}
}

function CSVSafe($s)
{
	if (strpos($s,",") > 0)
	{
		return '"'.$s.'"';
	}
	return $s;
}

$anymaps = false;
foreach($aq->base->stack as $result)
{		
	if ($result->typename == "map")
	{
		$anymaps = true;
		break;
	}	
}

if ($anymaps == true)
{
	$columns = array();
	$collookup = array();
	
	foreach($aq->base->stack as $result)
	{		
		if ($result->typename == "map")
		{
			foreach($result->value as $singlemap)
			{
				foreach($singlemap as $k => $v)
				{
					if ($k == "") continue;
					
					if (!in_array($k,$columns))
					{
						$columns[] = $k;
						$collookup[$k] = count($columns)-1;
					}
				}
			}
		}	
	}
	
	header('Content-Type: text/csv');
	
	$first = true;
	foreach($columns as $c)
	{
		if ($first == false)
			echo ",";
		else
			$first = false;
		
		echo CSVSafe($c);
	}
	echo "\r\n";
	
	foreach($aq->base->stack as $result)
	{		
		if ($result->typename == "map")
		{
			foreach($result->value as $singlemap)
			{
				$row = array_fill(0,count($columns),"");
				foreach($singlemap as $k => $v)
				{					
					$row[$collookup[$k]] = CSVSafe($v);
				}
				echo implode(",",$row);
				echo "\r\n";
			}
		}	
	}
	exit();
}

if (strpos($query,"GETHISTORY") === FALSE)
{
	$points = array();
	foreach($aq->base->stack as $result)
	{
		foreach($result->value as $v)
		{
			$points[] = $v;
		}
	}

	LiveValuesForPoints($points);
}

$qry = new AQLTable();
$qry->humanreadable = $humanreadable;
$qry->raw = $raw;
if (isset($_REQUEST['dots']))
{
	$qry->sep = ".";
}
$qry->Tabulate($aq);

$footer = "";
if (isset($_REQUEST['metadata']))
{
	//Include JSON metadata at end of table...
	require_once($installfolder.'/model/property.php');
	$allprops = Properties::GetAllProperties();
	$asx = array();
	$outset = array();
	foreach($aq->base->stack as $result)
	{
		foreach($result->value as $v)
		{			
			$va = array();			
			$va['assetid'] = $v->assetid;
			$va['sourceid'] = $v->sourceid;
			$va['propertyid'] = $v->propertyid;
			$va['node'] = $v->node;
			$va['propertyname'] = $v->name;
			$va['type'] = $v->type;
			$friendly = $v->name;
			$parts = explode(' - ',$v->name);
			if (count($parts) > 1)
			{
				$friendly = $parts[1].' '.$parts[0];
			}
			$va['friendlyname'] = $friendly;
			if (!isset($asx[$v->assetid]))
			{
				$asx[$v->assetid] = new Asset($v->assetid);
			}
			$va['assetname'] = $asx[$v->assetid]->name;
			
			foreach($allprops as $prop)
			{
				if ($prop->id == $v->propertyid)
				{										
					if (($prop->type == "STATUS") || ($prop->type == "ENUM") || ($prop->type == "LOOKUP"))
					{
						$mp = $prop->GetValueMap();
						$va['map'] = $mp;
						/*if (isset($mp[$ele['rawvalue']]))
						{
							$v['value'] = $mp[$p->rawvalue];
						}*/
					}
					
					if ($prop->type == "MEASUREMENT")
					{
						$def = $prop->GetDefault();
						$va['units'] = $def[1];
						$va['min'] = $def[2];
						$va['max'] = $def[3];
						$va['places'] = $def[4];
					}					
					
					//echo $sitefolder.'/cache/display/'.$p->propertyid.'.xml';
					if (file_exists($sitefolder.'/cache/display/properties/'.$prop->id.'.xml'))
					{						
						//Include colour mapping information
						$xml=simplexml_load_file($sitefolder.'/cache/display/properties/'.$prop->id.'.xml');
				
						$cmap = array();
						
						if (property_exists($xml,'colours'))
						{							
							//echo 'Colours Found!';
							$attrs = $xml->colours->attributes();
							$z = "".$attrs['zero'];
							$o = "".$attrs['one'];
							if (($z == "")) $z = 'blue';
							if (($o == "")) $o = 'cyan';							
							$cmap[0] = trim($z);
							$cmap[1] = trim($o);							
						}	
					
						if (property_exists($xml,'value'))
						{														
							foreach($xml->value as $vl)
							{
								$attrs = $vl->attributes();
								$pieces = explode('-',$attrs['value']);
								if ($pieces[0] == "")
								{
									unset($pieces[0]);
									$pieces = array_values($pieces);
									$pieces[0] = '-'.$pieces[0];
								}								
								if (count($pieces) > 1)
								{
									for($x=0;$x<count($pieces);$x++)
									{
										$cmap[$pieces[$x]] = "".$attrs['colour'];
									}
								}
								else
								{
									$cmap["".$attrs['value']] = "".$attrs['colour'];
								}
							}	
						}
						
						if (property_exists($xml,'gradient'))
						{							
							//echo 'Colours Found!';
							$stops = $xml->gradient->attributes()['stops'];			
							
							$range = $va['max'] - $va['min'];
							
							$bits = explode('%25',$stops);							
							foreach($bits as $bt)
							{
								$pieces = explode('_',$bt);
								while((count($pieces) > 0) && ($pieces[0] == ""))
								{
									unset($pieces[0]);
									$pieces = array_values($pieces);
								}
								
								if (count($pieces) < 2) continue;
								
								$cmap[intval((($pieces[1]/100) * $range) + $va['min'])] = $pieces[0];								
							}							
						}	
						
						if (count($cmap) > 0)
						{
							$va['colours'] = $cmap;
						}
					}
					
					break;
				}
			}
			$outset[] = $va;
		}
	}
	
	$footer = json_encode($outset,JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES);
}

$newlines = "\n";
if (isset($_REQUEST['windows'])) $newlines = "\r\n";

$failures = array();
if (array_key_exists('historyfailuremessages', $GLOBALS))
{
	global $historyfailuremessages;
	foreach($historyfailuremessages as $msg)
	{
		$failures[] = 'History '.$msg;
	}
}

if (array_key_exists('eventfailuremessages', $GLOBALS))
{
	global $eventfailuremessages;
	foreach($eventfailuremessages as $msg)
	{
		$failures[] = 'Event '.$msg;
	}
}

$format = "csv";
if (isset($_REQUEST['format']))
{
	$format = $_REQUEST['format'];
}

if (count($failures) > 0)
{
	header('X-ARDI-Failures: '.implode(';',$failures));
	if (isset($_REQUEST['hardfail']))
	{
		//http_response_code(203);
		
		if ($format == "csv")
		{
			header('Content-Type: text/csv');
			echo "Error".$newlines;
			foreach($failures as $c)
			{
				echo CSVSafe($c).$newlines;
			}
		}
		if ($format == "html")
		{
			header('Content-Type: text/html');
			echo "<h3>Error</h3>";
			echo "<ul>";
			foreach($failures as $c)
			{
				echo '<li>'.$c.'</li>';
			}
			echo "</ul>";
		}
		if ($format == "json")
		{
			header('Content-Type: application/json');
			$resp = array();
			$resp['errors'] = $failures;
			echo json_encode($resp);
		}
		exit();
	}
};

if ($format == "csv")
{
	header('Content-Type: text/csv');
	echo "Time";
	foreach($qry->columns as $c)
	{
		echo ",".CSVSafe($c);
	}
	//echo $newlines;
	
	foreach($qry->table as $k => $v)
	{
		echo $newlines.$k;
		foreach($v as $itm)
		{
			echo ','.CSVSafe($itm);
		}
		//echo $newlines;
	}
	exit();
}


if ($format == "html")
{
	header('Content-Type: text/html');
	echo '<table style="width: 100%;"><tr><th>Time</th>';
	foreach($qry->columns as $c)
	{
		echo "<th>".$c.'</th>';
	}
	echo "</tr>";
	
	foreach($qry->table as $k => $v)
	{
		echo '<tr><td>'.$k.'</td>';
		foreach($v as $itm)
		{
			echo '<td>'.$itm.'</td>';
		}
		echo "</tr>";
	}
	echo '</table>';
	exit();
}

if ($format == "json")
{
	header('Content-Type: application/json');
	echo '{ "columns": [ "Time"';

	foreach($qry->columns as $c)
	{
		echo ',"'.$c.'"';
	}
	echo ' ], "data": [';
	
	$first = true;
	foreach($qry->table as $k => $v)
	{
		if ($first == false) echo ',';
		$first = false;
		echo '["'.$k.'"';
		foreach($v as $itm)
		{
			echo ',"'.$itm.'"';
		}
		echo "]";
	}
	echo "]";
	if ($footer != "")
	{
		echo ', "metadata": ';
		echo $footer;
	}
	if (count($failures) > 0)
	{
		echo ', "failures": '.json_encode($failures);
	}
	echo "}";
	exit();	
}

if (($format == "txt") || ($format == "tsv"))
{
	header('Content-Type: text/plain');
	echo "Time";
	foreach($qry->columns as $c)
	{
		echo "\t".str_replace("\t","",$c);
	}
	//echo $newlines;
	
	foreach($qry->table as $k => $v)
	{
		echo $newlines.$k;
		foreach($v as $itm)
		{
			echo "\t".str_replace("\t","",$itm);
		}
		echo $newlines;
	}
	//exit();
}

?>