<?php

/** @dir
	Contains generic AJAX and JSON functions for ARDI.
*/

/** @file

	Search for an Asset
	
	This is the generic JSON/AJAX asset search function, used throughout ARDI.
	
	@param type The type of asset - 0=Normal, 1=Type. Defaults to 0. 
	@param q The string to search for.
	
	@cond
*/

	$groups = array();
	
	$mod = "";
	$hits = array();
	
	$types = array();
		
	$avoid = array();
	
	include_once($installfolder.'/model/property.php');
	$props = Properties::GetAllProperties();
	
	if (isset($_REQUEST['kind']))
	{
		if ($_REQUEST['kind'] == 'prop')
		{
			foreach($props as $px)
			{				
					$bits = array();
					$bits['id'] = $px->id;		
					$human = $px->name;
					$pieces = explode(' - ',$px->name);
					if (count($pieces) > 1)
					{
						$human = $pieces[1].' '.$pieces[0];
					}
					
					$bits['text'] = $human;
					$bits['propname'] = $px->name;
					//$bits['path'] = $v['path'];
					$bits['type'] = 'Property';
					$final[] = $bits;				
			}
		}
		
		if ($_REQUEST['kind'] == 'rel')
		{
			require_once($installfolder.'/model/relationship.php');
			$allrels = Relationships::GetAllRelationships();
			foreach($allrels as $px)
			{
				//if (strpos($px->name,$assetq) !== FALSE)
				//{
					$bits = array();
					$bits['id'] = $px->id;		
					$human = $px->name;			
					
					$bits['text'] = $human;
					$bits['relname'] = $px->name;			
					$bits['type'] = 'Relationship';
					$final[] = $bits;
				//}
			}
		}
		
		if ($_REQUEST['kind'] == 'type')
		{
			$qry = "SELECT type,id,name FROM assets WHERE type=1 ORDER BY name";			
			
			$query = $db->query($qry);
			
			$lastname = "";
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				$bits = array();
				$bits['id'] = $row['id'];						
				
				$bits['text'] = $row['name'];
				$bits['asname'] = $row['name'];			
				$bits['type'] = 'Type';
				$final[] = $bits;			
			}
		}
		
		if ($_REQUEST['kind'] == 'asset')
		{
			$qry = "SELECT type,id,name FROM assets WHERE type=0 ORDER BY name LIMIT 20";			
			
			$query = $db->query($qry);
			
			$lastname = "";
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				$bits = array();
				$bits['id'] = $row['id'];						
				
				$bits['text'] = $row['name'];
				$bits['asname'] = $row['name'];			
				$bits['type'] = 'Asset';
				$final[] = $bits;			
			}
		}
		
		function fcmp($a, $b)
		{
			if ($a['text'] == $b['text']) {
				return 0;
			}
			return ($a['text'] < $b['text']) ? -1 : 1;
		}
		
		usort($final,"fcmp");
		
		header("Content-Type: application/json");
		echo json_encode($final); 
		exit();
	}
	
	$finder = $_REQUEST['q'];
	if (trim($finder) == "")
	{
		return "{}";
	}
	$bits = explode('.',$finder);
	
	$propertyq = "";
	$assetq = $bits[0];
	if (count($bits) > 1)
	{
		$propertyq = $bits[1];
	}
	
	//print_r($avoid);
	
	require_once($installfolder.'/model/asset.php');
	
	$identifiers = array();
	
	foreach($props as $px)
	{
		if ($px->type == "TAG")
		{
			$identifiers[] = $px->id;
		}
		if ($px->type == "ID")
		{
			$identifiers[] = $px->id;
		}
	}
	
	//foreach($types as $t)
	//{
		//$mod = ' AND type = '.$t;
		if (count($identifiers) > 0)
		{
		
			$qry = "SELECT id FROM assets JOIN assetvalues ON (assetvalues.assetid = assets.id) WHERE (assetvalues.value LIKE ".$db->quote('%'.$assetq.'%').")".$mod." AND (propertyid IN (".implode(',',$identifiers).")) ORDER BY name";
			//echo $qry;
			
			$query = $db->query($qry);
			
			$lastname = "";
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				//if ($lastname == $row['name']) continue;		
				if (in_array($row['id'],$hits)) continue;
				if (in_array($row['id'],$avoid)) continue;
				$hits[] = $row['id'];
				
				$groups[] = array();
				$indx = count($groups)-1;
				$groups[$indx]['id'] = $row['id'];
				$thisasset = new Asset($row['id']);
				$groups[$indx]['text'] = $thisasset->name;
				
				$thisasset->Load();
				$nm = $thisasset->GetFullName();
				$groups[$indx]['path'] = trim(substr($nm,0,strlen($nm) - strlen($thisasset->name)));
				$lastname = $thisasset->name;
			}
		};
		
		
		$qry = "SELECT type,id FROM assets WHERE (name LIKE ".$db->quote('%'.$assetq.'%').")".$mod." ORDER BY name";
		//echo $qry;
		
		$query = $db->query($qry);
		
		$lastname = "";
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{
			//if ($lastname == $row['name']) continue;
			if (in_array($row['id'],$hits)) continue;
			if (in_array($row['id'],$avoid)) continue;
			$hits[] = $row['id'];
				
			$groups[] = array();
			$indx = count($groups)-1;
			$groups[$indx]['id'] = $row['id'];
			$thisasset = new Asset($row['id']);
			$groups[$indx]['text'] = $thisasset->name;
			
			$thisasset->Load();
			$nm = $thisasset->GetFullName();
			$groups[$indx]['path'] = trim(substr($nm,0,strlen($nm) - strlen($thisasset->name)));
			$lastname = $thisasset->name;
			if ($row['type'] == 1)
			{
				//echo 'Found A Type!';
				$types[] = $row['id'];
			}
		}
		
		$qry = "SELECT id FROM assets JOIN assetvalues ON (assetvalues.assetid = assets.id) WHERE (assetvalues.value LIKE ".$db->quote('%'.$assetq.'%').")".$mod." ORDER BY name";
		
		$query = $db->query($qry);
		
		$lastname = "";
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{
			if (in_array($row['id'],$hits)) continue;
			if (in_array($row['id'],$avoid)) continue;
			$hits[] = $row['id'];
				
			$groups[] = array();
			$indx = count($groups)-1;
			$groups[$indx]['id'] = $row['id'];
			$thisasset = new Asset($row['id']);
			$groups[$indx]['text'] = $thisasset->name;
			
			$thisasset->Load();
			$nm = $thisasset->GetFullName();
			$groups[$indx]['path'] = trim(substr($nm,0,strlen($nm) - strlen($thisasset->name)));
			$lastname = $thisasset->name;
		}
	//}
	
	$final = array();
	
	foreach($hits as $ht)
	{
		$bits = array();
		$bits['id'] = $ht;		
		$human = $px->name;
		$pieces = explode(' - ',$px->name);
		if (count($pieces) > 1)
		{
			$human = $pieces[1].' '.$pieces[0];
		}
		$asx = new Asset($ht);
		$bits['text'] = $asx->name;
		$bits['asname'] = $asx->name;
		//$bits['path'] = $v['path'];
		if (in_array($ht,$types))
			$bits['type'] = 'Type';
		else
			$bits['type'] = 'Asset';
		$final[] = $bits;
	}
	
	foreach($props as $px)
	{
		if (strpos($px->name,$assetq) !== FALSE)
		{
			$bits = array();
			$bits['id'] = $px->id;		
			$human = $px->name;
			$pieces = explode(' - ',$px->name);
			if (count($pieces) > 1)
			{
				$human = $pieces[1].' '.$pieces[0];
			}
			
			$bits['text'] = $human;
			$bits['propname'] = $px->name;
			//$bits['path'] = $v['path'];
			$bits['type'] = 'Property';
			$final[] = $bits;
		}
	}
	
	require_once($installfolder.'/model/relationship.php');
	$allrels = Relationships::GetAllRelationships();
	foreach($allrels as $px)
	{
		if (strpos($px->name,$assetq) !== FALSE)
		{
			$bits = array();
			$bits['id'] = $px->id;		
			$human = $px->name;			
			
			$bits['text'] = $human;
			$bits['relname'] = $px->name;			
			$bits['type'] = 'Relationship';
			$final[] = $bits;
		}
	}
		
	foreach($groups as $k => $v)
	{
		$asx = new Asset($v['id']);
		$props = $asx->GetProperties();
		foreach($props as $px)
		{
			$pass = false;
			switch($px->type)
			{
				case 'MEASUREMENT':
				case 'LOOKUP':
				case 'ENUM':
				case 'TEXT':
				case 'STATUS':
					$pass = true;
					break;					
			}
			if ($pass == true)
			{
				if ($propertyq != "")
				{
					$pass = false;
					if (strpos($px->name,$propertyq) !== FALSE)
					{
						$pass = true;
					}						
				}
			}
			if ($pass == true)
			{
				
				$bits = array();
				$bits['id'] = $asx->id;
				$bits['property'] = $px->id;
				$human = $px->name;
				$pieces = explode(' - ',$px->name);
				if (count($pieces) > 1)
				{
					$human = $pieces[1].' '.$pieces[0];
				}
				$bits['text'] = $asx->name.'.'.$human;
				$bits['path'] = $v['path'];
				$bits['type'] = 'Asset Property';
				$bits['propname'] = $px->name;
				$bits['asname'] = $asx->name;
				$final[] = $bits;
			}
			
		}
	}

	$ret = array();
	$ret['results'] = $groups;
	header("Content-Type: application/json");
	echo json_encode($final); 
?>