<?php

$title = "AQL Editor";

include($installfolder.'/include/tmpl.php');
//include($installfolder.'/model/model.php');

global $db;

$path = $sitefolder.'/addons';
if (!file_exists($path))
{
	mkdir($path);
}

require_once($installfolder.'/model/property.php');
?>
<style>
.editorbase {	
	width: 100%;
	padding: 5px;
	background-color: white;
	border: 1px solid black;
}

.suggest {
	width: 100%;
	padding: 0.2em;
	background-color: #EEEEEE;
	border: 1px solid silver;
	margin-bottom: 2px;
}
.finalise {
	width: 100%;
	padding: 0.2em;
	background-color: #DDDDDD;
	border: 1px solid silver;
	margin-bottom: 2px;
}

#aql {
	width: 100%;
	font-size: large;
	margin-bottom: 1em;
}

.acbase {
	margin-bottom: 0.2em;
}

.aql {
	display: inline-block;
	padding: 2px;
	border: 1px solid black;
	margin-right: 1em;
	margin-bottom: 1em;
}

.aql.assetlist {
	background-color: blue;
	color: white;
}

.aql.proplist {
	background-color: green;
	color: white;
}

.aql.assetproplist {
	background-color: white;
	color: black;
}
</style>
<script>
var parseRequest = 0;
var lookups = [];
var results = [];

function ChooseLookup(id)
{
	var leader = "";
	var lu = lookups[id];
	
	var aql = $('#aql').val();
	for(var x=aql.length-1;x >= 0;x--)
	{
		if (aql[x] == "'")
		{
			leader = aql.substr(0,x+1);
			break;
		}
	}
	
	newcontent = "";	
	if (lu.type == 'Asset Property')
	{
		newcontent = lu.asname + "' ASSET '" + lu.propname + "' PROPERTY";		
	}
	if (lu.type == 'Asset')
	{
		newcontent = lu.asname + "' ASSET";		
	}
	if (lu.type == 'Property')
	{
		newcontent = lu.propname + "' PROPERTY";		
	}
	if (lu.type == 'Relationship')
	{
		newcontent = lu.relname + "' RELATIONSHIP";
		if ((results == null) || (results.results == undefined) || ((results.results.length == 1) && (results.results[0].type == 'rellist')))
		{			
			newcontent += " ROOTS";
		}
	}
	if (lu.type == 'Type')
	{
		newcontent = lu.asname + "' OFTYPE";		
	}
	
	var fin = leader + newcontent;
		
	$('#aql').val(fin);
	$('#options').html('');
	RunSample();
}

function RunSample()
{
	$('#options').html("");
	var aql = $('#aql').val();
	if (aql != "")
	{
		$('#preview').html("Please Wait - Query is Running");
		$('.editorbase').html("...");
		$.post('<?php echo $siteroot;?>/aql/api/query',{"query": aql},function (d) {
			results = d;
			layouts = "";
			for(var x=0;x<results.results.length;x++)
			{
				counter = results.results[x].value.length;
				
				typename = results.results[x].type;
				if (typename == "pointlist") 
				{
					layouts += '<span class="aql ' + results.results[x].type + '">points/values (' + counter + ' points';
					if (counter > 0)
					{
						if (results.results[x].value[0].history == undefined)
							layouts += ", live only";
						else
							layouts += ", plus history";
					}
					layouts += ')</span>';
				}
				else					
					layouts += '<span class="aql ' + results.results[x].type + '">' + results.results[x].type + ' (' + counter + ')</span>';
			}
			
			UpdateNextStep();
			
			$('#preview').html(layouts);
		});
	}
}

function SingleItem()
{	
	if (results.results.length >= 1)
	{
		if (results.results[results.results.length-1].value.length > 1)
			return false;
	}
	return true;
}

function UpdateNextStep()
{
	$('.editorbase').html("");
	var layouts = '';
	
	if (results.results.length >= 2)
	{
		if ((results.results[results.results.length-1].type == 'proplist') && (results.results[results.results.length-2].type == 'assetlist'))
		{
			layouts += '<div class="suggest" incl=" VALUES">The <strong>VALUES</strong> command will let you read the values of these properties.</div>';
			layouts += '<div class="suggest" incl=" DVALUES">The <strong>DVALUES</strong> command will get values from assets inside this one.</div>';
			layouts += '<div class="suggest" incl=" UVALUES">The <strong>UVALUES</strong> command will get values from assets within this one.</div>';
		}			
		if ((results.results[results.results.length-1].type == 'proplist') && (results.results[results.results.length-2].type == 'proplist'))
		{
			layouts += '<div class="suggest" incl=" APPEND"><strong>APPEND</strong> these two lists together.</div>';
		}
		if ((results.results[results.results.length-1].type == 'assetlist') && (results.results[results.results.length-2].type == 'assetlist'))
		{
			layouts += '<div class="suggest" incl=" APPEND"><strong>APPEND</strong> these two lists together.</div>';
		}
	}	
	
	if (results.results.length >= 1)
	{
		if ((results.results[results.results.length-1].type == 'pointlist'))
		{
			
			var vx = $('#aql').val();
			if (vx.indexOf("GETHISTORY") <= 0)
			{				
				layouts += '<div class="suggest" incl=" BOUND">Use <strong>BOUND</strong> to show external data only</div>';
				layouts += '<div class="suggest" kind="map" incl=" {\'range\': \'30 minutes\'} GETHISTORY">Add a call to <strong>GETHISTORY</strong> to get historical values.</div>';		
				layouts += '<div class="finalise">Stop here if you want live results</div>';
			}
			else
			{
				if (SingleItem() == false)
				{
					layouts += '<div class="suggest" incl=" UNIQUE">Use <strong>UNIQUE</strong> to make sure no points are duplicated</div>';
				}
				layouts += '<div class="suggest">Refine your GETHISTORY parameters with <strong>grain</strong>, <strong>start</strong> and <strong>end</strong> times.</div>';
				layouts += '<div class="finalise">This query looks complete, unless you want to append more results.</div>';
			}
		}
		
		if ((results.results[results.results.length-1].type == 'proplist'))
		{
			layouts += '<div class="suggest" incl=" ALLPOINTS">Use <strong>ALLPOINTS</strong> to get the property value across all assets</div>';			
			
			layouts += '<div class="finalise">Get Details for These Properties</div>';
		}
		
		if ((results.results[results.results.length-1].type == 'assetlist'))
		{
			layouts += '<div class="suggest" incl=" ALLPOINTS">Use <strong>ALLPOINTS</strong> to get all of the data points on the asset</div>';
			layouts += '<div class="suggest" incl=" AIPOINTS">Use <strong>AIPOINTS</strong> to get the property values suitable for use with AI</div>';			
			if (SingleItem() == false)
			{
				layouts += '<div class="suggest" incl=" FIRST">Use <strong>FIRST</strong> to only use the first item in this list</div>';				
			}
			layouts += '<div class="suggest" incl=" \'" kind="prop">Add a single quote (\') to choose the name of a <strong>property</strong>.</div>';
			layouts += '<div class="suggest" incl=" \'" kind="rel">Add a single quote (\') to choose the name of a <strong>relationship</strong>.</div>';
			layouts += '<div class="finalise">Get Details for These Assets</div>';
		}
		
		if ((results.results[results.results.length-1].type == 'rellist'))
		{
			layouts += '<div class="suggest" incl=" \'ddown\' RELATED">Search for direct child assets</div>';
			layouts += '<div class="suggest" incl=" \'down\' RELATED">Search for down-stream assets (without this one)</div>';
			layouts += '<div class="suggest" incl=" \'downi\' RELATED">Search for down-stream assets (including this one)</div>';
			layouts += '<div class="suggest" incl=" \'dup\' RELATED">Search for direct parent assets</div>';
			layouts += '<div class="suggest" incl=" \'up\' RELATED">Search for up-stream assets (including this one)</div>';
			layouts += '<div class="suggest" incl=" \'upi\' RELATED">Search for up-stream assets (including this one)</div>';
			layouts += '<div class="finalise">Get Details for These Relationships</div>';
		}		
		
		if ((results.results[results.results.length-1].type == 'const'))
		{
			layouts += '<div class="suggest" incl=" ASSET">Use <strong>ASSET</strong> to search for an asset with that name</div>';			
			layouts += '<div class="suggest" incl=" PROPERTY">Use <strong>PROPERTY</strong> to search for a property with that name</div>';			
			layouts += '<div class="suggest" incl=" OFTYPE">Use <strong>OFTYPE</strong> to search for a type with that name</div>';						
			layouts += '<div class="suggest" incl=" RELATIONSHIP">Use <strong>RELATIONSHIP</strong> to search for a relationship with that name</div>';						
		}
	}
	
	
	if (layouts == "")
	{
		layouts += '<div class="suggest" incl="\'">Add a single-quote (\') and start typing the name of a <strong>Asset</strong>, <strong>Type</strong> or <strong>Property</strong>.</div>';
	}
	
	$('.editorbase').html(layouts);
	
	$('.suggest').on('click',function (e) {
		var kind = e.currentTarget.getAttribute("kind");
		if (kind == null) kind = "normal";
		var adding = e.currentTarget.getAttribute("incl");
		if (adding == null) return;
		if (adding == "") return;
		if (kind == "map") adding = adding.replaceAll("'",'"');
		$('#aql').val($('#aql').val() + adding);
		if (adding[adding.length-1] == "'")
		{
			$('#aql').focus();
			var kind = e.currentTarget.getAttribute("kind");
			$.post('<?php echo $siteroot;?>/aql/editor/assetpropertysearch',{"kind": kind},function (d) {
				$('#options').html("");
				lookups = d;
				for(var x=0;x<d.length;x++)
				{
					$('#options').html($('#options').html() + '<a href="#" onclick="ChooseLookup(' + x + '); return false;"><div class="option">' + d[x].text + ' (' + d[x].type + ')</div></a>');
				}
			});
		}
		else
			RunSample();
	});
	
	$('.finalise').on('click',function (e) {
		$('#sendform').submit();
	});
}

function LookupData(dta)
{
	if (dta != "")
	{
		$.post('<?php echo $siteroot;?>/aql/editor/assetpropertysearch',{"q": dta},function (d) {
			$('#options').html("");
			lookups = d;
			for(var x=0;x<d.length;x++)
			{
				$('#options').html($('#options').html() + '<a href="#" onclick="ChooseLookup(' + x + '); return false;"><div class="option">' + d[x].text + ' (' + d[x].type + ')</div></a>');
			}
		});
	}
}

function ParseAQL()
{
	//Get Tokens
	var tokens = [];
	quoted = null;
	var aql = $('#aql').val();
	working = "";
	for(var x=0;x<aql.length;x++)
	{
		if (quoted != null)
		{
			if (aql[x] == quoted)
			{
				quoted = null;
				if (working != "")
					tokens.push(working);
				working = "";
				continue;
			}
			
			working += aql[x];
			continue;
		}
		
		if (aql[x] == "'")
		{
			if (working != "")
				tokens.push(working);
			working = "";
			quoted = "'";
			continue;
		}
		
		if (aql[x] == '"')
		{
			if (working != "")
				tokens.push(working);
			working = "";
			quoted = '"';
			continue;
		}
		
		if (aql[x] == " ")
		{
			if (working != "")
				tokens.push(working);
			working = "";
		}
		
		working += aql[x];
	}
	if (working != "")
	{
		tokens.push(working);
	}
	
	if (quoted != null)
	{
		//Quotes have been left open!
		LookupData(tokens[tokens.length-1]);
	}
	else
	{
		RunSample();
	}
}

function QueueParsing()
{
	if (parseRequest != 0)
	{
		window.clearTimeout(parseRequest);
		parseRequest = 0;		
	}
	parseRequest = window.setTimeout("ParseAQL();",800);
}
</script>
<?php
SS('head');

?>
$('.aqlblock').on('mouseover',function(ev) {
	ShowTip(ev);
});

$('.aqlblock').on('mouseout',function(ev) {
	HideTip(ev);
});

$('.suggest').on('click',function (e) {
	var adding = e.currentTarget.getAttribute("incl");
	$('#aql').val($('#aql').val() + adding);
	if (adding[adding.length-1] == "'")
	{
		$('#aql').focus();
		var kind = e.currentTarget.getAttribute("kind");
		$.post('<?php echo $siteroot;?>/aql/editor/assetpropertysearch',{"kind": kind},function (d) {
			$('#options').html("");
			lookups = d;
			for(var x=0;x<d.length;x++)
			{
				$('#options').html($('#options').html() + '<a href="#" onclick="ChooseLookup(' + x + '); return false;"><div class="option">' + d[x].text + ' (' + d[x].type + ')</div></a>');
			}
		});
	}
	else
		RunSample();
});

if ($('#aql').val() != "")
{
	QueueParsing();
}
<?php
SS('onload');

	T('header-basic','title='.$title);

$msg = "";

require_once($installfolder.'/model/property.php');

$props = Properties::GetAllProperties();

//echo 'Boom!';
//exit;

ST('section','class=content');
	ST('row');
		ST('full');
			ST('box','title=Request');?>
			
				<form method="post" action="<?php echo $siteroot;?>/aql/" id="sendform" autocomplete="off">
					<input type="text" name="query" id="aql" value="" onkeyup="QueueParsing();" autocomplete="off" placeholder="Choose how to start your query..."/>
				</form>
				
				<div class="acbase" id="options">
					
				</div>
				
				<div class="preview" id="preview">
					
				</div>
			
				<div class="editorbase">
					<div class="suggest" incl="'" kind="asset">
						Add a single-quote (') and the name of an <strong>Asset</strong>
					</div>
					<div class="suggest" incl="'" kind="type">
						Add a single-quote (') and the name of an <strong>Type</strong>
					</div>
					<div class="suggest" incl="'" kind="prop">
						Add a single-quote (') and the name of an <strong>Property</strong>
					</div>
					<div class="suggest" incl="'" kind="rel">
						Add a single-quote (') and the name of an <strong>Relationship</strong>
					</div>					
				</div>
        
<?php				
			ET();
		ET();
	ET();
ET();	


?>
	<div class="tooltip">
	</div>
	