<?php

$pagesize = 10;
$pagestart = 0;

$title = "AQL Request";

include($installfolder.'/include/tmpl.php');
//include($installfolder.'/model/model.php');

global $db;

$path = $sitefolder.'/addons';
if (!file_exists($path))
{
	mkdir($path);
}
	
if (!isset($_REQUEST['query']))
{

T('header-basic','title='.$title);

$msg = "";

require_once($installfolder.'/model/property.php');

$props = Properties::GetAllProperties();

ST('section','class=content');
	ST('row');
		ST('full');
			ST('boxform','title=Request|method=POST');?>
        
				<br/><button type="submit" class="btn btn-success">Query</a><?php
					SS('footer');
					ST('ftable');
					
					?>
					<tr><td style="max-width: 200px; width: 200px;"><label>Your Request:</label></td><td style="width: 80%;"><input type="text" name="query" style="width: 100%;"/><br/>
						<a href="<?php echo $siteroot;?>/aql/editor/" class="btn btn-default" style="min-width: 200px; margin-top: 0.2em;">Basic Query Editor</a>
					</td></tr>
					<tr><td style="max-width: 200px; width: 200px;"><label>Options:</label></td><td style="width: 80%;"><input type="checkbox" name="debug" style="margin-right: 1em;"/>Show Explaination</td></tr>
					<!--<tr><td><label>Links:</label></td><td><a href="<?php echo $siteroot.'/aql/api/query?query='.urlencode($_REQUEST['query']);?>">JSON Data</a></td></tr>-->					
					<?php
				ET();
			ET();
		ET();
	ET();	
ET();

}
else
{
	include($installfolder.'/addons/aql/api/aql.php');

	$query = $_REQUEST['query'];

	$dbg = "";
	ob_start();
	$qry = new AQLQuery();
	$qry->Query($query);
	$dbg = ob_get_clean();

	$allprops = Properties::GetAllProperties();

	$points = array();
	
?>
<style>
.aqlblock
{
	border: 1px solid silver;
	padding: 2px;
	margin-right: 0.2em;
	color: white;
	width: auto;
	font-weight: bold;
	display: inline-block;
}

.aqlblock.const
{
	background-color: blue;
}
.aqlblock.assetlist
{
	background-color: green;
}
.aqlblock.proplist
{
	background-color: orange;
}
.aqlblock.function
{
	background-color: yellow;
	color: black;
}
.aqlblock.pointlist
{
	background-color: cyan;
	color: black;
}
.aqlblock.rellist
{
	background-color: purple;	
}
.aqlblock.map
{
	background-color: pink;	
}
.tooltip
{
	background-color: white;
	padding: 5px;
	border: 1px solid black;
	color: black;
	display: none;
	position: absolute;
	pointer-events: none;
	opacity: 1;
}
</style>
<script>
function ShowTip(ev)
{
	var tt = $('.tooltip');
	
	var rct = tt[0].parentElement.getBoundingClientRect();
	tt.css('left',ev.clientX - rct.x);
	tt.css('top',ev.clientY - rct.y);
	tt.html(ev.target.getAttribute("alt"));
	tt.stop();
	tt.fadeIn(500);
}

function HideTip(ev)
{
	var tt = $('.tooltip');	
	tt.stop();
	tt.fadeOut(500);
}
</script>
<?php
SS('head');

?>
$('.aqlblock').on('mouseover',function(ev) {
	ShowTip(ev);
});

$('.aqlblock').on('mouseout',function(ev) {
	HideTip(ev);
});
<?php
SS('onload');

	T('header-basic','title='.$title);

$msg = "";

require_once($installfolder.'/model/property.php');

$props = Properties::GetAllProperties();

//echo 'Boom!';
//exit;

ST('section','class=content');
	ST('row');
		ST('full');
			ST('boxform','title=Request|method=POST');?>
        
				<br/><button type="submit" class="btn btn-success">Query</a><?php
					SS('footer');
					ST('ftable');
					
					?>
					<tr><td style="max-width: 200px;"><label>Your Request:</label></td><td><input type="text" name="query" style="width: 100%;" value="<?php 
	if (isset($_REQUEST['query']))
	{
		echo str_replace('"','&quot;',($_REQUEST['query']));
	}
?>"/></td></tr>
					<tr><td style="max-width: 200px;"><label>Options:</label></td><td><input type="checkbox" name="debug" style="margin-right: 1em;"/>Show Explaination</td></tr>
					<!--<tr><td><label>Links:</label></td><td><a href="<?php echo $siteroot.'/aql/api/query?query='.urlencode($_REQUEST['query']);?>">JSON Data</a></td></tr>-->					
					<?php
				ET();
			ET();
		ET();
	ET();	

	ST('row');
		ST('full');
			ST('box','title=Response');

?>
	<div class="tooltip">
	</div>
	<?php			

	//print_r($qry->base->stack);
	$hashistory = false;
	
	$rsid = 0;
	echo '<p style="font-weight: bold;">'.$_REQUEST['query'].'</p>';
	
	echo '<p><a href="'.$siteroot.'/aql/api/query?query='.urlencode($_REQUEST['query']).'"><button type="button" class="btn btn-default">Raw JSON</button></a><a href="'.$siteroot.'/aql/api/query?simple=true&query='.urlencode($_REQUEST['query']).'"><button type="button" class="btn btn-default" class="margin-left: 1em;">Simplified JSON</button></a>';
	if (strpos($_REQUEST['query'],"GETHISTORY") > 0)
	{
	?>
	<a href="<?php echo $siteroot.'/aql/api/table?format=html&query='.urlencode($_REQUEST['query']);?>"><button type="button" class="btn btn-default">As Table (Web)</button></a>
	<a href="<?php echo $siteroot.'/aql/api/table?format=csv&query='.urlencode($_REQUEST['query']);?>"><button type="button" class="btn btn-default" class="margin-left: 1em;">As Table (CSV)</button></a>
	<a href="<?php echo $siteroot.'/aql/api/table?format=json&query='.urlencode($_REQUEST['query']);?>"><button type="button" class="btn btn-default" class="margin-left: 1em;">As Table (JSON)</button></a>
	<?php
	}
	echo '</p>';
	foreach($qry->base->stack as $result) 
	{
		$pointlist = [];
		if ($rsid >= 1)
		{
			echo "</blockquote>";
		}
		
		$rsid++;
		if ($result->name != "")
			echo "Result Set ".$result->name." (".$result->typename.")<br/><blockquote>";
		else
			echo "Result Set ".$rsid." (".$result->typename.")<br/><blockquote>";
		
		if ($result->typename == "map")
		{
			if (!$result->islist)
			{
				$result->value = array($result->value);
			}
			if (count($result->value) == 0)
			{
				continue;
			}
			echo '<table style="width: 100%;"><thead>';
			foreach($result->value[0] as $k => $v)
			{
				echo '<th>'.$k.'</th>';
			}
			echo '</thead>';
			
			foreach($result->value as $x)
			{		
				echo '<tr>';
				foreach($x as $k => $v)
				{
					echo '<td>'.$v.'</td>';
				}
				echo '</tr>';
			}
			echo '</table>';
			continue;
		}
		
		if ($result->typename == "proplist")
		{
			require_once($installfolder.'/model/property.php');
			$props = Properties::GetAllProperties();
			foreach($result->value as $r)
			{
				foreach($props as $p)
				{
					if ($r == $p->id)
					{
						echo $p->name.' (#'.$r.')<br/>';						
					}
				}
			}
			//print_r($result->value);
			continue;
		}

		if ($result->typename == "rellist")
		{
			require_once($installfolder.'/model/relationship.php');
			$props = Relationships::GetAllRelationships();
			foreach($result->value as $r)
			{
				foreach($props as $p)
				{
					if ($r == $p->id)
					{
						echo $p->name.' (#'.$r.' / '.$p->type.')<br/>';						
					}
				}
			}
			continue;
		}
		
		if ($result->typename == "timelist")
		{			
			foreach($result->value as $r)
			{
				echo $r['from'].' - '.$r['to'].'<br/>';
			}
			continue;
		}

		if ($result->typename == "assetlist")
		{
			foreach($result->value as $v)
			{
				$ass = new Asset($v);
				echo '<a href="'.$siteroot.'/dashboard/'.$v.'">';
				echo $ass->name.' ';
				if ($ass->ern != "")
					echo ' ('.$ass->ern.' / ';
				else
					echo ' (';
				echo '#'.$v.')</a><br/>';				
			}
			continue;
		}
		if ($result->typename == "pointlist")
		{
			$points = array();
			foreach($result->value as $v)
			{
				$points[] = $v;
			}
		}
	
		if ($result->typename == "const")
		{
			if ($result->islist == true)
			{
				echo implode(", ",$result->value);
			}
			else
				echo $result->value;
			continue;
		}		

		LiveValuesForPoints($points);

		echo '<table style="width: 100%;">';
		foreach($points as $p)
		{
			if ($p->propertyid == 0)
			{
				$ass = new Asset($p->assetid);
				echo '<tr><td><a href="'.$siteroot.'/dashboard/'.$p->assetid.'">'.$ass->name.'</a></td></tr>';
			}
			else
			{
				$ass = new Asset($p->assetid);
				echo '<tr><td style="vertical-align: top;"><a href="'.$siteroot.'/dashboard/'.$p->assetid.'">'.$ass->name.'</a>';
				$type = $p->type;
				$name = $p->name;
				
				$bits = explode(' - ',$p->name);
				if (count($bits) > 1)
				{
					$name = $bits[1].' '.$bits[0];
				}
								
				
				if ($p->history !== FALSE)
				{
					echo ' '.$name;
					echo '</td><td style="vertical-align: top;"><table style="width: 100%;">';
					foreach($p->history as $r)
					{
						echo '<tr><td>'.$r[0].'</td><td>'.$r[1].'</td></tr>';
					}
					$hashistory = true;
					echo '</table></td></tr>';
				}
				else
				{	
					switch($type)
					{
						case 'MEASUREMENT':
						case 'TEXT':
						case 'LOOKUP':
						case 'ENUM':
						case 'STATUS':
							echo ' '.$name.' is <strong>'.$p->value;
							echo '</strong></td></tr>';
							break;
						case 'URL':
							$bits = explode('|',$p->fullvalue);
							if (count($bits) > 1)
								echo ' <a href="'.$bits[1].'">'.$bits[0].'</a></td></tr>';
							else
								echo ' <a href="'.$bits[0].'">'.$name.'</a></td></tr>';
							break;
						default:
							echo ' '.$name.' <strong>'.$p->fullvalue;
							echo '</strong></td></tr>';
					}					
				}
			}			
		}
		echo '</table>';
	}
	echo "</blockquote>";
	
	//print_r($qry);
	if ($qry->base->errors != "")
	{		
		echo '<h4>Errors Detected</h4>';
		echo '<p style="color: red; font-weight: bold;">'.str_replace("\n","<br/>",$qry->base->errors).'</p>';
	}
	

				ET();
				
				if (isset($_REQUEST['debug']))
				{
					ST('box','title=Explaination');									
					ProcessDebug($dbg);
					ET();
				}
			ET();
		ET();
	ET();	



}

function ParseArray($arr,$style)
{
	if (strpos($arr,"AQLPoint Object"))
	{
		$items = array();
		$parts = explode("AQLPoint Object",$arr);
		
		$pointname = "";
		foreach($parts as $p)
		{
			$pieces = explode("=>",$p);
			for($chunk=0;$chunk<count($pieces);$chunk++)
			{
				$x = $pieces[$chunk];
				if (strpos($x,"[assetid]") !== FALSE)
				{
					$pointname = explode(" ",trim($pieces[$chunk+1]))[0];
				}
				if (strpos($x,"[propertyid]") !== FALSE)
				{
					#print_r($pieces[$chunk+1].' ----- ');
					#print_r(explode(" ",trim($pieces[$chunk+1])));
					$pointname .= ":".explode(" ",trim($pieces[$chunk+1]))[0];
				}
			}			
			$items[] = "Data Point ".$pointname;
		}
		
		return $items;
	}
	if (strpos($arr,"Array") !== FALSE)
	{
		//echo 'Parsing Array!';
		
		$items = [];
		$state = 0;
		$ps = 0;
		$vl = "";
		for($ps = 7;$ps < strlen($arr)-1;$ps++)
		{
			$chr = $arr[$ps];
			
			if ($chr == '[')
			{
				if ($vl != "")
				{
					$items[] = $vl;
				}
				$vl = "";
				$state = 1;
				continue;
			}
			if ($chr == ']')
			{
				$state = 2;
				continue;
			}			
			
			if ($state == 3)
			{
				$vl .= $chr;
			}
			
			if ($state == 2)
			{
				if (($chr != ' ') && ($chr != '=') && ($chr != '>'))
				{
					$state = 3;
					$vl = $chr;
				}
			}
			
						
		}
		if ($vl != "") $items[] = $vl;
		
		for($i=0;$i<count($items);$i++)
		{
			if ($style == "assetlist")
				$items[$i] = 'Asset #'.$items[$i];
			if ($style == "proplist")
				$items[$i] = 'Property #'.$items[$i];
			if ($style == "rellist")
				$items[$i] = 'Relationship #'.$items[$i];
		}
		return $items;
	}
	else
	{
		//echo 'No Mention of Arrays';
		return array($arr);
	}
}

function FriendlyTypeName($s)
{
	if ($s == 'const')
	{
		return 'Constants';
	}
	if ($s == 'proplist')
	{
		return 'Properties';
	}
	if ($s == 'rellist')
	{
		return 'Relationships';
	}
	if ($s == 'pointlist')
	{
		return 'Points';
	}
	if ($s == 'assetlist')
	{
		return 'Assets';
	}
	if ($s == 'map')
	{
		return 'Map';
	}
	return 'Unknown';
}

function GetConsumption($s)
{
	$final = array();
	$bits = explode("_",$s);
	$items = $bits[count($bits)-1];
	for($x=0;$x<strlen($items);$x++)
	{
		if ($items[$x] == 'a')
			$final[] = 'Assets';
		if ($items[$x] == 'c')
			$final[] = 'Constants';
		if ($items[$x] == 'r')
			$final[] = 'Relationships';
		if ($items[$x] == 'p')
			$final[] = 'Properties';
		if ($items[$x] == 't')
			$final[] = 'Points';
	}
	
	return implode(" + ",$final);
}

function ProcessDebug($dbg)
{
	$lines = explode("<br/>",$dbg);
	//echo 'Processing Debug Info: ';
	
	$dv = "";
	$stackdesc = false;
	foreach($lines as $ln)
	{
		$l = trim($ln);
		//echo $l;
		if ($stackdesc == false)
		{
			//if (strlen($l) <= 5)			
			//	continue;
			
			if ($l == "------")
			{
				//echo 'Spotted Stack Start!<br/>';
				$stackdesc = true;
				$stackdata = [];
				$stackdatavalue = [];
				//echo '<br/>';
			}
			else
			{
				if ((strlen($l) > 5) && (substr($l,0,6) == "Called"))
				{
					//echo 'Function Called!<br/>';
					$ps = strpos($l,'(');
					$nm = substr($l,7,$ps-7);
					echo '<div class="aqlstatement">';
					echo $lastcontent;
					echo '<div class="aqlblock function" alt="Calling AQL Function '.$nm.'">'.$nm.'</div>';
					echo '</div>';
					echo '<blockquote style="font-size: small; margin-bottom: 0px;">';
					$ap = strpos($l,"(");
					$bp = strpos($l,")");
					$cp = strpos($l," in ");
					
					$fn = substr($l,$ap + 1,($bp-$ap)-1);
					$consume = GetConsumption($fn);
					echo "Consumes ".$consume.", Takes ".substr($l,$cp+4);
					echo '</blockquote>';
					
				}
			}
		}
		else
		{
			if ((strlen($l) > 5) && (substr($l,0,6) == "------"))
			{
				$stackdesc = false;
				if (count($stackdata) > 0)				
				{
					$stackdatavalue[] = $dv;
				}
				//print_r($stackdata);
				//print_r($stackdatavalue);
				$l = substr($l,6);
				
				echo '<div class="aqlstatement">';
				$lastcontent = "";
				ob_start();
				for($q=0;$q<count($stackdata);$q++)
				{					
					$counter = 1;
					if (strpos($stackdatavalue[$q],'Array('))
					{
						//Contains an array!						
						if ($stackdatavalue[$q] == null)
						{
							$counter = 0;
						}
						if ($stackdatavalue[$q] == '')
						{
							$counter = 0;
						}
						if ($stackdatavalue[$q] == 'Array( [0] => )')
						{
							$counter = 0;
						}
					}
					if ($counter > 0)
					{
						$items = ParseArray($stackdatavalue[$q],$stackdata[$q]);
						$counter = count($items);
					}
					else
					{
						$items = array('Empty');
					}
					$valuetext = implode(", ",$items);
					//print_r($items);
					echo '<div class="aqlblock '.$stackdata[$q].'" alt="'.$valuetext.'">'.FriendlyTypeName($stackdata[$q]).' ('.$counter.')'.'</div>';
				}
				$lastcontent = ob_get_clean();
				echo $lastcontent;
				echo '</div>';
			}
			
			$pieces = explode(':',$l);
			if (count($pieces) > 1)
			{
				if (is_numeric($pieces[0]))
				{
					if (count($stackdata) > 0)
					{
						$stackdatavalue[] = $dv;
					}
					$stackdata[] = trim($pieces[1]);
					$dv = "";
					continue;
				}			

				$dv .= $l;
			}
			else
			{
				$dv .= $l;
			}
		}
		
		
	}
}

?>
