<?php

$pagesize = 10;
$pagestart = 0;
$showlive = false;

$allassets = array();

function GetAssetByID($id)
{
	global $allassets;
	if (isset($allassets[$id])) return $allassets[$id];
	$allassets[$id] = new Asset($id);
	return $allassets[$id];
}

$title = "Dashboard";

$clustering = true;

require_once($installfolder.'/model/property.php');

$options = array();

global $db;

$id = 0;
$assetset = array();
$propset = array();
$allprops = Properties::GetAllProperties();

$mode = "singleasset";
$overallstyle = "barchart";
$itemwidth = 1;
$itemheight = 3;

$range = FALSE;

$specificid = FALSE;

require_once($installfolder.'/model/relationship.php');
$allrels = Relationships::GetAllRelationships();

$threesixtyrel = -1;
foreach($allrels as $rl)
{
	if ($rl->name == "Visible")
	{
		$threesixtyrel = $rl->id;
	}
}

$zoom = 0;
if (isset($_REQUEST['zoom']))
{
	$zoom = $_REQUEST['zoom'];
}

$structure = "";
if (isset($_SESSION['structure']))
	$structure = $_SESSION['structure'];

if (isset($_REQUEST['from']))
{
	$oldid = $_REQUEST['from'];
	if (isset($_REQUEST['to']))
	{
		$id = $_REQUEST['to'];
		
		$struct = json_decode($structure);
		
		for($x=0;$x<count($struct->panels);$x++)
		{
			if (is_array($struct->panels[$x]->points))
			{
				for($y=0;$y<count($struct->panels[$x]->points);$y++)
				{
					if ($struct->panels[$x]->points[$y]->asset == $oldid)
					{
						$struct->panels[$x]->points[$y]->asset = $id;
					}
				}
			}
		}
		if (property_exists($struct,'asset'))
		{
			$struct->asset = $id;
		}
		
		$fromas = GetAssetByID($oldid);
		$toas = GetAssetByID($id);
		$struct->name = str_replace($fromas->name,$toas->name,$struct->name);
		$structure = json_encode($struct);
		$specificid = $id;
	}
}

if (isset($_REQUEST['range']))
{
	$range = $_REQUEST['range'];
	if ($range == "30min")
	{
		$range = 1800;
		$_REQUEST['range'] = 1800;
	}
	
	if ($range == "")
	{
		$range = FALSE;
		unset($_REQUEST['range']);
	}
}

$markers = array();
if (isset($_REQUEST['markers']))
{
	$mkr = $_REQUEST['markers'];
	$parts = explode("_",$mkr);
	foreach($parts as $p)
	{
		$markers[] = $p;
	}
}

if (isset($_REQUEST['act']))
{	
	$_REQUEST['act'] = strtolower(trim($_REQUEST['act']));
	//print_r($_REQUEST['act']);
	if ($_REQUEST['act'] == 'new')
	{
		$structure = '{"name": "New Dashboard (Live)", "panels": []}';
		if (isset($_REQUEST['id']))
		{
			$_SESSION['structure'] = $structure; 
			header('Location: '.$siteroot.'/dexplore/dash');
			exit;
		}
	}
	if ($_REQUEST['act'] == 'structure')
	{
		$structure = $_REQUEST['asset'];
		$_SESSION['structure'] = $structure;
		header('Location: '.$siteroot.'/dexplore/dash');
		exit;
	}
	if ($_REQUEST['act'] == 'flip')
	{		
		$structure = $_SESSION['structure'];
		$struct = json_decode($structure);
		$anylive = false;
		$anytrend = false;			

		//print("From Structure: ".$structure);
				
		foreach($struct->panels as $pan)
		{
			switch($pan->style)
			{
				case 'line':
				case 'discrete':
					$anytrend = true;
					break;
				default:
					$anylive = true;
					break;
			}
		}
		
		//echo 'Range: '.$range;
		
		if (($range != "") && ($range != "live"))
		{
			//echo "Switching to Historical";			
			$struct->name = str_replace("(Live)","(History)",$struct->name);
			foreach($struct->panels as $pan)
			{
				switch($pan->style)
				{
					case 'barchart':
					case 'gauge':					
						$pan->style = "line";
						break;
					case 'text':
						$pan->style = "discrete";
						break;					
				}

				/*if (property_exists($pan,'x'))
				{
					$ny = ceil($pan->x / 2);
					$nx = $pan->y * 2;
					$nw = $pan->h * 2;
					if ($pan->w > 1)
						$nh = $pan->w;
					else
						$nh = 1;
					
					//$nh = floor($pan->w / 2);
					
					$pan->x = $nx;
					$pan->y = $ny;
					$pan->w = $nw;
					$pan->h = $nh;
				}
				else
				{
					print("No Positions Found");
				}*/
			}
			for($x=0;$x<count($struct->panels);$x++)
			{
				if ($struct->panels[$x]->style == "links")
				{
					unset($struct->panels[$x]);
					$struct->panels = array_values($struct->panels);
					break;
				}
			}
			$structure = json_encode($struct);
			$_SESSION['structure'] = $structure;		
		
			header('Location: dash?range='.$range);
			exit();
		}
		else
		{
			$struct->name = str_replace("(History)","(Live)",$struct->name);
			foreach($struct->panels as $pan)
			{
				switch($pan->style)
				{
					case 'line':					
						$pan->style = "barchart";
						break;
					case 'discrete':
						$pan->style = "text";
						break;
				}

				/*if (property_exists($pan,'x'))
				{
					$nx = $pan->y;
					$ny = $pan->x / 2;
					$nh = $pan->w / 2;
					if ($pan->h == 1)
						$nw = 1;
					else
						$nw = $pan->h;
					
					$pan->x = $nx;
					$pan->y = $ny;
					$pan->w = $nw;
					$pan->h = $nh;
				}*/
			}
			$structure = json_encode($struct);
			$_SESSION['structure'] = $structure;
			
			header('Location: dash?range='.$range);
			exit();
		}
	}
	if ($_REQUEST['act'] == 'analyse')
	{		
		$structure = $_SESSION['structure'];
		$struct = json_decode($structure);
		$anylive = false;
		$anytrend = false;			

		//print("From Structure: ".$structure);
				
		foreach($struct->panels as $pan)
		{
			switch($pan->style)
			{
				case 'line':
				case 'discrete':
					$anytrend = true;
					break;
				default:
					$anylive = true;
					break;
			}
		}
		
		for($x=0;$x<count($struct->panels);$x++)
		{
			$pnl = $struct->panels[$x];
			if ($pnl->style == "links")
			{
				unset($struct->panels[$x]);
			}			
		}
		
		$nx = 0;
		$ny = 0;
		
		$struct->panels = array_values($struct->panels);
		
		//echo "Switching to Historical";
		$struct->name = str_replace("(History)","(Analytics)",$struct->name);
		$struct->name = str_replace("(Live)","(Analytics)",$struct->name);
		foreach($struct->panels as $pan)
		{
			switch($pan->style)
			{
				case 'discrete':				
					$pan->style = "stackedbarchart";
					if ($ny > 1) $ny = 0;
					$pan->x = $nx;
					$pan->y = $ny;
					$pan->w = 1;
					$pan->h = 6;	
					$nx++;
					break;
				case 'line':
					$pan->style = "distchart";
					$pan->x = $nx;
					$pan->y = $ny;
					$pan->w = 1;
					$pan->h = 6;
					
					$nx++;
					
					break;
			}				
		}
		$structure = json_encode($struct);
		$_SESSION['structure'] = $structure;		
	
		header('Location: dash?range='.$_REQUEST['range']);
		exit();
		
	}
	if ($_REQUEST['act'] == 'add')
	{
		$json = json_decode($structure);
		
		for($x=0;$x<count($json->panels);$x++)
		{
			if ($json->panels[$x]->style == "links")
			{
				unset($json->panels[$x]);
				$json->panels = array_values($json->panels);
				break;
			}
		}
		
		$aid = filter_var($_REQUEST['asset'],FILTER_VALIDATE_INT);
		if ($aid === FALSE) exit();
		
		if (strpos($json->name ,"(Live)") !== FALSE)
		{
			$json->name = "New Dashboard";
		}
		if (strpos($json->name ,"(History)") !== FALSE)
		{
			$json->name = "New Dashboard";
		}
		$asx = GetAssetByID($aid);
		//Do something here!	
		$usestyle = "barchart";
		$ptype = "MEASUREMENT";
		foreach($allprops as $px)
		{
			if ($px->id == $_REQUEST['property'])
			{
				$ptype = $px->type;
				break;
			}
		}
		if ($ptype != "MEASUREMENT")
		{
			$usestyle = "text";
		}
		
		//Get style from other elements, or range.
		if (($range !== FALSE) && ($range != "live") && ($range != ""))
		{
			if ($ptype == "MEASUREMENT")
				$usestyle = "line";
			else
				$usestyle = "discrete";
		}
		
		$pan = array();
		$pan['name'] = $asx->name;
		$pan['style'] = $usestyle;
		$pan['points'] = array();
		
		$pnt = array();	
		$pnt['asset'] = $_REQUEST['asset'];
		$pnt['property'] = $_REQUEST['property'];
		$pnt['name'] = "New";
		
		$pan['points'][] = $pnt;
		
		$json->panels[] = $pan;
		$structure = json_encode($json);
		if (isset($_REQUEST['id']))
		{
			$_SESSION['structure'] = $structure; 
			header('Location: '.$siteroot.'/dexplore/dash');
			exit;
		}		
	}
	if ($_REQUEST['act'] == 'del')
	{
		
		$targetpanel = $_REQUEST['panel'];
		$json = json_decode($structure);
		$changed = false;
			
		
		if ($_REQUEST['asset'] == -1)
		{
			for($x=0;$x<count($json->panels);$x++)
			{
				if ($x == $targetpanel)
				{
					unset($json->panels[$x]);
					$json->panels = array_values($json->panels);
				}
			}
		}
		else
		{
			
			
			for($x=0;$x<count($json->panels);$x++)
			{
				if ($x == $targetpanel)
				{
					for($n=0;$n<count($json->panels[$x]->points);$n++)
					{
						//echo 'Searching For '.$_REQUEST['asset'].' in '.$json->panels[$x]->points[$n]->asset;
						if ($json->panels[$x]->points[$n]->asset == $_REQUEST['asset'])
						{
							if ($json->panels[$x]->points[$n]->property == $_REQUEST['property'])
							{
								//echo 'Erasing!';
								$changed = true;
								unset($json->panels[$x]->points[$n]);
								$json->panels[$x]->points = array_values($json->panels[$x]->points);
							}
						}
					}				
				}
				if ($changed == true)
				{
					if (count($json->panels[$x]->points) == 0)
					{
						unset($json->panels[$x]);
						$json->panels = array_values($json->panels);
					}
					break;
				}
			}		
		}
		
		$structure = json_encode($json);
		//print("New Structure!: ");
		//print_r($structure);
		$_SESSION['structure'] = $structure; 
		if (isset($_REQUEST['id']))
		{			
			//header('Location: '.$siteroot.'/dexplore/dash');
			//exit;
		}
	}
	if ($_REQUEST['act'] == 'joinpanel')
	{
		//Combine two panels...
		$frompanel = $_REQUEST['asset'];
		$topanel = $_REQUEST['panel'];		
		
		$json = json_decode($structure);
		$counter = -1;
		$points = $json->panels[$_REQUEST['asset']]->points;
		foreach($points as $px)
		{
			$json->panels[$topanel]->points[] = $px;
		}
		
		unset($json->panels[$_REQUEST['asset']]);
		$json->panels = array_values($json->panels);
		
		$structure = json_encode($json);		
		$_SESSION['structure'] = $structure; 
	}
	
	if ($_REQUEST['act'] == 'joinchannel')
	{
		//Combine two panels...
		$frompanel = $_REQUEST['panel'];
		$ast = $_REQUEST['asset'];
		$prp = $_REQUEST['property'];
		$topan = $_REQUEST['misc'];		
		
		$json = json_decode($structure);
		
		//echo 'Moving from panel '.$frompanel.' to '.$topan.'<br/>';
		//print_r($json);
		
		$counter = -1;
		$points = $json->panels[$frompanel]->points;
		$grabbed = false;
		for($x=0;$x<count($points);$x++)
		{
			$hit = false;
			if ($points[$x]->asset == $ast)
			{
				if ($points[$x]->property == $prp)
				{
					$hit = true;
				}
			}
			if ($hit == true)
			{
				//echo 'Removing Existing...';
				$grabbed = $json->panels[$frompanel]->points[$x];
				unset($json->panels[$frompanel]->points[$x]);
				$json->panels[$frompanel]->points = array_values($json->panels[$frompanel]->points);				
				
				if (count($json->panels[$frompanel]->points) == 0)
				{
					unset($json->panels[$frompanel]);
					$json->panels = array_values($json->panels);
					
					if ($frompanel <= $topan)
					{
						$topan--;
					}
				}
				break;
			}
		}
				
		$json->panels[$topan]->points[] = $grabbed;
		
		//print_r($json);
		//exit;
		
		$structure = json_encode($json);		
		$_SESSION['structure'] = $structure; 
		header('Location: '.$siteroot.'/dexplore/dash');
		exit;
	}
	
	if ($_REQUEST['act'] == 'splitchannel')
	{
		//Split a single channel out of a panel.
		$frompanel = $_REQUEST['panel'];
		$ast = $_REQUEST['asset'];
		$prp = $_REQUEST['property'];		
		
		$json = json_decode($structure);
		$counter = -1;
		$points = $json->panels[$frompanel]->points;
		if (count($points) > 1)
		{
			$grabbed = false;
			for($x=0;$x<count($points);$x++)
			{
				$hit = false;
				if ($points[$x]->asset == $ast)
				{
					if ($points[$x]->property == $prp)
					{
						$hit = true;
					}
				}
				if ($hit == true)
				{				
					$grabbed = $json->panels[$frompanel]->points[$x];
					unset($json->panels[$frompanel]->points[$x]);
					$json->panels[$frompanel]->points = array_values($json->panels[$frompanel]->points);
					
					if (count($json->panels[$frompanel]->points) == 0)
					{
						unset($json->panels[$frompanel]);
						$json->panels = array_values($json->panels);
					}
					
					$asx = GetAssetByID($ast);
					
					$pan = array();
					$pan['name'] = $asx->name;
					$pan['style'] = $json->panels[$frompanel]->style;
					$pan['points'] = array();
					
					$pnt = array();	
					$pnt['asset'] = $ast;
					$pnt['property'] = $prp;
					foreach($allprops as $px)
					{
						if ($px->id == $prp)
						{
							$pnt['name'] = $px->name;
							break;
						}
					}				
					
					$pan['points'][] = $pnt;
					
					$json->panels[] = $pan;
					
					break;
				}
			}			
		}		
		
		$structure = json_encode($json);		
		$_SESSION['structure'] = $structure; 
	}
	
	if ($_REQUEST['act'] == 'splitpanel')
	{
		//Split a single channel out of a panel.
		$frompanel = $_REQUEST['panel'];		
		
		$json = json_decode($structure);
		$counter = -1;
		$points = $json->panels[$frompanel]->points;
		for($x=1;$x<count($points);$x++)
		{							
			$pnts = $json->panels[$frompanel]->points[1];
			unset($json->panels[$frompanel]->points[1]);
			$json->panels[$frompanel]->points = array_values($json->panels[$frompanel]->points);
						
			$asx = GetAssetByID($pnts->asset);
			
			$pan = array();
			$pan['name'] = $asx->name;
			$pan['style'] = $json->panels[$frompanel]->style;
			$pan['points'] = array();						
			
			$pan['points'][] = $pnts;
			
			$json->panels[] = $pan;
					
		}		
		
		$structure = json_encode($json);		
		$_SESSION['structure'] = $structure; 
	}
}
else
{
	if (isset($_REQUEST['id']))
	{
		$structure = "{}";
		$specificid = $_REQUEST['id'];
	}

	if (isset($_REQUEST['propertyid']))
	{
		$structure = "{}";
	}

	if (isset($_REQUEST['board']))
	{
		if (isset($specificid))
		{
			$ass = GetAssetByID($specificid);
			$media = $ass->GetMedia();
			$target = strtolower($_REQUEST['board'].'.dash');
			foreach($media as $m)
			{
				if (strpos(strtolower($m->localpath),$target) !== FALSE)
				{
					$activefolder = $sitefolder.'/media/assets/'.$specificid.'/'.$m->localpath;
					$structure = file_get_contents($activefolder);					
				}
			}
		}
	}
	
	if (isset($_REQUEST['points']))
	{
		$structure = "{}";
	}

	if ($structure == "{}")
	{
		include('autoformat.php');
	}
}

$rangestart = FALSE;
$rangeend = FALSE;
$rangepieces = $range;
if (!is_numeric($rangepieces))
{
	$pieces = explode('to',$rangepieces);
	if (count($pieces) > 1)
	{
		$rangestart = $pieces[0];
		$rangeend = $pieces[1];
	}
}

//print_r($structure);
$_SESSION['structure'] = $structure;

$clusters = array();
$sorted = array();

$dashboard = json_decode($structure);

//Scan packages to determine if history is required....
/*foreach($dashboard->panels as $pan)
{
	if (($pan->style == 'line') || ($pan->style == 'discrete'))
	{
		if (!isset($_REQUEST['range']))
		{			
			$_REQUEST['range'] = 1800;
			$range = $_REQUEST['range'];
			if ($range == "30min")
			{
				$range = 1800;
				$_REQUEST['range'] = 1800;
			}
		}
	}
}*/

if ((!isset($specificid)) || ($specificid === FALSE))
{
	if ($dashboard !== null)
	{
		if (property_exists($dashboard,'asset'))
		{
			$specificid = $dashboard->asset;
		}
	}
}

$_SESSION['structure'] = $structure;

//echo $structure;
//exit();

$plugins = array();
$plugins[] = 'stackedbarchart';
$plugins[] = 'barchart';
$plugins[] = 'gauge';
$plugins[] = 'text';
$plugins[] = 'line';
$plugins[] = 'discrete';
$plugins[] = 'links';
$plugins[] = 'dashlist';
$plugins[] = 'distchart';
$plugins[] = 'radar';

global $sitefolder;

?><!DOCTYPE html>
<html>
	<head>
		<title><?php echo $dashboard->name; ?></title>
		<!--<script src="bootstrap.js"></script>-->
		<script src="/plugins/jquery/jquery.min.js"></script>
		<script src="/plugins/optrix/hmi.js"></script>
		<script src="/addons/dexplore/moment.min.js"></script>
		<script src="/plugins/optrix/timecontrols.js"></script>
		<script src="/addons/dexplore/gridstack.js"></script>
		<script src="/addons/dexplore/d3v7.js"></script>
		<script src="/addons/dexplore/dashdata.js"></script>
		<?php
		
foreach($plugins as $plug)
{
	echo '   <script src="/addons/dexplore/vis_'.$plug.'.js"></script>';
}?>		
				
		<link href="/addons/dexplore/gridstack.css" rel="stylesheet" />		
		<!--<link href="/addons/dexplore/daterangepicker.css" rel="stylesheet" />		-->		
		<?php
		$textcolour = 'white';
		$nextmode = 'Light';
		
		if (isset($_COOKIE['dextheme']))
		{
			if (!isset($_REQUEST['theme']))
			{
				$_REQUEST['theme'] = $_COOKIE['dextheme'];
			}
		}
		
		if (isset($_REQUEST['theme']) && ($_REQUEST['theme'] == 'light'))
		{
		?><link href="/addons/dexplore/dash-light.css"  rel="stylesheet"/><?php	
			$textcolour = "black";
			$nextmode = "Dark";
			setcookie("dextheme","light",0,"/");
		}
		else
		{?>
	<link href="/addons/dexplore/dash.css"  rel="stylesheet"/><?php
	setcookie("dextheme","dark",0,"/");
		}
		
		
		?>
		<link href="/share/popup.css"  rel="stylesheet"/>
		<link rel="stylesheet" href="/plugins/optrix/timecontrols.css">
		<link href="/addons/dexplore/menu.css"  rel="stylesheet"/>
		<link href="/plugins/font-awesome/css/font-awesome.min.css"  rel="stylesheet"/>
		<link rel="stylesheet" href="<?php echo $themefolder; ?>/css/diagram.css">
		<script src="/plugins/typeahead/typeahead.bundle.min.js"></script>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
	</head>
	<body>
		<div class="header">
			<h1 oncontextmenu="RenameDashboard(); e.preventDefault();" onclick="RenameDashboard();"><span class="dashboardname" id="dashboardname"><?php echo $dashboard->name;?></span><input type="text" name="dashname" id="dashname" value="<?php echo $dashboard->name;?>" style="display: none;"/></h1>
			<div class="navigation"><?php
				if ((isset($specificid)) && ($specificid !== FALSE))
				{
					echo '<a class="nav" href="'.$siteroot.'" style="text-decoration: none; color: '.$textcolour.';">ARDI</a>';
					
					//This is an individual asset.					
					$ass = GetAssetByID($specificid);
					
					echo ' | <a class="nav" href="'.$siteroot.'/dashboard/'.$specificid.'" style="text-decoration: none; color: '.$textcolour.';">Dashboard</a>';
					
					$allkeys = array();
					$hits = 0;
					foreach(array_keys($asset[$ass->id]['relationships']) as $k)
					{
						if ($k == 3) continue;						
						foreach($allrels as $rx)
						{
							if ($rx->id == $k)
							{
								if ($rx->name == "Model")
								{
									break;
								}		
																
								$allkeys[$rx->name] = $rx->id;
								break;
							}
						}						
					}
					foreach($allkeys as $k => $v)
					{
						$hits++;
						//if ($hits > 1)
						//{
							echo ' | ';
						//}
						echo '<span class="nav" onclick="OpenNav('.$v.')">'.$k.'</span>';
					}
					
				}
				else
				{
					echo '<span class="navstart">Custom Page</span>';
				}
				echo ' | <a class="nav" href="#" onclick="StartSearch(); return false" style="text-decoration: none; color: '.$textcolour.';">Search</a>';
				echo ' | <a class="nav" href="#" onclick="ChangeTheme(); return false" style="text-decoration: none; color: '.$textcolour.';">'.$nextmode.'</a>';
?>			
			</div>
			<div class="topright">
<?php
	
	$rangestyle = "block";
	
	$customrange = FALSE;
	if ($range !== FALSE)
	{
		switch($range)
		{
			case 300:
			case 600:
			case 1800:
			case 3600:
			case 10800:
			case 21600:
			case 43200:
			case 86400:
			case 172800:
			case "live":
			case "":
				$customrange = false;
				break;
			default:
				$customrange = true;
				break;
		}
	}
	
		?><a href="#" onclick="$('.menucontent').toggle(500); return false;" class="smallscreenmenu"><i class="fa fa-bars smallscreenbutton"></i></a>
		<span class="menucontent">
		<div class="timerange">
		
		<input id="timerange" type="text" style="display: <?php echo $rangestyle; ?>"/>
		<!--<SELECT id="timerange" onchange="RangeChange();" style="display: <?php echo $rangestyle;?>">
			<option value="live"<?php if ($range === FALSE) echo ' selected';?>>Live</option>
			<option<?php if ($customrange !== FALSE) echo ' selected';?> value="*">Custom</option>
			<option value="300"<?php if ($range == 300) echo ' selected';?>>Last 5 Minutes</option>
			<option value="600"<?php if ($range == 600) echo ' selected';?>>Last 10 Minutes</option>			
			<option value="1800"<?php if ($range == 1800) echo ' selected';?>>Last 30 Minutes</option>
			<option value="3600"<?php if ($range == 3600) echo ' selected';?>>Last Hour</option>
			<option value="10800"<?php if ($range == 10800) echo ' selected';?>>Last 3 Hours</option>
			<option value="21600"<?php if ($range == 21600) echo ' selected';?>>Last 6 Hours</option>
			<option value="43200"<?php if ($range ==43200) echo ' selected';?>>Last 12 Hours</option>
			<option value="86400"<?php if ($range == 86400) echo ' selected';?>>Last 24 Hours</option>
			<option value="172800"<?php if ($range == 172800) echo ' selected';?>>Last 48 Hours</option>
		</SELECT>-->
		
		<div class="timecontrols" id="timecontrols" style="<?php if (($range === FALSE) || ($range == "") || ($range == "live")) {
		echo 'display: none';
	}
	else
	{
		echo 'display: block';
	};
	//if ($customrange == false) echo 'display: none;'; ?>">
			<!--<a id="prevtime" href="#" onclick="PrevTime(); return false;"><i class="fa fa-arrow-left"></i></a>
			<a id="nexttime" href="#" onclick="NextTime(); return false;"><i class="fa fa-arrow-right"></i></a>
			
			<a id="zoomin" href="#" onclick="ZoomIn(); return false;"><i class="fa fa-search-plus"></i></a>
			<a id="zoomout" href="#" onclick="ZoomOut(); return false;"><i class="fa fa-search-minus"></i></a>-->
			<!--<i class="fa fa-list right" style="color: white; position: absolute; top:2px;" id="eventlist"></i>-->
			<SELECT id="resolution" onchange="UpdateHistory();" style="display: <?php echo $rangestyle;?>">
				<option value="" selected>Auto</option>
				<option value="5">5 Samples</option>
				<option value="10">10 Samples</option>
				<option value="30">30 Samples</option>
				<option value="50">50 Samples</option>
				<option value="100">100 Samples</option>
				<option value="200">200 Samples</option>
				<option value="400">400 Samples</option>
				<option value="1000">1000 Samples</option>
			</SELECT>
			
		</div>
				
		
		</div>
		
		
<?php
if ($mode == "singleasset")
	{
		if ((!isset($_REQUEST['origin'])) && ($id > 0))
		{
			echo '<a href="'.$siteroot.'/dexplore/dash?id='.$id.'&zoom='.($zoom+1).'"><div class="headbutton"><i class="fa fa-binoculars"></i></div></a>';			
		}
		
	}
	if (($range != "") && ($range != "live"))
	{
		if (strpos($dashboard->name,"Analytics") === FALSE)
		{
			echo '<a href="#" onclick="Analyse(); return false;"><div class="headbutton"><i class="fa fa-list"></i></div></a>';
		}
		else
		{
			if (isset($specificid)) {
				echo '<a href="'.$siteroot.'/dexplore/dash?id='.$specificid.'"><div class="headbutton"><i class="fa fa-bar-chart"></i></div></a>';
			}
		}
	}
	//echo '<a href="#" onclick="Save(); return false;"><div class="headbutton"><i class="fa fa-save"></i></div></a>';
	//echo '<a href="#" onclick="New(); return false;"><div class="headbutton"><i class="fa fa-file"></i></div></a>';
	
	if ($dashboard !== null)
	{
		if (property_exists($dashboard,"origin")) 
			echo '<a href="#" onclick="Regen(event); return false;"><div class="headbutton"><i class="fa fa-refresh"></i></div></a>';
	}
	echo '<a href="#" onclick="AddProperty(); return false;"><div class="headbutton"><i class="fa fa-plus"></i></div></a>';?>		
	</span>
	
		<!-- <input type="text" value="" id="customtime" style=" -->
		<div id="customtime" style="font-size: 14px;<?php if (($range === FALSE) || ($range == "") || ($range == "live")) {
		echo 'display: none';
	}
	else
	{
		echo 'display: block';
	};?>">
		</div>
		<!--</input>-->
			</div>
		</div>		
		
		<?php 
		
function FriendlyName($prop)
{
	$bits = explode(' - ',$prop);
	if (count($bits) > 1)
		return $bits[1]." ".$bits[0];
	return $prop;
}

$panelcount = 0;
$panels = array();

$fullpropertyset = array();
$anyasset = FALSE;

$propdefaults = array();

/*echo '<!-- Panels: ';
print_r($dashboard->panels);
echo '-->';*/

foreach($dashboard->panels as $pnl)
{
	$propset = array();
	$assetlist = array();
	$final = array();
	
	$stripname = FALSE;	
	if (property_exists($pnl,"strip"))
	{
		$stripname = $pnl->strip;
		//echo 'Stripping '.$stripname;
	}
	
	$added = false;
	foreach($pnl->points as $ast)
	{	
		$ass = GetAssetByID($ast->asset);
		if ($anyasset === FALSE)
		{
			$anyasset = $ass;
		}
		
		//echo "//Checking Out ".$ass->name."\r\n";
		
		if (property_exists($ast,'node'))
		{
			$f = new AssetProperty();
			$f->id = -1;
			$f->name = str_replace(" Alert","",$pnl->name);
			$f->origin = $ast->asset;
			$f->altorigin = $ast->node;
			$f->origintype = 'local';
			$f->type = "ALERT";
			$final[] = $f;
			
			foreach($final as $fp)
			{
				$fullpropertyset[] = $fp;
			}
		}
		else
		{
			$props = $ass->GetLocalProperties();		
					
			$id = $ast->asset;
			
			$final = array();		
			foreach($props as $px)
			{
				if ($px->id == $ast->property)
				{
					$final[] = $px;
				}
			}
			foreach($final as $fp)
			{
				if ($fp->origintype == "template")
				{
					//$fp->origin = $id;
					//$fp->origintype="local";
					$fp->altorigin=$id;
				}
				
				$fullpropertyset[] = $fp;
			}
			//$ass->GetValues($final);		
		}	

//print_r($final);		
		
		foreach($final as $px)
		{
			if (isset($propdefaults[$px->id]))
			{
				$defaults = $propdefaults[$px->id];
			}
			else
			{
				$defaults = FALSE;
				foreach($allprops as $ap)
				{
					if ($ap->id == $px->id)
					{
						$defaults = $ap->GetDefault();
						break;
					}
				}
				
				$propdefaults[$px->id] = $defaults;
			}
			//print_r($defaults);
			$px->value = $defaults;
			if (count($propset) > 0)
			{
				if (!in_array($px->id,$propset))
				{
					continue;
				}
			}
			$style = "";
			$node = "";
			$value = 0;
			$min = 0;
			$max = 0;
			$places = 0;
			$units = "";
			$base = explode(' - ',$px->name)[0];
			
			$itm = array();	
			
			//$bits = explode('_',$k);		
			
			switch($px->type)
			{
				case 'MEASUREMENT':
					$style = $pnl->style;//'barchart';
					$node = 'measurement';
					$min = $px->value[2];//$px->value['min'];
					$max = $px->value[3];//$px->value['max'];
					$units = $px->value[1];//$px->value['units'];
					$places = $px->value[4];//$px->value['places'];
					break;
				case 'ENUM':
					$style = $pnl->style;
					$node = 'value';					
					$units = '';					
					foreach($allprops as $pq)
					{
						if ($pq->id == $px->id)
						{							
							$itm['map'] = $pq->GetValueMap();
							$keys = array_keys($itm['map']);
							if (count($keys) > 0)
							{
								$min = $keys[0];
								$max = $keys[count($keys)-1];
							}
							break;
						}
					}					
					break;
				case 'STATUS':
					$style = $pnl->style;
					$node = 'state';					
					$units = '';					
					foreach($allprops as $pq)
					{
						if ($pq->id == $px->id)
						{							
							$itm['map'] = $pq->GetValueMap();
							$keys = array_keys($itm['map']);
							$min = $keys[0];
							$max = $keys[count($keys)-1];
							break;
						}
					}					
					break;
				case 'ALERT':
					$style = $pnl->style;
					$node = $px->altorigin;					
					$units = '';					
					foreach($allprops as $pq)
					{
						if ($pq->id == $px->id)
						{							
							$itm['map'] = array();
							$itm['map'][0] = 'OK';
							$itm['map'][1] = 'ALERT';
							$keys = array_keys($itm['map']);
							$min = 0;
							$max = 1;
							break;
						}
					}					
					break;
				case 'LOOKUP':
					$style = $pnl->style;
					$node = 'text';					
					$units = '';					
					foreach($allprops as $pq)
					{
						if ($pq->id == $px->id)
						{							
							$itm['map'] = $pq->GetValueMap();
							$keys = array_keys($itm['map']);
							$min = 0;
							$max = 9999;
							break;
						}
					}					
					break;
			}		
			
			if ($style == "") continue;
			
			if ($px->origintype == "template") $px->origin = $id;
			
			$asn = GetAssetByID($px->origin);
					
			$itm['style'] = $style;
			$itm['min'] = $min;
			$itm['max'] = $max;
			$itm['node'] = $node;		
			$itm['units'] = $units;
			$itm['places'] = $places;
			$itm['name'] = $px->name;
			$itm['title'] = $px->name;
			//if ($px->id != -1)
			$itm['fullname'] = $asn->name.' '.FriendlyName($px->name);
			//else
			//	$itm['fullname'] = $asn->name.' '.$px->n;
			if ($px->origin != $specificid)
			{				
				if ($stripname !== FALSE)
					$itm['title'] = trim(str_replace('.'.$stripname,"",$asn->name.'.'.$px->name));
				else
					$itm['title'] = $asn->name.' - '.$px->name;
			}
			
			$itm['value'] = "VALUE_".$px->origin.':'.$px->id.':'.$node;//$px->value[$node];
			$itm['origin'] = $px->origin;
			$itm['propid'] = $px->id;
			//$itm['node'] = $node;
			
			$title = $ass->name;
			
			if (count($propset) > 0)
			{
				foreach($allprops as $pl)
				{
					if (in_array($pl->id,$propset))
					{
						$bitx = explode(' - ',$pl->name);
						if (count($bitx) == 2)
							$title .= ' '.$bitx[1].' '.$bitx[0];
						else
							$title .= ' '.$pl->name;
					}
				}
			}
			
			if (!isset($panels[$panelcount]))
			{
				$panels[$panelcount] = array();
				$added = true;
			}
			$panels[$panelcount][] = $itm;
		}		
	}
	
	if ($added == false)
	{
		//echo 'Panel Content Not Found For '.$pnl->name;
		$panels[$panelcount] = FALSE;
	}
	if (count($pnl->points) == 0)
	{			
		//echo 'No points found in panel!';
		$panels[$panelcount] = $pnl->style;
	}	
	$panelcount++;
}


//Try to get a full set of current values...
if ($anyasset !== FALSE)
{
	foreach($fullpropertyset as $fps)
	{
		$fps->value = FALSE;
	}
	$anyasset->GetValues($fullpropertyset);
	//print_r($fullpropertyset);
	
	$allvalues = array();
	foreach($fullpropertyset as $fps)
	{
		$node = "measurement";
		switch($fps->type)
		{
			case "STATUS":
				$node = "state";
				break;
			case "ENUM":
			case "LOOKUP":
				$node = "value";
				break;
			case "ALERT":
				$node = $fps->altorigin;
				break;
			case "TEXT":
				$node = "text";
				break;
		}
		//echo "Value: ";
		//print_r($fps->value);
		if (is_array($fps->value))
			$st = "VALUE_".$fps->origin.':'.$fps->id.':'.$node;
		else
			$st = "VALUE_".$fps->origin.':'.$fps->id.':'.$node;
		
		$panels = array_values($panels);
		
		for($pno=0;$pno < count($panels);$pno++)
		{
			if (!is_array($panels[$pno])) 
			{
				continue;
			}
			for($pointno = 0;$pointno < count($panels[$pno]);$pointno++)
			{
				$point = $panels[$pno][$pointno];
				$ev = $panels[$pno][$pointno]['value'];
				if ($point['value'] == $st)
				{	
					if ($fps->value !== FALSE)
					{
						$panels[$pno][$pointno]['value'] = $fps->value[$node];
						if ($node == "measurement")
						{						
							$panels[$pno][$pointno]['places'] = $fps->value['places'];
							$panels[$pno][$pointno]['units'] = $fps->value['units'];						
						}
					}
					break;
				}
			}
		}		
	}
		
	for($pno=0;$pno < count($panels);$pno++)
	{
		if (!is_array($panels[$pno])) 
		{			
			continue;		
		}
		for($pointno = 0;$pointno < count($panels[$pno]);$pointno++)
		{
			$point = $panels[$pno][$pointno];
			$ev = $panels[$pno][$pointno]['value'];
			if (strpos($ev,"VALUE_") !== FALSE)
			{
				//print_r($propdefaults[$point['propid']]);
				$newvalue = "";
				if (isset($propdefaults[$point['propid']][0]))					
					$newvalue = $propdefaults[$point['propid']][0];
				if ($newvalue == "") $newvalue = 0;
				//echo 'Replacing '.$point['value'].' with &quot;'.$newvalue.'&quot;';
				$panels[$pno][$pointno]['value'] = $newvalue;
				if (strpos($ev,"_measurement") !== FALSE)
				{
					$panels[$pno][$pointno]['places'] = $propdefaults[$point['propid']][4];
					$panels[$pno][$pointno]['units'] = $propdefaults[$point['propid']][1];						
				}
				break;
			}
		}
	}
}		
		?>
		
		
		
		<div class="grid-stack" style="height: 100%;">
		</div>
			
		<div class="popup" id="popupbase" style="display: none; position: absolute; left: 10px; top: 10px;">
		</div>
		
		<script type="text/javascript">
		
		
    let grid = GridStack.init({
      cellHeight: 'initial', // start square but will set to % of window width later
      animate: true, // show immediate (animate: true is nice for user dragging though)
      disableOneColumnMode: true, // will manually do 1 column
      float: true,
	  draggable: {	
			handle: '.title',
	  }
	});
    //let text = document.querySelector('#column-text');
    let layout = 'moveScale';
	var ResizeRenderRefresh = 0;
	var lastGridSize = 0;
    
    function resizeGrid() {
      let width = document.body.clientWidth;
	  var gridSize = 12;
      if (width < 700) {
        grid.column(1, layout).cellHeight('14.5vh');
		gridSize = 1;		
        //text.innerHTML = 1;
      } else if (width < 850) {
        grid.column(3, layout).cellHeight('33.3333vw');
		gridSize = 3;		
        //text.innerHTML = 3;
      } else if (width < 950) {		 
        grid.column(6, layout).cellHeight('14.5vh');
		gridSize = 6;		
        //text.innerHTML = 6;
      } else if (width < 1100) {		  
        grid.column(8, layout).cellHeight('14.5vh');
		gridSize = 8;		
        //text.innerHTML = 8;
      } else {		  
        grid.column(12, layout).cellHeight('14.5vh');
        //text.innerHTML = 12;
      }
	  
	  //It's also worth re-drawing the individual controls in this case...
	  if (gridSize != lastGridSize)
	  {
		  if (ResizeRenderRefresh != 0)
		  {		  
			  window.clearTimeout(ResizeRenderRefresh);
			  ResizeRenderRefresh = 0;
		  }
		  ResizeRenderRefresh = window.setTimeout('RenderPanels();',500);
		  lastGridSize = gridSize;
	  }
	  
    };
	
	window.addEventListener('resize', function(event, el) {
		resizeGrid();
		RenderPanels();		
	});
	
	grid.on('resizestop', function(event, el) {
		var element = parseInt(el.firstChild.firstChild.id.substr(6))-1;
		if (element == -1) element = 0;
		RenderContent(panelsettings[element]);
		StoreGridChanges();
	});

	panelsettings = [];
	
	var dateformat = d3.timeFormat("%Y-%m-%d %H:%M:%S");
	
	var currentDate = new Date();
	var rangestart = dateformat(currentDate.getTime() - 1800000);
	var rangeend = dateformat(currentDate);	
	var lastrangestart = null;
	var lastrangeend = null;
	
	function ApplyRange(myrange)
	{
		var tr = myrange;
		if (tr == undefined)
		{
			tr = $('#timerange').val();
		}
		
		if (tr[0] == "*")
		{
			tr = tr.substr(1);
		}
		var start = null;
		var end = null;
		var seconds = 0;
		try
		{
			seconds = parseInt(tr);			
			var currentDate = new Date();
			end = currentDate - (0);
			start = currentDate - (seconds * 1000);
		}
		catch(e)
		{			
		}
		
		try
		{
			if (tr.includes("-"))
			{
				tr = tr.split(' to ');
				start = parseDateTime(tr[0]).getTime();
				end = parseDateTime(tr[1]).getTime();
			}
		}
		catch(e)
		{
		}
		
		var state = {rangestart: rangestart,rangeend: rangeend,structure: '<?php echo $structure; ?>'};
		window.history.replaceState(state,'',window.location.href);
		console.log("Setting Structure");
		
		rangestart = dateformat(start);
		rangeend = dateformat(end);
		
		try
		{
			//$('#customtime').data('daterangepicker').setStartDate(moment(start).format('hh:mm A DD/MM/YYYY'));
			//$('#customtime').data('daterangepicker').setEndDate(moment(end).format('hh:mm A DD/MM/YYYY'));
		}
		catch(e)
		{
		}
		
		var state = {rangestart: rangestart,rangeend: rangeend,structure: '<?php echo $structure; ?>'};
			
		if ((lastrangestart != null) && ((rangestart != lastrangestart) || (rangeend != lastrangeend)))
		{
			var newurl = ReplaceVariable('range',rangestart + " to " + rangeend);			
			window.history.pushState(state,'',newurl);
		}		
		
		lastrangestart = rangestart;
		lastrangeend = rangeend;
		
		rangeset = true;
		
		for(var x=0;x<panelsettings.length;x++)
		{
			for(var y=0;y<panelsettings[x].data.length;y++)
			{
				panelsettings[x].data[y].rangemin = rangestart;
				panelsettings[x].data[y].rangemax = rangeend;
				panelsettings[x].data[y].hist = [];
			}
		};
		try
		{
			RenderPanels();		
		}
		catch
		{
			console.log("Exception During Panel Renedr");
		}
		
		var tzoffset = new Date().getTimezoneOffset() * 60000;
		var utcstart = dateformat(start + tzoffset);
		var utcend = dateformat(end + tzoffset);
		dashdata.Query(utcstart,utcend,$('#resolution').val());
		
		window.timecontrol[0].SetRange(rangestart,rangeend,false);
	}
	
	function UpdateHistory()
	{
		var start = parseDateTime(rangestart).getTime();;
		var end = parseDateTime(rangeend).getTime();;
		var tzoffset = new Date().getTimezoneOffset() * 60000;
		var utcstart = dateformat(start + tzoffset);
		var utcend = dateformat(end + tzoffset);
		dashdata.Query(utcstart,utcend,$('#resolution').val());
	}
	
	<?php
	$index = 0;
	$x = 0;
	$y = 0;
	
	if (isset($_REQUEST['navigate']))
		$nav = $_REQUEST['navigate'];	
	
	$activewidth = $itemwidth;
	$activeheight = $itemheight;
	/*if ($namestyle == "asset")	
	{
		if ($clustering == true)
		{
			$activeheight = 5;
			$activewidth = 5 * ($itemwidth / $itemheight);
		}
	}
	if ($clustering == true)
	{
		if (($itemwidth == 1) && ($activeheight <= 3) && (count($clusters) < 5))
		{
			$activeheight = 5;
		}
	}
	if (count($clusters) == 1)
	{
		$activewidth = 12;
	}*/
	
	/*echo 'Panels-----';
	print_r($panels);
	exit();*/
	
	$index = 0;
	foreach($panels as $propset)
	{
		if (!is_array($propset))
		{
			
			$panelinfo = $dashboard->panels[$index];
			echo "\r\n";
			
			$wd = 1;
			if (property_exists($panelinfo,'x'))
			{
				$x = $panelinfo->x;
				$y = $panelinfo->y;
				$wd = $panelinfo->w;
				$activeheight = $panelinfo->h;
			}
			echo '//Checking Panel '.$panelinfo->style."\r\n";
			switch($panelinfo->style)
			{
				case 'line':
				case 'discrete':
					//echo 'Checking for history sizing...';
					if (property_exists($panelinfo,'hx'))
					{
						//echo 'Using History Sizing!';
						$x = $panelinfo->hx;
						$y = $panelinfo->hy;
						$wd = $panelinfo->hw;
						$activeheight = $panelinfo->hh;
					}
					break;
				case 'barchart':
					$panelinfo->style = "none";
					break;
			}?>
			pnl = Object();
			pnl.name = "<?php echo $panelinfo->name; ?>";
			pnl.title = "<?php echo $panelinfo->name; ?>";
			pnl.number = <?php echo $index+1;?>;
			pnl.style = "<?php echo $panelinfo->style;?>";
			pnl.asset = 0; //Non-data panel!
			pnl.property = 0;
			pnl.initialised = false;
			pnl.obj = null;
			pnl.gridx = <?php echo $x; ?>;
			pnl.gridy = <?php echo $y; ?>;
			pnl.width = <?php echo $wd; ?>;
			pnl.height = <?php echo $activeheight;?>; <?php
			if ($panelinfo->style == 'links') { 
				$linkset = "[";				
				if ($specificid !== FALSE)
				{
					if (($range !== FALSE) && ($range != "") && ($range != "live"))
					{
						//Diagram
						$linkset .= '{ "name": "Live", "link": "'.$siteroot.'/dexplore/dash?id='.$specificid.'", "icon": "home" },';
					}
					//Diagram
					$linkset .= '{ "name": "Diagram", "link": "'.$siteroot.'/diagram/'.$specificid.'", "icon": "share-alt" },';
					//Media
					$linkset .= '{ "name": "Media", "link": "'.$siteroot.'/asset/dashboard-media?assetid='.$specificid.'", "icon": "file" },';
					//print_r($asset[$specificid]);
					//exit;
					foreach($asset[$specificid]['relationships'][2] as $rl)
					{
						if ($rl['upstream'] == false)
						{
							//Deeper
							$linkset .= '{ "name": "Zoom", "link": "'.$siteroot.'/dexplore/dash?id='.$specificid.'&zoom='.($zoom+1).'", "icon": "binoculars" },';
							break;
						}
					}
					
					//Home
					$linkset .= '{ "name": "Home", "link": "'.$siteroot.'/dashboard/'.$specificid.'", "icon": "tachometer" }';					
					
					$ass = GetAssetByID($specificid);
					$prp = $ass->GetLocalProperties();
					foreach($prp as $p)
					{
						if (($p->type == "LOCATION") || ($p->type == "PLACEMENT"))
						{
							$linkset .= ',{ "name": "Map", "link": "'.$siteroot.'/map/?id='.$specificid.'", "icon": "map-marker" }';
						}
					}

					if (isset($asset[$specificid]['relationships'][$threesixtyrel]))
					{
						$linkset .= ',{ "name": "360", "link": "'.$siteroot.'/360/client/asset?id='.$specificid.'", "icon": "camera" }';
					}
					
				}
				$linkset .= "]";
				?>			
			pnl.links = <?php echo $linkset; ?>; <?php
			}
			if ($panelinfo->style == 'dashlist') { 
			//Compile Dashboard Menu
			
			$ext = "";
			if ($specificid !== FALSE)
			{
				if (!isset($_REQUEST['navigate']))
				{
					$_REQUEST['navigate'] = 2;
					$_REQUEST['from'] = $specificid;				
				}
			}
			if (isset($_REQUEST['navigate']))
			{
				$dashmenu = '[';
				$nav = $_REQUEST['navigate'];
				$from = FALSE;
				if (isset($_REQUEST['from']))
				{
					$from = $_REQUEST['from'];
					$asx = GetAssetByID($from);
					
					//echo 'Navigating Around '.$asx->id.', rel '.$nav;
					
					foreach($asset[$asx->id]['relationships'][$nav] as $v)
					{
						if ($v['upstream'] == true)
						{
							$dink = GetAssetByID($v['target']);
							if (strlen($dashmenu) > 5) $dashmenu .= ',';
							$dashmenu .= '{ "name": "'.$dink->name.'", "subdir": "id='.$v['target'].'&'.'&navigate='.$nav.'&from='.$v['target'];							
							$dashmenu .= '", "direction": "up"}';
						}
					}
					
					foreach($asset[$asx->id]['relationships'][$nav] as $v)
					{
						if ($v['upstream'] == false)
						{
							$dink = GetAssetByID($v['target']);
							if (strlen($dashmenu) > 5) $dashmenu .= ',';
							$dashmenu .= '{ "name": "'.$dink->name.'", "subdir": "id='.$v['target'].'&navigate='.$nav.'&from='.$v['target'];							
							$dashmenu .= '", "direction": "down" }';
						}
					}
				}
				else
				{
					//Get Root Assets
					
					require_once($installfolder.'/model/relationship.php');
					$relset = Relationships::GetAllRelationships();
					
					$rel = $_REQUEST['navigate'];
					
					$relation = FALSE;
					foreach($relset as $r)
					{
						if ($r->id == $rel)
						{
							$relation = $r;
							break;
						}
					}
					
					$query = $db->query('SELECT DISTINCT parentasset FROM assetrelationships WHERE relationship='.$rel);

					$candidates = array();
					while($row = $query->fetch(PDO::FETCH_ASSOC))
					{
						$candidates[] = $row['parentasset'];
					}
					
					$haschildren = array();
					
					$toquery = array();
					$topper = $candidates;
					$counter = 0;
					while(count($topper) > 0)
					{
						$toquery[] = array_pop($topper);
						if ((count($toquery) > 500) || (count($topper) == 0))
						{
							$query = $db->query('SELECT DISTINCT childasset FROM assetrelationships WHERE relationship='.$rel.' AND childasset IN ('.implode(',',$toquery).")");
							//echo 'SELECT DISTINCT childasset FROM assetrelationships WHERE relationship='.$rel.' AND childasset IN ('.implode(',',$toquery).")";
							while($row = $query->fetch(PDO::FETCH_ASSOC))
							{
								$haschildren[] = $row['childasset'];
							}
							$toquery = array();
						}
					}
					
					//echo 'Total Candidates: '.count($candidates).'<br/>Total Exceptions: '.count($haschildren).'<br/>';
					
					$finals = array();
					foreach($candidates as $cn)
					{
						if (!in_array($cn,$haschildren))
						{
							//unset($candidates[$x]);
							$finals[] = $cn;
						}
					}
					
					unset($candidates);
					unset($haschildren);
					
					$sourceid = 0;
					//OK - add the assets that are marked as a SOURCE.
					include_once($installfolder.'/model/property.php');
					$props = Properties::GetAllProperties();
					foreach($props as $prp)
					{
						if ($prp->type == "SRCPOINT")
						{
							$sourceid = $prp->id;
							break;
						}
					}
					
					if ($sourceid != 0)
					{
						$query = $db->query('SELECT assetid,value FROM assetvalues WHERE propertyid='.$sourceid);
						while($row = $query->fetch(PDO::FETCH_ASSOC))
						{
							$bits = explode('|',$row['value']);
							$expd = explode(',',$bits[0]);
							foreach($expd as $ex)
							{
								if ($ex == $rel)
								{
									if (!in_array($row['assetid'],$finals))
									{
										$finals[] = $row['assetid'];
									}
								}
							}
						}
					}
										
					$hits = array();
					
					if (count($finals) > 0)
					{
						$query = $db->query('SELECT id,name FROM assets WHERE id IN ('.implode(',',$finals).') ORDER BY name');
						while($row = $query->fetch(PDO::FETCH_ASSOC))
						{						
							$ass = GetAssetByID($row['id']);
							$ass->Load();
							
							$itm = array();
							$itm['id'] = $row['id'];
							$itm['name'] = $row['name'];
							$itm['ern'] = $ass->ern;
							
							$hits[] = $itm;							
						}
					}
					
					$srcid = 0;
					//Checking for supply property...
					$query = $db->query('SELECT id FROM properties WHERE typename=\'SUPPOINT\'');
					while($row = $query->fetch(PDO::FETCH_ASSOC))
					{
						$srcid = $row['id'];
						break;
					}
					
					//Check for supplies....
					if ($srcid != 0)
					{
						//echo 'Checking Source ID - '.$srcid;
						$query = $db->query('SELECT id,name,value FROM assets JOIN assetvalues ON (assetvalues.assetid = assets.id) WHERE propertyid='.$srcid);
						while($row = $query->fetch(PDO::FETCH_ASSOC))
						{
							$bits = explode(':',$row['value']);
							foreach($bits as $b)
							{
								if ($b == $rel)
								{
									$found = false;
									foreach($hits as $h)
									{
										if ($h['id'] == $row['id'])
										{
											$found = true;
											break;
										}
									}
									
									if ($found == false)
									{
										$ass = GetAssetByID($row['id']);
										$h = array();
										$h['id'] = $row['id'];
										$h['name'] = $row['name'];
										$h['ern'] = $ass->ern;
										
										$hits[] = $h;
									}
								}
							}
						}
					}		
					
					
					foreach($hits as $ht)					
					{
						if (strlen($dashmenu) > 5) $dashmenu .= ',';
						$dashmenu .= '{ "name": "'.$ht['name'].'", "subdir": "id='.$ht['id'].'&'.'&navigate='.$nav.'&from='.$ht['id'];							
						$dashmenu .= '", "direction": "down"}';
					}
					
				}
				
				$dashmenu .= ']';
			}
			else
			{
				require_once($installfolder.'/model/relationship.php');
				$allrels = Relationships::GetAllRelationships();
				$dashmenu = '[ ';
				foreach($allrels as $r)
				{
					if (strlen($dashmenu) > 5) $dashmenu .= ',';
					$dashmenu .= '{ "name": "'.$r->name.'", "subdir": "navigate='.$r->id;
					if ($r->type == "heirachial")
					{
						$dashmenu .= '&from='.$r->GetRootAsset();
					}
					$dashmenu .= '" }';
					//print_r($r);
				};
				$dashmenu .= ' ]';
			}
			?>			
			pnl.dashboards = <?php echo $dashmenu; ?>; <?php }; ?>
			pnl.data = [];			
			panelsettings.push(pnl);<?php
			$index++;
			continue;
		}
		$pq = $propset[0];
		$wd = $activewidth;
		$cwd = count($propset) / 2;
		if ($cwd > $wd)
		{
			$wd = round($cwd);
		}
		
		if ($pq['style'] == 'distchart')
		{
			$showlive = true;
		}
		
		$clusterstyle = "live";
		if ($style == "line")
		{
			$clusterstyle = "history";
		}
		
		$title = "";
		$bits = explode(' - ',$pq['name']);
		$title = $bits[0];
		if (count($bits) > 1)
		{							
			$title = $bits[1].' '.$bits[0];
		}		
		
		
		if (($range == FALSE) || ($range == "") || ($range == "live"))
			$showlive = true;		
		
		$panelinfo = $dashboard->panels[$index];
		if (property_exists($panelinfo,'x'))
		{
			$x = $panelinfo->x;
			$y = $panelinfo->y;
			$wd = $panelinfo->w;
			$activeheight = $panelinfo->h;
		}
		echo '//Checking Panel '.$panelinfo->style."\r\n";
		switch($panelinfo->style)
		{
			case 'line':
			case 'discrete':
				//echo 'Checking for history sizing...';
				if (property_exists($panelinfo,'hx'))
				{
					//echo 'Using History Sizing!';
					$x = $panelinfo->hx;
					$y = $panelinfo->hy;
					$wd = $panelinfo->hw;
					$activeheight = $panelinfo->hh;
				}
				break;
		}
		
		$panelinfo = $dashboard->panels[$index];
				
		$index = $index + 1;		
			?>
		pnl = Object();
		pnl.name = "<?php echo $panelinfo->name; ?>";
		pnl.title = "<?php echo $panelinfo->name;//$title; ?>";
		pnl.number = <?php echo $index;?>;
		pnl.style = "<?php echo $pq['style'];?>";
		pnl.asset = <?php echo $pq['origin']; ?>;
		pnl.property = <?php echo $pq['propid']; ?>;		
		pnl.initialised = false;
		pnl.obj = null;
		pnl.gridx = <?php echo $x; ?>;
		pnl.gridy = <?php echo $y; ?>;
		pnl.width = <?php echo $wd; ?>;
		pnl.height = <?php echo $activeheight;?>; <?php
		if ($pq['style'] == 'dashlist') { ?>
		pnl.dashboards = [], <?php }; ?>			
		pnl.data = [<?php
		$counter = 0;				
		foreach($propset as $px)
		{
			//print_r($px);
			$title = $px['title'];			
			$counter++;
			if ($counter > 1) echo ',';?>	{
			name: "<?php if ($px['propid'] == -1) 
					echo 'Alert'; 
				else
					echo $title;?>",
			fullname: "<?php echo $px['fullname'];?>",
			units: "<?php echo $px['units']; ?>",
			places: <?php echo $pq['places']; ?>,
			property: <?php echo $px['propid'];?>,
			asset: <?php echo $px['origin'];?>,
			range: '<?php echo $range; ?>',
			minimum: <?php echo $px['min'];?>,
			maximum: <?php echo $px['max'];?>,<?php
			?>
			hist: [ [ rangestart, null],[rangeend, null] ],
			<?php /*hist: [ {stamp: "2022-02-01 09:00:00", value: 20},{stamp: "2022-02-02 09:00:00", value: 30} ], */?>
			rangemin: rangestart,
			rangemax: rangeend,
			tzoffset: new Date().getTimezoneOffset(), <?php
			
			if ($px['propid'] == -1)
			{
				?>
				map: { 0: "OK", 1: "ALERT" },
				colourmap: { 0: "green", 1: "red" },
				node: "<?php echo $px['node'];?>",
				<?php
			}
			if (isset($px['map']))
			{ ?>
			map: { <?php
			$firstmap = true;
			foreach($px['map'] as $ky => $vl)
			{
				if ($firstmap == true)
					$firstmap = false;
				else
					echo ",\r\n";
				
				if ($ky < 0)
					echo "          '".trim($ky)."': \"".trim($vl).'"';
				else
					echo '          '.trim($ky).': "'.trim($vl).'"';
			}
?>			
			},			<?php };
			$displayfile = $sitefolder.'/cache/display/properties/'.$px['propid'].'.xml';
			if (file_exists($displayfile))
			{
				$xml=simplexml_load_file($displayfile);
				
				//print_r($xml);
				
				if (property_exists($xml,'colours'))
				{
					//echo 'Colours Found!';
					$attrs = $xml->colours->attributes();	?>
			colourmap: { <?php
				echo '0: "'.$attrs['zero'].'",';
				echo '1: "'.$attrs['one'].'"';
			?> }, <?php					
				}	
			
				if (property_exists($xml,'value'))
				{			?>
			colourmap: { <?php
					$first = true;
					foreach($xml->value as $vl)
					{
						$attrs = $vl->attributes();
						if ($first == true)
							$first = false;
						else
							echo ',';
						echo '"'.$attrs['value'].'": "'.$attrs['colour'].'"';
					}	
			?> }, <?php					
				}	

				if (property_exists($xml,'gradient'))
				{
					$stops = $xml->gradient->attributes()['stops'];
					?>
			gradient: '<?php echo $xml->gradient->attributes()['stops'];?>',
			grad: [<?php
			$bits = explode('%25',$stops);
			$bcnt = 0;
			foreach($bits as $bt)
			{
				$pieces = explode('_',$bt);
				while((count($pieces) > 0) && ($pieces[0] == ""))
				{
					unset($pieces[0]);
					$pieces = array_values($pieces);
				}
				if ($bcnt > 0) echo ',';
				$bcnt++;
				if (count($pieces) < 2) continue;
				
				echo '['.($pieces[1]/100).', hexToRgbFloat("'.$pieces[0].'")]';
			}
			?>],<?php
				}
			}
	?>
			value: <?php 
				$vl = $px['value'];
				if ($vl == "^") 
					$vl = 'null';
				else
				{
					if (!is_numeric($vl))
					{
						$vl = '"'.$vl.'"';
					}
				}
				if ($vl == "")
					$vl = '""';
				
				
				echo $vl;?>
		}<?php }; ?>]
		
		pnl.data = CleanTitles(pnl.data);
		panelsettings.push(pnl);
		
		<?php
		
		$ele = 0;
		foreach($propset as $px)
		{
			
			if ($showlive == true) {?>
			
		dashdata.AddLive("<?php echo $px['origin'];?>:<?php echo $px['propid']; ?>:<?php echo $px['node'];?>",panelsettings[panelsettings.length-1],<?php echo $ele; ?>);		
			<?php } 
			if ($px['propid'] != -1) {?>
			dashdata.AddHist("<?php echo $px['origin'];?>:<?php echo $px['propid']; ?>:<?php echo $px['node'];?>",panelsettings[panelsettings.length-1],<?php echo $ele; ?>);		
			<?php } else { ?>
			dashdata.AddAlert("<?php echo $px['origin'];?>:<?php echo $px['propid']; ?>:<?php echo $px['node'];?>",panelsettings[panelsettings.length-1],<?php echo $ele; ?>);		
			<?php
			};
			$ele++; };
			$x+=$wd;;
			if ($x >= 12)
			{
				$x = 0;
				$y += $activeheight;
			}
		
	}	
	
	?>
	
	var structure = "<?php echo str_replace('"','\\"',$structure); ?>";
    
    var items = [ // our initial 12 column layout loaded first so we can compare      
    ];
	
	for(var x=0;x<panelsettings.length;x++)
	{
		items.push({x: panelsettings[x].gridx, y: panelsettings[x].gridy, h: Math.floor(panelsettings[x].height),w: Math.floor(panelsettings[x].width), id: x, title: panelsettings[x].title, style: panelsettings[x].style, content: "<div id=\"panel_" + panelsettings[x].number + "\" class=\"panel barchart panel_" + panelsettings[x].number + "\" data-id=\"-1\" data-panel=\"" + x + "\" data-assetid=\"-1\" data-propertyid=\"-1\" data-range=\"\" oncontextmenu=\"ContextMenu(event);event.preventDefault();\" style=\"width: 100%; height: 100%;\"><div class=\"title\">" + panelsettings[x].title + "</div><div class=\"plotarea\" id=\"plotarea_" + x + "\"></div></div>"});
	}
    grid.load(items);
	//RenderPanels();
    resizeGrid(); // finally size to actual window

    window.addEventListener('resize', function() {resizeGrid()});
	window.addEventListener("contextmenu", function(e) { e.preventDefault(); });
	window.addEventListener("popstate",function(e) {
		lastrangestart = null;
		lastrangeend = null;
		
		//The origin will be different every time, so we should look into removing it...
		
		//alert("Popping " + e.state.rangestart + " to " + e.state.rangeend + " / " + e.state.structure);
		if (e.state.structure != structure)
		{
			//Reload!
			console.log("Structures Different!");
			structure = e.state.structure;
			ResetStructure();
		}
		else
		{
			console.log("Structures Match!");
		}		
		ApplyRange(e.state.rangestart,e.state.rangeend);
	});
	grid.on('change',function (a,b) {
		StoreGridChanges();
	});
	
	var originalSelection = document.getElementById('timerange').selectedIndex;
	$(window).bind("pageshow", function() {
		document.getElementById('timerange').selectedIndex = originalSelection;
	});
	
	window.markers = [];
	<?php
	foreach($markers as $mk)
	{?>
	window.markers.push(parseDateTime('<?php echo $mk;?>')); <?php
	}
	?>
	
	/*var el = new EventList('<?php echo $siteroot;?>','#eventlist',function(st,en,nm){
		ApplyRange(st + " to " + en);
		el.Hide();
	});*/
	<?php if (($range !== FALSE) && ($range != "live"))
	{?>
	var sd = rangestart;
	var ed = rangeend;<?php
	}
	else
	{?>
	var sd = null;
	var ed = null;
	<?php }; ?>
	
	var tsoptions = {
		"server": "<?php echo $siteroot; ?>",		
		"minScale": 5,
		"maxScale": 1440,
		"liveOption": true,
		"liveDefault": true,
		"startDate": sd,
		"endDate": ed,
		"redirectDate": $('#customtime'),
		"inline": false,
		"nonLiveText": "History",
		"anchor": 'right',
		"onrangechange": function (st,en){
			if (st == null)
				$('#timerange').val('live');
			else			
				$('#timerange').val(st + " to " + en);
			
			RangeChange();
		}
	};

	window.timecontrol = $('#timerange').timeselector(tsoptions);
	
	dashdata.Start("<?php echo $_SERVER['HTTP_HOST'];?>/<?php echo $siteroot;?>");
	<?php if ($range !== FALSE) { ?>ApplyRange(<?php
	if (is_numeric($range)) 
		echo $range;
	else
		echo '"'.$range.'"';
	?>);<?php }; ?>
	
function Save()
{
	$.post('save',{<?php
		if (isset($_REQUEST['board'])) 
		{
			echo ' "board": "'.$_REQUEST['board'].'", "id": '.$_REQUEST['id'];
		}
		else
		{
			if ((isset($specificid)) && ($specificid != ""))
			{
				echo ' "id": '.$specificid;
			}
		}
	?>},function(d) {
		if (d.status == "CHOICE")
		{
			$('#savecontrols').html(d.content);
			$('#savepopup').fadeIn(500);
			
		}
		else
		{
			if (d.status == "OK")
			{
				Regen();
			}
			else
			{
				alert("Save Failed: " + d.message);
			}
		}
	});
}

function New()
{
	NavigatingOut();
	$('#actionformact').val("new");
	$('#actionformasset').val(0);
	$('#actionformproperty').val(0);
	$('#actionformpanel').val(-1);
	$('#actionformrange').val($('#timerange').val());
	$('#actionform').submit();
}

function Flip(v,rng)
{	
	NavigatingOut();
	if (rng == undefined)
	{
		rng = $('#timerange').val();
	}
	<?php 
	echo '/'.'/'.$range."\r\n";
		if (($range == "") || ($range == "live") )
			echo 'if (v != "live") {';
		else
			echo 'if (v == "live") {';?>
		$('#actionformact').val("flip");
		$('#actionformasset').val(v);
		$('#actionformproperty').val(0);
		$('#actionformpanel').val(-1);
		$('#actionformrange').val(rng);
		$('#actionform').submit();
	}
}

function Analyse(v)
{	
		NavigatingOut();
		$('#actionformact').val("analyse");
		$('#actionformasset').val(0);
		$('#actionformproperty').val(0);
		$('#actionformpanel').val(0);
		$('#actionformrange').val(rangestart + " to " + rangeend);
		$('#actionform').submit();	
}

function Regen(e)
{	
	<?php 
	if ($dashboard !== null)
	{
		if (property_exists($dashboard,"origin")) { ?>
	if ((e != undefined) && (e.shiftKey == true))
		window.location = '<?php echo $dashboard->origin;?>&regen=true';
	else
		window.location = '<?php echo $dashboard->origin;?>';
	<?php }; }; ?>
}

function RenameDashboard()
{
	$('#dashboardname').hide(0);
	$('#dashname').show(0);
	$('#dashname').on('keydown',function(e) {
		if (e.key == "Enter")
		{
			$('#dashboardname').html($('#dashname').val()).show(0);
			$('#newname').val($('#dashname').val());
			$('#dashname').hide(0);			
			StoreNameChange();
		}
	});
	$('#dashname').on('blur',function(e) {
		$('#dashboardname').html($('#dashname').val()).show(0);
		$('#newname').val($('#dashname').val());
		$('#dashname').hide(0);
		StoreNameChange();
	});
	$('#dashname').focus();
}

function StoreGridChanges()
{
	var gridvalues = grid.save(false);
	for(var x=0;x<gridvalues.length;x++)
	{
		gridvalues[x].style = panelsettings[gridvalues[x].id].style;
		gridvalues[x].title = panelsettings[gridvalues[x].id].title;
	}
	var changes = JSON.stringify(gridvalues);
	$.post('savegrid',{grid: changes},function(dta){
		console.log("Saved");		
	});
}

function StoreNameChange()
{	
	var newname = $('#dashboardname').html();
	<?php if (($range == "") || ($range == "live")) { ?>			
	newname.replace("(History)","(Live)");
	if (!newname.includes("(Live)")) newname += " (Live)";
	<?php }	else { ?>
	newname.replace("(Live)","(History)");
	if (!newname.includes("(History)")) newname += " (History)";
	<?php }; ?>
	$.post('savename',{name: newname},function(dta){
		console.log("Saved");		
	});
	
	$('#dashboardname').html(newname);
}
	
function UpdateData()
{
	for(var x=0;x<panelsettings.length;x++)
	{
		try
		{
			try
			{
				panelsettings[x].update(panelsettings[x].data);
			}
			catch(e)
			{
				console.log("Exception!");
			}
		}
		catch(e)
		{
		}
	}
}

var SearchInit = false;
var PropInit = false;

function AddProperty()
{
	$('.addelement').fadeIn(250);
	if (PropInit == false)
	{
		PropInit = true;
		var assetlist = new Bloodhound({
		  datumTokenizer: Bloodhound.tokenizers.obj.whitespace('text'),
		  queryTokenizer: Bloodhound.tokenizers.whitespace,
		  limit: 100,
		  remote: 'assetpropertysearch?q=%QUERY'
		});
		 
		// kicks off the loading/processing of `local` and `prefetch`
		assetlist.initialize();

		$("#lookitup").typeahead({
				hint: true,
				highlight: true,
				minLength: 2
			},{
				name: 'assets',
				displayKey: 'text',
				source: assetlist.ttAdapter(),
				templates: {
					empty: [
					  '<div class="tt-suggestions" style="font-size: small;"><div class="tt-suggestion">Not Found</div>',
					  '</div>'
					].join('\n'),
					suggestion: function(data){
						return '<p class="searchresult">' + data.text + '<span>' + data.path + '</span></p>';
					}            
				}        
			});
			
		$("#lookitup").on('typeahead:selected',function (evt,item) {    	
			var assetid = item.id;
			var propertyid = item.property;
			//alert("Adding " + assetid + ":" + propertyid);
			$('#actionformact').val("add");
			$('#actionformasset').val(assetid);
			$('#actionformproperty').val(propertyid);
			$('#actionformpanel').val(-1);
			$('#actionform').submit();
		});
		
		$("#lookitup").after('<input type="hidden" name="id" id="newassetid"/>');
	}	
	$('#lookitup').focus();
}

function ChangeTheme() {
	var newtheme = '<?php echo explode(' ',strtolower($nextmode))[0];?>';
	var content = window.location.href;
	var updated = "";
	if (content.indexOf('theme=') > 0)
	{		
		if (newtheme == 'dark')
			updated = content.replace("theme=light","theme=dark");
		else
			updated = content.replace("theme=dark","theme=light");
	}
	else
	{
		updated = content + "&theme=" + newtheme;
	}
	window.location.href = updated;
}

function StartSearch()
{
	$('.searchelement').fadeIn(250);
	if (SearchInit == false)
	{
		SearchInit = true;
		var assetlistsearch = new Bloodhound({
		  datumTokenizer: Bloodhound.tokenizers.obj.whitespace('text'),
		  queryTokenizer: Bloodhound.tokenizers.whitespace,
		  limit: 100,
		  remote: '<?php echo $siteroot;?>/ajax/assetnamesearch?q=%QUERY'
		});
		 
		// kicks off the loading/processing of `local` and `prefetch`
		assetlistsearch.initialize();

		$("#lookitupsearch").typeahead({
				hint: true,
				highlight: true,
				minLength: 2
			},{
				name: 'assets',
				displayKey: 'text',
				source: assetlistsearch.ttAdapter(),
				templates: {
					empty: [
					  '<div class="tt-suggestions" style="font-size: small;"><div class="tt-suggestion">Not Found</div>',
					  '</div>'
					].join('\n'),
					suggestion: function(data){
						return '<p class="searchresult">' + data.text + '<span>' + data.path + '</span></p>';
					}            
				}        
			});
			
		$("#lookitupsearch").on('typeahead:selected',function (evt,item) {    	
			var assetid = item.id;
			GoTo('id=' + item.id);
		});
		
		$("#lookitupsearch").after('<input type="hidden" name="id" id="switchassetid"/>');
	}
	
	$('#lookitup').focus();
}

function DeleteChannel(panel,asset,prop)
{
	$('#actionformact').val("del");
	$('#actionformasset').val(asset);
	$('#actionformproperty').val(prop);
	$('#actionformpanel').val(panel);
	$('#actionform').submit();
}

function Query()
{
	
}
	
function RenderPanels()
{
	ResizeRenderRefresh = 0;
	for(var x=0;x<panelsettings.length;x++)
	{
		panelsettings[x].initialised = false;
		try
		{
			RenderContent(panelsettings[x]);
		}
		catch
		{
			console.log("Exception Rendering Panel " + x);
		}
	}	
}	

function RenderContent(panelinfo)
{
	ob = $('.panel_' + panelinfo.number);
	if (panelinfo.initialised == false)
	{
		panelinfo.width = ob.width()-2;
		panelinfo.height = ob.height()-8;
		panelinfo.obj = ob;
		$('#plotarea_' + (panelinfo.number-1)).html("");
	}
	else
	{
		if (panelinfo.width != ob.width()) panelinfo.initialised = false;
		if (panelinfo.height != ob.height()) panelinfo.initialised = false;
		panelinfo.width = ob.width()-2;
		panelinfo.height = ob.height()-8;
		$('#plotarea_' + (panelinfo.number-1)).html("");
	}
	//alert('Erasing Plot Area ' + '#plotarea_' + (panelinfo.number-1));
	if (panelinfo.initialised == false)
	{
<?php
foreach($plugins as $plug)
{?>
		if (panelinfo.style == "<?php echo $plug; ?>")
			vis_<?php echo $plug; ?>_Create(panelinfo);
<?php }; ?>
		
		panelinfo.initialised = true;
	}	
}

var tooltipob = null;
var tooltipid = null;
var tooltipcontext = null;


function RangeChange()
{
	var vl = $('#timerange').val();
	if (vl[0] == "*")
	{
		$('#customtime').fadeIn(500);
		$('#timecontrols').fadeIn(500);
		$('#customtime').focus();
		return;
	}
	else
	{
		//$('#customtime').fadeOut();
		//$('#timecontrols').fadeOut();
	}
	
	if (vl == "live")
	{		
<?php if (($range != FALSE) && ($range != "live")) { ?>
		
		Flip(vl); 
		<?php }; ?>
	}
	else
	{		
	
		<?php if (($range === FALSE) || ($range == "live")) { ?>
		Flip(vl);
		<?php } else { ?>
		ApplyRange();
		<?php }; ?>
	}
}


$(function() {
	sd = moment().startOf('day');
	ed = moment().endOf('day');
	
	<?php if (($range !== FALSE) && ($range != "live"))
	{?>
		sd = moment(rangestart,'YYYY-MM-DD HH:mm:ss');
		ed = moment(rangeend,'YYYY-MM-DD HH:mm:ss');<?php
	}?>
	
	 /*$('#customtime').daterangepicker({
		timePicker: true,
		startDate: sd,
		endDate: ed,
		locale: {
		  format: 'hh:mm A DD/MM/YYYY'
		}
	 },function(st,en) {
		 var sts = st.format("YYYY-MM-DD HH:mm:ss");
		 var ens = en.format("YYYY-MM-DD HH:mm:ss");
		 <?php if (($range === FALSE) || ($range == "live")) { ?>
		Flip(1,sts + " to " + ens);
		<?php } else { ?>
		ApplyRange(sts + " to " + ens);
		<?php }; ?>
	 });*/
});
		</script>
		
		<div class="menuholder" style="display: none; min-height: 90px;position: absolute;left: 20px; top: 20px;min-width: 200px; color: white;" id="moremenu" name="moremenu">
			<menu class="menu show-menu">
  <li class="menu-item">
    <button type="button" class="menu-btn"> <i class="fa fa-folder-open"></i> <span class="menu-text">[ LOADING ]</span> </button>
  </li>
</menu>
		</div>
		
		<div class="tooltip" id="tooltip">
			
		</div>
		
		<div class="addelement popup" id="popup" style="display: none;">
			<label>Asset:</label> <input type="text" name="assetname" id="lookitup" style="padding-left: 0.5em;"/><br/><br/>
			<!--<button class="btn" style="background-color: #555555; color: white; width: 100%;">Add Navigation</button>-->
			<form method="POST" id="actionform">
				<input type="hidden" id="actionformproperty" name="property"/>
				<input type="hidden" id="actionformasset" name="asset"/>
				<input type="hidden" id="actionformact" name="act"/>
				<input type="hidden" id="actionformpanel" name="panel"/>
				<input type="hidden" id="actionformrange" name="range" value="<?php echo $range; ?>"/>
				<input type="hidden" id="actionformmisc" name="misc" value=""/>
			</form>
		</div>
		
<?php
if (($range !== FALSE) && ($range != "") && ($range != "live"))
{?>
		<div class="leftedge edge">
			<a href="#" onclick="PrevTime(); return false;"><i class="fa fa-arrow-left"></i></a>
			<a href="#" onclick="ZoomOut(); return false;"><i class="fa fa-search-minus"></i></a>
		</div>
		<div class="rightedge edge">
			<a href="#" onclick="NextTime(); return false;" alt="Move Forwards"><i alt="Move Forwards" class="fa fa-arrow-right"></i></a>
			<a href="#" onclick="ZoomIn(); return false;" alt="Zoom In"><i class="fa fa-search-plus" alt="Zoom In"></i></a>
		</div>
<?php
}
?>		
		<div class="searchelement popup" id="popup" style="display: none;">
			<label>Asset:</label> <input type="text" name="searchassetname" id="lookitupsearch" style="padding-left: 0.5em;"/><br/><br/>
			<!--<button class="btn" style="background-color: #555555; color: white; width: 100%;">Add Navigation</button>-->			
		</div>
		
		<div class="savelocation popup" id="savepopup" style="display: none;">
			<label>Name:</label><br/>			
			<form method="POST" action="save" id="saveform">
				<input type="text" name="newname" id="newname" value="<?php echo $dashboard->name;?>"/>
				<label>Under:</label><br/>			
				 <span id="savecontrols"> </span>
				<button class="btn">Save Dashboard</button>
			</form>
		</div>
		
		<?php
		if ((isset($specificid)) && ($specificid !== FALSE))
		{
			//This is an individual asset.					
			$ass = GetAssetByID($specificid);
			
			$allkeys = array();
			$hits = 0;
			foreach(array_keys($asset[$ass->id]['relationships']) as $k)
			{
				if ($k == 3) continue;						
				foreach($allrels as $rx)
				{
					if ($rx->id == $k)
					{
						if ($rx->name == "Model")
						{
							break;
						}		

						if ($hits >= 1)
						{
							echo ' | ';
						}
						
						$hits++;
						$allkeys[$rx->name] = $rx->id;
						break;
					}
				}						
			}
			//print_r($allkeys);
			foreach($allkeys as $k => $v)
			{?>
<div class="navigate" style="display: none;" id="navpopup_<?php echo $v; ?>">
	<ul class="dashboardlist">
<?php
				$newurl = "id=TARGETID";				
				
				$nav = $v;
				
				$localview = false;
				if ((!isset($_REQUEST['origin'])) && ($id > 0) && ($nav != 2))
				{					
					$newurl = "from=".$id.'&to=TARGETID';
					
				}
				if (($range !== FALSE) && ($range != "") && ($range != "live"))
				{
					$newurl .= "&range=".$range;
				}
				
				$from = FALSE;
				
				$from = $specificid;
				$asx = GetAssetByID($from);
				foreach($asset[$asx->id]['relationships'][$nav] as $v)
				{
					if ($v['upstream'] == true)
					{
						$dink = GetAssetByID($v['target']); ?>
	<li class="up"><a href="dash?<?php echo str_replace("TARGETID",$dink->id,$newurl);?>"><?php echo $dink->name;?></a></li><?php							
					}
				}
				
				foreach($asset[$asx->id]['relationships'][$nav] as $v)
				{
					if ($v['upstream'] == false)
					{
						$dink = GetAssetByID($v['target']);
						?>
	<li class="down"><a href="dash?<?php echo str_replace("TARGETID",$dink->id,$newurl);?>"><?php echo $dink->name;?></a></li><?php							
					}
				}
				
?>
</ul></div><?php
			}
			if (isset($_REQUEST['navigate']))
				$nav = $_REQUEST['navigate'];
			
		}?>
				
		<div class="errorpage" id="errorpage" style="display: none; position: fixed; bottom: 1em; left: 1em; width: 40%; min-height: 3em; background-color: red; color: white; padding: 1em; border-radius: 5px">
			
		</div>
	</body>
</html>