xcolumn = TD.getChannel(TD.mapping["X"]);
ycolumn = TD.getChannel(TD.mapping["Y"]);

if (xcolumn == -1) xcolumn = 1;
if (ycolumn == -1) ycolumn = xcolumn + 1;

var wd = $('#plotarea_1').width();
var ht = $('#plotarea_1').height();

// set the dimensions and margins of the graph
var margin = {top: 10, right: 30, bottom: 30, left: 60},
    width = wd - margin.left - margin.right,
    height = ht - margin.top - margin.bottom;
	
var svg = d3.select("#plotarea_" + 1)
  .append("svg")		
	.attr("viewBox", "0 0 " + wd + " " + ht)
	.attr("preserveAspectRatio","xMidYMid meet")
	.attr("width","100%")
	.attr("height","100%")

// append the svg object to the body of the page
svg = svg
  .append("g")
    .attr("transform",
          "translate(" + margin.left + "," + margin.top + ")");

	var data = TD.records;
	
	var boundt = d3.extent(data,function (d) { return d[0]; });	

	var boundy = d3.extent(data,function (d) { return parseFloat(d[xcolumn]) - parseFloat(d[ycolumn]); });	
	
	var miny = boundy[0];
	var maxy = boundy[1];	
	
	if (Math.abs(miny) > maxy)
	{
		maxy = Math.abs(miny);
	}
	else
	{
		if (miny < 0)
			miny = -maxy;
	}
	
	function make_x_gridlines() {		
		return d3.axisBottom(x)
			.ticks(5)
	}

	// gridlines in y axis function
	function make_y_gridlines() {		
		return d3.axisLeft(y)
			.ticks(5)
	}

	var mint = parseDateTime(boundt[0]).getTime();
	var maxt = parseDateTime(boundt[1]).getTime();

  // Add X axis
  var x = d3.scaleTime()
    .domain([mint,maxt])
    .range([ 0, width ]);
  svg.append("g")
    .attr("transform", "translate(0," + height + ")")
    .call(d3.axisBottom(x));

  // Add Y axis  
  var y = d3.scaleLinear()
    .domain([miny, maxy])
    .range([ height, 0]);
  svg.append("g")
    .call(d3.axisLeft(y));
	
// add the X gridlines
	svg.append("g")			
	  .attr("class", "grid xaxis")
	  .attr("transform", "translate(0," + height + ")")
	  .call(make_x_gridlines()
		  .tickSize(-height)
		  .tickFormat("")
	  )

	// add the Y gridlines
	svg.append("g")			
	  .attr("class", "grid yaxis")
	  .call(make_y_gridlines()
		  .tickSize(-width)
		  .tickFormat("")
	  )	 
	  
  // Add line
  /*line = d3.line()
	.defined(function(d) {
		return (d[xcolumn] != null) && (d[xcolumn] != "^");
	})
	.x(function(d) {
		return x(parseDateTime(d[0]).getTime());
	})
	.y(function(d) {
		return y(d[ycolumn] - d[xcolumn]);
	})*/
	var ar = d3.area()
		.x(function (d) { 
			return x(parseDateTime(d[0]).getTime());
		})
		.y0(function (d) { 
			return y(d[xcolumn] - d[ycolumn]);
		})
		.y1(function (d) { 
			return y(0);
		});
	
	svg.append("path")
      .datum(data)
      .attr("fill", "#cce5df")
      .attr("stroke", "#69b3a2")	  
      .attr("stroke-width", 1.5)
      .attr("d", ar )
	
  /*finalline = svg.selectAll(".line" + q)
	.data(data)
	.join(
		  enter => 
			enter.append("path") 		  
				.attr("class","line" + q + " trendline")
				.attr("fill","none")
				.attr("stroke",ColourSequence[0])
				.attr("stroke-width","2")
				.attr("d", ar(data))			
				.attr("shape-rendering","geometricPrecision"),
		  update =>
			update
				.transition()
				.duration(800)
				.attr("d", ar(data)));*/