xcolumn = TD.getChannel(TD.mapping["X"]);
ycolumn = TD.getChannel(TD.mapping["Y"]);

if (xcolumn == -1) xcolumn = 0;
if (ycolumn == -1) ycolumn = xcolumn + 1;

var wd = $('#plotarea_1').width();
var ht = $('#plotarea_1').height();

// set the dimensions and margins of the graph
var margin = {top: 10, right: 30, bottom: 30, left: 60},
    width = wd - margin.left - margin.right,
    height = ht - margin.top - margin.bottom;
	
var svg = d3.select("#plotarea_" + 1)
  .append("svg")		
	.attr("viewBox", "0 0 " + wd + " " + ht)
	.attr("preserveAspectRatio","xMidYMid meet")
	.attr("width","100%")
	.attr("height","100%")

// append the svg object to the body of the page
svg = svg
  .append("g")
    .attr("transform",
          "translate(" + margin.left + "," + margin.top + ")");

	var data = TD.records;

	var minx = d3.min(data,function (d) { return parseFloat(d[xcolumn]); });
	var maxx = d3.max(data,function (d) { return parseFloat(d[xcolumn]); });
	var xspn = maxx - minx;
	
	var miny = d3.min(data,function (d) { return parseFloat(d[ycolumn]); });
	var maxy = d3.max(data,function (d) { return parseFloat(d[ycolumn]); });
	var yspn = maxy - miny;
	
	minx -= (xspn * 0.05);
	maxx += (xspn * 0.05);
	
	miny -= (yspn * 0.05);
	maxy += (yspn * 0.05);
	
// gridlines in x axis function
	function make_x_gridlines() {		
		return d3.axisBottom(x)
			.ticks(5)
	}

	// gridlines in y axis function
	function make_y_gridlines() {		
		return d3.axisLeft(y)
			.ticks(5)
	}

  // Add X axis
  var x = d3.scaleLinear()
    .domain([minx, maxx])
    .range([ 0, width ]);
  svg.append("g")
    .attr("transform", "translate(0," + height + ")")
    .call(d3.axisBottom(x));

  // Add Y axis  
  var y = d3.scaleLinear()
    .domain([miny, maxy])
    .range([ height, 0]);
  svg.append("g")
    .call(d3.axisLeft(y));
	
	// add the X gridlines
	svg.append("g")			
	  .attr("class", "grid xaxis")
	  .attr("transform", "translate(0," + height + ")")
	  .call(make_x_gridlines()
		  .tickSize(-height)
		  .tickFormat("")
	  )

	// add the Y gridlines
	svg.append("g")			
	  .attr("class", "grid yaxis")
	  .call(make_y_gridlines()
		  .tickSize(-width)
		  .tickFormat("")
	  )	

  // Add dots
  svg.append('g')
    .selectAll("dot")
    .data(TD.records)
    .enter()
    .append("circle")
      .attr("cx", function (d) { return x(d[xcolumn]); } )
      .attr("cy", function (d) { return y(d[ycolumn]); } )
      .attr("r", 3.5)
      .style("fill", "#69b3a2")