

function vis_barchart_Create(ob)
{	
	var margin = {top: 20, right: 20, bottom: 70, left: 30};
	
	/*if (ob.data.length == 1)
	{
		margin.bottom = 20;
	}*/
	
	var svg = d3.select("#plotarea_" + (ob.number-1))
	  .append("svg")		
		.attr("viewBox", "0 0 " + ob.width + " " + ob.height)
		.attr("preserveAspectRatio","xMidYMid meet")
		.attr("width","100%")
		.attr("height","100%")
	  .append("g")
		.attr("transform",
			  "translate(" + margin.left + "," + margin.top + ")");
			  
	var width = ob.width - margin.left - margin.right;
    var height = ob.height - margin.top - margin.bottom;
	
	var data = ob.data;
	
	var bgr = svg.append('rect')
	     .attr("width",width)
		 .attr("height",height)
		 .attr("fill","black")
		 .attr("stroke","none")
		 .attr("data-panel", ob.number-1)
		 .attr("data-id", -1)	
		 .attr("data-assetid","-1")		
		 .attr("data-base",ob.data[0].asset)
		 .attr("data-range", "live")
		 .attr("opacity","0")
		 .on("pointerdown",function(e) { TouchHandler(e); })
		 .on("contextmenu",function(e) { e.preventDefault(); e.stopPropagation(); ContextMenu(e);});

	var gradients = '<clipPath id="inframe' + ob.number + '">';
    gradients += '  <rect x="0" y="1" width="' + width + '" height="' + (height-2) + '" />';
    gradients += '</clipPath>';
	var defs = svg.append("defs").html(gradients);		 
		 
	if (ob.data.length == 1)
	{
		bgr.attr("data-id","0")
		   .attr("data-assetid",ob.data[0].asset)
		   .attr("data-propertyid", ob.data[0].property)
		   .attr("data-range", "live");
	}

	// gridlines in x axis function
	function make_x_gridlines() {		
		return d3.axisBottom(x)
			.ticks(5)
	}

	// gridlines in y axis function
	function make_y_gridlines() {		
		return d3.axisLeft(y)
			.ticks(5)
	}

	var x = d3.scaleBand()
	  .range([ 0, width ])
	  .domain(data.map(function(d) { return d.name; }))
	  .padding(0.2);
	  
	var bottomclass = "axis";
	//if (data.length == 1) bottomclass="hiddenaxis";
	
	svg.append("g")
	  .attr("transform", "translate(0," + height + ")")
	  .call(d3.axisBottom(x))
	  .selectAll("text")
		.attr("transform", "translate(-10,0)rotate(-45)")
		.style("text-anchor", "end")
		.attr("class",bottomclass);
			
	// Add Y axis
	var bounds = [d3.min(data,function(d) {return d.minimum; }), d3.max(data,function(d) { return d.maximum; })];
	
	if ((bounds[0] == 0) && (bounds[1] < 0))
	{
		var tmp = bounds[0];
		bounds[0] = bounds[1];
		bounds[1] = tmp;
	}
	var y = d3.scaleLinear()	  
	  .domain(bounds)
	  .range([ height, 0]);
	svg.append("g")
	  .call(d3.axisLeft(y));
	
	if ((bounds[0] < 0) && (bounds[1] > 0))
	{
		ob.zeropoint = 0;
	}
	else
	{
		if ((bounds[0] == 0) || (bounds[1] == 0))
		{
			ob.zeropoint = 0;
		}
		else
		{
			if (bounds[0] > 0) 
				ob.zeropoint = bounds[0];
			else
				ob.zeropoint = bounds[1];
			
		}
	}
	  
	// add the X gridlines
	svg.append("g")			
	  .attr("class", "grid")
	  .attr("transform", "translate(0," + height + ")")
	  .call(make_x_gridlines()
		  .tickSize(-height)
		  .tickFormat("")
	  )

	// add the Y gridlines
	svg.append("g")			
	  .attr("class", "grid")
	  .call(make_y_gridlines()
		  .tickSize(-width)
		  .tickFormat("")
	  )	
	  
	var origin = 0;
			  
	ob.update = function(dt) {
		
		var margin = {top: 20, right: 20, bottom: 70, left: 30};
		
		/*if (ob.data.length == 1)
		{
			margin.bottom = 20;
		}*/
		
		var width = ob.width - margin.left - margin.right;
		var height = ob.height - margin.top - margin.bottom;
		
		bars = svg.selectAll(".clickbars").data(ob.data)
		bars.join(
		  enter => 
			enter.append("rect") 		  
				.attr("class","clickbars")
				.attr("x", function(d) { return x(d.name) + (x.bandwidth() * 0.25); })	
				.attr("y", y(bounds[1]))
				.attr("width", x.bandwidth()*0.5)
				.attr("data-panel", ob.number-1)
				.attr("data-id", function (d,i) { return i; })
				.attr("data-assetid", function (d) { return d.asset;})
				.attr("data-propertyid", function (d) { return d.property;})
				.attr("data-range", "live")				
				.on("mouseover",function(e) { ShowTooltip(e); })
				.on("mousemove",function(e) { UpdateTooltip(e); })
				.on("mouseout",function(e) { HideTooltip(e); })	
				.on("contextmenu",function(e) { e.preventDefault(); e.stopPropagation(); ContextMenu(e);})
				.on("pointerdown",function(e) { TouchHandler(e); })
				.attr("fill",function (d) {
					if ((d.value === null) || (d.value == "^") || (isNaN(d.value)))
						return "purple";
					return "#111111";
				})	
				.attr("opacity",function (d) {
					if ((d.value === null) || (d.value == "^") || (isNaN(d.value)))
						return 0.5;
					return 0.1;
				})				
				.transition(1000)				
				.attr("height",Math.abs(y(bounds[1]) - y(bounds[0]))-2),
			update =>
				update
					.attr("fill",function (d) {
						if ((d.value === null) || (d.value == "^") || (isNaN(d.value)))
							return "purple";
						return "#111111";
					})	
					.attr("opacity",function (d) {
						if ((d.value === null) || (d.value == "^") || (isNaN(d.value)))
							return 0.5;
						return 0.1;
					})		
		);
		
		bars = svg.selectAll(".bars").data(ob.data)
		bars.join(
		  enter => 
			enter.append("rect") 		  
				.attr("class","bars")
				.attr("x", function(d) { return x(d.name); })	
				.attr("y", y(origin))
				.attr("width", x.bandwidth())
				.attr("data-panel", ob.number-1)
				.attr("data-id", function (d,i) { return i; })
				.attr("data-assetid", function (d) { return d.asset;})
				.attr("data-propertyid", function (d) { return d.property;})
				.attr("data-range", "live")
				.attr("clip-path","url(#inframe" + ob.number + ")")
				.on("mouseover",function(e) { ShowTooltip(e); })
				.on("mousemove",function(e) { UpdateTooltip(e); })
				.on("mouseout",function(e) { HideTooltip(e); })	
				.on("contextmenu",function(e) { e.preventDefault(); e.stopPropagation(); ContextMenu(e);})
				.on("pointerdown",function(e) { TouchHandler(e); })
				.attr("fill", function(d) {
					if (d.grad)
					{
						vl = DashCalcGradientColourRGB(( parseFloat(d.value) - d.minimum) / (d.maximum - d.minimum),d.grad);
						return vl;
					}
					return "#69b3a2";
				})
				.transition(1000)
				.attr("y", function(d) {
					if (d.value < 0)
					{
						return y(ob.zeropoint); 
					}
					else
					{
						if ((d.value === null) || (d.value == "^") || (isNaN(d.value)))
							return y(ob.zeropoint);
						return y(d.value); 
					}
				})
				.attr("height", function(d) { 
					if ((d.value === null) || (d.value == "^") || (isNaN(d.value)))
						return 0;
					if (d.value < 0)
					{
						var ht = y(d.value) - y(ob.zeropoint); 
						if (ht < 0) ht = 0;
						return ht;
					}
					else
					{
						var ht = y(ob.zeropoint) - y(d.value); 
						if (ht < 0) ht = 0;
						return ht;
					}
				}),
		  update =>
		    update
				.transition()				
				.attr("height", function(d) {					
					if ((d.value === null) || (d.value == "^") || (isNaN(d.value)))
						return 0;
					if (d.value < 0)
					{
						var ht = y(d.value) - y(ob.zeropoint); 
						if (ht < 0) ht = 0;
						return ht;
					}
					else
					{
						var ht = y(ob.zeropoint) - y(d.value); 
						if (ht < 0) ht = 0;
						return ht;
					}
				})
				.attr("y", function(d) { 
					if (d.value < 0)
					{
						return y(ob.zeropoint); 
					}
					else
					{
						if ((d.value === null) || (d.value == "^") || (isNaN(d.value)))
							return y(ob.zeropoint);
						return y(d.value); 
					}
				})
				.attr("fill", function(d) {
					if (d.grad)
					{
						vl = DashCalcGradientColourRGB(( parseFloat(d.value)- d.minimum) / (d.maximum - d.minimum),d.grad);
						return vl;
					}
					return "#69b3a2";
				})
		);
			
		
			

	}
	ob.update(ob.data);
	
	ob.updateTooltip = function(pntno,ctx) {
		return ob.data[pntno].fullname + "<br/><strong>" + (Math.round(ob.data[pntno].value*100)/100) + ob.data[pntno].units + "</strong>";
	}
	
}