

function vis_discrete_Create(ob)
{	
	var margin = {top: 20, right: 20, bottom: 90, left: 30};
	
	if (ob.data.length == 1)
	{
		margin.bottom = 30;
	}
	
	var svg = d3.select("#plotarea_" + (ob.number-1))
	  .append("svg")		
		.attr("viewBox", "0 0 " + ob.width + " " + ob.height)
		.attr("preserveAspectRatio","xMidYMid meet")
		.attr("width","100%")
		.attr("height","100%")
	  .append("g")
		.attr("transform",
			  "translate(" + margin.left + "," + margin.top + ")");
			  
	ob.svg = svg;
			  
	var width = ob.width - margin.left - margin.right;
    var height = ob.height - margin.top - margin.bottom;
	
	var data = ob.data;

	// gridlines in x axis function
	function make_x_gridlines() {		
		return d3.axisBottom(x)
			.ticks(5)
	}

	// gridlines in y axis function
	function make_y_gridlines() {		
		return d3.axisLeft(y)
			.ticks(5)
	}
	
	//var timeParser = d3.timeParse("%Y-%m-%d %H:%M:%S");
	//var msTimeParser = d3.timeParse("%Y-%m-%d %H:%M:%S.%f");
	
	var xextents = d3.extent(data[0].hist,function(d) { 
		return parseDateTime(d[0]); 
	});
	
	svg.append('rect')
	     .attr("width",width)
		 .attr("height",height)
		 .attr("fill","black")
		 .attr("stroke","none")
		 .attr("data-panel", ob.number-1)
		 .attr("data-id", -1)
		 .on("mouseover",function(e) { ShowTooltip(e); })
		 .on("mousemove",function(e) { UpdateTooltip(e); })
		 .on("mouseout",function(e) { HideTooltip(e); })
		 .attr("data-id", -1)	
		 .attr("data-assetid","-1")
		 .attr("data-range", ob.data[0].rangemin + "-" + ob.data[0].rangemax)
		 .attr("draggable","true")
		 .on("dragstart",function(e) { console.log("Dragging In Control"); })
		 .on("drag",function(e) { console.log("Dragging In Control"); })
		 .on("dragstop",function(e) { console.log("Finished Drag"); })
		 .on("pointerdown",function(e) { TouchHandler(e); })
		 .on("contextmenu",function(e) { e.preventDefault(); e.stopPropagation(); ContextMenu(e);});			 

	var x = d3.scaleTime()
		.domain([parseDateTime(data[0].rangemin),parseDateTime(data[0].rangemax)])
		.range([0,width]);
		
		
	ob.x = x;
	  
	var bottomclass = "axis";	
	
	svg.append("g")
	  .attr("transform", "translate(0," + height + ")")
	  .call(d3.axisBottom(x))
	  .selectAll("text")
		.attr("transform", "translate(-10,0)rotate(0)")
		.style("text-anchor", "middle")
		.attr("class",bottomclass);
			
	var ydomain = [0, ob.data.length];	
			
	// Add Y axis
	var y = d3.scaleBand()
	  .range([ 0, height ])
	  .domain(data.map(function(d) { return d.name; }))
	  .padding(0.01);
	  
	ob.y = y;
	  
	svg.append("g")
	  .attr("class","yaxis")
	  .call(d3.axisLeft(y))
	  
	  
	// add the X gridlines
	svg.append("g")			
	  .attr("class", "grid xaxis")
	  .attr("transform", "translate(0," + height + ")")
	  .call(make_x_gridlines()
		  .tickSize(-height)
		  .tickFormat("")
	  )

	// add the Y gridlines
	svg.append("g")			
	  .attr("class", "grid yaxis")
	  .call(make_y_gridlines()
		  .tickSize(-width)
		  .tickFormat("")
	  )
	  
	var origin = 0;
			  
	ob.update = function(dt) {
		
		var margin = {top: 20, right: 20, bottom: 70, left: 30};
		
		var width = ob.width - margin.left - margin.right;
		var height = ob.height - margin.top - margin.bottom;
		
		var timeFormat = new d3.timeFormat("%Y-%m-%d %H:%M:%S");
		
		for(var q=0;q<ob.data.length;q++)
		{
			var tzoffset = ob.data[q].tzoffset * 60000;
			
			var chunks = [];
			var tmp = null;
			last = null;
			laststart = null;
			lastsample = null;
			if (!ob.data[q].hist) continue;
			for(var v=0;v<ob.data[q].hist.length;v++)
			{
				tmp = ob.data[q].hist[v];
				tmp[1] = Math.floor(tmp[1]);
				if (last == null)
				{
					last = tmp[1];
					laststart = tmp[0];
					continue;
				}
				if (last != tmp[1])
				{
					chunks.push([last,laststart,tmp[0]]);
					last = tmp[1];
					laststart = tmp[0];
				}
				last = tmp[1];
				lastsample = tmp[0];
			}
			if (laststart != lastsample)
			{
				chunks.push([last,laststart,lastsample]);
			}
			
			var data = chunks.map(function(d) {				
				return {
				  value: d[0],
				  startingat: new Date(parseDateTime(d[1]).getTime() - tzoffset),
				  endingat: new Date(parseDateTime(d[2]).getTime() - tzoffset)
				};
			});
			
			bars = svg.selectAll(".bars" + q).data(data)
			bars.join(
			  enter => 
				enter.append("rect") 		  
					.attr("class","bars" + q)
					.attr("x", function(d) { return x(d.startingat); })	
					.attr("y", function(d) { 
						return y(ob.data[q].name); 
					})
					.attr("height", y.bandwidth())
					.attr("width", function (d) {
						return x(d.endingat) - x(d.startingat);
					 })
					.attr("data-panel", ob.number-1)
					.attr("data-id", function (d,i) { return q; })
					.attr("data-node", function (d,i) { 
						try {
							return ob.data[q].node;
						}
						catch
						{
							return "";
						}	
					 })
					.attr("data-assetid", function (d) { return ob.data[q].asset;})
					.attr("data-propertyid", function (d) { return ob.data[q].property;})
					.attr("data-range", function (d) {
						return timeFormat(d.startingat) + " to " + timeFormat(d.endingat);
					})
					.attr("data-value", function (d) {
						try
						{							
							return ob.data[q].map[d.value] + " (" + d.value + ")";
						}
						catch(e)
						{
							return d.value;
						}
					})
					.attr("data-duration", function (d) {
						var tm = (d.endingat - d.startingat) / 1000;
						if (tm > 86400) return (Math.round((tm*10) / 86400)/10) + " Days";
						if (tm > 5400) return (Math.round((tm*10) / 3600)/10) + " Hours";
						if (tm > 120) return (Math.round((tm*10) / 60)/10) + " Minutes";
						return (Math.round(tm*10)/10) + " Seconds";
					})
					.on("mouseover",function(e) { ShowTooltip(e); })
					.on("mousemove",function(e) { UpdateTooltip(e); })
					.on("mouseout",function(e) { HideTooltip(e); })	
					.on("contextmenu",function(e) { e.preventDefault(); e.stopPropagation(); ContextMenu(e);})
					.on("pointerdown",function(e) { TouchHandler(e); })
					.attr("fill", function(d) {
						try
						{
							return ob.data[0].colourmap[d.value];
						}
						catch(e)
						{
							if (d.value == 0) return 'black';
							return 'green';
						}
					})					
			);
		}
			
		if (window.markers.length > 0)
		{
			var marks = ob.svg.selectAll(".marker" + q)
				.data(window.markers)
				.join(
					  enter => 
						enter.append("line") 		  
							.attr("class","marker")
							.attr("fill","none")
							.attr("stroke","silver")
							.attr("stroke-width","2")
							.attr("x1",function(d) {
								return x(d);
							})
							.attr("x2",function(d) {
								return x(d);
							})
							.attr("y1",0)
							.attr("y2",ob.height)
							.attr("stroke-dasharray","4")
							.attr("shape-rendering","geometricPrecision"),
					  update =>
						update
							.transition()
							.duration(800)
							.attr("d", line(data))
				)	
		}
			

	}
	ob.update(ob.data);
	
	ob.updateTooltip = function(pntno,ctx) {
		
		return ob.data[pntno].fullname + "<br/><strong>" + ctx.currentTarget.getAttribute("data-value") + "</strong><br/>" + ctx.currentTarget.getAttribute("data-duration") + "<br/>From " + ctx.currentTarget.getAttribute("data-range");
	}
	
}