

function vis_distchart_Create(ob)
{	
	var margin = {top: 20, right: 20, bottom: 70, left: 30};
	
	var svg = d3.select("#plotarea_" + (ob.number-1))
	  .append("svg")		
		.attr("viewBox", "0 0 " + ob.width + " " + ob.height)
		.attr("preserveAspectRatio","xMidYMid meet")
		.attr("width","100%")
		.attr("height","100%")
	  .append("g")
		.attr("transform",
			  "translate(" + margin.left + "," + margin.top + ")");
			  
	var width = ob.width - margin.left - margin.right;
    var height = ob.height - margin.top - margin.bottom;
	
	var data = ob.data;
	var gradients = "<linearGradient id=\"sgrav" + ob.number + "\" gradientTransform=\"rotate(90)\">";
	gradients += '  <stop offset="0%" stop-color="#000000"/>';
	gradients += '  <stop offset="25%" stop-color="#205B20"/>';
	gradients += '  <stop offset="50%" stop-color="#55FF55"/>';
	gradients += '  <stop offset="75%" stop-color="#204420"/>';
	gradients += '  <stop offset="100%" stop-color="#000000"/>';
	gradients += "</linearGradient>";
	gradients += '<clipPath id="inframe' + ob.number + '">';
    gradients += '  <rect x="0" y="1" width="' + width + '" height="' + (height-2) + '" />';
    gradients += '</clipPath>';
	var defs = svg.append("defs").html(gradients);
	
	var bgr = svg.append('rect')
	     .attr("width",width)
		 .attr("height",height)
		 .attr("fill","black")
		 .attr("stroke","none")
		 .attr("data-panel", ob.number-1)
		 .attr("data-id", -1)	
		 .attr("data-assetid","-1")		
		.attr("data-range", "live")		 
		 .on("click",function(e) { NavMenu(e); })
		 .on("contextmenu",function(e) { e.preventDefault(); e.stopPropagation(); ContextMenu(e);});	
		 
	if (ob.data.length == 1)
	{
		bgr.attr("data-id","0")
		   .attr("data-assetid",ob.data[0].asset)
		   .attr("data-propertyid", ob.data[0].property)
		   .attr("data-range", "live");
	}

	// gridlines in x axis function
	function make_x_gridlines() {		
		return d3.axisBottom(x)
			.ticks(5)
	}

	// gridlines in y axis function
	function make_y_gridlines() {		
		return d3.axisLeft(y)
			.ticks(5)
	}

	var x = d3.scaleBand()
	  .range([ 0, width ])
	  .domain(data.map(function(d) { return d.name; }))
	  .padding(0.2);
	  
	var bottomclass = "axis";
	
	svg.append("g")
	  .attr("transform", "translate(0," + height + ")")
	  .call(d3.axisBottom(x))
	  .selectAll("text")
		.attr("transform", "translate(-10,0)rotate(-45)")
		.style("text-anchor", "end")
		.attr("class",bottomclass);
			
	// Add Y axis
	var bounds = [d3.min(data,function(d) {return d.minimum; }), d3.max(data,function(d) { return d.maximum; })];
	
	var y = d3.scaleLinear()	  
	  .domain(bounds)
	  .range([ height, 0]);
	svg.append("g")
	  .call(d3.axisLeft(y));
	
	if ((bounds[0] < 0) && (bounds[1] > 0))
	{
		ob.zeropoint = 0;
	}
	else
	{
		if ((bounds[0] == 0) || (bounds[1] == 0))
		{
			ob.zeropoint = 0;
		}
		else
		{
			if (bounds[0] > 0) 
				ob.zeropoint = bounds[0];
			else
				ob.zeropoint = bounds[1];
			
		}
	}
	
	ob.contentgroup = svg.append("g");
	  
	// add the X gridlines
	svg.append("g")			
	  .attr("class", "grid")
	  .attr("transform", "translate(0," + height + ")")
	  .call(make_x_gridlines()
		  .tickSize(-height)
		  .tickFormat("")
	  )

	// add the Y gridlines
	svg.append("g")			
	  .attr("class", "grid")
	  .call(make_y_gridlines()
		  .tickSize(-width)
		  .tickFormat("")
	  )	
	  
	var origin = 0;
			  
	ob.update = function(dt) {
		
		var margin = {top: 20, right: 20, bottom: 70, left: 30};		
		
		var width = ob.width - margin.left - margin.right;
		var height = ob.height - margin.top - margin.bottom;		
		
		bars = ob.contentgroup.selectAll(".clickbars").data(ob.data)
		bars.join(
		  enter => 
			enter.append("rect") 		  
				.attr("class","clickbars")
				.attr("x", function(d) { return x(d.name) + (x.bandwidth() * 0.25); })	
				.attr("y", y(bounds[1]-1))
				.attr("width", x.bandwidth()*0.5)
				.attr("data-panel", ob.number-1)
				.attr("data-id", function (d,i) { return i; })
				.attr("data-assetid", function (d) { return d.asset;})
				.attr("data-propertyid", function (d) { return d.property;})
				.attr("data-range", "live")
				.on("mouseover",function(e) { ShowTooltip(e); })
				.on("mousemove",function(e) { UpdateTooltip(e); })
				.on("mouseout",function(e) { HideTooltip(e); })	
				.on("contextmenu",function(e) { e.preventDefault(); e.stopPropagation(); ContextMenu(e);})
				.on("click",function(e) { NavMenu(e);})				
				.attr("fill","#111111")	
				.attr("opacity","0.2")				
				.transition(1000)				
				.attr("height",Math.abs(y(bounds[1]) - y(bounds[0]))-2)			
		);
		
		for(var n=0;n<ob.data.length;n++)
		{
			var dt = ob.data[n];
			if (dt.hist.length == 0)
			{
				ob.data[n].min = 0;
				ob.data[n].max = 0;
				ob.data[n].mean = 0;
				ob.data[n].variance = 0;
				continue;
			}
			
			var mx = parseFloat(dt.hist[0][1]);
			var mn = mx;
			var ttl = 0;
			var samples = 0;
			var squares = 0;
			var curr = 0;
			for(var q=0;q<dt.hist.length;q++)
			{
				curr = parseFloat(dt.hist[q][1]);
				if (curr == null) continue;
				
				if (curr > mx)
					mx = curr;
				if (curr < mn)
					mn = curr;
				ttl += curr;
				samples += 1;
			}
			
			var mean = ttl / samples;
			
			for(var q=0;q<dt.hist.length;q++)
			{
				curr = parseFloat(dt.hist[q][1]);
				if (curr == null) continue;
				
				squares += (curr - mean) * (curr - mean);				
			}
			
			var variance = Math.sqrt(squares / samples);
			ob.data[n].min = mn;
			ob.data[n].max = mx;
			ob.data[n].mean = mean;
			ob.data[n].variance = variance;
			
		}		
		
		bars = ob.contentgroup.selectAll(".bars").data(ob.data)
		bars.join(
		  enter => 
			enter.append("rect") 		  
				.attr("class","bars")
				.attr("x", function(d) { return x(d.name); })	
				.attr("y", y(origin))
				.attr("width", x.bandwidth())
				.attr("data-panel", ob.number-1)
				.attr("data-id", function (d,i) { return i; })
				.attr("data-assetid", function (d) { return d.asset;})
				.attr("data-propertyid", function (d) { return d.property;})
				.attr("data-range", "live")
				.attr("clip-path","url(#inframe" + ob.number + ")")
				.on("mouseover",function(e) { ShowTooltip(e); })
				.on("mousemove",function(e) { UpdateTooltip(e); })
				.on("mouseout",function(e) { HideTooltip(e); })	
				.on("contextmenu",function(e) { e.preventDefault(); e.stopPropagation(); ContextMenu(e);})
				.on("click",function(e) { NavMenu(e);})				
				.attr("fill", function(d) {					
					return "url(#sgrav" + ob.number + ")";
				})				
				.attr("y", function(d) {					
					
					return y(d.mean + (d.variance*2)); 
					
				})
				.attr("height", function(d) { 
					if (d.value == null) return 0;
					
					var ht = Math.abs(y(d.mean - (d.variance*2)) - y(d.mean + (d.variance*2)) ); 
					return ht;
				}),
		  update =>
		    update					
				.attr("y", function(d) {					
					
					return y(d.mean + (d.variance*2)); 
					
				})
				.attr("height", function(d) { 
					if (d.value == null) return 0;
					
					var ht = Math.abs(y(d.mean - (d.variance*2)) - y(d.mean + (d.variance*2)) ); 
					return ht;
				})				
		);
			
		points = ob.contentgroup.selectAll(".points").data(ob.data)
		points.join(
		  enter => 
			enter.append("rect") 		  
				.attr("class","points")
				.attr("x", function(d) { return x(d.name)-1; })	
				.attr("y", y(origin))
				.attr("width", x.bandwidth()+2)
				.attr("fill", function(d) {					
					return "#FFFFFF";
				})				
				.attr("y", function(d) {					
					
					return y(d.value); 
					
				})
				.attr("height", 5),
		  update =>
		    update
				.transition()				
				.attr("y", function(d) {					
					
					return y(d.value); 
					
				})				
		);
			

	}
	ob.update(ob.data);
	
	ob.updateTooltip = function(pntno,ctx) {
		return ob.data[pntno].fullname + "<br/>Current: <strong>" + (Math.round(ob.data[pntno].value*100)/100) + ob.data[pntno].units + "</strong>" + "<br/>Average: <strong>" + (Math.round(ob.data[pntno].mean*100)/100) + ob.data[pntno].units + "</strong>" + "<br/>Std Dev: <strong>" + (Math.round(ob.data[pntno].variance*100)/100) + ob.data[pntno].units + "</strong>";
	}
	
}