
function vis_text_Create(ob)
{	
		
	var margin = {top: 20, right: 20, bottom: 20, left: 20};	
	
    var width = ob.width - margin.left - margin.right;
    var height = ob.height - margin.top - margin.bottom;

	// append the svg object to the body of the page
	//alert("Writing To #plotarea_" + (ob.number-1));
	var svg = d3.select("#plotarea_" + (ob.number-1))
	  .append("svg")		
		.attr("viewBox", "0 0 " + ob.width + " " + ob.height)
		.attr("preserveAspectRatio","xMidYMid meet")
		.attr("width","100%")
		.attr("height","100%")		
		.attr("data-assetid",ob.data[0].assetid)
		.attr("data-range", ob.data[0].rangemin + "-" + ob.data[0].rangemax)
		.attr("data-panel", ob.number-1)
		.attr("data-id", 0)
		.on("click",function(e) { NavMenu(e); })
		.on("contextmenu",function(e) { e.preventDefault(); e.stopPropagation(); ContextMenu(e);}) 
	  .append("g")
		.attr("transform",
			  "translate(" + margin.left + "," + margin.top + ")");
		
	ob.update = function(dt) {
		data = ob.data;
		
		var margin = {top: 20, right: 20, bottom: 20, left: 20};	
		
		var width = ob.width - margin.left - margin.right;
		var height = ob.height - margin.top - margin.bottom;
		
		if (ob.data[0].colourmap)
		{
			var bgs = svg.selectAll("rect").data(data);
			bgs.join(
				enter => 
					enter.append("rect")
						 .attr('x',0)
						 .attr('y',0)
						 .attr('width',width)
						 .attr('height',height)
						 .attr("data-assetid",ob.data[0].asset)
						.attr("rx",5)						 
						.attr('data-propertyid', ob.data[0].property)
						.attr("data-range", ob.data[0].rangemin + "-" + ob.data[0].rangemax)
						.attr("data-panel", ob.number-1)
						.attr("data-id", 0)
						.attr("data-node", function (d,i) { 
							try {
								return ob.data[0].node;
							}
							catch
							{
								return "";
							}	
						 })
						.attr("data-range", "live")		 						
						.on("click",function(e) { NavMenu(e); e.stopPropagation() })
						.on("contextmenu",function(e) { e.preventDefault(); e.stopPropagation(); ContextMenu(e);}) 
						.attr('opacity',function(d) {
							if (d.value == null) return 0.5;
							if (d.value == "^") return 0.5;
							return 1;
						})
						.attr('fill',function(d) {
							if (d.value == null) return "purple";
							if (d.value == "^") return "purple";
							try
							{
								var cl = d.colourmap[parseInt(d.value)];
								if (cl == undefined)
									return "black";
								if ((cl == "#FFFFFF") || (cl == "white") || (cl == "rgb(255,255,255)"))
									return "black";
								return cl;
							}
							catch(e)
							{
								return "#666666";
							}
						}),
				update =>
					update.attr('fill',function(d) {
							if (d.value == null) return "purple";
							if (d.value == "^") return "purple";
							try
							{
								var cl = d.colourmap[parseInt(d.value)];
								if (cl == undefined)
									return "black";
								if ((cl == "#FFFFFF") || (cl == "white") || (cl == "rgb(255,255,255)"))
									return "black";
								return cl;
							}
							catch(e)
							{
								return "#666666";
							}
						})
						.attr('opacity',function(d) {
							if (d.value == null) return 0.5;
							if (d.value == "^") return 0.5;
							return 1;
						})
			);
					
		}
	
		var textvalues = svg.selectAll("text").data(data);
		
		textvalues.join(
		  enter => 
			enter.append("text")
			.attr("x", width/2)
			.attr("y", height/2)
			.attr("width", width)
			.attr("height", height)
			.attr("fill", "#69b3a2")
			.attr("font-size",function (d) {
				var tx = null;
				try
				{
					tx = d.map[d.value];
				}
				catch(e)
				{					
					if (d.value == null)
						tx = "No Data";
					else
					{
						if (d.value == "^")
							tx = "Bad/No Data";
						else
							tx = "Unknown (" + d.value + ")";
					}
				}
				var ln = 0;
				try
				{
					ln = d3.min([width/(tx.length/1.5),height/1.5]);
				}
				catch(e)
				{
				}
				if (ln == 0) ln = 15;
				return ln + "px";
			})
			.attr("text-anchor","middle")
			.attr("alignment-baseline","middle")
			.text(function(d) { 
				if (d.map)
				{
					if (d.value == null)
					{
						return "No Data";
					}
					if (d.value == "^")
					{
						return "Bad / No Data";
					}
					try
					{
						var s = d.map[parseInt(d.value)];
						if (s == undefined)
						{
							return "Unknown (" + d.value + ")";
						}
						return s;
					}
					catch(e)
					{
						return "Unknown (" + d.value + ")";
					}
				}
				else
					return d.value;
			}).attr('fill',function(d) {
				if (d.colourmap)
				{
					return "white";					
				}
				else
				{
					return 'white';
				}
		})		
			.attr('data-assetid', ob.data[0].asset)
			.attr('data-propertyid', ob.data[0].property)
			.attr("data-range", ob.data[0].rangemin + "-" + ob.data[0].rangemax)
			.attr("data-panel", ob.number-1)
			.attr("data-id", 0)
			.attr("data-range", "live")		 
			.on("click",function(e) { NavMenu(e); e.stopPropagation() })
			.on("contextmenu",function(e) { e.preventDefault(); e.stopPropagation(); ContextMenu(e);}) 
	,
		  update => 
			update.text(function(d) { 
				if (d.map)
				{
					if (d.value == null)
					{
						return "No Data";
					}
					if (d.value == "^")
					{
						return "Bad / No Data";
					}
					try
					{
						var s = d.map[parseInt(d.value)];
						if (s == undefined)
						{
							return "Unknown (" + d.value + ")";
						}
						return s;
					}
					catch(e)
					{
						return "Unknown (" + d.value + ")";
					}
				}
				else
					return d.value;
			}).attr('fill',function(d) {
				if (d.colourmap)
				{
					return "white";
					
				}
				else
				{
					return 'white';
				}
			}).attr("font-size",function (d) {
				var tx = null;
				try
				{
					tx = d.map[parseInt(d.value)];
				}
				catch(e)
				{
					if (d.value == null)
						tx = "No Data";
					else
					{
						if (d.value == "^")
						{
							tx = "Bad / No Data";
						}
						else
						{
							tx = "Unknown (" + d.value + ")";
						}
					}
				}
				var sz = 0;
				try
				{
					sz = d3.min([width/(tx.length/1.5),height/1.5]);
				}
				catch(e)
				{
				}
				if (ln == 0) ln = 15;
				return sz + "px";
			})
		);
		
		svg.append('text')
		.attr('class','gaugetext')
		.attr('transform','translate(' + (width/2) + "," + ((height * 0.85)) + ")")					
		.text(ob.data[0].fullname)
		.attr('font-size',Math.min((height * 0.1),(width * 0.04)) + 'px')
		.attr('font-weight','bold')
		.attr('fill','#555555');
	}
	
	ob.update(ob.data);
}