<?php

$pagesize = 10;
$pagestart = 0;

$title = "ARDI Extensions";

include($installfolder.'/include/tmpl.php');

function cmp($a, $b)
{
    if ($a == $b) {
        return 0;
    }
    return version_compare($b, $a);
}

function GetBuildNo($str)
{
	$str = str_replace("_x64","",$str);
	$str = str_replace("_x86","",$str);
	$str = str_replace("_lin","",$str);
	
	$lastnumber = 0;
	$bits = explode('_',$str);
	foreach($bits as $b)
	{
		if ((0+$b) != 0)
		{
			$lastnumber = 0+$b;
		}
	}
	return $lastnumber;
}
$platform = "windows";

$securitycontext = [
	'ssl' => [
		'cafile' => $installfolder.'/addons/extender/cacert.pem',
		'verify_peer'=>true,
		'verify_peer_name'=>true
	]
];

$extensions = file_get_contents("https://ardi.optrix.com.au/extensions/list.php",false,stream_context_create($securitycontext));
$ext = json_decode($extensions);
//print_r($ext);

$set = array();
foreach($ext as $ex)
{
	$set[$ex->name] = $ex;
}

ksort($set);

global $db;

T('header-basic','title='.$title);

$localversions = "";

ST('section','class=content');
	ST('row');
	
		ST('half');
			ST('box','title=Installed Extensions');				
				foreach($set as $k => $v)
				{
					$code = $v->code;
					$type = $v->type;
					
					if ($type == 'addon')
					{
						$realpath = $installfolder.'/addons/'.$code;
						if (file_exists($realpath))
						{
							$vx = "0";
							$vf = $installfolder.'/pages/info/'.$code.'.ver';
							if (file_exists($vf))
							{
								$vx = trim(explode("\n",file_get_contents($vf))[1]);
							}
							
							$udc = "";
							echo '<li';
							if ($vx != $v->version)
							{
								echo ' style="font-weight: bold;"';
								$udc = "Update Required - ";
							}
							echo '><a href="'.$siteroot.'/extender/extension?id='.$v->code.'">'.$k.' ('.$udc.'Local: '.$vx.', Latest: '.$v->version.')</a></li>';
						}
					}	
					if ($type == 'driver')
					{
						
						$installed = false;
						$realpath = $installfolder.'/data/live/'.$code;
						if (file_exists($realpath))
						{
							$installed = true;
						}
						else
						{
							$realpath = $installfolder.'/data/historical/'.$code;
							if (file_exists($realpath))
							{
								$installed = true;
							}
						}
						
						if ($installed == true)
						{
							$vx = "0";
							$vf = $installfolder.'/pages/info/'.$code.'.ver';
							if (file_exists($vf))
							{
								$vx = trim(explode("\n",file_get_contents($vf))[1]);
							}
							
							$udc = "";
							echo '<li';
							if ($vx != $v->version)
							{
								echo ' style="font-weight: bold;"';
								$udc = "Update Required - ";
							}
							echo '><a href="'.$siteroot.'/extender/extension?id='.$v->code.'">'.$k.' ('.$udc.'Local: '.$vx.', Latest: '.$v->version.')</a></li>';
						}
					}						
				}
			ET();
		ET();

		ST('half');
			ST('box','title=All Extensions');
			
			echo '<h3>Addons</h3>';
			echo '<ul>';
				foreach($set as $k => $v)
				{
					if ($v->type != 'addon') continue;
					echo '<li><a href="'.$siteroot.'/extender/extension?id='.$v->code.'">'.$k.' (v '.$v->version.', build '.$v->build.')</a></li>';
				}
			echo '</ul>';
			
			echo '<h3>Drivers</h3>';
			echo '<ul>';
				foreach($set as $k => $v)
				{
					if ($v->type != 'driver') continue;
					echo '<li><a href="'.$siteroot.'/extender/extension?id='.$v->code.'">'.$k.' (v '.$v->version.', build '.$v->build.')</a></li>';
				}
			echo '</ul>';
			
			ET();
		ET();	
	ET();
ET();

?>
