<?php

$pagesize = 10;
$pagestart = 0;

$extension = $_REQUEST['id'];

$title = "ARDI Extension Install";

include($installfolder.'/include/tmpl.php');

function cmp($a, $b)
{
    if ($a == $b) {
        return 0;
    }
    return version_compare($b, $a);
}

$platform = "windows";

$securitycontext = [
	'ssl' => [
		'cafile' => $installfolder.'/addons/extender/cacert.pem',
		'verify_peer'=>true,
		'verify_peer_name'=>true
	]
];

$info = file_get_contents("https://ardi.optrix.com.au/extensions/".$extension.'/info.json',false,stream_context_create($securitycontext));
$inf = json_decode($info);

// Initialize a file URL to the variable 
$url = 'https://ardi.optrix.com.au/extensions/download.php?code='.$extension.'&serial='.uniqid("",true); 
  
// Use basename() function to return the base name of file  
@mkdir($sitefolder.'/install');
@mkdir($sitefolder.'/install/'.$extension);
$file_name = $sitefolder.'/install/'.$extension.'/download.zip'; 

 
$log = "";

$py = PythonPath();
$outp = array();
//$oute = array();
//exec($py.' -V',$outp,$oute);
   
if (count($outp) > 0)
{
	$pythonv = $outp[0];	
	$bits = explode('.',$pythonv);
	$pversion = $bits[0].$bits[1];
}
   
if ($inf->type == 'driver')
{
	//Shut down drivers of this type...	
	//print($py);
	
	$cmd = '"'.$py.'" "'.dirname($installfolder).'\Drivers\ardidrivers.py" localhost* remove --driver='.$extension;
	$log .= "<p>Shutting Down Existing Drivers via ".$cmd."</p>";
	exec($cmd);
}	

$log .= "<p><strong>Downloading Archive File</strong> ".$url."</p>";

set_time_limit(0);
//This is the file where we save the information
$fp = fopen ($file_name, 'w+');
//Here is the file we are downloading, replace spaces with %20
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_TIMEOUT, 5000);
// write curl response to file
curl_setopt($ch, CURLOPT_CAINFO, $installfolder."/addons/extender/cacert.pem");
curl_setopt($ch, CURLOPT_CAPATH, $installfolder."/addons/extender/cacert.pem"); 
curl_setopt($ch, CURLOPT_VERBOSE, true);
curl_setopt($ch, CURLOPT_FILE, $fp); 
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
// get curl response
curl_exec($ch); 
curl_close($ch);
fclose($fp);

$wheels = glob($sitefolder.'/install/'.$extension.'/*.whl');
foreach($wheels as $wheel)
{
	unlink($wheel);//$wheelset[] = $wheel;
}


$zip = new ZipArchive();
$log .= "<p>Opening ZIP Archive ".$file_name."</p>";
if($zip->open($file_name))
{
	$zip->extractTo($sitefolder.'/install/'.$extension);
	$zip->close();
}
else
{
	echo 'Not a ZIP Archive';
	exit;
}

$any = false;

//Investigate file - check for dodgy elements.
$log .= "<p>Inspecting Archive Contents @ ".$sitefolder.'/install/'.$extension."</p>";

$dodgy = false;
$pth = $sitefolder.'/install/'.$extension;
$content = glob($pth.'/*');
foreach($content as $cnt)
{
	$dodge = true;
	
	$base = basename($cnt);
	//$log .= $base."<br/>";
	switch($base)
	{
		case 'download.zip':
		case 'download_dependencies.zip':
		case 'requirements.txt':
			$dodge = false;
			break;
		case 'services':
		case 'drivers':		
		case 'web':			
			$any = true;
			$dodge = false;
			break;
	}
	
	if ($dodge == true)
	{
		$dodgy = true;
		$log .= "<p><strong>Encountered Unexpected File @ ".$cnt."</strong></p>";
		break;
	}
}

if (file_exists($pth.'/web'))
{
	$content = glob($pth.'/web/*');
	foreach($content as $cnt)
	{
		$dodge = true;
		
		$base = basename($cnt);
		//$log .= $base."<br/>";
		switch($base)
		{
			case 'data':
			case 'plugins':
			case 'addons':		
				$dodge = false;
				break;
		}
		
		if ($dodge == true)
		{
			$dodgy = true;
			$log .= "Encountered Unexpected File @ ".$cnt."<br/>";
			break;
		}
	}
}

if (file_exists($pth.'/web/data'))
{
	$content = glob($pth.'/web/data/*');
	foreach($content as $cnt)
	{
		$dodge = true;
		
		$base = basename($cnt);
		//$log .= $base."<br/>";
		switch($base)
		{
			case 'live':
			case 'historical':		
			case 'event':		
				$dodge = false;
				break;
		}
		
		if ($dodge == true)
		{
			$dodgy = true;
			$log .= "Encountered Unexpected File @ ".$cnt."<br/>";
			break;
		}
	}
}

if (file_exists($pth.'/services'))
{
	$content = glob($pth.'/services/*');
	foreach($content as $cnt)
	{
		$dodge = true;
		
		$base = basename($cnt);
		//$log .= $base."<br/>";
		switch($base)
		{			
			case 'consolidator':		
				$dodge = false;
				break;
		}
		
		if ($dodge == true)
		{
			$dodgy = true;
			$log .= "Encountered Unexpected File @ ".$cnt."<br/>";
			break;
		}
	}
}

if (file_exists($pth.'/drivers'))
{
	$content = glob($pth.'/drivers/*');
	foreach($content as $cnt)
	{
		$dodge = true;
		
		$base = basename($cnt);
		//$log .= $base."<br/>";
		switch($base)
		{
			case 'live':
			case 'hist':		
			case 'event':		
				$dodge = false;
				break;
		}
		
		if ($dodge == true)
		{
			$dodgy = true;
			$log .= "Encountered Unexpected File @ ".$cnt."<br/>";
			break;
		}
	}
}

if ($dodgy == false)
{
	
	//OK - let's decompress this into the real location...
	if($zip->open($file_name))
	{
		$log .= "<p>Extracting File to ".dirname($installfolder)."</p>";
		$zip->extractTo(dirname($installfolder));
		$zip->close();
	}
	//unlink($file_name);
	
	$log .= "<p>Checking for Python Scripts under ".dirname($installfolder).'</p>';
	

	//Now, check for wheels....

	$failed = false;

	if (isset($inf->depends))
	{
		//Download the dependencies...
		
		$platform="win32";
		$pythonversion=$pversion;
		
		switch(strtoupper(PHP_OS))
		{
			case "WINNT":
			case "WIN32":
			case "WINDOWS":
				$platform="win32";
				break;
			default:
				$platform="linux";
				break;
		}
		
		if (($pythonversion === FALSE) || ($pythonversion == "")) $pythonversion = "310";
		
		//unlink($file_name);
		$file_name = $sitefolder.'/install/'.$extension.'/download_dependencies.zip'; 
		$url = 'https://ardi.optrix.com.au/extensions/wheels.php?code='.$extension.'&platform='.$platform.'&python='.$pythonversion.'&serial='.uniqid("",true); 
		$log .= "<p>Downloading Dependencies from ".$url.'</p>';		
		  		
		set_time_limit(0);
		//This is the file where we save the information
		$fp = fopen ($file_name, 'w+');
		//Here is the file we are downloading, replace spaces with %20
		$ch = curl_init(str_replace(" ","%20",$url));
		curl_setopt($ch, CURLOPT_TIMEOUT, 5000);
		// write curl response to file
		curl_setopt($ch, CURLOPT_FILE, $fp); 
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_FRESH_CONNECT, TRUE);
		curl_setopt($ch, CURLOPT_CAINFO, $installfolder."/addons/extender/cacert.pem");
		curl_setopt($ch, CURLOPT_CAPATH, $installfolder."/addons/extender/cacert.pem"); 
		// get curl response
		curl_exec($ch); 
		curl_close($ch);
		fclose($fp);
		
		if($zip->open($file_name))
		{
			$log .= "<p>Extracting Wheels to ".$sitefolder.'/install/'.$extension."</p>";
			$zip->extractTo($sitefolder.'/install/'.$extension);
			$zip->close();
		}
		
		//Install python wheels for appropriate platform & Python version...
		$requirements = $sitefolder.'/install/'.$extension.'/requirements.txt';
		$pipver = "pip3";
		
		if (file_exists($requirements))
		{		
			$basefolder = pathinfo($requirements,PATHINFO_DIRNAME);

			//$log .= 'Reviewing Wheel: Package '.$bits[0].', Version '.$bits[1].', version '.$bits[2].' / '.$bits[3].', platform '.$bits[4].'<br/>';
			if (true)
			{
				if ($platform == "linux")
					$cmd = $pipver.' install -r "'.$requirements.'"';
				else
					$cmd = $pipver.' install --no-index --find-links="'.$basefolder.'" -r "'.$requirements.'"';
				$log .= '<br/><p>Executing '.str_replace('"','&quot;',$cmd).'</p>';
				
				$outp = array();
				$errs = array();

				exec($cmd,$outp,$errs);
				
				if (is_array($outp))
				{
					foreach($outp as $ln)
					{
						$log .= $ln."<br/>";
					}
				}
				if (is_array($errs))
				{
					foreach($errs as $ln)
					{
						$log .= '<p style="color: red;">'.$ln."</p>";
						if (trim($ln) != "")
							$failed = true;
					}
				}
				$log .= "<br/><br/>";
			}
		}
	}
	
	if ($failed != true)
	{
		$tx = $inf->name."\r\n".$inf->version;
		file_put_contents($installfolder.'/pages/info/'.$inf->code.'.ver',$tx);
	}
}

if ($inf->type == 'driver')
{
	//Restart drivers of this type...
	$cmd = '"'.$py.'" '.$installfolder.'\Drivers\ardidrivers.py" localhost* install --driver='.$extension;
	$log .= "<p>Restoring existing drivers via ".$cmd."</p>";
	exec($cmd);
}	

$log .= "<p><strong>Extension Install Complete</strong></p>";

$msg = "Extension Installed Successfully";
$cls = "success";

if ($dodge == true)
{
	$msg = "Invalid / Corrupted File Detected";
	$cls = "error";
}

if ($any == false)
{
	$msg = "Extension Currently Unavailable";
	$cls = "warning";
}

global $db;

T('header-basic','title='.$title);

$localversions = "";

ST('section','class=content');
	ST('row');
	
		ST('half');
			ST('box','title=Installation Log');				
				echo '<h2>'.$inf->name.' ('.$inf->version.')</h2>';
				echo '<p>'.$log.'</p>';
				echo '<br/>';
				echo '<a href="'.$siteroot.'/extender"><button class="btn btn-'.$cls.'">'.$msg.'</button></a>';
				if ($cls == "success")
				{
					if ($inf->type == "addon") { 
						echo '&nbsp;&nbsp;&nbsp;<a href="'.$siteroot.'/admin/addons"><button class="btn btn-'.$cls.'">Enable Addons</button></a>';
					}
					else
					{
						echo '&nbsp;&nbsp;&nbsp;<a href="'.$siteroot.'/admin/drivers"><button class="btn btn-'.$cls.'">Add Drivers</button></a>';
					}
				}
			ET();
		ET();
		
	ET();
ET();

?>
