<?php

function FriendlyPropertyName($propname)
{
	$bits = explode(' - ',$propname);
	if (count($bits) > 1)
	{
		if ($bits[1] == 'Actual')
			return $bits[0];
		return $bits[1].' '.$bits[0];
	}
	return $propname;
}

function GetDistinctName($assetlist,$default="")
{	
	$commonelement = $assetlist[0];
	
	$pieces = explode(' ',$assetlist[0]);
	$matches = [];
	for($x=0;$x<count($pieces);$x++)
	{
		$matches[$x] = true;
	}
		
	foreach($assetlist as $h)
	{
		$bits = explode(' ',$h);		
		
		for($x=0;$x<count($pieces);$x++)
		{
			if (!in_array($pieces[$x],$bits))
				$matches[$x] = false;
		}
	}
	
	//print_r($matches);
	
	$commonelement = "";
	for($x=0;$x<count($pieces);$x++)
	{
		if ($matches[$x] == true)
		{
			if ($commonelement != "")
				$commonelement .= " ";
			$commonelement .= $pieces[$x];
		}
	}
	
	if ($commonelement == "")
	{
		$commonelement = $default;
	}
	return $commonelement;
}

function GetFakeColourMap($keys)
{
	$x = 0;
	$coloursequence = ['blue','green','yellow','red','purple','cyan','orange','grey','magenta'];
		
	$cmap = array();
	foreach($keys as $k)
	{
		$cmap[$k] = $coloursequence[$x];
		$x++;
		if ($x >= count($coloursequence)) $x = 0;
	}
	return $cmap;
}

function GetColourMapFor($prop)
{
	global $sitefolder;
	
	//print("Searching For ".$prop." Colour Map.");
	
	$displayfile = $sitefolder.'/cache/display/properties/'.$prop.'.xml';
	if (!file_exists($displayfile))
	{
		//print("File ".$displayfile." does not exist.");
		return FALSE;
	}	
	
	$xml=simplexml_load_file($displayfile);
				
	$map = array();
	
	if (property_exists($xml,'colours'))
	{		
		$attrs = $xml->colours->attributes();
		$map[0] = "".$attrs['zero'][0];
		$map[1] = "".$attrs['one'][0];		
		
		#print_r($map);
	}	

	if (property_exists($xml,'value'))
	{			
		foreach($xml->value as $vl)
		{
			$attrs = $vl->attributes();
			
			$map[0+$attrs['value']] = "".$attrs['colour'];			
		}				
	}	
	
	//print("Colour Map:");
	//print_r($map);
	return $map;
}

function CleanupName($nm)
{
	$nm = str_replace("#","",$nm);
	$nm = str_replace(":","",$nm);
	$pieces = explode(' ',$nm);
	
	$replace = false;
	for($x=1;$x<count($pieces)-1;$x++)
	{		
		for($q=0;$q<$x;$q++)
		{
			if ($pieces[$q] == $pieces[$x])
			{
				unset($pieces[$x]);
				$pieces = array_values($pieces);
				$x--;
				$replace = true;
			}
		}		
	}
	if ($replace == true)
	{
		$nm = implode(' ',$pieces);
	}
	return $nm;
}
?>