<?php

if (!function_exists('DrawHeader'))
{
	function DrawHeader($name,$code)
	{
		echo '<tr><td><h3>'.$name.'</h3></td></tr>';		
		echo '<tr><td><a href="index?method=control">Control Only</a>&nbsp;&nbsp;&nbsp;<a href="index">All Tests</a></td></tr>';				
	}
}

if (!isset($_REQUEST['mode']))
	$mode = "query";
else
	$mode = $_REQUEST['mode'];


include_once($installfolder.'/model/property.php');

$method = "report";
if (isset($_REQUEST['method']))
	$method = $_REQUEST['method'];

$allprops = Properties::GetAllProperties();

if ($mode == "query")
{
	//Get all 'target' properties
	$targets = array();
	foreach($allprops as $px)
	{
		if (strpos(strtolower($px->name),"target") !== FALSE)
		{
			$targets[] = $px;
		}
	}
	
	//Get practical property usage figures...
	$propusage = array();
	$query = $db->query("SELECT propertyid,assetid FROM datalinks WHERE mode=1");
				
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		if (!isset($propusage[$row['propertyid']]))
		{
			$propusage[$row['propertyid']] = array();
		}
		$propusage[$row['propertyid']][] = $row['assetid'];
	}
	
	
	DrawHeader("Control","livecontrol");
	
	foreach($targets as $px)
	{
		if (!isset($propusage[$px->id]))
			continue;
				
		if ($px->type == "MEASUREMENT")
		{			
			$nm = $px->name;
			$rrx = explode(' - ',$px->name);
			if (count($rrx) > 1)
			{
				$nm = $rrx[1].' '.$rrx[0];
			}
			
			$clas = 'statusline';
			
			foreach($propusage[$px->id] as $aid)
			{
				$ass = new Asset($aid);				
				echo '<tr><td><div class="'.$clas.' unknown"id="control_'.$px->id.'_'.$aid.'" name="control_'.$px->id.'_'.$aid.'"';				
				echo '><div class="status unknown"></div><a target="_blank" href="control?mode=report&param0=control&param1='.$px->id.'&param2='.$aid.'">'.$ass->name.' '.$nm.'</a></div></td></tr>';	
			}
		}
	}
		
}

if (($mode == "process") || ($mode == "report") || ($mode == 'aicurrent') || ($mode == 'deep'))
{
	$property = filter_var($_REQUEST['param1'],FILTER_VALIDATE_INT);
	$assid = filter_var($_REQUEST['param2'],FILTER_VALIDATE_INT);
	
	$state = 'EMPTY';
	
	$ass = new Asset($assid);
	$props = $ass->GetLocalProperties();
	$spanprop = -1;
	$refprop = -1;
	$name = "";
	$subname = "";
	$final = array();
	foreach($props as $px)
	{
		if ($px->id == $property)
		{
			//print_r($px);
			$parts = explode(' - ',$px->name);
			$fullname = $parts[0];
			if (count($parts) > 1)
				$subname = ' - '.$parts[1];
			$name = str_replace(" - target","",strtolower($px->name));
			$final[] = $px;
			break;
		}		
	}
	
	//print_r($props);
	
	$matchlen = strlen($name);
	
	$candidates = array();
	
	foreach($props as $px)
	{
		if ($px->id == $property) continue;
		if (strlen($px->name) < $matchlen) continue;				
		
		if (strtolower(substr($px->name,0,$matchlen)) == $name)
		{
			$candidates[] = $px;
		}
	}
	
	if (count($candidates) == 0)
	{
		$status = "EMPTY";		
	}
	else
	{
	
		if (count($candidates) == 1)
		{
			$final[] = $candidates[0];	
			$refprop = $candidates[0]->id;
		}
		else
		{		
			foreach($candidates as $cdn)
			{
				if (strpos(strtolower($cdn->name)," actual") !== FALSE)
				{
					$final[] = $cdn;
					$refprop = 1;
					break;
				}
			}
			if ($refprop == -1)
			{
				//Check to see if there's a type name match...
				$query = $db->query("SELECT name FROM assetrelclosures JOIN assets ON (assets.id = assetrelclosures.parentasset) WHERE childasset=".$assid." AND relationship=3");
					
				$typenames = array();
				while($row = $query->fetch(PDO::FETCH_ASSOC)) 
				{
					$typenames[] = strtolower($row['name']);
				}
				foreach($candidates as $cdn)
				{
					$bits = explode(' - ',$cdn->name);
					$matcher = strtolower($bits[count($bits)-1]);
					foreach($typenames as $t)
					{
						if (strpos(strtolower($bits[0])," span") !== FALSE) continue;
						if (strpos(strtolower($bits[0])," tolerance") !== FALSE) continue;
						if (strpos(strtolower($bits[0])," min") !== FALSE) continue;
						if (strpos(strtolower($bits[0])," max") !== FALSE) continue;
						
						if (strpos($t,$matcher) !== FALSE)
						{
							$final[] = $cdn;
							$refprop = $cdn->id;
							break;
						}
					}		
					if ($refprop != -1) break;
				}
			}
			if ($refprop == -1)
			{
				$final[] = $candidates[0];
				$refprop = $candidates[0]->id;
			}
		}
		
		//Get the span, if available...
		
		foreach($props as $px)
		{
			if ($px->id == $property) continue;
			if ($px->id == $refprop) continue;
			
			if (strlen($px->name) < $matchlen) continue;				
			
			//echo 'Scanning '.$px->name;
			
			if (strtolower(substr($px->name,0,$matchlen)) == $name)
			{
				//echo 'Checking '.$px->name;
				$parts = explode(' - ',$px->name)[0];
				$parts = strtolower($parts);
				$pass = false;
				if (strpos($parts,' span') !== FALSE) $pass = true;
				
				if ($pass == true)
				{					
						$spanprop = $px->id;
						$final[] = $px;
						break;
				}
				if ($spanprop != -1) break;
			}
		}
		
		if ($final[0] === FALSE)
		{
			if ($final[0]->value['measurement'] == '^')
				$final[0]->value['measurement'] = 0;
		
		}
		
		if ($final[1] === FALSE)
		{
			if ($final[1]->value['measurement'] == '^')
				$final[1]->value['measurement'] = 0;
		}
		
		
		//Get the sub-name of the actual value...
		$bits = explode(' - ',$final[1]->name);
		if (count($bits) > 1)
			$subname = ' - '.$bits[1];
		
		$span = 1;
		if (count($final) >= 2)
		{
			$ass->GetValues($final);
			$diff = abs($final[0]->value['measurement'] - $final[1]->value['measurement']);
			$span = 1;
			
			if ($spanprop == -1)
			{
				//Figure this out from the property info...
				$span = ($final[1]->value['max'] - $final[1]->value['min']) * 0.01;
			}
			else
			{
				$span = $final[2]->value['measurement'];
			}
			
			if ($diff > $span)
			{
				if ($spanprop == -1)
				{
					$state = 'WARNING';
					if ($diff > $span*10)
					{
						$state = 'ERROR';
					}
				}
				else
					$state = 'ERROR';			
			}
			
			if ($state == "EMPTY")
				$state = 'OK';		
		}
	}
	
	
	if ($mode == 'process')
	{
		if (isset($diff))
			echo $state.':'.$diff;
		else
			echo $state;
		exit();
	}
	
	if ($mode == "deep")
	{		
		
		$context = array();	
		
		if (($final[0] !== null) && ($final[1] !== null))
		{
			
		
			$context['name'] = 'FirstSite '.$ass->name.' '.$fullname.' Control';		
			$context['module'] = 'drift_alert';
			$asa = new Asset($final[0]->origin);
			$asb = new Asset($final[1]->origin);
			
			$context['inputs'] = array($asa->name.".".$final[0]->name,$asb->name.".".$final[1]->name);
			$context['outputs'] = 'Control Alert';		
			$context['tolerance'] = 2;
			
			echo json_encode($context);		
		}
		else
		{
			echo '{}';
		}
		
		exit();
	}
	
	if ($mode == 'report')
	{
		$title = $ass->name." Control";
	
		include($installfolder.'/include/tmpl.php');
		
		?>

		<script src="/addons/dexplore/d3v7.js"></script>
		<style>
		
.results 
{
	display: block;
	padding: 10px;
	border-radius: 5px;
	border: 1px solid black;
	color: black;
	font-size: 20px;
	font-weight: bold;
	width: auto;
	margin-bottom: 0.5em;
}

.results.OK
{
	background-color: green;
	color: white;
}

.results.WARNING
{
	background-color: yellow;
	color: black;
}

.results.ERROR
{
	background-color: red;
	color: white;
}

.results.EMPTY
{
	background-color: #777777;
	color: white;
}

#gaugeblock g.arc {
		fill: steelblue;
	}

#gaugeblock g.pointer {
	fill: blue;
	stroke: white;
}

#gaugeblock g.label text {
	text-anchor: middle;
	font-size: 14px;
	font-weight: bold;
	fill: #666;
}
		</style>
		<script src="firstsite.js"></script>
		<script>
		
var gauge = function(container, configuration) {
	var that = {};
	var config = {
		size						: 200,
		clipWidth					: 200,
		clipHeight					: 110,
		ringInset					: 20,
		ringWidth					: 20,
		
		pointerWidth				: 10,
		pointerTailLength			: 5,
		pointerHeadLengthPercent	: 0.9,
		
		minValue					: 0,
		maxValue					: 10,
		minGood						: 4,
		maxGood						: 6,
		
		minAngle					: -90,
		maxAngle					: 90,
		
		transitionMs				: 750,
		
		majorTicks					: 5,
		labelFormat					: d3.format(',g'),
		labelInset					: 10,
		
		arcColorFn					: d3.interpolateHsl(d3.rgb('#660000'), d3.rgb('#990000'))
	};
	var range = undefined;
	var r = undefined;
	var pointerHeadLength = undefined;
	var value = 0;
	
	var svg = undefined;
	var arc = undefined;
	var goodarc = undefined;
	var scale = undefined;
	var ticks = undefined;
	var tickData = undefined;
	var pointer = undefined;

	var donut = d3.pie();
	
	function deg2rad(deg) {
		return deg * Math.PI / 180;
	}
	
	function newAngle(d) {
		var ratio = scale(d);
		var newAngle = config.minAngle + (ratio * range);
		return newAngle;
	}
	
	function configure(configuration) {
		var prop = undefined;
		for ( prop in configuration ) {
			config[prop] = configuration[prop];
		}
		
		range = config.maxAngle - config.minAngle;
		r = config.size / 2;
		pointerHeadLength = Math.round(r * config.pointerHeadLengthPercent);

		// a linear scale that maps domain values to a percent from 0..1
		scale = d3.scaleLinear()
			.range([0,1])
			.domain([config.minValue, config.maxValue]);
			
		ticks = scale.ticks(config.majorTicks);
		tickData = d3.range(config.majorTicks).map(function() {return 1/config.majorTicks;});
		
		arc = d3.arc()
			.innerRadius(r - config.ringWidth - config.ringInset)
			.outerRadius(r - config.ringInset)
			.startAngle(function(d, i) {
				var ratio = d * i;
				return deg2rad(config.minAngle + (ratio * range));
			})
			.endAngle(function(d, i) {
				var ratio = d * (i+1);
				return deg2rad(config.minAngle + (ratio * range));
			});
			
		
	}
	that.configure = configure;
	
	function centerTranslation() {
		return 'translate('+r +','+ r +')';
	}
	
	function isRendered() {
		return (svg !== undefined);
	}
	that.isRendered = isRendered;
	
	function render(newValue) {
		svg = d3.select(container)
			.append('svg:svg')
				.attr('class', 'gauge')
				.attr('width', config.clipWidth)
				.attr('height', config.clipHeight);
		
		var centerTx = centerTranslation();
		
		var arcs = svg.append('g')
				.attr('class', 'arc')
				.attr('transform', centerTx);
		
		arcs.selectAll('.baddie')
				.data(tickData)
			.enter().append('path')
				.attr('fill', function(d, i) {
					return config.arcColorFn(d * i);
				})
				.attr('class','baddie')
				.attr('d', arc);
				
		var rmin = scale(config.minGood);
		var rmax = scale(config.maxGood);
				
		goodarc = d3.arc()
			.innerRadius((r - config.ringWidth - config.ringInset)-4)
			.outerRadius((r - config.ringInset) + 4)
			.startAngle(deg2rad(config.minAngle + (rmin * range)))
			.endAngle(deg2rad(config.minAngle + (rmax * range)));
				
		arcs.append('path')
			.attr('fill','green')
			.attr('class','goodie')
			.attr('d', goodarc);
		
		var lg = svg.append('g')
				.attr('class', 'label')
				.attr('transform', centerTx);
		lg.selectAll('text')
				.data(ticks)
			.enter().append('text')
				.attr('transform', function(d) {
					var ratio = scale(d);
					var newAngle = config.minAngle + (ratio * range);
					return 'rotate(' +newAngle +') translate(0,' +(config.labelInset - r) +')';
				})
				.text(config.labelFormat);

		var lineData = [ [config.pointerWidth / 2, 0], 
						[0, -pointerHeadLength],
						[-(config.pointerWidth / 2), 0],
						[0, config.pointerTailLength],
						[config.pointerWidth / 2, 0] ];
		var pointerLine = d3.line();
		var pg = svg.append('g').data([lineData])
				.attr('class', 'pointer')
				.attr('transform', centerTx);
				
		pointer = pg.append('path')
			.attr('d', pointerLine/*function(d) { return pointerLine(d) +'Z';}*/ )
			.attr('transform', 'rotate(' +config.minAngle +')');
			
		update(newValue == undefined ? 0 : newValue);
	}
	that.render = render;
	
	function update(newValue, newConfiguration) {
		if ( newConfiguration  !== undefined) {
			configure(newConfiguration);
		}
		var ratio = scale(newValue);
		var newAngle = config.minAngle + (ratio * range);
		pointer.transition()
			.duration(config.transitionMs)			
			.attr('transform', 'rotate(' +newAngle +')');
	}
	that.update = update;

	configure(configuration);
	
	return that;
};

function DrawReports()
{
	var g = gauge('#gaugeblock', {
		size: 500,
		clipWidth: 500,
		clipHeight: 500,
		ringWidth: 60,
		minValue: <?php echo $final[1]->value['min'];?>,
		maxValue: <?php echo $final[1]->value['max'];?>,
		minGood: <?php echo $final[0]->value['measurement'] - $span;?>,
		maxGood: <?php echo $final[0]->value['measurement'] + $span;?>,
		transitionMs: 1000,
		labelFormat: d3.format(".0f")
	});
	g.render(<?php echo $final[1]->value['measurement'];?>);
	//g.update(50);
}
		</script><?php		

SS('head');
?>
DrawReports();
<?php
SS('onload');

T('header-basic','title='.$title);

ST('section','class=content');
	
		//Get AI Analysis...		
		ST('row');	
			ST('full');
				ST('box');
					echo '<div class="results '.str_replace("*","",$state).'">'.$state.'</div>';
					if ($state == "EMPTY")
					{
						echo '<hr/>This asset as a <strong>target</strong> property, but doesn\'t seem to have a property for the <strong>actual measurement</strong>.';
					}
					else
					{						
						if ($spanprop == -1)
						{
							echo '<p style="font-size: large; font-weight: bold;"><span>'.round($final[1]->value['measurement'],$final[1]->value['places']).'</span> vs <span>'.round($final[0]->value['measurement'],$final[1]->value['places']).$final[1]->value['units'].'</span></p>';
							echo '<hr/>There is no <strong>control tolerance</strong> specified for this asset - the values may actually be quite normal.<br/><br/>To set a control tolerance, add a property called &quot;'.$fullname.' Tolerance'.$subname.'&quot; or &quot;'.$fullname.' Span'.$subname.'&quot; to the asset or type.';
						}
						else
						{
							echo '<p style="font-size: large; font-weight: bold;"><span>'.round($final[1]->value['measurement'],$final[1]->value['places']).'</span> vs <span>'.round($final[0]->value['measurement'],$final[1]->value['places']).$final[1]->value['units'].'</span> (Expected to be within '.$span.' of target)</p>';
						}
					}
				ET();
			ET();			
		ET();
ET();?>
	
	
			<div id="gaugeblock" style="text-align: center;">
			</div>
<?php
	}		
}
?>