<?php

$pagesize = 10;
$pagestart = 0;

include('phases.php');

ob_start();

$method = 'report';
if (isset($_REQUEST['method']))
	$method = $_REQUEST['method'];


function FriendlyPropertyName($propname)
{
	$bits = explode(' - ',$propname);
	if (count($bits) > 1)
	{
		if ($bits[1] == 'Actual')
			return $bits[0];
		return $bits[1].' '.$bits[0];
	}
	return $propname;
}

function GetDistinctName($assetlist,$default="")
{	
	$commonelement = $assetlist[0];
	
	$pieces = explode(' ',$assetlist[0]);
	$matches = [];
	for($x=0;$x<count($pieces);$x++)
	{
		$matches[$x] = true;
	}
		
	foreach($assetlist as $h)
	{
		$bits = explode(' ',$h);		
		
		for($x=0;$x<count($pieces);$x++)
		{
			if (!in_array($pieces[$x],$bits))
				$matches[$x] = false;
		}
	}
	
	//print_r($matches);
	
	$commonelement = "";
	for($x=0;$x<count($pieces);$x++)
	{
		if ($matches[$x] == true)
		{
			if ($commonelement != "")
				$commonelement .= " ";
			$commonelement .= $pieces[$x];
		}
	}
	
	if ($commonelement == "")
	{
		$commonelement = $default;
	}
	return $commonelement;
}

function GetFakeColourMap($keys)
{
	$x = 0;
	$coloursequence = ['blue','green','yellow','red','purple','cyan','orange','grey','magenta'];
		
	$cmap = array();
	foreach($keys as $k)
	{
		$cmap[$k] = $coloursequence[$x];
		$x++;
		if ($x >= count($coloursequence)) $x = 0;
	}
	return $cmap;
}

function GetColourMapFor($prop)
{
	global $sitefolder;
	
	//print("Searching For ".$prop." Colour Map.");
	
	$displayfile = $sitefolder.'/cache/display/properties/'.$prop.'.xml';
	if (!file_exists($displayfile))
	{
		//print("File ".$displayfile." does not exist.");
		return FALSE;
	}	
	
	$xml=simplexml_load_file($displayfile);
				
	$map = array();
	
	if (property_exists($xml,'colours'))
	{		
		$attrs = $xml->colours->attributes();
		$map[0] = "".$attrs['zero'][0];
		$map[1] = "".$attrs['one'][0];		
		
		#print_r($map);
	}	

	if (property_exists($xml,'value'))
	{			
		foreach($xml->value as $vl)
		{
			$attrs = $vl->attributes();
			
			$map[0+$attrs['value']] = "".$attrs['colour'];			
		}				
	}	
	
	//print("Colour Map:");
	//print_r($map);
	return $map;
}

function CleanupName($nm)
{
	$nm = str_replace("#","",$nm);
	$nm = str_replace(":","",$nm);
	$pieces = explode(' ',$nm);
	
	$replace = false;
	for($x=1;$x<count($pieces)-1;$x++)
	{		
		for($q=0;$q<$x;$q++)
		{
			if ($pieces[$q] == $pieces[$x])
			{
				unset($pieces[$x]);
				$pieces = array_values($pieces);
				$x--;
				$replace = true;
			}
		}		
	}
	if ($replace == true)
	{
		$nm = implode(' ',$pieces);
	}
	return $nm;
}

function CreateTemplateReport($template,$options)
{
	global $sitefolder;
	global $installfolder;
	
	$method = "report";
	if (isset($_REQUEST['method']))
		$method = $_REQUEST['method'];
	
	$ext = ".py";
	$filename = "report";
	$dest = "/reports/automatic";
	
	if ($method == "display")
	{
		$ext = ".js";
		$filename = "generate";
		$dest = "/displays/automatic";
	}
	if ($method == "dashboard")
	{
		$ext = ".json";
		$filename="import";
		$dest = "/grafana";
	}
	
	if (!file_exists($installfolder.'/addons/autoreporter/templates/'.$template.$ext))
	{
		print("Template ".$template." does not exist!");
		return;
	}
	
	$options['name'] = CleanupName($options['name']);
	
	$code = "";
	
	@mkdir($dest);
	
	$mode = "create";
	$content = file_get_contents($installfolder.'/addons/autoreporter/templates/'.$template.$ext);
	foreach($options as $k => $v)
	{
		if (strlen($k) > 3)
		{
			if (substr($k,0,3) == "map")
			{
				$mapname = substr($k,3);
				if ($code != "") $code .= "    ";
				$code .= $mapname.' = '.json_encode($v)."\n";
				continue;
			}
		}
		if (is_numeric($v) || is_string($v))
		{
			$content = str_replace('['.strtoupper($k).']',$v,$content);
		}
	}
	
	$content = str_replace('[CODE]',$code,$content);
	
	//Create Folder for Auto-Generated Reports
	$root = $sitefolder.$dest;
	if (!file_exists($root)) mkdir($root);
	
	$repname = $options['name'];
	$repfilename = str_replace("__","_",str_replace(" ","_",str_replace("\\","",str_replace("/","",$repname))));
	
	$folder = $options['folder'];
	
	$root = $root.'/'.$repfilename;
	@mkdir($root);
	
	$reportrange = 24;
	if (isset($_REQUEST['range']))
	{
		$reportrange = 0+$_REQUEST['range'];
	}
	
	//Create Info File...
	$ifile = $repname;
	$ifile .= "\r\n".$reportrange."\r\n2020-01-01 06:00:00\r\nAustralia/Sydney\r\n".$folder;
	if (!file_exists($root.'/info.txt'))
		file_put_contents($root.'/info.txt',$ifile);
	
	//Create Report File...
	file_put_contents($root.'/'.$filename.$ext,$content);
	
	@unlink($root.'/last.txt');
	
	print("Written New Report @".$root);
}

foreach($phases as $phase)
{
	$values = array();
	foreach($_REQUEST as $k => $v)
	{
		$bits = explode('_',$k);
		if (count($bits) <= 2) continue;
		
		if ($bits[0] == $phase['code'])
		{
			//echo 'Checking Value Of '.$k.' = '.$v;
			if ($v != 'on') continue;
			$a = array();
			$a['style'] = $bits[1];
			$a['options'] = "";
			for($x=2;$x<count($bits);$x++)
			{
				if ($a['options'] != "")
					$a['options'] .= ' ';
				$a['options'] .= $bits[$x];
			}
			$values[] = $a;
		}
		
		$mode = "create";
		//ob_start();
		include($phase['code'].'.php');
		//$scrap = ob_get_clean();
	}
}

$content = ob_get_clean();

if ($method == "display")
{
	header('Location: '.$siteroot.'/displaylist/');
	exit();
}
header('Location: '.$siteroot.'/reportlist/');


?>
