<?php

if (!function_exists('DrawHeader'))
{
	function DrawHeader($name,$code)
	{
		echo '<tr><td><h3>'.$name.'</h3></td></tr>';	
		echo '<tr><td><a href="index?method=drivers">Drivers Only</a>&nbsp;&nbsp;&nbsp;<a href="index">All Tests</a></td></tr>';				
		//echo '<tr><td><a href="#" onclick="CheckMatching(\'.'.$code.'.checkbox\'); return false;">Check</a>&nbsp;&nbsp;&nbsp;<a href="#" onclick="UncheckMatching(\'.'.$code.'.checkbox\'); return false;">Uncheck</a><br/><hr/></td></tr>';
	}
}
$method = "report";
if (!isset($_REQUEST['mode']))
	$mode = "query";
else
	$mode = $_REQUEST['mode'];

include_once($installfolder.'/model/property.php');


$allprops = Properties::GetAllProperties();

if ($mode == "query")
{
	//Get practical property usage figures...
	$typelist = array();
	$query = $db->query("SELECT * FROM datasources");
				
	$sources = array();
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		$sources[] = $row;
	}	
	
	$header = "";
	$touched = array();
	DrawHeader("Drivers and Connections","driver");
	foreach($sources as $src)
	{
		//echo 'Type ID: '.$t;
		$asx = new Asset($src['assetid']);				
		
		$md = 'Live';
		if ($src['mode'] == 1)
			$md = 'History';
		if ($src['mode'] == 4)
			$md = 'Event';
		
		$touched[] = $row['id'];
		echo '<tr><td><div class="statusline unknown" id="drivers_'.$asx->id.'_'.$src['mode'].'" name="drivers_'.$asx->id.'_'.$src['mode'].'"';
		echo '><div class="status unknown"></div>'.$asx->name.' ('.$md.')'.'</div></td></tr>';		
	}
	
}

if ($mode == "list")
{
	//Get practical property usage figures...
	$typelist = array();
	$query = $db->query("SELECT * FROM datasources");
				
	$sources = array();
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		$sources[] = $row;
	}	
	
	$header = "";
	$touched = array();
	$items = array();
	foreach($sources as $src)
	{
		//echo 'Type ID: '.$t;
		$asx = new Asset($src['assetid']);				
		
		$md = 'Live';
		if ($src['mode'] == 1)
			$md = 'History';
		if ($src['mode'] == 4)
			$md = 'Event';
		
		$touched[] = $src['assetid'];
		$itm = array();
		$itm['name'] = $asx->name;
		$itm['id'] = $src['assetid'];
		$itm['mode'] = $src['mode'];
		$itm['modename'] = $md;
		$items[] = $itm;				
	}
	
	echo json_encode($items);
	
}

if (($mode == "process") || ($mode == "report") || ($mode == "deep"))
{	
	
	$assetid = filter_var($_REQUEST['param1'],FILTER_VALIDATE_INT);
	$modeid = filter_var($_REQUEST['param2'],FILTER_VALIDATE_INT);
	
	if ($assetid < 0)
	{
		echo 'Unknown';
		exit();
	}
	
	$query = $db->query("SELECT * FROM datasources JOIN datadriver ON (datasources.gatewayport = datadriver.port) WHERE datasources.assetid=".$assetid);
	
	$source = array();
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{		
		if ($row['assetid'] = $assetid)
		{
			if ($row['mode'] == $modeid)
			{
				$source = $row;
				break;
			}
		}
	}	
	
	
	if ($mode == "deep")
	{		
		$context = array();
		
		$ass = new Asset($assetid);		
		
		$driverstyle = 'Live';
		if ($modeid == 1) $driverstyle = 'Historical';
		if ($modeid > 1) $driverstyle = 'Event';
		
		//$ass->Load();
		$context['name'] = $ass->name.' '.$driverstyle.' Driver Status';
		$context['modeid'] = $modeid;
		$context['inputs'] = '#tick';
		$context['outputs'] = 'Offline Alert';
		$context['port'] = $source['gatewayport'];
		$context['address'] = $source['address'];
		$context['asset'] = $row['assetid'];
		$context['module'] = 'driver_state';
		
		if ($context['address'] == 'localhost')
			$context['address'] = '127.0.0.1';
		
		echo json_encode($context);
		exit();
	}
		
	
	$host = LocalHostName();
	if ($source['address'] != $host)
	{
		$host = $drv['address'];
	}
	if ($host == "localhost") $host = "127.0.0.1";
	$outie = "";
	if ($source['driver'] != '')
	{
		//echo 'Calling For Status...';
		
		$tmx = @microtime(true);
		$client = @stream_socket_client("tcp://".$host.":".$source['port'],$err,$errmsg,2);	
		$ctm = @microtime(true) - $tmx;
		if ($ctm > 5) $timewarning = true;
		
		@fwrite($client,"status\n");
																
		while (!feof($client)) {
			$outie .= fread($client, 8192);
		}
		
		@fclose($client);		
		
		$dta = json_decode($outie,true);
		foreach($dta as $d)
		{
			if ($d['asset'] == $assetid)
			{
				if ($d['connected'] == 1)
				{
					echo 'OK';
					exit();
				}
				else
				{
					echo 'WARNING';
					exit();
				}
			}
		}
		echo 'Unknown';
		exit();
	}
	
	if ($outie == "") $outie = "[]";
	
	$typeasset = new Asset($activetype);
	
	$alist = array();	
	
	$alist[] = $activeasset;
	
	$title = "";
	$overall = "OK";
	
	$resultsets = array();
	$issues = array();
	$markups = array();
	
	global $sitefolder;
	
	foreach($alist as $assid)
	{
		$ass = new Asset($assid);
		$query = "'".$ass->name."' AIPOINTS VALUES";
		$queryurl = 'http://localhost/'.$siteroot.'/aql/api/query?query='.urlencode($query);	
		$resp = file_get_contents($queryurl);	
		
		$value = json_decode($resp,true);
		$values = $value['results'][0]['value'];
		
		for($x=0;$x<count($values);$x++)
		{
			$scl = $values[$x]['rawvalue'];		
			if ($values[$x]['rawvalue'] == '^') 
				$scl = 0;
			else
			{
				if (isset($values[$x]['min']))
				{
					$scl = ($scl - floatval($values[$x]['min'])) / (floatval($values[$x]['max']) - floatval($values[$x]['min']));
				}
				else
				{
					$mn = FALSE;
					$mx = FALSE;					
					foreach($values[$x]['map'] as $k => $v)
					{
						if (($mn === FALSE) || ($mn > $k))
						{
							$mn = $k;
						}
						if (($mx === FALSE) || ($mx < $k))
						{
							$mx = $k;
						}						
					}
					if (($mx - $mn) == 0)
					{
						$scl = 0;
					}
					else
						$scl = ($scl - $mn) / ($mx - $mn);
				}
			}		
			$values[$x]['rawvalue'] = $scl;		
		}
		
		$resultsets[$assid] = $values;
		
		break;
	}
	
	
	//print_r($values);
	
	if ($mode == 'aicurrent')
	{
		$results = array();
		$results['scaled'] = array();
		foreach($values as $v)
		{
			$results['scaled'][] = floatval($v['rawvalue']);
		}
		
		header('Content-Type: application/json');
		echo json_encode($results);
		exit();
	}
	
	
	
	if ($mode == 'process')
	{
		$p1 = filter_var($_REQUEST['param1'],FILTER_VALIDATE_INT);
		$p2 = filter_var($_REQUEST['param2'],FILTER_VALIDATE_INT);
		$cmd = '"'.PythonPath().'" "'.$installfolder.'/addons/firstsite/python/aicompare.py" "127.0.0.1'.$siteroot.'" "'.$sitefolder.'/firstsite" type '.$p1.' '.$p2.' -p';
		//echo $cmd;
		//$res = exec($cmd);
		$descriptorspec = array(
		   0 => array("pipe", "r"),  // stdin is a pipe that the child will read from
		   1 => array("pipe", "w"),  // stdout is a pipe that the child will write to
		   2 => array("pipe", "w") // stderr is a file to write to
		);
		$valueset = array();
		foreach($values as $v)
		{
			$valueset[] = $v['rawvalue'];
		}
		$process = proc_open($cmd, $descriptorspec, $pipes);
		if (is_resource($process))
		{
			fwrite($pipes[0],json_encode($valueset));
			fclose($pipes[0]);
			
			$res = stream_get_contents($pipes[1]);
			$err = stream_get_contents($pipes[2]);
			$rval = proc_close($process);
		}
		$res = trim($res);
		if (($res != "OK") && ($res != "OK*"))
			echo 'WARNING ('.$res.')';
		else
			echo str_replace("*","",$res);
		exit;
	}
	
	
	$title = $typeasset->name." FirstSite Analysis";
	
	include($installfolder.'/include/tmpl.php');
	
	
	?>

		<script src="/addons/dexplore/d3v7.js"></script>
		<style>
.tick
{

}	

.axis line
{
	stroke: silver;
}

.axis path
{
	stroke: silver;
}

.axis text
{
	fill: black;
	font-size: 8px;
}

.xaxis text
{
	fill: none;
	font-size: 8px;
}

.legend
{
	font-size: 5px;
}
		</style>
		<script src="firstsite.js"></script>
		<script>
var data = [];
var markups = [];
		
<?php foreach($resultsets as $k => $v)
{
?>
data = <?php echo json_encode($v); ?>;
<?php
}
?>

function ResetAI()
{
	if (window.confirm('Are you sure you want to remove all AI training data for this FirstSite category?') == true)
	{
		<?php if (count($values) > 0)
		{?>
		ClearResults(data,'type',<?php echo $activetype;?>,0);<?php }; ?>
	}
}

function DrawReports()
{
	var margin = {top: 20, bottom: 20, left: 60, right: 40};		
	var svg = d3.select('#vis');

	var width =	700;
	var height = 500;
	
	var dt = [];
	for(var x=0;x<data.length;x++)
	{			
		dt.push({"axis": data[x].name + " " + data[x].propname, "value": parseFloat(data[x].rawvalue)*100});
	}
	this.dtx = [dt];
	
	var radarChartOptions = {
		  w: width,
		  h: height,			  
		  margin: margin,
		  maxValue: 1,
		  levels: 5,
		  roundStrokes: true,
		  color:  d3.scaleOrdinal().range(["purple"]),
		  minValue: 0,
		  maxValue: 100,
		  update: false,
		  animtime: 200
		};
		
	//Call function to draw the Radar chart
	RadarChart("#vis", this.dtx, radarChartOptions);
	
	/*var width = 1000 - (margin.left + margin.right);
	var height = 400 - (margin.top + margin.bottom);	
	
	var mn = 0;
	var mx = 0;
	
	var piecewidth = width / (data.length);
			
	svg = svg.append("g")
		.attr("transform","translate(" + margin.left + "," + margin.top + ")");
		
	var names = [];
	for(var x=0;x<data.length;x++)
	{
		names.push(data[x].name + " " + data[x].propname);
		
		
		
		if (data[x].rawvalue > mx)
			mx = data[x].rawvalue;
		
		if (data[x].rawvalue < mn)
			mn = data[x].rawvalue;
		
	}
	
	if (Math.abs(mn) > mx)
	{
		mx = Math.abs(mn);
	}
	else
	{
		if (mn == 0)
		{
			mn = -0.1;
		}
	}
	
	var y = d3.scaleLinear().domain([mx*1.1,mn]).range([0,height]);
	var x = d3.scaleBand().domain(names).range([0, width]).padding(0.2);
	
	svg.append("g")
		.attr("transform","translate(0,0)")
		.attr("class","axis yaxis")
		.call(d3.axisLeft(y));	
	
	svg.append("g")
		.attr("transform","translate(0," + (height) + ")")
		.attr("class","axis xaxis")
		.call(d3.axisBottom(x));
		
	var gapwidth = piecewidth - x.bandwidth();
				
	svg.selectAll(".chartbox")
		  .data(data)
		  .enter()
		  .append("rect")
		  .attr("class","chartbox")
		  .attr("x", function(d) { 
			return x(d.name + " " + d.propname);
		  })
		  .attr("y", function(d) { 
			return y(0);
		  })
		  .attr("width", x.bandwidth() )
		  .attr("height", 0)		  
		  .attr("name", function(d) { return d.name + ";" + d.propname + ";" + d.rawvalue; })
		  .style("fill", "green" )
		  .call(tip)
		  .transition()
		  .duration(500)
		  .delay(function(d,i) {
			  return (1000 / (data.length)) * i;
		  })
		  .attr("height", function(d) { return Math.abs(y(-0.1) - y(d.rawvalue)); })
		  .attr("y", function(d) { 
			if (d.rawvalue > 0)
				return y(d.rawvalue);
			else
				return y(0);
		  });
		  
	svg.selectAll(".markupline")
		.data(markups)
		.enter()
		.append("line")
		.attr("stroke",function(d) {
			if (d.style == "Discontinuity") return '#fcb103';
			return 'red';
		})
		.attr("stroke-width", "2px")
		.attr("x1",function(d) {
			if (d.style == "Discontinuity") return x(d.location) - (gapwidth/2);
			return x(d.location);
		})
		.attr("y1",0)
		.attr("y2",height)
		.attr("x2",function(d) {
			if (d.style == "Discontinuity") return x(d.location) - (gapwidth/2);
			return x(d.location);
		});
		
	svg.selectAll(".markuptext")
		.data(markups)
		.enter()
		.append("text")
		.attr("fill",function(d) {
			if (d.style == "Discontinuity") return '#fcb103';
			return 'red';
		})	
		.attr("x",0)
		.attr("y",0)
		.attr("transform",function(d) {
			var yy = 0;
			var xx = x(d.location) + 5;
			if (d.style == "Discontinuity")
				xx -= (gapwidth/2);
			
			return "translate(" + xx + " " + yy + ") rotate(90)";
		})		
		.text(function(d) { return d.style;});*/
}

<?php
//};

foreach($markups as $mu)
{?>
markups.push({'style': '<?php echo $mu[0];?>', 'location': '<?php echo $mu[1];?>'});
<?php } ?>
	
		</script>
<?php		

SS('head');
?>
DrawReports();
<?php
SS('onload');


T('header-basic','title='.$title);
?>
	
	
			<svg id="vis" class="vis" style="max-height: 800px; text-align: center;" viewBox="0 0 700 500">
			
			</svg><?php
	
ST('section','class=content');
	/*ST('row');	
		ST('full');
			ST('box');?>
		<h2>Observations</h2>
		<table>
	<?php
	//Show Report...
	foreach($issues as $iss)
	{
		echo '<tr><td>'.$iss.'</td></tr>';
	}		
	if (count($issues) == 0) echo '<tr><td>No Issues Found</td></tr>'; ?>
		</table><br/><br/>
		<button type="button" class="btn btn-success" onclick="SubmitResults(data,'type',<?php echo $activetype;?>,0);">This Is Normal</button>
	
<?php
			ET();
		ET();
	ET();*/
	
	
	//echo 'Checking For '.$filename;

	
		//Get AI Analysis...		
		ST('row');	
			ST('full');
				ST('box');
					if (file_exists($filename))
					{
						echo '<h3>AI Results</h3>';
						echo '<div class="airesp" style="font-weight: bold; font-size: larger;">';
						$p1 = filter_var($_REQUEST['param1'],FILTER_VALIDATE_INT);
						$p2 = filter_var($_REQUEST['param2'],FILTER_VALIDATE_INT);
						$cmd = '"'.PythonPath().'" "'.$installfolder.'/addons/firstsite/python/aicompare.py" "127.0.0.1'.$siteroot.'" "'.$sitefolder.'/firstsite" type '.$p1.' '.$p2.' -p';
						//echo $cmd;
						//$res = exec($cmd);
						$descriptorspec = array(
						   0 => array("pipe", "r"),  // stdin is a pipe that the child will read from
						   1 => array("pipe", "w"),  // stdout is a pipe that the child will write to
						   2 => array("pipe", "w") // stderr is a file to write to
						);
						$valueset = array();
						foreach($values as $v)
						{
							$valueset[] = $v['rawvalue'];
						}
						$process = proc_open($cmd, $descriptorspec, $pipes);
						if (is_resource($process))
						{
							fwrite($pipes[0],json_encode($valueset));
							fclose($pipes[0]);
							
							$res = stream_get_contents($pipes[1]);
							$err = stream_get_contents($pipes[2]);
							$rval = proc_close($process);
						}
						
						echo $res;
						echo '</div>';
						?>
						<br/><button type="button" class="btn btn-success" onclick="SubmitResults(data,'type',<?php echo $activetype;?>,<?php echo $activeasset;?>);">This Is Normal</button><br/>
						<br/><button type="button" class="btn btn-warning" onclick="ResetAI();">Reset AI Training Data</button><?php
						//echo $cmd;
					}
					else
					{
						echo '<h3>AI Results Not Available</h3>';
						echo '<p>You need to train the AI using the <strong>This Is Normal</strong> button to prepare an AI</p>';?>
						<br/><button type="button" class="btn btn-success" onclick="SubmitResults(data,'type',<?php echo $activetype;?>,<?php echo $activeasset;?>);">This Is Normal</button><br/><?php
					}
				ET();
			ET();
		ET();
ET();
	
}

?>
<div class="tooltip" id="internal_tooltip" style="display: none; pointer-events: none; color: black; position: absolute; font-size: small; background-color: white; max-width: 200px; border: 1px solid black; border-radius: 5px; padding: 5px;opacity: 1; ">
			
		</div>