function SubmitResults(data,style,p1,p2,p3) {
	$.post('normalvalues',{ values: JSON.stringify(data), style: style, param1: p1, param2: p2, param3: p3},function (resp) {
		window.location.reload();
	});
}

function ClearResults(data,style,p1,p2,p3) {
	$.post('clearvalues',{ values: JSON.stringify(data), style: style, param1: p1, param2: p2, param3: p3},function (resp) {
		window.location.reload();
	});
}

function updateTooltip(ev)
{
	return ev.target.getAttribute("name").replaceAll(";","<br/>");
}

var tipoptions = {};

function tip(selection)
{
	selection.on('mouseover',function(ev) {
		var content = updateTooltip(ev);
		$('#internal_tooltip').html(content);
		ShowTooltip(ev,tipoptions);			
	});
	selection.on('mousemove',function(ev) {
		var content = updateTooltip(ev);
		$('#internal_tooltip').html(content);
		UpdateTooltip(ev,tipoptions);			
	});
	selection.on('mouseleave',function(ev) {
		HideTooltip();
	});
	
}

var tiptarget = null;

function ShowTooltip(ev,options)
{
	tiptarget = ev.target;
	var style = "simple";
	$('#internal_tooltip').attr('class','tooltip ' + style);
		
	var ex = ev.clientX;
	var ey = ev.clientY + window.scrollY;
	if (ex > window.innerWidth - 150)
	{
		ex = ex - $('#internal_tooltip').innerWidth();
	}
	if (ey > window.innerHeight - 150)
	{
		ey = ey - $('#internal_tooltip').innerHeight();
	}
	$('#internal_tooltip').css("top",ey);
	$('#internal_tooltip').css("left",ex);	
		
	if ($(ev.target).attr('class').indexOf('element') >= 0)
	{	
		$('.element').attr("opacity",0.75);	
		$(ev.target).attr("opacity",1);
	}
	
	$('#internal_tooltip').stop();
	$('#internal_tooltip').fadeIn(200);
	
}

function UpdateTooltip(ev,options)
{
	if (tiptarget != null)
	{
		var style = "simple";
		$('#internal_tooltip').attr('class','tooltip ' + style);	
			
		var ex = ev.clientX;
		var ey = ev.clientY + window.scrollY;
		if (ex > window.innerWidth - 150)
		{
			ex = ex - $('#internal_tooltip').innerWidth();
		}
		if (ey > window.innerHeight - 150)
		{
			ey = ey - $('#internal_tooltip').innerHeight();
		}
		$('#internal_tooltip').css("top",ey);
		$('#internal_tooltip').css("left",ex);	
	}
}

function HideTooltip()
{
	tiptarget = null;
	$('#internal_tooltip').stop();
	$('#internal_tooltip').fadeOut(200);
	$('.element').attr("opacity",1);	

}