function GetValue(actual,reference)
{
	var x = 100 - (actual - reference); 
	if (x < 0) x = 0;
	return x;
}

class ActiveReport extends SVGReport {
	initialise() {
		super.initialise();
		this.radar = null;
		this.chartoptions = null;
		this.dtx = null;
	};
	
	create() {
		this.liveReport("'Coil Entry' ASSET 'Coil' RELATIONSHIP 'downi' RELATED 'Paint Line' ASSET APPEND 'Speed - Max' PROPERTY VALUES");		
	}
	
	update() {
		if (this.chartoptions == null) return;
		
		var ref = report.livedata[0];
		
		for(var x=0;x<report.livedata.length-1;x++)
		{
			try
			{
				report.dtx[0][x].value = GetValue(parseFloat(report.livedata[x+1]), ref);				
			}
			catch
			{
			}
		}
		report.chartoptions.update = true;
		report.chartoptions.animtime = Math.floor(report.updatetiming) * 1.1;		
		RadarChart("#reportsvg",report.dtx,report.chartoptions);		
	}
		
	draw(data) {
		//Calculate resulting size...
		$('#reportsvg').html("");
		
		var margin = {top: 20, right: 20, bottom: 20, left: 20};
		var height = this.sizing[1];
		var width = this.sizing[0];
		var base = parseFloat(this.livedata[0]);		

		var dt = [];
		for(var x=1;x<this.livedata.length;x++)
		{			
			dt.push({"axis": this.columns[x].name.replace(" Speed - Max",""), "value": GetValue(parseFloat(this.livedata[x]),base)});
		}
		this.dtx = [dt];
		
		var radarChartOptions = {
			  w: width,
			  h: height,			  
			  margin: margin,
			  maxValue: 1,
			  levels: 5,
			  roundStrokes: true,
			  color:  d3.scaleOrdinal().range(["yellow"]),
			  minValue: 0,
			  maxValue: 100,
			  update: false,
			  animtime: 200
			};
			
		//Call function to draw the Radar chart
		RadarChart("#reportsvg", this.dtx, radarChartOptions);
		
		this.chartoptions = radarChartOptions;		
		
		this.radar = this;
	}	
}