<?php

$pagesize = 10;
$pagestart = 0;

$title = "ARDI FirstSite Analysis";
$method = 'report';
if (isset($_REQUEST['method']))
{
	$method = $_REQUEST['method'];
}

include('phases.php');

include($installfolder.'/include/tmpl.php');
//include($installfolder.'/model/model.php');

global $db;

$path = $sitefolder.'/addons';
if (!file_exists($path))
{
	mkdir($path);
}

$msg = "";

require_once($installfolder.'/model/property.php');

$props = Properties::GetAllProperties();

?>
<style>
.checkbox
{
	display: inline;
	margin-right: 2em;
}

.statusline .status
{
	display: block;
	width: 20px;
	height: 12px;
	margin-right: 1em;
	border: 1px solid black;
	display: inline-block;
}

.deadline .status
{
	display: block;
	width: 20px;
	height: 12px;
	margin-right: 1em;
	border: 1px solid black;
	display: inline-block;
	text-decoration: strikeout;
}

.statusline .status.unknown
{
	background-color: silver;
}

.statusline.unknown a
{
	color: silver;
}
.prog.unknown
{
	background-color: silver;
}

.statusline .status.processing
{
	background-color: purple;
}

.statusline.processing a
{
	color: purple;
}
.prog.processing
{
	background-color: purple;
}

.statusline .status.ok
{
	background-color: green;
}

.statusline.ok a
{
	color: green;
}

.prog.ok
{
	background-color: green;
}

.statusline .status.warning
{
	background-color: yellow;
}

.statusline.warning a
{
	color: #007777;
}
.prog.warning
{
	background-color: yellow;
}

.statusline .status.error
{
	background-color: red;
}

.statusline.error a
{
	color: #990000;
}
.prog.error
{
	background-color: red;
}

.statusline .status.empty
{
	background-color: #777777;
}

.statusline.empty a
{
	color: #777777;
}
.prog.empty
{
	background-color: #777777;
}


</style>
<?php
SS('head');
?>

NextPhase();

<?php
SS('onload');
?>
<script>

var phaseno = 0;
var phasenames = [<?php
for($x=0;$x<count($phases);$x++)
{
	if ($x > 0) echo ',';
	echo '"'.$phases[$x]['name'].':'.$phases[$x]['code'].'"';
}
?>];

var Content = "";
var processing = true;

function UncheckAll()
{
	$('.checkbox').prop('checked',false);
}

function CheckAll()
{
	$('.checkbox').prop('checked',true);
}

function UncheckMatching(m)
{
	$(m).prop('checked',false);
}

function CheckMatching(m)
{
	$(m).prop('checked',true);
}

var itemlist = [];
var itemprocess = -1;

function ProcessPhases()
{
	var items = $('.statusline');
	var cnt = '';	
	for(var x=0;x<items.length;x++)
	{
		cnt += '<div class="prog unknown" style="display: inline-block; margin: 0px; padding: 0px; width: 10px; height: 10px;" id="' + items[x].getAttribute('name') + '_prog"/>';		
		itemlist.push(items[x].getAttribute('name'));
	}
	
	$('.statusline .status').on('click',function (ev) {
		var nm = ev.target.parentNode.getAttribute("id");
		$('#' + nm).attr('class','statusline unknown');
		$('#' + nm + ' .status').attr('class','status unknown');
		$('#' + nm + "_prog").attr('class','prog unknown');
		itemlist.push(nm);
		if (processing == false)
		{
			processing = true;
			itemprocess = itemlist.length-2;
			console.log("Restarting Processing...");
			ProcessPhase();
		}
	});
	
	$('#progress').html(cnt);	
	
	ProcessPhase();
}

function ProcessPhase()
{		
	processing = true;
	itemprocess++;
	if (itemprocess >= itemlist.length) 
	{
		processing = false;
		return;
	}
	var bits = itemlist[itemprocess].split('_');
	var style = bits[0];
	var params = {mode: "process"};
	
	var nm = itemlist[itemprocess];
	
	$('#' + itemlist[itemprocess]).attr('class','statusline processing');
	$('#' + itemlist[itemprocess] + ' .status').attr('class','status processing');
	$('#' + itemlist[itemprocess] + "_prog").attr('class','prog processing');
	
	var lnk = $('#' + itemlist[itemprocess] + ' a').attr('href');
	if (lnk != undefined)
	{
		var ps = lnk.indexOf('&at=');
		if (ps == -1)
		{
			lnk += "&at=" + new Date().getTime();
		}
		else
		{
			lnk = lnk.substr(0,ps) + "&at=" + new Date().getTime();
		}	
		$('#' + itemlist[itemprocess] + ' a').attr('href',lnk);
	}
	
	//console.log('#' + itemlist[itemprocess] + "_prog");
	
	for(var n=0;n<bits.length;n++)
	{
		params['param'+n] = bits[n];
	}	
	
	$.post('<?php echo $siteroot;?>/firstsite/' + style,params,function(d) {
		//console.log(d);
		d = d.replace("*","");
		var newstat = d.split(':')[0].toLowerCase();
		$('#' + itemlist[itemprocess]).attr('class','statusline ' + newstat);
		$('#' + itemlist[itemprocess] + ' .status').attr('class','status ' + newstat);	
		$('#' + itemlist[itemprocess] + '_prog').attr('class','prog ' + newstat);			
		
		window.setTimeout('ProcessPhase();',500);
	});
	
}

function NextPhase()
{
	if (phaseno >= phasenames.length)
	{
		$('#loadinglabel').html('All Reports Loaded');
		ProcessPhases();
		return;
	}
	
	var name = phasenames[phaseno].split(':')[0];
	var code = phasenames[phaseno].split(':')[1];
	$('#loadinglabel').html('Phase ' + (phaseno + 1) + '/' + phasenames.length + ' - ' + name);
	
	$.post(code+"?method=<?php echo $method;?>",function (data) {
		Content += data;
		$('table').html(Content);
		NextPhase();
	});
	
	phaseno++;
}

</script>
<?php

T('header-basic','title='.$title);

ST('section','class=content');
	ST('row');
		ST('full');
			ST('box','title=Progress');?>
				<div id="progress" style="position: relative; width: 100%;min-height:10px;">
				</div>
				<?php
			ET();
			ST('box','title=Results');?>
				
				<?php					
					ST('ftable');
					
					?>					
					<?php
					ET();
			ET();
		ET();
	ET();	
ET();

?>
