<?php

if (!function_exists('DrawHeader'))
{
	function DrawHeader($name,$code)
	{
		echo '<tr><td><h3>'.$name.'</h3></td></tr>';		
		echo '<tr><td><a href="index?method=limits">Limits Only</a>&nbsp;&nbsp;&nbsp;<a href="index">All Tests</a></td></tr>';				
	}
}

if (!isset($_REQUEST['mode']))
	$mode = "query";
else
	$mode = $_REQUEST['mode'];


include_once($installfolder.'/model/property.php');

$method = "report";
if (isset($_REQUEST['method']))
	$method = $_REQUEST['method'];

$allprops = Properties::GetAllProperties();

if ($mode == "query")
{
	//Get all 'target' properties
	$targets = array();
	foreach($allprops as $px)
	{
		if (strpos(strtolower($px->name),"maximum") !== FALSE)
		{
			$targets[] = $px;
		}
	}
	
	foreach($allprops as $px)
	{
		if (strpos(strtolower($px->name),"minimum") !== FALSE)
		{
			$targets[] = $px;
		}
	}
	
	$targetids = array();
	foreach($targets as $tg)
	{
		$targetids[] = $tg->id;
	}
	
	print_r($targets);
	
	//Get practical property usage figures...
	$propusage = array();
	$query = $db->query("SELECT propertyid,assetid FROM assetvalues WHERE propertyid IN (".implode(',',$targetids).")");
				
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		if (!isset($propusage[$row['propertyid']]))
		{
			$propusage[$row['propertyid']] = array();
		}
		$propusage[$row['propertyid']][] = $row['assetid'];
	}
	
	//Next, we get a list of types so we can distribute values to any type-users...
	$query = $db->query("SELECT id FROM assets WHERE type=1");
	$types = array();
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		if (isset($propusage[$row['id']]))
		{
			$types[] = $row['id'];
		}
	}
	
	if (count($types) > 0)
	{
		$proplist = array_keys($propusage);
		//Finally, spread usages out across types...
		$query = $db->query("SELECT parentasset,childasset FROM assetrelclosures WHERE parentasset IN (".implode(',',$types).")");		
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{
			foreach($proplist as $pid)
			{
				if (in_array($row['parentasset'],$propusage[$pid]))
				{
					$proplist[$pid][] = $row['childasset'];
				}
			}
		}
	}
	
	DrawHeader("Limits","livelimits");
	
	$combos = array();
	
	foreach($targets as $px)
	{
		if (!isset($propusage[$px->id]))
			continue;
				
		if ($px->type == "MEASUREMENT")
		{			
			$nm = $px->name;
			$rrx = explode(' - ',$px->name);
			if (count($rrx) > 1)
			{
				$nm = $rrx[1].' '.$rrx[0];
			}
			
			$clas = 'statusline';
			
			$nm = str_replace("Maximum","",$nm);
			$nm = trim(str_replace("Minimum","",$nm));
			
			$combo = $aid.'_'.$nm;
			if (in_array($combo,$combos))
			{
				continue;
			}
			$combos[] = $combo;
			
			foreach($propusage[$px->id] as $aid)
			{
				$ass = new Asset($aid);							
				echo '<tr><td><div class="'.$clas.' unknown"id="limits_'.$px->id.'_'.$aid.'" name="limits_'.$px->id.'_'.$aid.'"';				
				echo '><div class="status unknown"></div><a target="_blank" href="limits?mode=report&param0=limits&param1='.$px->id.'&param2='.$aid.'">'.$ass->name.' '.$nm.'</a></div></td></tr>';	
			}
		}
	}
		
}

if (($mode == "process") || ($mode == "report") || ($mode == 'aicurrent') || ($mode == 'deep'))
{
	$property = filter_var($_REQUEST['param1'],FILTER_VALIDATE_INT);
	$assid = filter_var($_REQUEST['param2'],FILTER_VALIDATE_INT);
	
	$state = 'EMPTY';
	
	$ass = new Asset($assid);
	$props = $ass->GetProperties();
	$lowerlimit = -1;
	$upperlimit = -1;
	$refprop = -1;
	$name = "";
	$subname = "";
	$final = array();
		
	$other = "";
	//Get the 'min' or 'max' figure...
	foreach($props as $px)
	{
		if ($px->id == $property)
		{
			//print_r($px);
			$parts = explode(' - ',$px->name);
			$fullname = $parts[0];			
			$name = str_replace("maximum","",strtolower($px->name));
			$name = str_replace("minimum","",$name);
			if (strpos(strtolower($px->name),"minimum") !== FALSE)
			{
				$other = strtolower(str_replace("Minimum","Maximum",$px->name));
				$final[1] = $px;
			}
			else
			{
				$other = strtolower(str_replace("Maximum","Minimum",$px->name));
				$final[2] = $px;
			}
			break;
		}		
	}	
	
	//Find if there's the opposite option (ie. a max if we've been given a min).
		
	foreach($props as $px)
	{
		if ($px->id == $property) continue;		
		
		if (strtolower($px->name) == $other)
		{			
			$indx = 1;
			if (isset($final[1])) $indx = 2;
			$final[$indx] = $px;
			break;			
		}
	}
	
	//Try to determine the figure we're actually limiting...
	$matchlen = strlen($name);
	
	$candidates = array();
	
	foreach($props as $px)
	{
		if ($px->id == $property) continue;
		if (strlen($px->name) < $matchlen) continue;				
		
		if (strtolower($px->name) == $name)
		{
			$candidates[] = $px;
		}
	}
	
	$name = trim(str_replace(" -","",$name));
	
	if (count($candidates) == 0)
	{
		foreach($props as $px)
		{
			if ($px->id == $property) continue;
			if (($final[1] !== FALSE) && ($px->id == $final[1]->id)) continue;
            if (($final[2] !== FALSE) && ($px->id == $final[2]->id)) continue;

			if (strlen($px->name) < $matchlen) continue;				
			
			$parts = explode(' - ',strtolower($px->name));			
			
			//echo 'Searching For '.$name.' vs '.$parts[0];
			
			if ($parts[0] == $name)
			{
				$candidates[] = $px;
			}
		}
	}
	
	if (count($candidates) == 0)
	{
		$status = "EMPTY";		
	}
	else
	{
	
		
			$final[0] = $candidates[0];	
			$refprop = $candidates[0]->id;
		
		if ($final[0]->value['measurement'] == '^')
			$final[0]->value['measurement']	= 0;
		
		if ($final[1]->value['measurement'] == '^')
			$final[1]->value['measurement']	= 0;
		
		//Get the sub-name of the actual value...
		$bits = explode(' - ',$final[0]->name);
		if (count($bits) > 1)
			$subname = ' - '.$bits[1];
		
		//Check to see if we're in limits...
		$span = 1;
		if (isset($final[0]))
		{
			$ass->GetValues($final);			
			
			if (isset($final[1]))
			{				
				if (floatval($final[0]->value['measurement']) < floatval($final[1]->value['measurement']))
				{
					$state = 'WARNING';					
				}
			}
			if (isset($final[2]))
			{
				if (floatval($final[0]->value['measurement']) > floatval($final[2]->value['measurement']))
				{
					$state = 'WARNING';					
				}
			}			
			
			if ($state == "EMPTY")
				$state = 'OK';		
		}
	}
	
	if ($mode == "deep")
	{				
		$context = array();	
		
		if (isset($final[1]))
		{
			$context['name'] = 'FirstSite '.$ass->name.' '.$fullname.' Lower Limit';		
			$context['module'] = 'limit_low_alert';
			$context['inputs'] = array($final[0]->name.".".$final[0]->propname,$final[1]->name.".".$final[1]->propname);
			$context['outputs'] = 'Low Limit Alert';
			$context['tolerance'] = 2;
		}
		if (isset($final[2]))
		{
			$context['name'] = 'FirstSite '.$ass->name.' '.$fullname.' Upper Limit';		
			$context['module'] = 'limit_high_alert';
			$context['inputs'] = array($final[0]->name.".".$final[0]->propname,$final[2]->name.".".$final[2]->propname);
			$context['outputs'] = 'High Limit Alert';
			$context['tolerance'] = 2;
		}
		
		echo json_encode($context);		
		
		exit();
	}
	if ($mode == 'process')
	{
		if (isset($diff))
			echo $state;
		else
			echo $state;
		exit();
	}
	
	if ($mode == 'report')
	{
		$title = $ass->name." Limits";
	
		include($installfolder.'/include/tmpl.php');
		
		?>

		<script src="/addons/dexplore/d3v7.js"></script>
		<style>
		
.results 
{
	display: block;
	padding: 10px;
	border-radius: 5px;
	border: 1px solid black;
	color: black;
	font-size: 20px;
	font-weight: bold;
	width: auto;
	margin-bottom: 0.5em;
}

.results.OK
{
	background-color: green;
	color: white;
}

.results.WARNING
{
	background-color: yellow;
	color: black;
}

.results.ERROR
{
	background-color: red;
	color: white;
}

.results.EMPTY
{
	background-color: #777777;
	color: white;
}

#gaugeblock g.arc {
		fill: steelblue;
	}

#gaugeblock g.pointer {
	fill: blue;
	stroke: white;
}

#gaugeblock g.label text {
	text-anchor: middle;
	font-size: 14px;
	font-weight: bold;
	fill: #666;
}
		</style>
		<script src="firstsite.js"></script>
		<script>
		
var gauge = function(container, configuration) {
	var that = {};
	var config = {
		size						: 200,
		clipWidth					: 200,
		clipHeight					: 110,
		ringInset					: 20,
		ringWidth					: 20,
		
		pointerWidth				: 10,
		pointerTailLength			: 5,
		pointerHeadLengthPercent	: 0.9,
		
		minValue					: 0,
		maxValue					: 10,
		minGood						: 4,
		maxGood						: 6,
		
		minAngle					: -90,
		maxAngle					: 90,
		
		transitionMs				: 750,
		
		majorTicks					: 5,
		labelFormat					: d3.format(',g'),
		labelInset					: 10,
		
		arcColorFn					: d3.interpolateHsl(d3.rgb('#660000'), d3.rgb('#990000'))
	};
	var range = undefined;
	var r = undefined;
	var pointerHeadLength = undefined;
	var value = 0;
	
	var svg = undefined;
	var arc = undefined;
	var goodarc = undefined;
	var scale = undefined;
	var ticks = undefined;
	var tickData = undefined;
	var pointer = undefined;

	var donut = d3.pie();
	
	function deg2rad(deg) {
		return deg * Math.PI / 180;
	}
	
	function newAngle(d) {
		var ratio = scale(d);
		var newAngle = config.minAngle + (ratio * range);
		return newAngle;
	}
	
	function configure(configuration) {
		var prop = undefined;
		for ( prop in configuration ) {
			config[prop] = configuration[prop];
		}
		
		range = config.maxAngle - config.minAngle;
		r = config.size / 2;
		pointerHeadLength = Math.round(r * config.pointerHeadLengthPercent);

		// a linear scale that maps domain values to a percent from 0..1
		scale = d3.scaleLinear()
			.range([0,1])
			.domain([config.minValue, config.maxValue]);
			
		ticks = scale.ticks(config.majorTicks);
		tickData = d3.range(config.majorTicks).map(function() {return 1/config.majorTicks;});
		
		arc = d3.arc()
			.innerRadius(r - config.ringWidth - config.ringInset)
			.outerRadius(r - config.ringInset)
			.startAngle(function(d, i) {
				var ratio = d * i;
				return deg2rad(config.minAngle + (ratio * range));
			})
			.endAngle(function(d, i) {
				var ratio = d * (i+1);
				return deg2rad(config.minAngle + (ratio * range));
			});
			
		
	}
	that.configure = configure;
	
	function centerTranslation() {
		return 'translate('+r +','+ r +')';
	}
	
	function isRendered() {
		return (svg !== undefined);
	}
	that.isRendered = isRendered;
	
	function render(newValue) {
		svg = d3.select(container)
			.append('svg:svg')
				.attr('class', 'gauge')
				.attr('width', config.clipWidth)
				.attr('height', config.clipHeight);
		
		var centerTx = centerTranslation();
		
		var arcs = svg.append('g')
				.attr('class', 'arc')
				.attr('transform', centerTx);
		
		arcs.selectAll('.baddie')
				.data(tickData)
			.enter().append('path')
				.attr('fill', function(d, i) {
					return config.arcColorFn(d * i);
				})
				.attr('class','baddie')
				.attr('d', arc);
				
		var rmin = scale(config.minGood);
		var rmax = scale(config.maxGood);
				
		goodarc = d3.arc()
			.innerRadius((r - config.ringWidth - config.ringInset)-4)
			.outerRadius((r - config.ringInset) + 4)
			.startAngle(deg2rad(config.minAngle + (rmin * range)))
			.endAngle(deg2rad(config.minAngle + (rmax * range)));
				
		arcs.append('path')
			.attr('fill','green')
			.attr('class','goodie')
			.attr('d', goodarc);
		
		var lg = svg.append('g')
				.attr('class', 'label')
				.attr('transform', centerTx);
		lg.selectAll('text')
				.data(ticks)
			.enter().append('text')
				.attr('transform', function(d) {
					var ratio = scale(d);
					var newAngle = config.minAngle + (ratio * range);
					return 'rotate(' +newAngle +') translate(0,' +(config.labelInset - r) +')';
				})
				.text(config.labelFormat);

		var lineData = [ [config.pointerWidth / 2, 0], 
						[0, -pointerHeadLength],
						[-(config.pointerWidth / 2), 0],
						[0, config.pointerTailLength],
						[config.pointerWidth / 2, 0] ];
		var pointerLine = d3.line();
		var pg = svg.append('g').data([lineData])
				.attr('class', 'pointer')
				.attr('transform', centerTx);
				
		pointer = pg.append('path')
			.attr('d', pointerLine/*function(d) { return pointerLine(d) +'Z';}*/ )
			.attr('transform', 'rotate(' +config.minAngle +')');
			
		update(newValue == undefined ? 0 : newValue);
	}
	that.render = render;
	
	function update(newValue, newConfiguration) {
		if ( newConfiguration  !== undefined) {
			configure(newConfiguration);
		}
		var ratio = scale(newValue);
		var newAngle = config.minAngle + (ratio * range);
		pointer.transition()
			.duration(config.transitionMs)			
			.attr('transform', 'rotate(' +newAngle +')');
	}
	that.update = update;

	configure(configuration);
	
	return that;
};

<?php

$minlevel = $final[0]->value['min'];
if (isset($final[1]))
	$minlevel = $final[1]->value['measurement'];

$maxlevel = $final[0]->value['max'];
if (isset($final[2]))
{	
	$maxlevel = $final[2]->value['measurement'];
	if ($maxlevel == '^')
	{
		$maxlevel = $minlevel;
	}
}
?>

function DrawReports()
{
	var g = gauge('#gaugeblock', {
		size: 500,
		clipWidth: 500,
		clipHeight: 500,
		ringWidth: 60,
		minValue: <?php echo $final[0]->value['min'];?>,
		maxValue: <?php echo $final[0]->value['max'];?>,
		minGood: <?php echo $minlevel;?>,
		maxGood: <?php echo $maxlevel;?>,
		transitionMs: 1000,
		labelFormat: d3.format(".0f")
	});
	g.render(<?php echo $final[0]->value['measurement'];?>);
	//g.update(50);
}
		</script><?php		

SS('head');
?>
DrawReports();
<?php
SS('onload');

T('header-basic','title='.$title);

ST('section','class=content');
	
		//Get AI Analysis...		
		ST('row');	
			ST('full');
				ST('box');
					echo '<div class="results '.str_replace("*","",$state).'">'.$state.'</div>';
					if ($state == "EMPTY")
					{
						echo '<hr/>This asset as a <strong>maximum</strong> or a <strong>minimum</strong> property, but doesn\'t seem to have a property for the <strong>actual measurement</strong>.';
					}
					else
					{						

						echo '<p style="font-size: large; font-weight: bold;">Actual Value: <span>'.round($final[0]->value['measurement'],$final[0]->value['places']).$final[0]->value['units'].'</span>';
						if (isset($final[1]))
							echo '<br/>Minimum Value: <span>'.round($final[1]->value['measurement'],$final[1]->value['places']).$final[1]->value['units'].'</span>';
						if (isset($final[2]))
							echo '<br/>Maxmum Value: <span>'.round(floatval($final[2]->value['measurement']),$final[2]->value['places']).$final[2]->value['units'].'</span>';
						echo '</p>';
						
					}
				ET();
			ET();			
		ET();
ET();?>
	
	
			<div id="gaugeblock" style="text-align: center;">
			</div>
<?php
	}		
}
?>