<?php

if (!function_exists('DrawHeader'))
{
	function DrawHeader($name,$code)
	{
		echo '<tr><td><h3>'.$name.'</h3></td></tr>';	
		echo '<tr><td><a href="index?method=properties">Properties Only</a>&nbsp;&nbsp;&nbsp;<a href="index">All Tests</a></td></tr>';				
		//echo '<tr><td><a href="#" onclick="CheckMatching(\'.'.$code.'.checkbox\'); return false;">Check</a>&nbsp;&nbsp;&nbsp;<a href="#" onclick="UncheckMatching(\'.'.$code.'.checkbox\'); return false;">Uncheck</a><br/><hr/></td></tr>';
	}
}
$method = "report";
if (!isset($_REQUEST['mode']))
	$mode = "query";
else
	$mode = $_REQUEST['mode'];

include_once($installfolder.'/model/property.php');

$attime = "";
$scanrange = 0;
$samples = 20;
if (isset($_REQUEST['scan']))
{
	$scanrange = $_REQUEST['scan'];
}
if (isset($_REQUEST['at']))
{
	$attime = $_REQUEST['at'];
	if (is_numeric($attime))
	{
		//Parse a UTC datetime...
		$attime = gmdate('Y-m-d H:i:s',intval($attime/1000));					
	}
}

$allprops = Properties::GetAllProperties();

if ($mode == "query")
{
	//Get practical property usage figures...
	$propusage = array();
	$query = $db->query("SELECT propertyid,assetid FROM datalinks WHERE mode=1");
				
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		if (!isset($propusage[$row['propertyid']]))
		{
			$propusage[$row['propertyid']] = 0;
		}
		$propusage[$row['propertyid']]++;
	}
	
	
	DrawHeader("Values","current");
	foreach($allprops as $px)
	{
		if (!isset($propusage[$px->id]))
			continue;
		
		if (strpos($px->name," Target") !== FALSE)
		{
			continue;
		}
		$valid = false;		
					
		if ($px->type == "PLACEMENT") continue;
		if ($px->type == "ID") continue;
		if ($px->type == "TAG") continue;
		if ($px->type == "URL") continue;
		echo '<tr><td><div class="statusline unknown"id="prop_'.$px->id.'" name="prop_'.$px->id.'"';				
		echo '><div class="status unknown"></div><a target="_blank" href="prop?mode=report&param0=prop&param1='.$px->id.'">'.$px->name.'</a></div></td></tr>';				
		
	}
}

if ($mode == "list")
{
	//Get practical property usage figures...
	$propusage = array();
	$query = $db->query("SELECT propertyid,assetid FROM datalinks WHERE mode=1");
				
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		if (!isset($propusage[$row['propertyid']]))
		{
			$propusage[$row['propertyid']] = 0;
		}
		$propusage[$row['propertyid']]++;
	}
	
	
	$items = array();
	foreach($allprops as $px)
	{
		if (!isset($propusage[$px->id]))
			continue;
		
		if (strpos($px->name," Target") !== FALSE)
		{
			continue;
		}
		$valid = false;		
					
		if ($px->type == "PLACEMENT") continue;
		if ($px->type == "ID") continue;
		if ($px->type == "TAG") continue;
		if ($px->type == "URL") continue;
		$itm = array();
		$itm['name'] = $px->name;
		$itm['id'] = $px->id;
		$items[] = $itm;		
		echo json_encode($items);
	}	
}

if (($mode == "process") || ($mode == "report"))
{	
	$title = "";
	$overall = "OK";
	$issues = array();
	$markups = array();
	$batches = array();

	global $sitefolder;		
	$propid = $_REQUEST['param1'];
	
	global $sitefolder;
	
			
	$propinfo = FALSE;
	
	foreach($allprops as $px)
	{
		if ($px->id == $_REQUEST['param1'])
		{
			$propinfo = $px;
			break;
		}
	}
	
	if ($propinfo == FALSE) exit();
	
	$defaults = $px->GetDefault();	

	//Get All Property  Values...
	$query = "'".$propinfo->name."' PROPERTY ALLPOINTS";	
	$queryurl = 'http://localhost/'.$siteroot.'/aql/api/query?query='.urlencode($query);	
	$resp = file_get_contents($queryurl);	
	
	$value = json_decode($resp,true);
	$values = $value['results'][0]['value'];	
	
	if ($scanrange > 0)
	{
		$histquery = "'".$propinfo->name."' PROPERTY ALLPOINTS {\"range\": \"".$scanrange." minutes\",\"grain\": -".$samples."} GETHISTORY";
		$queryurl = 'http://localhost/'.$siteroot.'/aql/api/table?query='.urlencode($histquery)."&format=csv";	
		$table = file_get_contents($queryurl);
		$history = explode("\n",$table);		
		//print_r($table);
		//exit();
	}
	if ($attime != "")
	{
		$dt = DateTimeImmutable::createFromFormat("Y-m-d H:i:s",$attime);
		if ($dt === FALSE)
		{
			echo 'Failed On '.$attime;
		}
		$en = $dt->add(new DateInterval("PT10S"));
		$en = $en->format("Y-m-d H:i:s");
		
		$histquery = "'".$propinfo->name."' PROPERTY ALLPOINTS {\"start\": \"".$attime."\",\"end\": \"".$en."\",\"grain\": -10} GETHISTORY";
		$queryurl = 'http://localhost/'.$siteroot.'/aql/api/table?query='.urlencode($histquery)."&format=csv";	
		$table = file_get_contents($queryurl);
		$history = explode("\n",$table);	
		
		$headers = explode(',',$history[0]);
		$dta = explode(',',$history[1]);
				
		//Load historical values into the active value list...
		for($x=0;$x<count($headers);$x++)
		{
			$vx = -1;
			foreach($values as $v)
			{
				$vx++;
				$nm = $v['name'].' '.$v['propname'];
				if ($nm == $headers[$x])
				{
					if ($dta[$x] != "^")
						$values[$vx]['rawvalue'] = round(floatval($dta[$x]),3);
					else
						$values[$vx]['rawvalue'] = '^';
					break;
				}
			}
		}		
		
		unset($history);
	}
	
	$minrange = 0;
	$maxrange = 1;
	$code = "";	
	
	switch ($propinfo->type)
	{
		case "MEASUREMENT":
			$defaults = $propinfo->GetDefault();
			$maxrange = $defaults[3];
			$minrange = $defaults[2];
			break;
		case "ENUM":
		case "LOOKUP":
		case "STATUS":
			$valueset = $propinfo->GetValueMap();
			foreach($valueset as $k => $v)
			{
				if (($minrange === FALSE) || ($k < $minrange))
					$minrange = $k;
				if (($maxrange === FALSE) || ($k > $maxrange))
					$maxrange = $k;
			}					
			break;
	}
	
	$allzero = true;
	
	foreach($values as $v)
	{					
		if ($v == null) continue;
		if ($v['rawvalue'] == "^")
		{			
			$issues[] = "Bad Data On ".$v['name'];
			$markups[] = array('Bad Data',$v['name']);
			$overall = "ERROR";						
		}	
		else
		{
			//echo $v['rawvalue'].' vs '.$minrange.' / '.$maxrange.'<br/>';
			if (($v['rawvalue'] < $minrange) || ($v['rawvalue'] > $maxrange))
			{				
				$issues[] = "Out-Of-Range Data On ".$v['name'].' ('.$v['rawvalue'].')';
				$markups[] = array('Out Of Range Data',$v['name']);	
				$overall = "ERROR";						
			}
		}
		if ($v['rawvalue'] != 0)
			$allzero = false;
		$code .= "data.push(".json_encode($v).");\n";		
	}
	
	if ($allzero == true)
	{
		$issues[] = "All Data Zero";
		$markups[] = array('All Data Zero',$values[0]['name']);	
		if ($overall == "OK")
			$overall = "EMPTY";
	}
	
	if ($mode == "process")
	{
		if (count($issues) == 0)
			echo 'OK';
		else
		{
			echo $overall.':';
			echo implode(':',$issues);
		}
		exit();
	}
	
	$title = $px->name." FirstSite Property Analysis";
	
	include($installfolder.'/include/tmpl.php');
	
	
	?>

		<script src="/addons/dexplore/d3v7.js"></script>
		<style>
.tick
{

}	

.axis line
{
	stroke: silver;
}

.axis path
{
	stroke: silver;
}

.axis text
{
	fill: black;
	font-size: 8px;
}

.xaxis text
{
	fill: none;
	font-size: 8px;
}
		</style>
		<script src="firstsite.js"></script>
		<script>
var data = [];
var markups = [];

<?php
if (isset($history))
{?>
var dhistory = [<?php
$first = true;
for($x=1;$x<count($history);$x++)
{
	if (trim($history[$x]) == "") continue;
	if ($first == true)
		$first = false;
	else
		echo ',';
	echo '[';
	$ps = strpos($history[$x],',');
	
	echo trim(substr($history[$x],$ps+1));
	echo ']';
}
?>];	
<?php }?>
		
<?php 		
echo $code;
?>

function DrawReports()
{
	var margin = {top: 20, bottom: 20, left: 60, right: 40};		
	var svg = d3.select('#vis');	
	
	var width = 1000 - (margin.left + margin.right);
	var height = 400 - (margin.top + margin.bottom);	
	
	var mn = 0;
	var mx = 0;
	
	var piecewidth = width / (data.length);
			
	svg = svg.append("g")
		.attr("transform","translate(" + margin.left + "," + margin.top + ")");
		
	var names = [];
	for(var x=0;x<data.length;x++)
	{
		names.push(data[x].name);
		
			if (data[x].rawvalue > mx)
				mx = data[x].rawvalue;
			
			if (data[x].rawvalue < mn)
				mn = data[x].rawvalue;
		
	}
	
	if (Math.abs(mn) > mx)
	{
		mx = Math.abs(mn);
	}

	var basey = 0;
	if (mn == 0)
	{
		mn = -0.1;
		basey = mn;
	}
	
	var y = d3.scaleLinear().domain([mx*1.1,mn]).range([0,height]);
	var x = d3.scaleBand().domain(names).range([0, width]).padding(0.2);
	
	svg.append("g")
		.attr("transform","translate(0,0)")
		.attr("class","axis yaxis")
		.call(d3.axisLeft(y));	
	
	svg.append("g")
		.attr("transform","translate(0," + (height) + ")")
		.attr("class","axis xaxis")
		.call(d3.axisBottom(x));
		
	var gapwidth = piecewidth - x.bandwidth();
	
	<?php 
	if (isset($history))
	{ ?>	
	for(var q=0;q<dhistory.length;q++)
	{
	svg.append("path")
		.datum(dhistory[q])	
		.attr("fill","blue")
		.attr("stroke","none")
		.attr("opacity",0.02)
		.attr("stroke-width", "2px")
		.attr("d",d3.area().x(function (d,i) {
			return x(names[i]) + (x.bandwidth()/2);
		})
		.y1(function (d,i) {
			return y(d);
		})
		.y0(function (d) {
			return y(0);
		})); 
	};<?php
	}
	?>
	
				
	svg.selectAll(".chartbox")
		  .data(data)
		  .enter()
		  .append("rect")
		  .attr("class","chartbox")
		  .attr("x", function(d) { 
			return x(d.name);
		  })
		  .attr("y", function(d) { 
			return y(0);
		  })
		  .attr("width", x.bandwidth() )
		  .attr("height", 0)		  
		  .attr("name", function(d) { return d.name + ";" + parseFloat(d.rawvalue).toFixed(2); })
		  .style("fill", "green" )
		  .call(tip)
		  .transition()
		  .duration(500)
		  .delay(function(d,i) {
			  return (1000 / (data.length)) * i;
		  })
		  .attr("height", function(d) { return Math.abs(y(basey) - y(d.rawvalue)); })
		  .attr("y", function(d) { 
			if (d.rawvalue > 0)
				return y(d.rawvalue);
			else
				return y(0);
		  });
		  
		  
	svg.selectAll(".markupline")
		.data(markups)
		.enter()
		.append("line")
		.attr("stroke",function(d) {
			if (d.style == "Discontinuity") return '#fcb103';
			return 'red';
		})
		.attr("stroke-width", "2px")
		.attr("x1",function(d) {
			if (d.style == "Discontinuity") return x(d.location) - (gapwidth/2);
			return x(d.location);
		})
		.attr("y1",0)
		.attr("y2",height)
		.attr("x2",function(d) {
			if (d.style == "Discontinuity") return x(d.location) - (gapwidth/2);
			return x(d.location);
		});
		
	svg.selectAll(".markuptext")
		.data(markups)
		.enter()
		.append("text")
		.attr("fill",function(d) {
			if (d.style == "Discontinuity") return '#fcb103';
			return 'red';
		})	
		.attr("x",0)
		.attr("y",0)
		.attr("transform",function(d) {
			var yy = 0;
			var xx = x(d.location) + 5;
			if (d.style == "Discontinuity")
				xx -= (gapwidth/2);
			
			return "translate(" + xx + " " + yy + ") rotate(90)";
		})		
		.text(function(d) { return d.style;});
}

<?php
//};

foreach($markups as $mu)
{?>
markups.push({'style': '<?php echo $mu[0];?>', 'location': '<?php echo $mu[1];?>'});
<?php } ?>
	
		</script>
<?php		

SS('head');
?>
DrawReports();
<?php
SS('onload');


T('header-basic','title='.$title);
?>
	
	
			<svg id="vis" class="vis" style="width: 95%;" viewBox="0 0 1000 400">
			
			</svg><?php
	
ST('section','class=content');
	ST('row');	
		ST('full');
			ST('box');?>
		<h2>Observations</h2>
		<table>
	<?php
	//Show Report...
	foreach($issues as $iss)
	{
		echo '<tr><td>'.$iss.'</td></tr>';
	}		
	if (count($issues) == 0) echo '<tr><td>No Issues Found</td></tr>'; ?>
		</table><br/><br/>
		<!--<button type="button" class="btn btn-success" onclick="SubmitResults(data,'sequence',<?php echo $rid;?>,<?php echo $propid;?>,<?php $values[0]['assetid'];?>);">This Is Normal</button>-->
	
<?php
			ET();
		ET();
	ET();
ET();
	
}

?>
<div class="tooltip" id="internal_tooltip" style="display: none; pointer-events: none; color: black; position: absolute; font-size: small; background-color: white; max-width: 200px; border: 1px solid black; border-radius: 5px; padding: 5px;opacity: 1; ">
			
		</div>