import json
import requests
import os
import sys
import joblib
import argparse
from sklearn.svm import OneClassSVM

parser = argparse.ArgumentParser(
                    prog='FirstSite AI',
                    description='Performs simple AI on FirstSite data',
                    epilog='Optrix 2023')

parser.add_argument('host')           # positional argument
parser.add_argument('folder')      # option that takes a value
parser.add_argument('style')
parser.add_argument('pone')
parser.add_argument('ptwo',default="")
parser.add_argument('-r','--retrain',action='store_true')
parser.add_argument('-p','--pipe',action='store_true')

args = parser.parse_args()

host = args.host#"localhost/s/op"
parameters = [args.style,args.pone,args.ptwo]
basepath = args.folder#"c:/wamp/ardi2/sites/op/firstsite"

def GetTrainingData(url):
    dta = requests.get(url)
    #print(dta.text)
    dta = dta.json()
    items = []
    for n in dta:
        items.append(n['scaled'])

    return items

def GetCurrentData(url):
    dta = requests.get(url)
    #print(dta.text)
    dta = dta.json()    
    res = dta['scaled']

    return res

#Get AI File Name
existing = False
fname = basepath + "/" + str(parameters[0]) + "_" + str(parameters[1]) + "_" + str(parameters[2]) + ".joblib"

tx = None
if args.retrain == False and os.path.exists(fname):
    #Load from joblib
    working = joblib.load(fname)
    existing = True
else:

    #Train AI
    url = "http://" + host + "/firstsite/" + parameters[0] + "&mode=aitraining&param0=" + parameters[0] + "&param1=" + str(parameters[1]) + "&param2=" + str(parameters[2])
    tx = GetTrainingData(url)

    #print("Training AI...")
    #print(str(tx))
    working = OneClassSVM(gamma='auto',nu=0.5).fit(tx)
    #print(str(working.predict([tx[0]])))


#Use AI
if args.pipe == False:
    #print("Getting Data")
    url = "http://" + host + "/firstsite/" + parameters[0] + "&mode=aicurrent&param0=" + parameters[0] + "&param1=" + str(parameters[1]) + "&param2=" + str(parameters[2])
    td = GetCurrentData(url)
else:
    #print("Using Piped Data")
    jsn = sys.stdin.read()
    td = json.loads(jsn)

#print(str(td))
res = working.predict([td])
if res[0] == 1:
    print('OK')
else:
    #Certain patterns will confuse the algorithm. Try a manual search, too.
    if tx is None:
        url = "http://" + host + "/firstsite/" + parameters[0] + "&mode=aitraining&param0=" + parameters[0] + "&param1=" + str(parameters[1]) + "&param2=" + str(parameters[2]) + "&jitter=0"
        tx = GetTrainingData(url)    

    closest = None    
    for indx in range(0,len(tx)):        
        mxdiff = None
        for qrx in range(0,len(td)):
            d = abs(tx[indx][qrx] - td[qrx])
            if mxdiff is None or d > mxdiff:
                mxdiff = d

        if closest is None or mxdiff < closest:
            closest = mxdiff

    #print("Closest Manual Match: " + str(closest))

    if closest < 0.05:
        print('OK*')
    else:
        print('Unexpected')

if existing == False:
    joblib.dump(working,fname)
