<?php

include_once('common.php');

if (!function_exists('DrawHeader'))
{
	function DrawHeader($name,$code)
	{
		echo '<tr><td><h3>'.$name.'</h3></td></tr>';
		echo '<tr><td><a href="index?method=sequences">Sequences Only</a>&nbsp;&nbsp;&nbsp;<a href="index">All Tests</a></td></tr>';		
		//echo '<tr><td><a href="#" onclick="CheckMatching(\'.'.$code.'.checkbox\'); return false;">Check</a>&nbsp;&nbsp;&nbsp;<a href="#" onclick="UncheckMatching(\'.'.$code.'.checkbox\'); return false;">Uncheck</a><br/><hr/></td></tr>';
	}
}

if (!isset($_REQUEST['mode']))
	$mode = "query";
else
	$mode = $_REQUEST['mode'];

include_once($installfolder.'/model/property.php');

$allprops = Properties::GetAllProperties();

if ($mode == "query")
{
	//Get practical property usage figures...
	$rels = array();
	$query = $db->query("SELECT name,id,style,options FROM relationships");
				
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		if (strpos(strtolower($row['name']),'sequence') !== FALSE)
		{
			$rels[] = $row;
			continue;
		}	
		if (strpos(strtolower($row['name']),'profile') !== FALSE)
		{
			$rels[] = $row;
			continue;
		}		
		if ($row['style'] == 1)
		{
			if ($row['options'] == "")
			{				
				$blocked = false;
				switch($row['name'])
				{
					case 'Monitors':
					case 'Visible':
					case 'Model':
					case 'Data':
						$blocked = true;
						break;
				}
				
				if ($blocked == true) continue;
								
				$rels[] = $row;
				continue;
			}
		}
	}
	
	if (count($rels) > 0)
	{			

		DrawHeader('Sequence Analysis','seq');
		foreach($rels as $rx)
		{				
			$onchain = array();
			$query = $db->query("SELECT childasset,parentasset FROM assetrelclosures WHERE relationship=".$rx['id']);
						
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				if (!in_array($row['childasset'],$onchain))
				{
					$onchain[] = $row['childasset'];
				}
				if (!in_array($row['parentasset'],$onchain))
				{
					$onchain[] = $row['parentasset'];
				}
			}								
			
			if (count($onchain) < 3) continue;
			
			$assetlist = implode(',',$onchain);
			
			$propset = array();
			$query = $db->query("SELECT propertyid FROM datalinks WHERE assetid IN (".$assetlist.") AND mode=1");
						
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				if (!isset($propset[$row['propertyid']]))
				{
					$propset[$row['propertyid']] = 0;
				}
				$propset[$row['propertyid']]++;
			}		
			
			foreach($propset as $k => $v)
			{
				$px = FALSE;
				foreach($allprops as $p)
				{
					if ($p->id == $k)
					{
						$px = $p;
						break;
					}
				}
								
				$forceheatmap = false;
				$valid = false;
				switch($px->type)
				{
					case "MEASUREMENT":
						$valid = true;						
						break;
					case "ENUM":
					case "LOOKUP":
					case "STATUS":						
						$forceheatmap = true;
						$valid = true;						
						break;
				}
				if ($valid == false) continue;
				
				$nm = $px->name;
				$rrx = explode(' - ',$px->name);
				if (count($rrx) > 1)
				{
					$nm = $rrx[1].' '.$rrx[0];
				}
									
				echo '<tr><td><div class="statusline unknown"id="sequence_'.$k.'_'.$rx['id'].'" name="sequence_'.$k.'_'.$rx['id'].'"';				
				echo '><div class="status unknown"></div><a target="_blank" href="sequence?mode=report&param0=sequence&param2='.$rx['id'].'&param1='.$k.'">'.$nm.' across '.$rx['name'].'</a></div></td></tr>';				
			}			
		}		
	}
}

if ($mode == "list")
{
	//Get practical property usage figures...
	$rels = array();
	$query = $db->query("SELECT name,id,style,options FROM relationships");
				
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		if (strpos(strtolower($row['name']),'sequence') !== FALSE)
		{
			$rels[] = $row;
			continue;
		}	
		if (strpos(strtolower($row['name']),'profile') !== FALSE)
		{
			$rels[] = $row;
			continue;
		}		
		if ($row['style'] == 1)
		{
			if ($row['options'] == "")
			{				
				$blocked = false;
				switch($row['name'])
				{
					case 'Monitors':
					case 'Visible':
					case 'Model':
					case 'Data':
						$blocked = true;
						break;
				}
				
				if ($blocked == true) continue;
								
				$rels[] = $row;
				continue;
			}
		}
	}
	
	if (count($rels) > 0)
	{			

		//DrawHeader('Sequence Analysis','seq');
		$items = array();
		foreach($rels as $rx)
		{				
			$onchain = array();
			$query = $db->query("SELECT childasset,parentasset FROM assetrelclosures WHERE relationship=".$rx['id']);
						
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				if (!in_array($row['childasset'],$onchain))
				{
					$onchain[] = $row['childasset'];
				}
				if (!in_array($row['parentasset'],$onchain))
				{
					$onchain[] = $row['parentasset'];
				}
			}								
			
			if (count($onchain) < 3) continue;
			
			$assetlist = implode(',',$onchain);
			
			$propset = array();
			$query = $db->query("SELECT propertyid FROM datalinks WHERE assetid IN (".$assetlist.") AND mode=1");
						
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				if (!isset($propset[$row['propertyid']]))
				{
					$propset[$row['propertyid']] = 0;
				}
				$propset[$row['propertyid']]++;
			}		
			
			foreach($propset as $k => $v)
			{
				$px = FALSE;
				foreach($allprops as $p)
				{
					if ($p->id == $k)
					{
						$px = $p;
						break;
					}
				}
				
				if ($px == FALSE) continue;
								
				$forceheatmap = false;
				$valid = false;
				switch($px->type)
				{
					case "MEASUREMENT":
						$valid = true;						
						break;
					case "ENUM":
					case "LOOKUP":
					case "STATUS":						
						$forceheatmap = true;
						$valid = true;						
						break;
				}
				if ($valid == false) continue;
				
				$nm = $px->name;
				$rrx = explode(' - ',$px->name);
				if (count($rrx) > 1)
				{
					$nm = $rrx[1].' '.$rrx[0];
				}
				
				$itm = array();
				$itm['name'] = $nm.' across '.$rx['name'];
				$itm['property'] = $k;
				$itm['relationship'] = $rx['id'];				
				$items[] = $itm;	
									
				//echo '<tr><td><div class="statusline unknown"id="sequence_'.$k.'_'.$rx['id'].'" name="sequence_'.$k.'_'.$rx['id'].'"';				
				//echo '><div class="status unknown"></div><a target="_blank" href="sequence?mode=report&param0=sequence&param2='.$rx['id'].'&param1='.$k.'">'.$nm.' across '.$rx['name'].'</a></div></td></tr>';				
			}			
		}	
		echo json_encode($items);
		exit();
	}
}

$title = "";
$rid = $_REQUEST['param2'];
$propid = $_REQUEST['param1'];

foreach($allprops as $px)
{
	if ($px->id == $propid)
	{
		$propinfo = $px;
		break;
	}
}

if ($propinfo == FALSE) return;

$propfriendly = $propinfo->name;
$bits = explode(' - ',$propfriendly);
if (count($bits) > 1)
{
	$propfriendly = $bits[1].' '.$bits[0];
}

$title .= $propfriendly;
	
$query = $db->query("SELECT name FROM relationships WHERE id=".$rid);
					
while($row = $query->fetch(PDO::FETCH_ASSOC)) 
{
	$rname = $row['name'];
}			



if ($mode == "aitraining")
{
	$rid = $_REQUEST['param2'];
	$propid = $_REQUEST['param1'];
			
	foreach($allprops as $px)
	{
		if ($px->id == $propid)
		{
			$propinfo = $px;
			break;
		}
	}
	
	if ($propinfo == FALSE) return;
	
	$propfriendly = $propinfo->name;
	$bits = explode(' - ',$propfriendly);
	if (count($bits) > 1)
	{
		$propfriendly = $bits[1].' '.$bits[0];
	}
	
	$minrange = 0;
	$maxrange = 1;		
	
	switch ($propinfo->type)
	{
		case "MEASUREMENT":
			$defaults = $propinfo->GetDefault();
			$maxrange = $defaults[3];
			$minrange = $defaults[2];
			break;
		case "ENUM":
		case "LOOKUP":
		case "STATUS":
			$valueset = $propinfo->GetValueMap();
			foreach($valueset as $k => $v)
			{
				if (($minrange === FALSE) || ($k < $minrange))
					$minrange = $k;
				if (($maxrange === FALSE) || ($k > $maxrange))
					$maxrange = $k;
			}					
			break;
	}
	
	$storage = $sitefolder.'/firstsite';
	if (!file_exists($storage))
		@mkdir($storage);

	$filename = 'sequence_'.$rid.'_'.$propinfo->id.'.json';
	$filename = $storage.'/'.$filename;
	
	//echo 'Checking '.$filename;

	$results = array();
	//echo 'AI Training Data..';
	if (file_exists($filename))
	{				
		$jitter = ($maxrange - $minrange)*0.015;
		if (isset($valueset))
			$jitter = 0.4;
		
		$items = json_decode(file_get_contents($filename),true);
		foreach($items as $vx)
		{			
			$result = array();
			$result['raw'] = array();
			$result['scaled'] = array();
			foreach($vx as $v)
			{
				$result['raw'][] = $v['rawvalue'];
				$scl = (($v['rawvalue']+$jitter) - $minrange) / ($maxrange - $minrange);
				$scl = ($scl - 0.5) * 2;
				$result['scaled'][] = $scl;
			}
			$results[] = $result;
		}		
		
		if (!isset($_REQUEST['jitter'])) {
			//This time with added jitter
			foreach($items as $vx)
			{			
				$result = array();
				$result['raw'] = array();
				$result['scaled'] = array();
				foreach($vx as $v)
				{
					$result['raw'][] = $v['rawvalue']+$jitter;
					$scl = (($v['rawvalue']+$jitter) - $minrange) / ($maxrange - $minrange);
					$scl = ($scl - 0.5) * 2;
					//if ($scl > 1) $scl = 1;
					$result['scaled'][] = $scl;
				}
				$results[] = $result;
			}
			
			//This time with removed jitter
			foreach($items as $vx)
			{			
				$result = array();
				$result['raw'] = array();
				$result['scaled'] = array();
				foreach($vx as $v)
				{
					$result['raw'][] = $v['rawvalue']-$jitter;
					$scl = (($v['rawvalue']-$jitter) - $minrange) / ($maxrange - $minrange);
					$scl = ($scl - 0.5) * 2;
					//if ($scl < 0) $scl = 0;
					$result['scaled'][] = $scl;
				}
				$results[] = $result;
			}
		}
					
	}
	header('Content-Type: application/json');
	echo json_encode($results);
	exit();
}

if ($mode == "agent_deploy")
{

		global $sitefolder;	
		
		$title = $propfriendly.' over '.$rname;		
	
		include($installfolder.'/include/tmpl.php');
		
		T('header-basic','title='.$title);				
		
		ST('section','class=content');
		ST('row');
		ST('full');
		ST('box','title=Agent Deployment');
	
		$autoadded = false;
		$agencyinfo = $sitefolder.'/addons/agency.ini';
		if (file_exists($agencyinfo))
		{
			$settings = parse_ini_file($agencyinfo, false, INI_SCANNER_RAW);		
			$agentpath = $settings['path'];
			$agentservice = $settings['service'];
			
			if (file_exists($agentpath))
			{
				$agentpath .= "/agents/".str_replace(" ","_",strtolower($title)).".agent";
				$content = '#http://'.$_SERVER['HTTP_HOST'].$siteroot.'/firstsite/sequence?mode=agent&param0=sequence&param1='.$_REQUEST['param1'].'&param2='.$_REQUEST['param2'];
				file_put_contents($agentpath,$content);
				$autoadded = $agentpath;
			}
			
			//Request Service Restart	
		}

		if ($autoadded == true)
		{
			echo '<h3>Agent Has Been Installed</h3>';
			echo '<p>Your new agent has been created and added to your Agency system. Please wait a few moments for your service to restart, and your new Agency alerts should be available.</p>';	
			echo '<p><a href="'.$siteroot.'/agency/view">Go To Agency</a></p>';
			if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
				$cmd = '"'.$installfolder.'/../drivers/nssm/win64/nssm.exe" restart "'.$agentservice.'"';
				exec($cmd);
			} else {
				$cmd = "sudo systemctl restart ".$agentservice;
				exec($cmd);
			}		
		}
		else
		{
			echo '<h3>Manual Installation Required</h3>';
			
			echo "<p>Due to settings, security or other restrictions, ARDI doesn't have access to your Agency installation to automatically install new Agents.</p><p>To create an agent, copy the content below and paste it into a <strong>.agent</strong> file in your <em>agency/agents</em> directory.</p>";

			echo '<code style="white-space: pre;">';
			ob_start();

			$content = '#http://'.$_SERVER['HTTP_HOST'].$siteroot.'/firstsite/sequence?mode=agent&param0=sequence&param1='.$_REQUEST['param1'].'&param2='.$_REQUEST['param2'];
			echo $content;

			$content = ob_get_clean();
			echo htmlspecialchars($content);
			echo '</code>';
			echo '<br/>';
		}
		
		ET();
		ET();
		ET();
		ET();
		
		exit();
	
}

if (($mode == "process") || ($mode == "report") || ($mode == "aicurrent") || ($mode == "agent") || ($mode == "deep"))
{	
	$title = "";
	$overall = "OK";

	global $sitefolder;	
	$rid = $_REQUEST['param2'];
	$propid = $_REQUEST['param1'];
			
	foreach($allprops as $px)
	{
		if ($px->id == $propid)
		{
			$propinfo = $px;
			break;
		}
	}
	
	if ($propinfo == FALSE) return;
	
	$propfriendly = $propinfo->name;
	$bits = explode(' - ',$propfriendly);
	if (count($bits) > 1)
	{
		$propfriendly = $bits[1].' '.$bits[0];
	}
	
	$title .= $propfriendly;
		
	$query = $db->query("SELECT name FROM relationships WHERE id=".$rid);
						
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		$rname = $row['name'];
	}				
		
	//Get the list of origin assets...
	$query = $db->query('SELECT DISTINCT parentasset FROM assetrelationships WHERE relationship='.$rid);

	$candidates = array();
	while($row = $query->fetch(PDO::FETCH_ASSOC))
	{
		$candidates[] = $row['parentasset'];
	}
	
	$haschildren = array();
	
	$toquery = array();
	$topper = $candidates;
	$counter = 0;
	while(count($topper) > 0)
	{
		$toquery[] = array_pop($topper);
		if ((count($toquery) > 500) || (count($topper) == 0))
		{
			$query = $db->query('SELECT DISTINCT childasset FROM assetrelationships WHERE relationship='.$rid.' AND childasset IN ('.implode(',',$toquery).")");
			//echo 'SELECT DISTINCT childasset FROM assetrelationships WHERE relationship='.$rel.' AND childasset IN ('.implode(',',$toquery).")";
			while($row = $query->fetch(PDO::FETCH_ASSOC))
			{
				$haschildren[] = $row['childasset'];
			}
			$toquery = array();
		}
	}
	
	//echo 'Total Candidates: '.count($candidates).'<br/>Total Exceptions: '.count($haschildren).'<br/>';
	
	$finals = array();
	foreach($candidates as $cn)
	{
		if (!in_array($cn,$haschildren))
		{
			//unset($candidates[$x]);
			$finals[] = $cn;
		}
	}
	
	unset($candidates);
	unset($haschildren);
	
	$sourceid = 0;
	//OK - add the assets that are marked as a SOURCE.
	include_once($installfolder.'/model/property.php');
	$props = Properties::GetAllProperties();
	foreach($props as $prp)
	{
		if ($prp->type == "SRCPOINT")
		{
			$sourceid = $prp->id;
			break;
		}
	}
	
	if ($sourceid != 0)
	{
		$query = $db->query('SELECT assetid,value FROM assetvalues WHERE propertyid='.$sourceid);
		while($row = $query->fetch(PDO::FETCH_ASSOC))
		{
			$bits = explode('|',$row['value']);
			$expd = explode(',',$bits[0]);
			foreach($expd as $ex)
			{
				if ($ex == $rel)
				{
					if (!in_array($row['assetid'],$finals))
					{
						$finals[] = $row['assetid'];
					}
				}
			}
		}
	}		
		
			
	$hits = array();
	
	if (count($finals) > 0)
	{
		$query = $db->query('SELECT id,name FROM assets WHERE id IN ('.implode(',',$finals).') ORDER BY name');
		while($row = $query->fetch(PDO::FETCH_ASSOC))
		{						
			$ass = new Asset($row['id']);
			$ass->Load();
			
			$itm = array();
			$itm['id'] = $row['id'];
			$itm['name'] = $row['name'];
			$itm['ern'] = $ass->ern;
			
			$hits[] = $itm;				
		}
	}
	
	$srcid = 0;
	//Checking for supply property...
	$query = $db->query('SELECT id FROM properties WHERE typename=\'SUPPOINT\'');
	while($row = $query->fetch(PDO::FETCH_ASSOC))
	{
		$srcid = $row['id'];
		break;
	}
	
	//Check for supplies....
	if ($srcid != 0)
	{
		//echo 'Checking Source ID - '.$srcid;
		$query = $db->query('SELECT id,name,value FROM assets JOIN assetvalues ON (assetvalues.assetid = assets.id) WHERE propertyid='.$srcid);
		while($row = $query->fetch(PDO::FETCH_ASSOC))
		{
			$bits = explode(':',$row['value']);
			foreach($bits as $b)
			{
				if ($b == $rel)
				{
					$found = false;
					foreach($hits as $h)
					{
						if ($h['id'] == $row['id'])
						{
							$found = true;
							break;
						}
					}
					
					if ($found == false)
					{
						$ass = new Asset($row['id']);
						$h = array();
						$h['id'] = $row['id'];
						$h['name'] = $row['name'];
						$h['ern'] = $ass->ern;
						
						$hits[] = $h;
					}
				}
			}
		}
	}		
	
	$issues = array();
				
	$markups = array();
	
	$batches = array();	
	
	$values = array();
	
	foreach($hits as $h)
	{							
		$code = "";
		$onchain = array();
		$query = $db->query("SELECT childasset,parentasset FROM assetrelclosures WHERE relationship=".$rid.' AND parentasset='.$h['id']);
					
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{
			if (!in_array($row['childasset'],$onchain))
			{
				$onchain[] = $row['childasset'];
			}
			if (!in_array($row['parentasset'],$onchain))
			{
				$onchain[] = $row['parentasset'];
			}
		}		

		$matches = 0;
		$namearray = array();
		if (count($onchain) > 1)
		{
			$assetlist = implode(',',$onchain);
			$query = $db->query("SELECT name,propertyid,assetid FROM datalinks JOIN assets ON (assets.id = datalinks.assetid) WHERE assetid IN (".$assetlist.") AND mode=1 AND propertyid=".$propid);
										
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				$matches++;
				$namearray[] = $row['name'];
			}		
		}							
		
		if ($matches > 1)
		{
			$commonelement = GetDistinctName($namearray,$rname);		
			//Do an analysis across the relationship...
						
			//Get current value distribution...
			$query = "'".$h['name']."' ASSET '".$rname."' RELATIONSHIP 'downi' RELATED '".$propinfo->id."' PROPERTYBYID VALUES";
			$queryurl = 'http://localhost/'.$siteroot.'/aql/api/query?query='.urlencode($query);
			//echo $queryurl;
			$resp = file_get_contents($queryurl);
			//print($resp);
			
			$value = json_decode($resp,true);
			$lvalues = $value['results'][0]['value'];

			$attime = "";
			if (isset($_REQUEST['at']))
			{
				$attime = $_REQUEST['at'];
				if (is_numeric($attime))
				{
					//Parse a UTC datetime...
					$attime = gmdate('Y-m-d H:i:s',intval($attime/1000));					
				}
			}
			
			if ($attime != "")
			{
				$dt = DateTimeImmutable::createFromFormat("Y-m-d H:i:s",$attime);
				$en = $dt->add(new DateInterval("PT10S"));
				$en = $en->format("Y-m-d H:i:s");
				
				$histquery = "'".$h['name']."' ASSET '".$rname."' RELATIONSHIP 'downi' RELATED '".$propinfo->id."' PROPERTYBYID VALUES {\"start\": \"".$attime."\",\"end\": \"".$en."\",\"grain\": -10} GETHISTORY";
				$queryurl = 'http://localhost/'.$siteroot.'/aql/api/table?query='.urlencode($histquery)."&format=csv";	
				$table = file_get_contents($queryurl);
				$history = explode("\n",$table);	
				
				$headers = explode(',',$history[0]);
				$dta = explode(',',$history[1]);
						
				//Load historical values into the active value list...
				for($x=0;$x<count($headers);$x++)
				{
					$vx = -1;
					foreach($lvalues as $v)
					{
						$vx++;
						$nm = $v['name'].' '.$v['propname'];
						if ($nm == $headers[$x])
						{
							$lvalues[$vx]['rawvalue'] = round(floatval($dta[$x]),3);
							break;
						}
					}
				}		
				
				unset($history);
			}
			
			$cont = false;
			if (count($lvalues) == 0) continue;
			if ($lvalues[0]['type'] == 'MEASUREMENT')
				$cont = true;
			
			$databad = false;						
			$datarange = false;
			
			foreach($lvalues as $v)
			{							
				$code .= "data.push(".json_encode($v).");\n";				
			}
			
			$markups[] = array('Start',$lvalues[0]['name']);	
					
			
			if ($cont == true)
			{
				//Calculate the standard deviation across the channels...
				$ttl = 0;
				$counter = 0;
				foreach($lvalues as $v)
				{
					if ($v['rawvalue'] != "^")
					{
						$ttl += $v['rawvalue'];
						$counter += 1;
					}
				}
				
				if ($counter > 0)
				{
					$avg = $ttl / $counter;
					
					if ($ttl == 0)
					{
						$issues[] = 'All Values are Zero';
						//$markups[] = array('Zero',$values[0]['name']);
						if ($overall == "OK")
							$overall = "EMPTY";
					}
								
					$squaretotal = 0;
					foreach($lvalues as $v)
					{
						if ($v['rawvalue'] != "^")
						{
							$squaretotal += ($v['rawvalue'] - $avg) * ($v['rawvalue'] - $avg);
						}
					}
										
					$stddev = sqrt($squaretotal / $counter);
					if ($stddev < 1) $stddev = 1;
					
					$lastvalue = FALSE;
					foreach($lvalues as $v)
					{
						if (abs($v['rawvalue'] - $avg) > ($stddev * 2.5))
						{
							$issues[] = $v['name'].' Looks Like An Outlier';
							$markups[] = array('Outlier',$v['name']);
							if ($overall == "OK")
								$overall = "WARNING";
						}
						if ($lastvalue === FALSE)
						{
							$lastvalue = $v;							
						}
						else
						{
							if (abs($v['rawvalue'] - $lastvalue['rawvalue']) > ($stddev*1.5))
							{							
								//These types of discontinuity can often be caused by assets in a redundant configuration.
								//Check for other relationships that connect nearby assets...
								
								$issues[] = "Value Discontinuity Between ".$lastvalue['name'].' and '.$v['name'];
								$markups[] = array('Discontinuity',$v['name']);
								if ($overall == "OK")
									$overall = "WARNING";						
							}
						}
						$lastvalue = $v;
					}
				}
			}			
			foreach($lvalues as $v)
			{
				$values[] = $v;
			}
		}	
		if ($code != "")
			$batches[] = $code;		
	}
	
	$storage = $sitefolder.'/firstsite';
	if (!file_exists($storage))
		@mkdir($storage);

	$filename = 'sequence';

	$param = 1;
	$parameters = array();
	$parameters[0] = $_REQUEST['param2'];
	$parameters[1] = $_REQUEST['param1'];

	$filename .= '_'.implode('_',array_values($parameters)).'.json';

	$filename = $storage.'/'.$filename;
	
	if ($mode == "process")
	{
		
		if (file_exists($filename))
		{		
			$p1 = filter_var($_REQUEST['param1'],FILTER_VALIDATE_INT);
			$p2 = filter_var($_REQUEST['param2'],FILTER_VALIDATE_INT);
			$cmd = '"'.PythonPath().'" "'.$installfolder.'/addons/firstsite/python/aicompare.py" "127.0.0.1'.$siteroot.'" "'.$sitefolder.'/firstsite" sequence '.$p1.' '.$p2;
			$res = exec($cmd);
			if (($res != "OK") && ($res != "OK*"))
			{
				echo 'WARNING:AI Reports Unexpected Values';
			}
			else
				echo $res;
		}
		else
		{		
			if (count($issues) == 0)
				echo 'OK';
			else
			{
				echo $overall.':';
				echo implode(':',$issues);
			}
		}
		exit();
	}	
	
	if ($mode == "deep")
	{		
		$aifile = $sitefolder.'/firstsite/sequence_'.$propid.'_'.$rid.'.joblib';
		//print("Checking For File: ".$aifile);
		if (file_exists($aifile))
		{
			$context = array();	
			
			$context['name'] = 'FirstSite '.$rname.' Sequence';
			$context["path"] = $siteroot.'/firstsite/sequence_'.$rid.'_'.$propid;
			$context["files"] = array($siteroot.'/firstsite/sequence_'.$propid.'_'.$rid.".joblib",$siteroot.'/firstsite/sequence_'.$rid.'_'.$propid.".json");
			$context['module'] = 'fsite_svm';
			
			echo json_encode($context);
		}	
		else
			echo '{}';
		
		exit();
	}
	
	if ($mode == "aicurrent")
	{
		$minrange = 0;
		$maxrange = 1;		
		
		//print_r($values);
		
		switch ($propinfo->type)
		{
			case "MEASUREMENT":
				$defaults = $propinfo->GetDefault();
				$maxrange = $defaults[3];
				$minrange = $defaults[2];
				break;
			case "ENUM":
			case "LOOKUP":
			case "STATUS":
				$valueset = $propinfo->GetValueMap();
				foreach($valueset as $k => $v)
				{
					if (($minrange === FALSE) || ($k < $minrange))
						$minrange = $k;
					if (($maxrange === FALSE) || ($k > $maxrange))
						$maxrange = $k;
				}					
				break;
		}
	
		$results = array();
		$results['raw'] = array();
		$results['scaled'] = array();
		foreach($values as $v)
		{
			$results['raw'][] = $v['rawvalue'];
			$scl = ($v['rawvalue'] - $minrange) / ($maxrange - $minrange);
			$scl = ($scl - 0.5) * 2;
			$results['scaled'][] = $scl;
		}
		header('Content-Type: application/json');
		echo json_encode($results);
		exit();
	}
	
	if ($mode == "agent")
	{		
		ob_start();
		header('Content-Type: application/json');
		if (file_exists($filename))
		{	
			$title = $propfriendly.' over '.$rname;
			$inputid = 0;
			
			$aifile = $sitefolder.'/firstsite/sequence_'.$propid.'_'.$rid.'.joblib';
	?>
{
   "name": "<?php echo ucwords($title);?>",
   "style": "ARDIFirstSite",
   "inputs": [ 
   <?php
   $indx = 0;
   foreach($values as $a)
   {
	   $indx++;
	   if ($indx > 1)
		   echo ',';
	   echo '{ "name": "I'.$indx.'" }';
   }
   ?>
   ],
   "normalise": "-1-1",
   "outputs": [ <?php      
	   $alert = true;	   	   
	   ?>
	   {
		"name": "Status",
		"style": "boolean"<?php if ($alert == true) {?>,
		"threshold": ">0.5" <?php }; ?>
	  }
	],
   "binding": {
	   <?php
   
	   $indx = 0;
	   foreach($values as $a)
	   {
		   $indx++;
		   if ($indx > 1)
			   echo ','."\n\t\t";
		   echo '"I'.$indx.'": "'.$values[$indx-1]['name'].'.'.$values[$indx-1]['propname'].'"';
	   }
   
	   ?>		
   },
	"attachment": [{
		"style": "single",
		"asset": "<?php echo $values[0]['name'];?>"
	  }
	],
	"data": {
		"aifile": "<?php echo $aifile;?>",	
		"training": "http://<?php echo $_SERVER['HTTP_HOST'];?><?php echo $siteroot;?>/firstsite/sequence?mode=aitraining&param0=sequence&param1=<?php echo $_REQUEST['param1'];?>&param2=<?php echo $_REQUEST['param2'];?>"
	}
}
	<?php
		}
		$content = ob_get_clean();
		echo $content;	
		exit();
	}
	
	$title .= " FirstSite Analysis";
	
	include($installfolder.'/include/tmpl.php');
	
	
	?>

		<script src="/addons/dexplore/d3v7.js"></script>
		<style>
.tick
{

}	

.results 
{
	display: block;
	padding: 10px;
	border-radius: 5px;
	border: 1px solid black;
	color: black;
	font-size: 20px;
	font-weight: bold;
	width: auto;
	margin-bottom: 0.5em;
}

.results.OK
{
	background-color: green;
	color: white;
}

.results.WARNING
{
	background-color: yellow;
	color: black;
}

.results.ERROR
{
	background-color: red;
	color: white;
}

.results.EMPTY
{
	background-color: #777777;
	color: white;
}

.axis line
{
	stroke: silver;
}

.axis path
{
	stroke: silver;
}

.axis text
{
	fill: black;
	font-size: 8px;
}

.xaxis text
{
	fill: none;
	font-size: 8px;
}
		</style>
		<script src="firstsite.js"></script>
		<script>
var data = [];
var markups = [];

function DrawReports()
{
<?php
	$bid = 0;
	foreach($batches as $b)
	{
		$bid++;
		echo '    DrawReport'.$bid.'();'."\n";
		break;
	}
?>
}
		
<?php 		
$bid = 0;
foreach($batches as $b)
{
	$bid++;
?>
function DrawReport<?php echo $bid;?>()
{
	var margin = {top: 20, bottom: 20, left: 60, right: 40};		
	var svg = d3.select('#vis<?php echo $bid;?>');	
	
	var width = 1000 - (margin.left + margin.right);
	var height = 400 - (margin.top + margin.bottom);	
	
	var mn = 0;
	var mx = 0;
	
	var piecewidth = width / (data.length);
			
	svg = svg.append("g")
		.attr("transform","translate(" + margin.left + "," + margin.top + ")");
		
	var names = [];
	for(var x=0;x<data.length;x++)
	{
		names.push(data[x].name);
		
			if (data[x].rawvalue > mx)
				mx = data[x].rawvalue;
			
			if (data[x].rawvalue < mn)
				mn = data[x].rawvalue;
		
	}
	
	if (Math.abs(mn) > mx)
	{
		mx = Math.abs(mn);
	}
	
	var y = d3.scaleLinear().domain([mx*1.1,mn]).range([0,height]);
	var x = d3.scaleBand().domain(names).range([0, width]).padding(0.2);
	
	svg.append("g")
		.attr("transform","translate(0,0)")
		.attr("class","axis yaxis")
		.call(d3.axisLeft(y));	
	
	svg.append("g")
		.attr("transform","translate(0," + (height) + ")")
		.attr("class","axis xaxis")
		.call(d3.axisBottom(x));
		
	var gapwidth = piecewidth - x.bandwidth();
				
	svg.selectAll(".chartbox")
		  .data(data)
		  .enter()
		  .append("rect")
		  .attr("class","chartbox")
		  .attr("x", function(d) { 
			return x(d.name);
		  })
		  .attr("y", function(d) { 
			return y(0);
		  })
		  .attr("name", function(d) {
			  return d.name + ";" + parseFloat(d.rawvalue).toFixed(2);
		  })
		  .attr("width", x.bandwidth() )
		  .attr("height", 0)		  		  
		  .style("fill", "green" )
		  .call(tip)
		  .transition()
		  .duration(500)
		  .delay(function(d,i) {
			  return (1000 / (data.length)) * i;
		  })
		  .attr("height", function(d) { return Math.abs(y(0) - y(d.rawvalue)); })
		  .attr("y", function(d) { 
			if (d.rawvalue > 0)
				return y(d.rawvalue);
			else
				return y(0);
		  });
		  
	svg.selectAll(".markupline")
		.data(markups)
		.enter()
		.append("line")
		.attr("stroke",function(d) {
			if (d.style == "Discontinuity") return '#fcb103';
			if (d.style == "Start") return 'blue';
			return 'red';
		})
		.attr("stroke-width", "2px")
		.attr("x1",function(d) {
			if (d.style == "Discontinuity") return x(d.location) - (gapwidth/2);
			return x(d.location);
		})
		.attr("y1",0)
		.attr("y2",height)
		.attr("x2",function(d) {
			if (d.style == "Discontinuity") return x(d.location) - (gapwidth/2);
			return x(d.location);
		});
		
	svg.selectAll(".markuptext")
		.data(markups)
		.enter()
		.append("text")
		.attr("fill",function(d) {
			if (d.style == "Discontinuity") return '#fcb103';
			if (d.style == "Start") return 'blue';
			return 'red';
		})	
		.attr("x",0)
		.attr("y",0)
		.attr("transform",function(d) {
			var yy = 0;
			var xx = x(d.location) + 5;
			if (d.style == "Start")
			{
				return "translate(" + (xx-5) + " " + (height + 15) + ")";
			}						
			if (d.style == "Discontinuity")
				xx -= (gapwidth/2);
			
			return "translate(" + xx + " " + yy + ") rotate(90)";
		})		
		.text(function(d) { 
			if (d.style == "Start")
				return d.location;
			return d.style;
		});
		
	
}

<?php
};

foreach($batches as $b)
{
	if ($b != "")
		echo $b;
}

foreach($markups as $mu)
{?>
markups.push({'style': '<?php echo $mu[0];?>', 'location': '<?php echo $mu[1];?>'});
<?php } ?>
	
function ResetAI()
{
	if (window.confirm('Are you sure you want to remove all AI training data for this FirstSite category?') == true)
	{
		<?php if (count($values) > 0)
		{?>
		ClearResults(data,'sequence',<?php echo $rid;?>,<?php echo $propid;?>,<?php $values[0]['assetid'];?>);<?php }; ?>
	}
}
		</script>
<?php		

SS('head');
?>
DrawReports();
<?php
SS('onload');


T('header-basic','title='.$title);
?>
	
	<?php 
	
ST('section','class=content');
	ST('row');	
		
	//ET();
	
	
	
	$storage = $sitefolder.'/firstsite';
	if (!file_exists($storage))
		@mkdir($storage);

	$filename = 'sequence';

	$param = 1;
	$parameters = array();
	$parameters[0] = $_REQUEST['param2'];
	$parameters[1] = $_REQUEST['param1'];

	$filename .= '_'.implode('_',array_values($parameters)).'.json';

	$filename = $storage.'/'.$filename;
	
	//echo 'Checking For '.$filename;

	
		//Get AI Analysis...		
		//ST('row');	
			ST('half');
				ST('box');
					if (file_exists($filename))
					{												
						$p1 = filter_var($_REQUEST['param1'],FILTER_VALIDATE_INT);
						$p2 = filter_var($_REQUEST['param2'],FILTER_VALIDATE_INT);
						$cmd = '"'.PythonPath().'" "'.$installfolder.'/addons/firstsite/python/aicompare.py" "127.0.0.1'.$siteroot.'" "'.$sitefolder.'/firstsite" sequence '.$p1.' '.$p2.' -p';
						
						$minrange = 0;
						$maxrange = 1;		
						
						//print_r($values);
						
						switch ($propinfo->type)
						{
							case "MEASUREMENT":
								$defaults = $propinfo->GetDefault();
								$maxrange = $defaults[3];
								$minrange = $defaults[2];
								break;
							case "ENUM":
							case "LOOKUP":
							case "STATUS":
								$valueset = $propinfo->GetValueMap();
								foreach($valueset as $k => $v)
								{
									if (($minrange === FALSE) || ($k < $minrange))
										$minrange = $k;
									if (($maxrange === FALSE) || ($k > $maxrange))
										$maxrange = $k;
								}					
								break;
						}
					
						$results = array();
						$results['raw'] = array();
						$results['scaled'] = array();
						foreach($values as $v)
						{
							$results['raw'][] = $v['rawvalue'];
							$scl = ($v['rawvalue'] - $minrange) / ($maxrange - $minrange);
							$scl = ($scl - 0.5) * 2;
							$results['scaled'][] = $scl;
						}						
						
						$descriptorspec = array(
						   0 => array("pipe", "r"),  // stdin is a pipe that the child will read from
						   1 => array("pipe", "w"),  // stdout is a pipe that the child will write to
						   2 => array("pipe", "w") // stderr is a file to write to
						);
						$valueset = array();
						foreach($values as $v)
						{
							$scl = ($v['rawvalue'] - $minrange) / ($maxrange - $minrange);							
							$valueset[] = ($scl - 0.5) * 2;
						}
						$process = proc_open($cmd, $descriptorspec, $pipes);
						if (is_resource($process))
						{
							fwrite($pipes[0],json_encode($valueset));
							fclose($pipes[0]);
							
							$res = stream_get_contents($pipes[1]);
							$err = stream_get_contents($pipes[2]);
							$rval = proc_close($process);
						}						
						echo '<div class="results '.str_replace("*","",$res).'">'.$res.'</div>';
						echo '<p>These results have been processed by a <strong>Machine Learning AI</strong> and found to be close to the normal pattern.</p>';
						if ($res == 'OK*')
						{
							echo '<div>This result is close to the edge of the sample data</div>';
						}
						//echo '</div>';
												
						//echo $cmd;
					}
					else
					{
						echo '<div class="results '.$overall.'">'.$overall.'</div>';
						//echo '<h3>AI Results Not Available</h3>';
						echo '<p><strong>Machine Learning</strong> is available for this test. You need to train the AI using the <strong>This Is Normal</strong> button to prepare it.</p>';
					}
				ET();
			ET();
			
			ST('half');
			ST('box');?>
		<h2 style="margin-top: 0px;">Observations</h2>
		<table>
	<?php
	//Show Report...
	foreach($issues as $iss)
	{
		echo '<tr><td>'.$iss.'</td></tr>';
	}		
	if (count($issues) == 0) echo '<tr><td>No Issues Found</td></tr>'; ?>
		</table><br/><br/>
		<?php if (CheckAdmin()) { ?>
		<button type="button" class="btn btn-success" onclick="SubmitResults(data,'sequence',<?php echo $rid;?>,<?php echo $propid;?>,<?php $values[0]['assetid'];?>);" style="margin-right: 1em;">This Is Normal</button>
		<button type="button" class="btn btn-warning" onclick="ResetAI();" style="margin-right: 1em;">Reset AI Training Data</button>
		<?php if (CheckAdmin()) { ?><a href="<?php echo $siteroot;?>/firstsite/sequence?mode=agent_deploy&param0=sequence&param1=<?php echo $_REQUEST['param1'];?>&param2=<?php echo $_REQUEST['param2'];?>"><button type="button" class="btn btn-default" style="margin-right: 1em;">Deploy As Agent</button></a><?php }; ?>
		
		<?php }; ?>
	
<?php
			ET();
			
			
		ET();
		ET();
		
		$bid = 0;
	foreach($batches as $b)
	{
		$bid++;
		if ($b != "")
		{?>
			<svg id="vis<?php echo $bid;?>" class="vis" style="width: 95%;" viewBox="0 0 1000 400">
			
			</svg><?php
			break;
		}
	}
	
ET();
	
}
	$showfocus = true;
	ST('row');	
		ST('full');
			ST('full');
				if ($showfocus == true)
				{
				ST('box');
					//Pull training data	
					$filename = 'sequence_'.$_REQUEST['param2'].'_'.$_REQUEST['param1'].'.json';
					$filename = $storage.'/'.$filename;
					
					//echo 'Checking '.$filename;

					//$results = array();
					$bestmatch = "";
					$bestmatchoffset = 9999;
					if (file_exists($filename))
					{
						$indx = -1;
						$items = json_decode(file_get_contents($filename),true);
						foreach($items as $vx)
						{			
							$indx++;
							$matchsize = 0;							
							$fitdata = array();
							for($x=0;$x<count($values);$x++)
							{
								$diff = abs($values[$x]['rawvalue'] - $vx[$x]['rawvalue']);
								$clr = "#009900";
								
								if ($diff >= 0.005)
									$clr = "#009999";
								
								if ($diff > 0.01)
									$clr = "#990000";
								
								$fitdata[$values[$x]['name'].' '.$values[$x]['propname']] = round($diff*100,2);//$ex .= '<label style="color: '.$clr.'">'.$values[$x]['name'].' '.$values[$x]['propname'].':</label> '.round($diff*100,2)."%<br/>";
								if ($diff > $matchsize)
								{
									$matchsize = $diff;									
								}								
							}
							//echo 'Max Match Offset: '.$matchsize;
							if ($bestmatchoffset > $matchsize)
							{
								
								$bestmatch = $fitdata;
								$bestmatchoffset = $matchsize;
							}		
						}
						?>
						<h3>Differences to Closest Training Data</h3><hr/>
						<?php
						$keys = array_keys($bestmatch);
						sort($keys);
						
						foreach($keys as $k)
						{
							$clr = "#009900";
							$v = $bestmatch[$k];
							if ($v > 0.5) $clr = '#009999';
							if ($v > 2) $clr = '#990000';
							echo '<label style="color: '.$clr.'">'.$k.'</label>: '.round($v,2).'%<br/>';
						}
															
					}						
				ET();
				}
			ET();
		ET();
	ET();

?>
<div class="tooltip" id="internal_tooltip" style="display: none; pointer-events: none; color: black; position: absolute; font-size: small; background-color: white; max-width: 200px; border: 1px solid black; border-radius: 5px; padding: 5px;opacity: 1; ">
			
		</div>