<?php
	
	if (!function_exists('HistLink_CompileMe'))
	{
		function HistLink_CompileMe()
		{
			global $sitefolder;
			global $siteroot;
			global $installfolder;
			global $db;
			global $addins;
			global $asset;
			
			$asset = array();
			$livesrcid = array();
			
			//echo 'Hello?';
			$map = "";
			if (!file_exists($sitefolder.'/addons/autohistlink.ini')) return;
			$settings = parse_ini_file($sitefolder.'/addons/autohistlink.ini');
			
			$map=$settings['Mapping'];

			if ($map == "") return;
			
			$mapindex = array();
			$bits = explode(',',$map);
			foreach($bits as $b)
			{
				$pieces = explode(':',$b);
				$livesrcid[] = $pieces[0];
				$mapindex[$pieces[0]] = $pieces[1];
			}
			
			$condition = " AND sourceid IN (".implode(',',$livesrcid).")";
			
			//First, compile a list of all assets and properties that have HISTORIAN content...
			$hist = array();
			$query = $db->query('SELECT assetid,propertyid,node FROM datalinks WHERE profile=1 AND mode=1');
			
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				$hist[] = $row['assetid'].'_'.$row['propertyid'].'_'.$row['node'];
			}
			//echo 'SELECT assetid,propertyid,node FROM datalinks WHERE profile=1 AND mode=1'.$condition;
			
			//Now, find all assets and properties with LIVE DATA content...
			$query = $db->query('SELECT sourceid,assetid,propertyid,node,address FROM datalinks WHERE profile=1 AND mode=0'.$condition);
			$live = array();
			$liveaddr = array();
			$livesource = array();
			
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				$live[] = $row['assetid'].'_'.$row['propertyid'].'_'.$row['node'];
				$liveaddr[$row['assetid'].'_'.$row['propertyid'].'_'.$row['node']] = $row['address'];
				$livesource[$row['assetid'].'_'.$row['propertyid'].'_'.$row['node']] = $row['sourceid'];
			}
			
			$channeladded = false;
			
			//Compare the two and find those newly-added, on the suitable part, that need to be mapped...
			require_once($installfolder.'/model/property.php');
			$propset = Properties::GetAllProperties();
			foreach($live as $l)
			{
				if (!in_array($l,$hist))
				{
					//Duplicate the link...
					$srcid = $mapindex[$livesource[$l]];
					$bits = explode('_',$l);
					$address = $liveaddr[$l];
					$qry = 'INSERT INTO datalinks (sourceid,assetid,propertyid,node,profile,mode,address,transform) VALUES ('.$srcid.','.$bits[0].','.$bits[1].','.$db->quote($bits[2]).',1,1,'.$db->quote($address).',\'NONE\')';
					$addins->Commit("newdatalink",array("source"=>$srcid, "asset"=>$bits[0], "property" => $bits[1], "node" => $bits[2],"context" => "1", "mode" => "1", "address" => $address ));
					$db->query($qry);
					echo $qry;
					$channeladded = true;
				}
			}
			//echo 'Done!';
			//exit;

			if ($channeladded == true)
			{
				$addins->Commit("datalinkschanged",true);
			}
			$addins->Commit("autohistlink_update","","Updated Automatic Mapping");
		}
	}
	
	HistLink_CompileMe();
	//echo 'Compiled!';
	//exit;
?>