class ActiveReport extends SVGReport {
	initialise() {
		super.initialise();		
		this.mapping = [];
		this.content = [];
	};
	
	create() {
		this.liveReport("('[PROPERTYA]','[PROPERTYB]') PROPERTY ALLPOINTS VALUES");		
	}
	
	update() {
		this.draw([]);	
	}
	
	addContent(q,n,from,range) {
		this.content.push({a: q, b: n,name: from, range: range, warn: range * 0.9, diff: 0,diffperc: 0});
	}
		
	draw(data) {
		
		if (this.content.length == 0)
		{
			var hits = 0;
			for(var q=0;q<this.columns.length;q++)
			{
				if (!this.columns[q].name.includes("[PROPERTYA]"))
					continue;
				
				var to = "";
				var from = this.columns[q].name;
				var others = this.columns[q].name.replace("[PROPERTYA]","[PROPERTYB]");				
				
				for(var n=0;n<this.columns.length;n++)
				{				
					if (n == q) continue;			
					if (this.columns[n].name == others)
					{						
						this.addContent(q,n,from.replace(" [PROPERTYA]",""),1);						
						hits += 2;
						break;
					}
				}
				if (hits >= this.columns.length) break;
			}
		}
		
		var width = this.width;
		var height = this.height;
		var margin = {"left": 15, "right": 15, "top": this.margin.top, "bottom": 50};
		
		
		//Calculate resulting size...		
		if (this.group == null)
		{
			// append the svg object to the div called 'my_dataviz'		
			this.group = d3.select("#reportsvg")		  
				.attr("width", width)
				.attr("height", height)
			  .append("g")
				.attr("transform", "translate(" + margin.left + " " + margin.top + ")");
		}
		
		width -= (margin.right + margin.left);
		height -= (margin.bottom + margin.top);
		
		for(var x=0;x<this.content.length;x++)
		{
			var cx = this.content[x];
			this.content[x].diff = Math.abs(this.livedata[cx.a] - this.livedata[cx.b]);
			this.content[x].diffperc = (this.livedata[cx.a] - this.livedata[cx.b]) / cx.range;
			if (this.content[x].diffperc > 1) this.content[x].diffperc = 1;
			if (this.content[x].diffperc < -1) this.content[x].diffperc = -1;
		}		
		
		var lineheight = height / this.content.length;
		var textlineheight = lineheight;
		if (textlineheight > 30) textlineheight = 30;
		
		var position_x = function(i) {
			return 0;
		}
		var position_y = function(i) {
			return i * lineheight;
		}			
				
		var svg = this.group;
		
		var rep = this;
		
		svg.selectAll(".bars").data(this.content)
			.join(
				enter => enter
					.append("rect")
					.attr("fill",function (d) { if (d.diff > d.range) return "red"; if (d.diff > d.warn) return "orange"; return "green"; })
					.attr("x",function(d,i) {
						return position_x(i);
					})
					.attr("y",function(d,i) {
						return position_y(i);
					})
					.attr("width",width)
					.attr("height",lineheight - 10)
					.attr("class","bars element")
					.attr("value",function(d) { 						
						return d.diff.toFixed(2) + " - " + rep.livedata[d.a].toFixed(2) + " vs " + rep.livedata[d.b].toFixed(2); 
					})
					.attr("name",function(d) { return d.name; })
					.attr("units","")
					.call(this.tip),
				update => update
					.attr("value",function(d) { 						
						return d.diff.toFixed(2) + " - " + rep.livedata[d.a].toFixed(2) + " vs " + rep.livedata[d.b].toFixed(2); 
					})
					.transition()
					.duration(300)
					.attr("fill",function (d) { if (d.diff > d.range) return "red"; if (d.diff > d.warn) return "orange"; return "green"; })			
		);
	
		svg.selectAll(".blackout").data(this.content)
			.join(
				enter => enter
					.append("path")
					.attr("d",function (d,i) {						
								return "M0,0L20," + (lineheight/2) + "L0," + lineheight + "L-20," + (lineheight/2) + "Z";						
							
					})
					.attr("fill","black")
					.attr("transform",function(d,i) {
						var xpos = (position_x(i) + (width * 0.5) + (d.diffperc * (width/2)));
						if (xpos < 0) xpos = 10;
						if (xpos > width) xpos - width - 10;
						return "translate( " + xpos + " " +  position_y(i) + ")";
					})					
					.attr("width",5)
					.attr("height",lineheight - 10)
					.attr("class","blackout")
					.attr("opacity",0.2),
				update => update
					.attr("fill","black")
					.transition()
					.duration(rep.updatetiming)					
					.ease(d3.easeLinear)
					.attr("transform",function(d,i) {
						var xpos = (position_x(i) + (width * 0.5) + (d.diffperc * (width/2)));
						if (xpos < 0) xpos = 10;
						if (xpos > width) xpos - width - 10;
						return "translate( " + xpos + " " +  position_y(i) + ")";
					})													
					.attr("d",function (d,i) {
						var xpos = (position_x(i) + (width * 0.5) + (d.diffperc * (width/2)));
						if (xpos <= 0)
							return "M40,0L40," + (lineheight/2) + "L40," + lineheight + "L0," + (lineheight/2) + "Z";
						else
						{
							if (xpos >= width)
								return "M-40,0L0," + (lineheight/2) + "L-40," + lineheight + "L-40," + (lineheight/2) + "Z";
							else
								return "M0,0L20," + (lineheight/2) + "L0," + lineheight + "L-20," + (lineheight/2) + "Z";
						}
							
					})
		);
		
		svg.selectAll(".labels").data(this.content)
			.join(
				enter => enter
					.append("text")
					.attr("fill","white")
					.attr("x",function(d,i) {
						return position_x(i) + 10;
					})
					.attr("y",function(d,i) {
						return position_y(i) + 10;
					})					
					.attr("class","labels")
					.attr("font-size",textlineheight)
					.attr("alignment-baseline","hanging")
					.attr("font-family","Arial, Helvetica, sans-serif")
					.text(function(d) { return d.name;}),
				update => update
					.attr("fill","white")			
		);
		
		
		var rep = this;
		svg.selectAll(".values").data(this.content)
			.join(
				enter => enter
					.append("text")
					.attr("fill","white")
					.attr("x",function(d,i) {
						return position_x(i) + (width - 10);
					})
					.attr("y",function(d,i) {
						return position_y(i) + 10;
					})					
					.attr("class","values")
					.attr("text-anchor","end")
					.attr("alignment-baseline","hanging")
					.text(function(d) { 
						return d.diff.toFixed(2);
					}),
				update => update					
					.attr("fill","white")								
					.text(function(d) { 
						return d.diff.toFixed(2);
					})
		);
		
	}	
}