import os
import sys

sys.path.insert(0,os.path.dirname(os.path.dirname(os.path.dirname(__file__))))

import datetime
import traceback
import mplreport

def GenFilteredSPC(report,df,assetname,controlpoint,referencepoint,title,sigma,filtertimes=None,args=None,samples=60,relative=True):
    finalsamples = 60
    samples = 60*100    
    reference = ""

    fixedcompare = True    
    if isinstance(referencepoint,str):
        fixedcompare = False
    

    fig,axes = report.CreatePage(2)
    ax = axes[0]
    report.Title(override=title)

    downtimes = []
    uptimes = []
    finaltimes = [None] * (finalsamples+1)
    finalresults = [0] * (finalsamples+1)
    finaltotals = [0] * (finalsamples+1)
    col = assetname + " " + controlpoint
    mn = assetname + " " + str(referencepoint)
    
    indx = -1
    lastmean = None
    secondsper = (args.localend - args.localstart).total_seconds() / finalsamples
    for k,v in df.iterrows():
        indx += 1
        bucket = int((k - df.index[0]).total_seconds() / secondsper)
        passes = False
        if filtertimes is not None:
            for st,en in filtertimes:
                if k >= st and k <= en:
                    passes = True
        else:
            passes = True

        if fixedcompare == True:
            comparewith = referencepoint
        else:
            comparewith = v[mn]

        if passes == True:
            diff = 0
            
            finalresults[bucket] += v[col] - comparewith
            finaltotals[bucket] += 1
        
            
        if lastmean is not None:
            if abs(lastmean - comparewith) > 0.5:
                if comparewith > lastmean:
                    uptimes.append(k)
                else:
                    downtimes.append(k)                
            pass
        lastmean = comparewith

    for q in range(0,finalsamples):
        finaltimes[q] = df.index[0] + datetime.timedelta(seconds=q*secondsper)
        if finaltotals[q] > 0:
            finalresults[q] = finalresults[q] / finaltotals[q]
        
    ax.plot(finaltimes,finalresults,label=col,color='blue',zorder=5)
    if len(uptimes) > 0:
        zeroes = [0] * len(uptimes)
        ax.scatter(uptimes,zeroes,marker="^",color='purple')
    if len(downtimes) > 0:
        zeroes = [0] * len(downtimes)
        ax.scatter(downtimes,zeroes,marker="v",color='purple')

    mean = 0    
    ax.margins(0,0)
    ax.grid(zorder=-1)
    ax.set_ylim((mean - (sigma*4),mean+(sigma*4)))

    width = df.index[1] - df.index[0]    

    #Upper Limits
    ax.broken_barh([(finaltimes[0],width)],(mean+sigma*3,sigma),color=(1,0,0,0.2))    
    ax.axhline(mean+(sigma*3),color="red",dashes=(2,2))
    ax.broken_barh([(finaltimes[0],width)],(mean+sigma*2,sigma),color=(1,0.5,0,0.2))    
    ax.axhline(mean+(sigma*2),color="orange",dashes=(2,2))
    ax.broken_barh([(finaltimes[0],width)],(mean+(sigma*1),sigma),color=(1,1,0,0.2))    
    ax.axhline(mean+(sigma*1),color="yellow",dashes=(2,2))

    ax.broken_barh([(finaltimes[0],width)],(mean - (sigma*2),sigma),color=(1,1,0,0.2))    
    ax.axhline(mean-(sigma*1),color="yellow",dashes=(2,2))
    ax.broken_barh([(finaltimes[0],width)],(mean - (sigma*3),sigma),color=(1,0.5,0,0.2))    
    ax.axhline(mean-(sigma*2),color="orange",dashes=(2,2))
    ax.broken_barh([(finaltimes[0],width)],(mean - (sigma*4),sigma),color=(1,0,0,0.2))    
    ax.axhline(mean-(sigma*3),color="red",dashes=(2,2))
    
    ax.axhline(mean,color="green",dashes=(2,2))

    fig.tight_layout(rect=[0.05, 0.05, 0.96, 0.87])

    #Process For Issues...
    qpoints = [0] * finalsamples
    col = df.columns[0]
    buflen = 15
    last = buflen-1
    inbuffer = 0
    previous = [None] * buflen
    indx = -1

    threesigma = sigma*3
    twosigma = sigma*2
    
    for xv in range(0,finalsamples):#df.iterrows():
        k = finaltimes[xv]
        v = finalresults[xv]
        
        indx = indx + 1
        val = v        
        mean = 0
        if val is None or val == "^":
            previous = [None] * buflen
            inbuffer = 0
            continue
        
        for q in range(1,buflen):
            previous[q-1] = previous[q]
        
        previous[last] = v#v[col]
        inbuffer += 1
        #Rule 1
        if inbuffer > 0:
            diff = previous[last]
            if abs(diff) > (sigma*3):
                #print("Rule 1")
                qpoints[indx] = 1

        #Rule 2
        if inbuffer > 2:
            counter = 0
            
            direction = None
            if previous[last] > twosigma:
                direction = True
            else:
                if previous[last] < -twosigma:
                    direction = False
                    
            if direction is not None:                            
                for n in range(buflen-3,buflen):
                    if direction == True:
                        if previous[n] > twosigma:
                            counter += 1
                    else:
                        if previous[n] < -twosigma:
                            counter += 1
                if counter == 2:
                    #print("Rule 2 - " + str(previous[buflen-3:]))
                    if qpoints[indx] == 0:
                        qpoints[indx] = 2

        #Rule 3
        if inbuffer > 4:
            counter = 0

            direction = None
            if previous[last] > twosigma:
                direction = True
            else:
                if previous[last] < -twosigma:
                    direction = False
                    
            if direction is not None:
                for n in range(buflen-5,buflen):
                    if direction == True:
                        if previous[n] > twosigma:
                            #print(str(previous[n]) + " > " + str(twosigma))
                            counter += 1                        
                    else:
                        if previous[n] < -twosigma:
                            #print(str(previous[n]) + " < " + str(twosigma))
                            counter += 1
                if counter == 4:
                    #print("Rule 3 - " + str(mean) + " - " + str(previous[buflen-5:]))
                    if qpoints[indx] == 0:
                        qpoints[indx] = 3


        #Rule 4
        if inbuffer > 6:
            counter = 0
            direction = None
            original = previous[last]
            for n in range(buflen-7,buflen-1):
                if direction is None:
                    if previous[n] > original:
                        direction = 1
                    else:
                        if previous[n] < original:
                            direction = -1
                        else:
                            break
                    original = previous[n]
                    continue

                thisdirection = None                
                if previous[n] > original:
                    thisdirection = 1
                else:
                    if previous[n] < original:
                        thisdirection = -1
                    else:
                        break
                        
                if thisdirection == direction:
                    counter += 1
                else:
                    break

                original = previous[n]
            if counter >= 6:
                #print("Rule 4")
                if qpoints[indx] == 0:
                    qpoints[indx] = 4


        #Rule 5
        if inbuffer > 7:
            #print(str(mean) + " vs " + str(previous[buflen-7:]))
            counter = 0
            meanup = None
            if previous[last] > mean:
                meanup = True
                #print("Above Mean")
            else:
                if previous[last] < mean:
                    meanup = False
                    #print("Below Mean Mean")

            if meanup is not None:
                for n in range(buflen-7,buflen):
                    if meanup == True:
                        if previous[n] > mean:
                            counter += 1
                        else:
                            break
                    else:
                        if previous[n] < mean:
                            counter += 1
                        else:
                            break
                            
            if counter >= 6:
                #print("Rule 5")
                if qpoints[indx] == 0:
                    qpoints[indx] = 5


        #Rule 6
        if inbuffer >= 15:
            counter = 0
            meanup = None
            if previous[last] > mean:
                meanup = True
            else:
                if previous[last] < mean:
                    meandown = False

            if meanup is not None:
                for n in range(buflen-7,buflen):
                    if meanup == True:
                        if previous[n] > mean:
                            break
                        else:
                            meanup = False
                    else:
                        if previous[n] < mean:
                            break
                        else:
                            meanup = True
                            
            if counter >= 14:
                #print("Rule 6")
                if qpoints[indx] == 0:
                    qpoints[indx] = 6

    cells = [["Event Type","Detected At","Finished"]]
    cellcolours= [["silver","silver","silver"]]
    xpoints = []
    ypoints = []
    colours = []
    indx = -1
    lastevtype = ""
    for xv in range(0,finalsamples):
        k = finaltimes[xv]
        v = finalresults[xv]
        
        indx += 1
        xpoints.append(k)
        ypoints.append(v)
        clr = 'blue'
        evtype = ""
        if qpoints[indx] == 1:
            clr = 'red'
            evtype = "Out Of Range (R1)"
        if qpoints[indx] == 2:
            clr = 'orange'
            evtype = "Near Range Edge (R2)"
        if qpoints[indx] == 3:
            clr = 'orange'
            evtype = "In Outer Band (R3)"
        if qpoints[indx] == 4:
            clr = 'yellow'
            evtype = "Trending (R4)"
        if qpoints[indx] == 5:
            clr = 'yellow'
            evtype = "One-Sided (R5)"
        if qpoints[indx] == 6:
            clr = 'yellow'
            evtype = "In Control (R6)"
        colours.append(clr)
        if qpoints[indx] != 0:
            ax.annotate(" " + str(qpoints[indx]),(k,(v)-(sigma * 0.2)))

        if evtype != "" and evtype != lastevtype:
            if lastevtype != "":
                cells[len(cells)-1][2] = k
            cells.append([evtype,k,k])
            cellcolours.append(["white","white","white"])            
        if evtype == "" and lastevtype != "":            
            cells[len(cells)-1][2] = k
        lastevtype = evtype

    ax.scatter(xpoints,ypoints,color=colours,zorder=20)

    ax = axes[1]
    
    ax.axis('off')

    if len(cells) > 10:
        for v in range(len(cells)-1,10,-1):
            del cells[v]
            del cellcolours[v]
    
    tab = ax.table(cellText=cells,cellColours=cellcolours,loc=9)    
    tab.scale(1,1.75)

@mplreport.ardireport("[NAME]")
def CreateReport(report,args):       
    #Figure out the number of samples we are going to need (in this case, 10-second samples).
    samples = 1000
    propertyname = "[PROPERTY]"
    referencename = "[REFERENCE]"
    spanname = "[SPAN]"

    #First, get the reference values
    query = "('" + referencename + "') PROPERTYEX ALLPOINTS"
    df = report.GetCurrent(query)

    targets = {}
    for c in df.columns:
        targets[c] = df.iloc[0][c]

    #Get the span, if they are available...
    spans = {}
    if spanname == "":
        for k in targets:
            spans[k] = [DEFAULTSPAN]
    else:
        query = "('" + spanname + "') PROPERTYEX ALLPOINTS"
        df = report.GetCurrent(query)
        
        for c in df.columns:
            spans[c.replace(spanname,referencename)] = df.iloc[0][c]
    
    #Our AQL query goes here
    query = "('" + propertyname + "','" + referencename + "') PROPERTYEX ALLPOINTS"       
    
    df = report.GetHistory(query,samples=samples)    

    index = 0
    for t in targets:

        ttime = 0
        lasthit = None
        channame = t.replace(referencename,propertyname)         
        if channame in df.columns:
            sigma = spans[t]
            GenFilteredSPC(report,df,t.replace(referencename,"").strip(),propertyname,targets[t],t.replace(referencename,"").strip() + " " + propertyname + " Control",sigma,None,args)

        index += 1          

    #Save this report out.
    report.Save()