class ActiveReport extends SVGReport {
	initialise() {
		super.initialise();		
		this.mapping = [];
		this.content = [];
	};
	
	create() {
		this.singleQueryReport("('[PROPERTYA]','[PROPERTYB]') PROPERTY ALLPOINTS {%%} GETHISTORY");
	}
	
	
	updateTooltip(ev) {
		return '<h3>' + ev.target.getAttribute("name") + '</h3>' + ev.target.getAttribute("duration") + "<br/>" + ev.target.getAttribute("perc");
	}
	
	addContent(q,n,from,range) {
		this.content.push({a: q, b: n,name: from, range: range, warn: range * 0.9, diff: 0,diffperc: 0});
	}
		
	draw(data) {
		
		if (this.content.length == 0)
		{
			var hits = 0;
			for(var q=0;q<this.columns.length;q++)
			{
				if (!this.columns[q].name.includes("[PROPERTYA]"))
					continue;
				
				var to = "";
				var from = this.columns[q].name;
				var others = this.columns[q].name.replace("[PROPERTYA]","[PROPERTYB]");				
				
				for(var n=0;n<this.columns.length;n++)
				{				
					if (n == q) continue;			
					if (this.columns[n].name == others)
					{						
						this.addContent(q,n,from.replace(" [PROPERTYA]",""),1);						
						hits += 2;
						break;
					}
				}
				if (hits >= this.columns.length) break;
			}
		}
		
		var width = this.width;
		var height = this.height;
		var margin = {"left": 15,"right": 15,"top": this.margin.top, "bottom": 50};		
		
		//Calculate resulting size...		
		if (this.group == null)
		{
			// append the svg object to the div called 'my_dataviz'		
			this.group = d3.select("#reportsvg")		  
				.attr("width", width)
				.attr("height", height)
			  .append("g")
				.attr("transform", "translate(" + margin.left + " " + margin.top + ")");
		}
		
		width -= (margin.right + margin.left);
		height -= (margin.bottom + margin.top);
		
		var span = data[data.length-1][0] - data[0][0];
		
		for(var x=0;x<this.content.length;x++)
		{
			var cx = this.content[x];
			var ttltime = 0;
			for(var n=1;n<data.length;n++)
			{
				var tm = data[n][0] - data[n-1][0];
				var vl = data[n-1][cx.a+1] - data[n-1][cx.b+1];
				if (Math.abs(vl) > cx.range) 
				{
					ttltime += tm;
				}
			}
			this.content[x].diff = ttltime;			
		}		
		
		var lineheight = height / this.content.length;
		var textlineheight = lineheight;
		if (textlineheight > 30) textlineheight = 30;
		
		var position_x = function(i) {
			return 0;
		}
		var position_y = function(i) {
			return i * lineheight;
		}			
				
		var svg = this.group;
		
		var rep = this;
		
		svg.selectAll(".bars").data(this.content)
			.join(
				enter => enter
					.append("rect")
					.attr("fill","green")
					.attr("x",function(d,i) {
						return position_x(i);
					})
					.attr("y",function(d,i) {
						return position_y(i);
					})
					.attr("width",width)
					.attr("height",lineheight - 10)
					.attr("class","bars element")
					.call(this.tip)
					.attr('name',function(d) { return d.name + " in control"; })					
					.attr('perc',function(d) { return (Math.round(((span-d.diff) / span)*10000)/100) + "%"; })
					.attr('duration',function(d) { return rep.formatDuration((span - d.diff)/1000); })
		);
		
		svg.selectAll(".issues").data(this.content)
			.join(
				enter => enter
					.append("rect")
					.attr("fill","red")
					.attr("x",function(d) {
						return width - ((d.diff / span) * width);
					})
					.attr("y",function(d,i) {
						return position_y(i);
					})
					.attr("width",function(d) {
						return ((d.diff / span) * width);
					})
					.attr("height",lineheight - 10)
					.attr("class","issues")
					.call(this.tip)
					.attr('name',function(d) { return d.name + " out of control"; })					
					.attr('perc',function(d) { return (Math.round((d.diff / span)*10000)/100) + "%"; })
					.attr('duration',function(d) { return rep.formatDuration(d.diff/1000); }),
				update => update
					.transition()
					.duration(300)
					.attr("fill",function (d) { if (d.diff > d.range) return "red"; if (d.diff > d.warn) return "orange"; return "green"; })			
		);
	
		
		
		svg.selectAll(".labels").data(this.content)
			.join(
				enter => enter
					.append("text")
					.attr("fill","white")
					.attr("x",function(d,i) {
						return position_x(i) + 10;
					})
					.attr("y",function(d,i) {
						return position_y(i) + 10;
					})					
					.attr("class","labels")
					.attr("font-size",textlineheight)
					.attr("alignment-baseline","hanging")
					.attr("font-family","Arial, Helvetica, sans-serif")
					.text(function(d) { return d.name;}),
				update => update
					.attr("fill","white")			
		);
		
		
		var rep = this;
		svg.selectAll(".values").data(this.content)
			.join(
				enter => enter
					.append("text")
					.attr("fill","white")
					.attr("x",function(d,i) {
						return position_x(i) + (width - 10);
					})
					.attr("y",function(d,i) {
						return position_y(i) + 10;
					})					
					.attr("class","values")
					.attr("text-anchor","end")
					.attr("alignment-baseline","hanging")
					.text(function(d) { 
						return rep.formatDuration(d.diff/1000);
					}),
				update => update					
					.attr("fill","white")								
					.text(function(d) { 
						return rep.formatDuration(d.diff/1000);
					})
		);
		
	}	
}