import os
import sys

sys.path.insert(0,os.path.dirname(os.path.dirname(os.path.dirname(__file__))))

import datetime
import traceback
import mplreport


@mplreport.ardireport("[NAME]")
def CreateReport(report,args):       
    #Figure out the number of samples we are going to need (in this case, 10-second samples).
    samples = 1000
    propertyname = "[PROPERTY]"
    referencename = "[REFERENCE]"
    spanname = "[SPAN]"

    #First, get the reference values
    query = "('" + referencename + "') PROPERTYEX ALLPOINTS"
    df = report.GetCurrent(query)

    targets = {}
    for c in df.columns:
        targets[c] = df.iloc[0][c]

    #Get the span, if they are available...
    spans = {}
    if spanname == "":
        for k in targets:
            spans[k] = [DEFAULTSPAN]
    else:
        query = "('" + spanname + "') PROPERTYEX ALLPOINTS"
        df = report.GetCurrent(query)
        
        for c in df.columns:
            spans[c.replace(spanname,referencename)] = df.iloc[0][c]

    for k in targets:
        if k not in spans:
            spans[k] = 1
    
    #Our AQL query goes here
    query = "('" + propertyname + "','" + referencename + "') PROPERTYEX ALLPOINTS"       
    
    df = report.GetHistory(query,samples=samples)    

    fig,ax = report.CreatePage(1)
    report.Title()

    yvalues = []
    xticks = []
    xticklabels = []

    total_seconds = (args.localend - args.localstart).total_seconds()
    unit,multiplier = report.DurationUnit()

    index = 0
    for t in targets:
        ttime = 0
        lasthit = None
        channame = t.replace(referencename,propertyname)         
        if channame in df.columns:
            for indx,vl in df[channame].items():
                target = targets[t]
                if t in df.columns:                    
                    target = df.loc[indx][t]

                diff = vl - target
                if abs(diff) > spans[t]:
                    if lasthit is not None:
                        ttime += (indx - lasthit).total_seconds()
                    
                    lasthit = indx
                else:
                    if lasthit is not None:
                        ttime += (indx - lasthit).total_seconds()
                    lasthit = None

        yvalues.append(round((ttime / multiplier),2))
        xticks.append(index)
        xticklabels.append(t.replace(referencename,"").strip())
        index += 1

    report.AIChannel("barchart",yvalues)

    ax.bar(xticks,yvalues,color='r')    

    ax.margins(x=0,y=0)
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels,rotation=90)
    ax.set_ylabel('Time Out Of Control (' + unit + ')')
    report.Grid(ax)       

    #Save this report out.
    report.Save()
