import os
import sys

sys.path.insert(0,os.path.dirname(os.path.dirname(os.path.dirname(__file__))))

import datetime
import traceback
import mplreport
import discretepatterns as dp
from matplotlib.patches import Patch

@mplreport.ardireport("[NAME]")
def CreateReport(report,args):       
    #Figure out the number of samples we are going to need (in this case, 10-second samples).
    samples = 1000
    propertyname = "[PROPERTY]"
    referencename = "[REFERENCE]"
    spanname = "[SPAN]"

    #First, get the reference values
    query = "('" + referencename + "') PROPERTYEX ALLPOINTS"
    df = report.GetCurrent(query)

    targets = {}
    for c in df.columns:
        targets[c] = df.iloc[0][c]

    #Get the span, if they are available...
    spans = {}
    if spanname == "":
        for k in targets:
            spans[k] = [DEFAULTSPAN]
    else:
        query = "('" + spanname + "') PROPERTYEX ALLPOINTS"
        df = report.GetCurrent(query)
        
        for c in df.columns:
            spans[c.replace(spanname,referencename)] = df.iloc[0][c]

    for k in targets:
        if k not in spans:
            spans[k] = [DEFAULTSPAN]
    
    #Our AQL query goes here
    query = "('" + propertyname + "','" + referencename + "') PROPERTYEX ALLPOINTS"       
    
    df = report.GetHistory(query,samples=samples)    

    pageno = 0
    axno = 0
    fig,axes = report.CreatePage(2)
    report.Title()
    
    total_seconds = (args.localend - args.localstart).total_seconds()
    unit,multiplier = report.DurationUnit()

    index = 0
    for t in targets:

        ttime = 0
        lasthit = None
        channame = t.replace(referencename,propertyname)         
        if channame in df.columns:            
                
            if axno > 2 or (pageno == 0 and axno == 2):
                axno = 0
                fig,axes = report.CreatePage(3)
                pageno += 1

            ax = axes[axno]                        
            ax.plot(df[channame],label='Actual')
            ax.plot(df[t],label='Target',linestyle='dashed')
            report.Grid(ax)       
            report.TimeAxis(ax.xaxis)
            ax.legend()
            ax.margins(x=0,y=0)
            ax.set_ylabel(t.replace(referencename,"").strip())            
            axno += 1

        index += 1       
     
        
    if pageno > 0:
        if axno <= 2:
            axes[2].axis('off')
    if axno <= 1:
        axes[1].axis('off')
    
    

    #Save this report out.
    report.Save()
