class ActiveReport extends SVGReport {
	initialise() {
		super.initialise();
		this.first = true;
	};
	
	create() {
		var context = this;
		$.getScript("converters", function(){
			context.liveReport("'[PROPERTY]' ALLPOINTS");		
		});
	}
	
	update() {

		this.draw(report.livedata);		
	}
		
	draw(data) {
		//Calculate resulting size...
				
		var margin = {top: 60, right: 40, bottom: 40, left: 40};
		var height = this.sizing[1];
		var width = this.sizing[0];
		var base = parseFloat(this.livedata[0]);
		
		var svg = this.svgbase;			
		
		if (this.first == true)
		{
			$('#reportsvg').html("");
			
			var group = svg.append("g")
				.attr("transform","translate(" + margin.left + " " + margin.top + ")");
				
			svg = group;
			width = width - (margin.left + margin.right);
			height = height - (margin.top + margin.bottom);
			
			this.totalitems = this.columns.length;
			this.horiz = Math.ceil(Math.sqrt(this.totalitems));
			this.vert = this.horiz;
			
			var dmn = [];
			for(var q=0;q<this.horiz;q++)
			{
				dmn.push(q);
			}
			
			var x = d3.scaleBand()
				.domain(dmn)
				.range([ 0, width])
				.padding(.1);	

			dmn = [];
			for(var q=0;q<this.vert;q++)
			{
				dmn.push(q);
			}

			  // Y axis
			  var y = d3.scaleBand()
				.range([ 0, height ])
				.domain(dmn)
				.padding(.1);			  
				
			this.svg = group;
			this.first = false;
			this.x = x;
			this.y = y;
		}
		
		var ex = 0;
		var ey = 0;
		var finaldata = [];		
		for(var q=0;q<data.length;q++)
		{
			finaldata.push({name: this.columns[q].name,value: parseFloat(data[q]),desc: MapValue[PROPERTYID](data[q]).toUpperCase(), colour: MapColour[PROPERTYID](data[q]),x: ex,y: ey});						
			ex += 1;
			if (ex >= this.horiz)
			{
				ex = 0;
				ey++;
			}
		}		

		var context = this;
		var boxmargin = 20;
		if (this.x.bandwidth() * 0.1 < 20) boxmargin = this.x.bandwidth() * 0.1;
		if (this.y.bandwidth() * 0.1 < boxmargin) boxmargin = this.y.bandwidth() * 0.1;
		
		this.svg.selectAll(".bg")
			.data(finaldata)
			.join(
				enter => enter.append("rect")
					.attr("class","bg element")
					.attr("x", function(d) {
						return context.x(d.x);
					})
					.attr("y", function(d) { 
						return context.y(d.y); 
					})		
					.attr("width",context.x.bandwidth())
					.attr("height",context.y.bandwidth())
					.attr("fill", function (d) {
						return d.colour;
					})
					.attr("opacity",1)
					.attr("text-anchor","start")
					.attr("alignment-baseline","hanging")
					.attr("name",function(d) { return d.name.replace(" [PROPERTY]",""); })					
					.attr("units","")
					.attr("value",function(d) { return d.desc; })
					.call(this.tip),
				update => update	
					.transition()
					.duration(500)
					.attr("fill", function (d) {
						return d.colour;
					})
			)
			
			this.svg.selectAll(".headings")
			.data(finaldata)
			.join(
				enter => enter.append("text")
					.attr("class","headings")
					.attr("x", function(d) {
						return context.x(d.x) + boxmargin;
					})
					.attr("y", function(d) { 
						return context.y(d.y) + boxmargin; 
					})					
					.attr("fill", function(d) {
						var clr = d3.rgb(d.colour);
						if (clr.r > 180) return "black";
						if (clr.g > 180) return "black";
						if (clr.b > 180) return "black";
						return "white";
					})
					.attr("font-family","'RobotoCondensed', Arial, Helvetica, sans-serif")
					.attr("opacity",0.75)
					.attr("text-anchor","start")
					.attr("alignment-baseline","hanging")		
					.attr("font-size", function(d) {
						return Math.max((context.x.bandwidth()) / (d.name.replace(" [PROPERTY]","").length / 2),30);
					})					
					.text(function(d) { 
						return d.name.replace("[PROPERTY]","");
					}),
				update => update					
					.text(function(d) { 
						return d.name.replace("[PROPERTY]","");
					})
					.attr("fill", function(d) {
						var clr = d3.rgb(d.colour);
						if (clr.r > 180) return "black";
						if (clr.g > 180) return "black";
						if (clr.b > 180) return "black";
						return "white";
					})
			)
			
			this.svg.selectAll(".values")
			.data(finaldata)
			.join(
				enter => enter.append("text")
					.attr("class","values")
					.attr("x", function(d) {
						return context.x(d.x) + boxmargin;
					})
					.attr("y", function(d) { 
						return context.y(d.y) + (context.y.bandwidth() - boxmargin); 
					})					
					.attr("fill", function(d) {
						var clr = d3.rgb(d.colour);
						if (clr.r > 180) return "black";
						if (clr.g > 180) return "black";
						if (clr.b > 180) return "black";
						return "white";
					})
					.attr("font-family","'RobotoCondensed', Arial, Helvetica, sans-serif")
					.attr("opacity",1)
					.attr("text-anchor","start")
					.attr("alignment-baseline","baseline")	
					.attr("pointer-events","none")							
					.attr("font-size", function(d) {
						return context.y.bandwidth() * 0.2;
					})
					.text(function(d) { 
						return d.desc;
					}),
				update => update					
					.text(function(d) { 
						return d.desc;
					})
					.attr("fill", function(d) {
						var clr = d3.rgb(d.colour);
						if (clr.r > 180) return "black";
						if (clr.g > 180) return "black";
						if (clr.b > 180) return "black";
						return "white";
					})
			)

	}	
}