class ActiveReport extends SVGReport {
	initialise() {
		super.initialise();
		this.first = true;
	};
	
	create() {
		this.liveReport("'[PROPERTY]' ALLPOINTS");		
	}
	
	update() {

		this.draw(report.livedata);		
	}
		
	draw(data) {
		//Calculate resulting size...
		
		
		var margin = {top: this.margin.top, right: 40, bottom: 40, left: 150};
		var height = this.sizing[1];
		var width = this.sizing[0];
		var base = parseFloat(this.livedata[0]);
		
		var min = [MINVALUE];
		var max = [MAXVALUE];
		
		var svg = this.svgbase;
		
		var minvalue = null;
		var maxvalue = null;
		var finaldata = [];		
		for(var q=0;q<data.length;q++)
		{
			finaldata.push({name: this.columns[q].name,value: parseFloat(data[q])});			
			if ((minvalue == null) || (parseFloat(data[q]) < minvalue))
				minvalue = parseFloat(data[q]);
			
			if ((maxvalue == null) || (parseFloat(data[q]) > maxvalue))
				maxvalue = parseFloat(data[q]);
		}
				
		if (this.first == true)
		{
			$('#reportsvg').html("");
			
			var group = svg.append("g")
				.attr("transform","translate(" + margin.left + " " + margin.top + ")");
				
			svg = group;
			width = width - (margin.left + margin.right);
			height = height - (margin.top + margin.bottom);

			var x = d3.scaleLinear()
				.domain([[MINVALUE], [MAXVALUE]])
				.range([ 0, width]);
			  svg.append("g")
				.attr("transform", "translate(0," + height + ")")
				.call(d3.axisBottom(x))
				.selectAll("text")
				  .attr("transform", "translate(-10,0)rotate(-45)")
				  .style("text-anchor", "end");

			  // Y axis
			  var y = d3.scaleBand()
				.range([ 0, height ])
				.domain(finaldata.map(d => d.name.replace("[PROPERTY]","")))
				.padding(.1);
			  svg.append("g")
				.call(d3.axisLeft(y))
				
			this.svg = group;
			this.first = false;
			this.x = x;
			this.y = y;
		}
		
		this.multiplier = Math.pow(10,[PLACES]);

		var context = this;

		  //Bars
		  this.svg.selectAll(".bar")
			.data(finaldata)
			.join(
				enter => enter.append("rect")
					.attr("class","bar element")
					.attr("x", function(d) {
						return context.x(Math.min([MINVALUE],d.value));
					})					
					.attr("width",0)
					.attr("y", function(d) { 
						if (isNaN(d.value)) return context.y(d.name.replace("[PROPERTY]","")) + (context.y.bandwidth()/4);
						return context.y(d.name.replace("[PROPERTY]","")); 
					})
					.attr("height", function(d) {
						if (isNaN(d.value)) 
							return context.y.bandwidth()/2;
						return context.y.bandwidth();
					})	
					.attr("fill", function(d) {
						if (isNaN(d.value)) return 'purple';						
						var clr = MapColour[PROPERTYID](d.value);
						if (d.value == minvalue)
							return d3.color(clr).darker(0.5).formatHex();
						if (d.value == maxvalue)
							return d3.color(clr).brighter(0.5).formatHex();
						return clr;
					})
					.attr("name",function(d) { return d.name.replace("[PROPERTY]",""); })
					.attr("value",function(d) { return Math.round(d.value * context.multiplier) / context.multiplier; })					
					.attr("units","[UNITS]")
					.call(this.tip)
					.transition()
					.duration(1000)					
					.attr("width", function(d) {
						if (isNaN(d.value)) return width;					
						return context.x(Math.abs(d.value)) - context.x([MINVALUE]); 
					}),
				update => update
					.transition()
					.duration(500)	
					.attr("y", function(d) { 
						if (isNaN(d.value)) return context.y(d.name.replace("[PROPERTY]","")) + (context.y.bandwidth()/4);
						return context.y(d.name.replace("[PROPERTY]","")); 
					})
					.attr("height", function(d) {
						if (isNaN(d.value)) 
							return context.y.bandwidth()/2;
						return context.y.bandwidth();
					})	
					.attr("width",function(d) {
						if (isNaN(d.value)) return width;
						return context.x(Math.abs(d.value)) - context.x([MINVALUE]); 
					})
					.attr("x", function(d) {
						return context.x(Math.min([MINVALUE],d.value));
					})
					.attr("fill", function(d) {
						if (isNaN(d.value)) return 'purple';
						var clr = MapColour[PROPERTYID](d.value);
						if (d.value == minvalue)
							return d3.color(clr).darker(0.5).formatHex();
						if (d.value == maxvalue)
						{
							return d3.color(clr).brighter(0.5).formatHex();
						}
						return clr;
					})
			)
			
			if (this.columns.length < 50)
			{
				var fontsize = Math.min(12,context.y.bandwidth());
				this.svg.selectAll(".values")
				.data(finaldata)
				.join(
					enter => enter.append("text")
						.attr("class","values")
						.attr("x", 0 )
						.attr("y", function(d) { 
							return context.y(d.name.replace("[PROPERTY]","")) + 10; 
						})					
						.attr("fill", "white")
						.attr("opacity",0)
						.attr("text-anchor",function(d) {
							var cx = x(d.value);
							if (cx < 100)
								return "start";
							return "end";
						})
						.attr("font-size",fontsize)
						.attr("alignment-baseline","middle")
						.transition()
						.duration(1000)					
						.attr("x", function(d) {
							var cx = context.x(d.value);
							if (cx < 100)
								return cx + 10; 
							return cx - 10;
						})
						.attr("opacity",1)
						.text(function(d) { 
							if (isNaN(d.value)) return "";
							return (Math.round(d.value * context.multiplier) / context.multiplier) + "[UNITS]";
						}),
					update => update
						.attr("text-anchor",function(d) {
							var cx = context.x(d.value)-10;
							if (cx < 100)
								return "start";
							return "end";
						})
						.transition()
						.duration(500)	
						.attr("opacity",1)
						.attr("x", function(d) {
							var cx = context.x(d.value);
							if (cx < 100)
								return cx + 10; 
							return cx - 10;
						})
						.text(function(d) {
							if (isNaN(d.value)) return "";
							return (Math.round(d.value * context.multiplier) / context.multiplier) + "[UNITS]";
						})
				)
			}

	}	
}