class ActiveReport extends SVGReport {
	initialise() {
		super.initialise();
		this.first = true;
	};
	
	create() {
		report.singleQueryReport("'[PROPERTY]' ALLPOINTS 'all' SET {%%,\"grain\": -1} GETHISTORY 'AVG' NAME 'all' GET {%%,\"method\": \"max\",\"grain\": -1} GETHISTORY 'MAX' NAME 'all' GET {%%,\"method\": \"min\",\"grain\": -1} GETHISTORY 'MIN' NAME");	
	}
	
	
	
	updateTooltip(ev) {
		var tg = ev.target;
		if (tg.getAttribute("class").includes("bar"))
			return "<h3>" + tg.getAttribute("name") + "</h3><p>Average: " + tg.getAttribute("value") + "</p><p>Minimum: " + tg.getAttribute("min") + "</p><p>Maximum: " + tg.getAttribute("max") + "</p>";
		else
			return "<h3>" + tg.getAttribute("name") + "</h3><p>Average: " + tg.getAttribute("value") + "</p>";
	}
		
	draw(data) {
		//Calculate resulting size...
		
		
		var margin = {top: this.margin.top, right: 40, bottom: 40, left: 200};
		var height = this.sizing[1];
		var width = this.sizing[0];
		var base = parseFloat(this.livedata[0]);
		
		var svg = this.svgbase;
		
		var minvalue = 999;
		var finaldata = [];		
		for(var q=0;q<this.columns.length;q++)
		{
			if (this.columns[q].name.includes(" AVG"))
			{
				var lookupmx = this.columns[q].name.replace("AVG","MAX");
				var lookupmi = this.columns[q].name.replace("AVG","MIN");
				var min = -1;
				var max = -1;
				for(var v=0;v<this.columns.length;v++)
				{
					if (this.columns[v].name == lookupmx)
					{
						max = v;
						if (min >= 0) break;
					}
					if (this.columns[v].name == lookupmi)
					{
						min = v;
						if (max >= 0) break;
					}
				}
				finaldata.push({name: this.columns[q].name.replace("[PROPERTY]","").replace(" AVG",""),avg: data[0][q+1],min: data[0][min+1],max: data[0][max+1]});						
			}
		}
		
		if (this.first == true)
		{
			$('#reportsvg').html("");
			
			var group = svg.append("g")
				.attr("transform","translate(" + margin.left + " " + margin.top + ")");
				
			svg = group;
			width = width - (margin.left + margin.right);
			height = height - (margin.top + margin.bottom);

			var x = d3.scaleLinear()
				.domain([[MINVALUE], [MAXVALUE]])
				.range([ 0, width]);
			  svg.append("g")
				.attr("transform", "translate(0," + height + ")")
				.call(d3.axisBottom(x))
				.selectAll("text")
				  .attr("transform", "translate(-10,0)rotate(-45)")
				  .style("text-anchor", "end");

			  // Y axis
			  var y = d3.scaleBand()
				.range([ 0, height ])
				.domain(finaldata.map(d => d.name))
				.padding(.1);
			  svg.append("g")
				.call(d3.axisLeft(y))
				
			this.svg = group;
			this.first = false;
			this.x = x;
			this.y = y;
		}
		
		this.multiplier = Math.pow(10,[PLACES]);

		var context = this;

		  //Bars
		  this.svg.selectAll(".bar")
			.data(finaldata)
			.join(
				enter => enter.append("rect")
					.attr("class","bar element")
					.attr("x", function(d) {
						return context.x(d.min);
					})
					.attr("y", function(d) { 
						return context.y(d.name) + (context.y.bandwidth()*0.25); 
					})
					.attr("width", function(d) {
						return Math.abs(context.x(d.max) - context.x(d.min)); 
					})
					.attr("height", context.y.bandwidth() * 0.5 )
					.attr("fill", "blue")					
					.attr("opacity",0)
					.attr("name",function(d) { return d.name; })
					.attr("value",function(d) { return Math.round(context.multiplier * d.avg)/context.multiplier; })
					.attr("min",function(d) { return Math.round(context.multiplier * d.min)/context.multiplier; })
					.attr("max",function(d) { return Math.round(context.multiplier * d.max)/context.multiplier; })
					.attr("units","[UNITS]")
					.call(this.tip)
					.transition()
					.delay(function(d,i) { return i*50; })
					.duration(500)
					.attr("opacity",1),
				update => update
					.attr("value",function(d) { return Math.round(context.multiplier * d.avg)/context.multiplier; })
					.attr("min",function(d) { return Math.round(context.multiplier * d.min)/context.multiplier; })
					.attr("max",function(d) { return Math.round(context.multiplier * d.max)/context.multiplier; })
					.transition()
					.duration(500)	
					.attr("width",function(d) {
						return Math.abs(context.x(d.max) - context.x(d.min)); 
					})
					.attr("x", function(d) {
						return context.x(d.min);
					})
					
			)
			
		this.svg.selectAll(".avg")
			.data(finaldata)
			.join(
				enter => enter.append("rect")
					.attr("class","avg element")
					.attr("x", function(d) {
						return context.x(d.avg) - 4;
					})
					.attr("y", function(d) { 
						return context.y(d.name); 
					})
					.attr("width",8)
					.attr("height", context.y.bandwidth() )
					.attr("fill", "cyan")
					.attr("opacity",0)
					.attr("name",function(d) { return d.name; })
					.attr("value",function(d) { return Math.round(context.multiplier * d.avg)/context.multiplier; })					
					.attr("units","[UNITS]")
					.call(this.tip)
					.transition()
					.delay(function(d,i) { return i*50; })
					.duration(500)
					.attr("opacity",0.9),
				update => update
					.attr("value",function(d) { return Math.round(context.multiplier * d.avg)/context.multiplier; })					
					.transition()
					.duration(500)						
					.attr("x", function(d) {
						return context.x(d.avg);
					})
					
			)
			
			/*this.svg.selectAll(".values")
			.data(finaldata)
			.join(
				enter => enter.append("text")
					.attr("class","values")
					.attr("x", 0 )
					.attr("y", function(d) { 
						return context.y(d.name.replace("[PROPERTY]","")) + 10; 
					})					
					.attr("fill", "white")
					.attr("opacity",0)
					.attr("text-anchor",function(d) {
						var cx = x(d.value);
						if (cx < 100)
							return "start";
						return "end";
					})
					.attr("alignment-baseline","hanging")
					.transition()
					.duration(1000)					
					.attr("x", function(d) {
						var cx = context.x(d.value);
						if (cx < 100)
							return cx + 10; 
						return cx - 10;
					})
					.attr("opacity",1)
					.text(function(d) { 
						return (Math.round(d.value * context.multiplier) / context.multiplier) + "[UNITS]";
					}),
				update => update
					.attr("text-anchor",function(d) {
						var cx = context.x(d.value)-10;
						if (cx < 100)
							return "start";
						return "end";
					})
					.transition()
					.duration(500)	
					.attr("opacity",1)
					.attr("x", function(d) {
						var cx = context.x(d.value);
						if (cx < 100)
							return cx + 10; 
						return cx - 10;
					})
					.text(function(d) {
						return (Math.round(d.value * context.multiplier) / context.multiplier) + "[UNITS]";
					})
			)*/

	}	
}