import os
import sys

sys.path.insert(0,os.path.dirname(os.path.dirname(os.path.dirname(__file__))))

import datetime
import traceback
import mplreport

@mplreport.ardireport("[NAME]")
def CreateReport(report,args):       
    #Figure out the number of samples we are going to need (in this case, 10-second samples).
    samples = 10
    propertyname = "[PROPERTY]"

    #Our AQL query goes here
    query = "('" + propertyname + "') PROPERTYEX ALLPOINTS"       

    #Get the pandas data-frame with the results.
    dfa = report.GetHistory(query,samples=samples)
    dfmax = report.GetHistory(query,samples=samples,method="max")
    dfmin = report.GetHistory(query,samples=samples,method="min")  

    #Create the report page
    fig,ax = report.CreatePage(1)
    report.Title()

    #Get the number of items
    items = len(dfa.columns)        

    xticks = []
    xticklabels = []

    #Create a buffer to put in the AI results...
    summary = [0] * (3*items)

    #Get max, min and average values for each of the columns
    means = dfa.mean()
    maxes = dfmax.max()
    mins = dfmin.min()

    minvalue = None

    #Calculate the size of the 'mean' bar
    avgsize = (maxes.max() - mins.min()) * 0.01
    havg = avgsize / 2

    #Draw the span and mean bars
    indx = -1
    for col in dfa.columns:
        indx += 1
        try:
            avg = means[col]
            min = mins[col]
            max = maxes[col]        
        except:
            indx -= 1
            continue      

        if minvalue is None or minvalue > min:
            minvalue = min

        ax.bar([indx],[max-min],0.5,[min],color='c')
        ax.bar([indx],[avgsize],0.9,[avg-havg],color='b')
        xticks.append(indx)
        xticklabels.append(col.replace(propertyname,"").strip())

        summary[(indx * 3)] = min
        summary[(indx * 3)+1] = avg
        summary[(indx * 3)+2] = max

    #Make the report pretty
    report.Grid(ax)
    ax.set_xticks(xticks)

    reallabels = report.SimplifyTicks(xticklabels)
    ax.set_xticklabels([""]*len(xticks),rotation=90,ha='right')
    ax.tick_params(axis="x",direction="in",pad=-100)

    indx = 0
    for n in reallabels:
        ax.text(indx,minvalue," " + n,rotation=90,ha='left',alpha=0.5)
        indx+=1

    ax.margins(x=0)
    ax.set_xlabel('Asset')
    ax.set_ylabel('[PROPAXIS]')

    #Store AI results
    report.AIChannel("barchart",summary)

    #Save this report out.
    report.Save()