class ActiveReport extends SVGReport {
	initialise() {
		super.initialise();
		this.first = true;
	};
	
	create() {		
		report.singleQueryReport("'[PROPERTY]' ALLPOINTS {%%} GETHISTORY");			
	}	
	
	updateTooltip(ev) {
		return '<h3>' + ev.target.getAttribute("name") + '</h3>' + ev.target.getAttribute("value") + "<br/>" + ev.target.getAttribute("duration");
	}
		
	draw(data) {
		//Calculate resulting size...
				
		var margin = {top: this.margin.top, right: 40, bottom: 40, left: 150};
		var height = this.sizing[1];
		var width = this.sizing[0];	

		//height -= margin.top + margin.bottom;
		
		var svg = this.svgbase;			
				
		$('#reportsvg').html("");
		
		var group = svg.append("g")
			.attr("transform","translate(" + margin.left + " " + margin.top + ")");
			
		svg = group;
		width = width - (margin.left + margin.right);
		height = height - (margin.top + margin.bottom);			
		
		var x = d3.scaleTime()
			.domain([data[0][0], data[data.length-1][0]])
			.range([ 0, width]);
		svg.append("g")
			.attr("transform", "translate(0," + height + ")")
			.call(d3.axisBottom(x))
			.selectAll("text")
			  .attr("transform", "translate(-10,0)rotate(-45)")
			  .style("text-anchor", "end");
		
		 // Y axis
		var y = d3.scaleBand()
			.range([ 0, height ])
			.domain(this.columns.map(d => d.name.replace(" [PROPERTY]","")))
			.padding(.1);
		svg.append("g")
			.call(d3.axisLeft(y));
			
		this.svg = group;
		this.first = false;
		this.x = x;
		this.y = y;
		
		
		var val = 0;
		var tm = 0;
		var finaldata = [];
		for(var n=0;n<this.columns.length;n++)
		{			
			var lasttime = data[0][0];		
			for(var q=1;q<data.length;q++)
			{
				val = data[q-1][n+1];
				if (val != data[q][n+1])
				{
					tm = data[q][0] - lasttime;								
					finaldata.push({name: this.columns[n].name,value: parseFloat(val),desc: MapValue[PROPERTYID](val), colour: MapColour[PROPERTYID](val),x1: lasttime, x2: data[q][0],y: n, duration: tm});										
					lasttime = data[q][0];
				}
			}
			var q = data.length-1;			
			if (lasttime != data[q][0])
			{				
				tm = data[q][0] - lasttime;								
				finaldata.push({name: this.columns[n].name,value: parseFloat(val),desc: MapValue[PROPERTYID](val), colour: MapColour[PROPERTYID](val),x1: lasttime, x2: data[q][0],y: n, duration: tm});										
			}
		}		

		var context = this;
		
		this.svg.selectAll(".bg")
			.data(finaldata)
			.join(
				enter => enter.append("rect")
					.attr("class","bg element")
					.attr("x", function(d) {
						return context.x(d.x1);
					})
					.attr("y", function(d) { 
						return context.y(d.name.replace(" [PROPERTY]","")); 
					})		
					.attr("width", function(d) {
						return context.x(d.x2) -  context.x(d.x1); 
					})
					.attr("height",y.bandwidth())
					.attr("fill", function (d) {
						return d.colour;
					})
					.attr('value', function(d) { 
						return d.desc;
					})
					.attr('name', function(d) { 
						return d.name.replace(" [PROPERTY]","");
					})
					.attr('duration', function(d) { 
						return context.formatDuration(d.duration/1000) + ", from " + context.formatDate(d.x1,d.x1,d.x2) + " to " + context.formatDate(d.x2,d.x1,d.x2);
					})
					.call(this.tip)
					.attr("units","")
					.attr("opacity",1)
					.attr("text-anchor","start")
					.attr("alignment-baseline","hanging"),
				update => update
					.transition()
					.duration(500)
					.attr("x", function(d) {
						return context.x(d.x1);
					})				
					.attr("fill", function (d) {
						return d.colour;
					})
					.attr('value', function(d) { 
						return d.desc;
					})
					.attr("width", function(d) {
						return context.x(d.x2) -  context.x(d.x1); 
					})
			)

	}	
}