import os
import sys

sys.path.insert(0,os.path.dirname(os.path.dirname(os.path.dirname(__file__))))

import datetime
import traceback
import mplreport
import discretepatterns as dp
from matplotlib.patches import Patch

@mplreport.ardireport("[NAME]")
def CreateReport(report,args):       
    #Figure out the number of samples we are going to need (in this case, 10-second samples).
    samples = 1000
    propertyname = "[PROPERTY]"    

    #Our AQL query goes here
    query = "('" + propertyname + "') PROPERTYEX ALLPOINTS"       

    #Get the pandas data-frame with the results. Note that usually, the number of samples really don't matter.
    rdata = report.FetchHistory(query,samples=samples)
    df = rdata.data    

    fig,ax = report.CreatePage(1)
    report.Title()

    pat = dp.DiscretePatterns()
    pat.SetDataframe(df)
    pat.Ready()

    yticks = []
    yticklabels = []

    colour = report.GetDiscreteColourMap(rdata,df.columns[0])
    value = rdata.GetValueMap(df.columns[0])
    
    indx = 0
    for col in df.columns:
        periods = pat.GetAllTimeframes(col)
        for q in periods:
            try:
                clr = colour[q]
            except:
                clr = 'r'
                if q == 0:
                    clr = 'b'
                if q == 1:
                    clr = 'c'
                try:
                    colour[q] = clr
                except:
                    newclr = {}
                    for x in range(0,len(colour)):
                        newclr[x] = colour[x]
                    colour[q] = clr
                    colour = newclr

            xsets = []
            for set in periods[q]:
                xsets.append((set[0],set[1] - set[0]))
            ax.broken_barh(xsets,(indx,0.8),color=clr)

            yticks.append(indx+0.5)
            yticklabels.append("")#(col.replace(propertyname,"").strip())

        ax.text(df.index[0] + datetime.timedelta(seconds=30),indx + 0,col.replace(propertyname,"").strip(),verticalalignment="bottom",color=(0,0,0,0.5))

        indx += 1    
    
    ax.margins(x=0,y=0)
    ax.set_yticks(yticks)
    ax.set_yticklabels(yticklabels)
    report.Grid(ax)
    report.TimeAxis(ax.xaxis)

    #Custom Legend
    legend_elements = report.GetDiscreteLegend(rdata,df.columns[0])[0]

    ax.legend(handles=legend_elements)

    #Save this report out.
    report.Save()
