class ActiveReport extends SVGReport {
	initialise() {
		super.initialise();
		this.first = true;
	};
	
	create() {		
		report.singleQueryReport("'[PROPERTY]' ALLPOINTS {%%} GETHISTORY");			
	}
	
	updateTooltip(ev) {
		return '<h3>' + ev.target.getAttribute("name") + '</h3>' + ev.target.getAttribute("value") + "<br/>" + ev.target.getAttribute("duration");
	}
		
	draw(data) {
		//Calculate resulting size...
				
		var margin = {top: this.margin.top, right: 40, bottom: 40, left: 150};
		var height = this.sizing[1];
		var width = this.sizing[0];	

		//height -= margin.top + margin.bottom;
		
		var svg = this.svgbase;			
				
		$('#reportsvg').html("");
		
		var group = svg.append("g")
			.attr("transform","translate(" + margin.left + " " + margin.top + ")");
			
		svg = group;
		width = width - (margin.left + margin.right);
		height = height - (margin.top + margin.bottom);			
		
		var x = d3.scaleLinear()
			.domain([0, 100])
			.range([ 0, width]);
		svg.append("g")
			.attr("transform", "translate(0," + height + ")")
			.call(d3.axisBottom(x))
			.selectAll("text")
			  .attr("transform", "translate(-10,0)rotate(-45)")
			  .style("text-anchor", "end");
		
		 // Y axis
		var y = d3.scaleBand()
			.range([ 0, height ])
			.domain(this.columns.map(d => d.name.replace(" [PROPERTY]","")))
			.padding(.1);
		svg.append("g")
			.call(d3.axisLeft(y));
			
		this.svg = group;
		this.first = false;
		this.x = x;
		this.y = y;
		
		rows = [];
		
		var span = data[data.length-1][0] - data[0][0];
		var val = 0;
		var tm = 0;
		var timeframes = [];
		var valueset = [];
		for(var n=0;n<this.columns.length;n++)
		{
			var lasttime = null;
			for(var q=1;q<data.length;q++)
			{
				val = data[q-1][n+1];
				tm = data[q][0] - data[q-1][0];
				if (!valueset.includes(val))
					valueset.push(val);
				
				timeframes.push({name: this.columns[n].name,value: val,y: n, duration: tm});										
			}	
		}
		
		valueset.sort();
		var rows = [];
		
		var offset = 0;	
		var rawd = 0;		
		var finaldata = [];
		for(var n=0;n<this.columns.length;n++)
		{
			var rowtext = "";
			offset = 0;
			for(var q=0;q<valueset.length;q++)
			{
				val = 0;
				for(var t=0;t<timeframes.length;t++)
				{
					if ((timeframes[t].y == n) && (timeframes[t].value == valueset[q]))
					{
						val += timeframes[t].duration;
					}
				}
				
				rawd = val;
				val = (val*100) / span;
				
				finaldata.push({name: this.columns[n].name,value: val,desc: MapValue[PROPERTYID](valueset[q]), colour: MapColour[PROPERTYID](valueset[q]),x1: offset, x2: offset+val, n, duration: rawd,perc: val});
				offset += val;
				
				if (val > 0)
				{
					if (rowtext != "") rowtext += ", ";
					rowtext +=  MapValue[PROPERTYID](valueset[q]) + " " + (Math.round(val *100)/100) + "%";
				}
			}				
			rows.push({name: this.columns[n].name,txt: rowtext});
		}		

		var context = this;
		
		this.svg.selectAll(".bg")
			.data(finaldata)
			.join(
				enter => enter.append("rect")
					.attr("class","bg element")
					.attr("x", function(d) {
						return context.x(d.x1);
					})
					.attr("y", function(d) { 
						return context.y(d.name.replace(" [PROPERTY]","")); 
					})		
					.attr("width", function(d) {
						return context.x(d.x2) -  context.x(d.x1); 
					})
					.attr("height",y.bandwidth())
					.attr("fill", function (d) {
						return d.colour;
					})
					.attr('value', function(d) { 
						return d.desc;
					})
					.attr('name', function(d) { 
						return d.name.replace(" [PROPERTY]","");
					})
					.attr('duration', function(d) { 
						return context.formatDuration(d.duration/1000) + " ( " + (Math.round(d.perc*100)/100) + "% )";
					})
					.call(this.tip)
					.attr("units","")
					.attr("opacity",1)
					.attr("text-anchor","start")
					.attr("alignment-baseline","hanging"),
				update => update
					.transition()
					.duration(500)
					.attr("x", function(d) {
						return context.x(d.x1);
					})				
					.attr("fill", function (d) {
						return d.colour;
					})
					.attr('value', function(d) { 
						return d.desc;
					})
					.attr("width", function(d) {
						return context.x(d.x2) -  context.x(d.x1); 
					})
			)

		this.svg.selectAll(".label")
			.data(rows)
			.join(
				enter => enter.append("text")
					.attr("class","label element")
					.attr("x", function(d) {
						return context.x(1);
					})
					.attr("y", function(d) { 
						return context.y(d.name.replace(" [PROPERTY]","")) + (context.y.bandwidth()/2); 
					})							
					.attr("fill", "black")
					.attr("font-size",Math.min(12,y.bandwidth() * 0.75))
					.attr("pointer-events","none")
					.attr("text-anchor","start")
					.attr("alignment-baseline","middle")
					.text(function(d) { return d.txt;}),
				update => update
					.text(function(d) { return d.txt;})
			)
	}	
}