import os
import sys

sys.path.insert(0,os.path.dirname(os.path.dirname(os.path.dirname(__file__))))

import datetime
import traceback
import mplreport
import discretepatterns as dp
from matplotlib.patches import Patch

@mplreport.ardireport("[NAME]")
def CreateReport(report,args):       
    #Figure out the number of samples we are going to need (in this case, 10-second samples).
    samples = 1000
    propertyname = "[PROPERTY]"            

    #Our AQL query goes here
    query = "('" + propertyname + "') PROPERTYEX ALLPOINTS"       

    #Get the pandas data-frame with the results. Note that usually, the number of samples really don't matter.
    rdata = report.FetchHistory(query,samples=samples)
    df = rdata.data

    colour = report.GetDiscreteColourMap(rdata,df.columns[0])
    value = rdata.GetValueMap(df.columns[0])

    #Create buckets to place summary/AI data into
    buckets = []
    bucketindex = {}
    for x in value:
        if value[x] not in buckets:     
            bucketindex[int(x)] = len(buckets)
            buckets.append(value[x])
        else:
            for n in range(0,len(buckets)):
                if buckets[n] == value[x]:
                    bucketindex[int(x)] = n
                    break    

    #Setup the report page
    fig,ax = report.CreatePage(1)
    report.Title()

    #Get the time-frames for each value
    pat = dp.DiscretePatterns()
    pat.SetDataframe(df)
    pat.Ready()

    #Create the array for AI data...
    summary = [0] *(len(df.columns) * len(buckets)) 
      
    yticks = []
    yticklabels = []    
    
    #For every column....
    indx = 0
    offset = 0
    for col in df.columns:
        offset=0

        #Get the timeframes for each value.
        periods = pat.GetAllTimeframes(col)

        modetimes = {}

        #Add up the total time for ALL statuses
        values = []
        totaltime = 0
        for q in periods:
            for r in periods[q]:
                totaltime += (r[1] - r[0]).total_seconds()
            values.append(q)

        values.sort()
        #Add up the total time for each of the SPECIFIC statuses
        for q in values:
            modetime = 0
            for r in periods[q]:
                modetime += (r[1] - r[0]).total_seconds()

            try:
                clr = colour[q]
            except:
                clr = 'r'
                if q == 0:
                    clr = 'b'
                if q == 1:
                    clr = 'c'
                try:
                    colour[q] = clr
                except:
                    newclr = {}
                    for x in range(0,len(colour)):
                        newclr[x] = colour[x]
                    colour[q] = clr
                    colour = newclr

            xsets = []        
            xsets.append((offset,modetime))
            ax.broken_barh(xsets,(indx,0.8),color=clr)
            offset += modetime

            modetimes[q] = modetime
            summary[(indx * len(buckets)) + bucketindex[q]] = modetime

        yticks.append(indx+0.5)
        yticklabels.append("")

        #Add an annotation inside the chart axis
        nm = col.replace(propertyname,"").strip() + " - " 
        for q in periods:
            nm += " " + value[q] + ": " + str(round((modetimes[q]/totaltime)*100,2)) + "%"
        ax.text(10,indx + 0,nm,verticalalignment="bottom",color=(0,0,0,0.5))

        indx += 1  
    
    #Make it pretty
    ax.margins(x=0,y=0)
    ax.set_yticks(yticks)
    ax.set_yticklabels(yticklabels)
    ax.set_xlabel('Time (s)')
    report.Grid(ax)    

    #Custom Legend
    legend_elements = report.GetDiscreteLegend(rdata,df.columns[0])[0]

    ax.legend(handles=legend_elements)

    #Save AI information
    report.AIChannel("barchart",summary)

    #Save this report out.
    report.Save()
