class ActiveReport extends SVGReport {
	initialise() {
		super.initialise();		
		this.first = true;
		this.samplediff = 1;
		this.displaysamples = 250;		
		this.tick = 0;
	};
	
	create() {
		
		this.hybridReport("'[ASSET]' ASSET 'Sequence' RELATIONSHIP 'downi' RELATED '[PROPERTY]' PROPERTY VALUES {\"grain\": -" + this.displaysamples + ",%%} GETHISTORY");		
	}
		
	draw(data) {
		
		//this.timedUpdates(1);
		var height = this.sizing[1];
		var width = this.sizing[0];

		var minvalue = 99999;
		var maxvalue = -99999;
		
		var margin = {top: this.margin.top, bottom: 20, left: 120, right: 20};		
		var svg = null;
		
		margin.left += 20;
		margin.bottom += 20;	
		
		width = width - (margin.left + margin.right);
		height = height - (margin.top + margin.bottom);
		
		var x = null;
		var y = null;
		var boxwidth = width / data.length;
		
		var drange = [];
		for(var n=0;n<data.length;n++)
		{
			drange.push(data[n][0]);
		}
		
		if (this.first == true)
		{
			this.finaldata = [];
			
			this.samplediff = (data[1][0] - data[0][0]);			
			
			var colnames = [];
			for(var n=0;n<this.columns.length;n++)
			{
				colnames.push(this.columns[n].name.replace(" [PROPERTY]",""));
			}
			
			this.x = d3.scaleBand().domain(drange).range([0, width]).padding(-0.2);
			this.y = d3.scaleBand().domain(colnames).range([height,0]).padding(0.1);
			
			x = this.x;
			y = this.y;
			
			this.svg = this.svgbase.append("g")
				.attr("transform","translate(" + margin.left + "," + margin.top + ")");
				
			svg = this.svg;
			
			var xaxis = d3.axisBottom(x);
			xaxis.ticks(2);
			xaxis.tickFormat((d,i) => "");
			
			svg.append("g")
				.attr("transform", "translate(0," + height + ")")
				.call(xaxis);
				
			svg.append("g")
				.call(d3.axisLeft(y));
				
			for(var q=0;q<data.length;q++)
			{
				for(var n=1;n<data[q].length;n++)
				{
					this.finaldata.push({x: data[q][0],y: this.columns[n-1].name.replace(" [PROPERTY]",""),value: data[q][n],seq: q + "x" + (n-1)});
					
					if (minvalue > data[q][n])
						minvalue = data[q][n];
					if (maxvalue < data[q][n])
						maxvalue = data[q][n];
				}
			}		
				
			this.first = false;
		}
		else
		{
			svg = this.svg;
			x = this.x;
			y = this.y;			
			
			var offset = 0;
			for(var q=0;q<data.length;q++)
			{
				for(var n=1;n<data[q].length;n++)
				{
					this.finaldata[offset].value = data[q][n];
					this.finaldata[offset].x = data[q][0];
					
					if (minvalue > data[q][n])
						minvalue = data[q][n];
					if (maxvalue < data[q][n])
						maxvalue = data[q][n];
					
					offset++;
				}
			}		
		}		
		
		this.x = d3.scaleBand().domain(drange).range([0, width]).padding(-0.2);
		x = this.x;
						
		if (data[0].length > 30)
		{
			//Sharp transition version
			svg.selectAll(".hmbox")
			  .data(this.finaldata, function(d) {return d.seq;})
			  .join( enter => enter		  
				  .append("rect")
				  .attr("class","hmbox")
				  .attr("x", function(d) { return x(d.x) })
				  .attr("y", function(d) { return y(d.y) })
				  .attr("width", boxwidth )
				  .attr("height", y.bandwidth() )
				  .attr("name", function(d) { return d.y; })
				  .attr("units","")
				  .attr("value", function(d) { 
					return d.value.toFixed(1) + "[UNITS] @ " + d.x;
				  })
				  .attr("fill", function(d) { return MapColour[PROPERTYID](d.value,minvalue,maxvalue); } )
				  .attr("stroke","none")				  
				  .call(this.tip),
				 update => update					
					.attr("value", function(d) { 
						if (d.value == undefined) return "Unknown" + " @ " + d.x;
						return d.value.toFixed(1) + " @ " + d.x;
					})					
					.attr("fill", function(d) { return MapColour[PROPERTYID](d.value,minvalue,maxvalue); } ));

		}
		else
		{
			//Smoothly Animate Colours
			svg.selectAll(".hmbox")
			  .data(this.finaldata, function(d) {return d.seq;})
			  .join( enter => enter		  
				  .append("rect")
				  .attr("class","hmbox")
				  .attr("x", function(d) { return x(d.x) })
				  .attr("y", function(d) { return y(d.y) })
				  .attr("width", boxwidth )
				  .attr("height", y.bandwidth() )
				  .attr("name", function(d) { return d.y; })
				  .attr("units","")
				  .attr("value", function(d) { 
					return d.value.toFixed(1) + " @ " + d.x;
					})
				  .attr("fill", function(d) { return MapColour[PROPERTYID](d.value,minvalue,maxvalue); } )
				  .attr("stroke","none")
				  .call(this.tip),
				 update => update					
					.attr("value", function(d) { 
						if (d.value == undefined) return "Unknown" + " @ " + d.x;
						return d.value.toFixed(1) + "[UNITS] @ " + d.x;
					})
					.transition()
					.duration(1000)
					.attr("fill", function(d) { return MapColour[PROPERTYID](d.value,minvalue,maxvalue); } ));
		}
		
		margin.left -= 20;
		margin.bottom -= 20;	
	}	
}