import os
import sys

sys.path.insert(0,os.path.dirname(os.path.dirname(os.path.dirname(__file__))))

import datetime
import traceback
import mplreport
import numpy as np

@mplreport.ardireport("[NAME]")
def CreateReport(report,args):       
    #Figure out the number of samples we are going to need (in this case, 10-second samples).
    samples = 500
    propertyname = "[PROPERTY]"

    #Our AQL query goes here
    query = "('[ASSET]') ASSET '[RELATIONSHIP]' RELATIONSHIP 'downi' RELATED ('" + propertyname + "') PROPERTYEX VALUES"       

    #Get the pandas data-frame with the results.
    rdata = report.GetHistory(query,samples=samples,md=True)
    df = rdata.data

    fig,ax = report.CreatePage(1)
    report.Title()
    
    yticks = []
    yticklabels = []

    img = np.empty([len(df.columns),samples])

    minval = None
    maxval = None

    offset = -1
    for indx,rw in df.iterrows():
        offset += 1
        if offset >= samples:
            break

        for c in range(0,len(df.columns)):
            vl = rw[df.columns[c]]
            img[c,offset] = vl
            if minval is None or minval > vl:
                minval = vl
            if maxval is None or maxval < vl:
                maxval = vl

    indx = -1
    for c in df.columns:
        indx += 1
        yticks.append(indx)
        if indx == 0 or indx == len(df.columns)-1:
            yticklabels.append(c.replace(propertyname,"").strip())
        else:
            yticklabels.append("")

    yticklabels = report.SimplifyTicks(yticklabels)

    cmapname = 'viridis'
    colourmap = report.GetAnalogueColourMap(rdata,df.columns[0])
    if colourmap is not None:        
        minval = colourmap[1]
        maxval = colourmap[2]
        cmapname = colourmap[0]
        
    if minval is not None and minval < 0 and maxval > 0:
        largest = maxval
        if abs(minval) > largest:
            largest = abs(minval)
        minval = -largest
        maxval = largest
        cmapname = 'bwr'

    if minval is None:        
        report.FailedAxis(ax,"No History Available")
    else:
        hmap = ax.imshow(img,aspect='auto',interpolation='nearest',cmap=cmapname,vmin=minval,vmax=maxval)
        cb = report.figure.colorbar(hmap)    
            
        ax.margins(x=0,y=0)
        report.HeatMapTimeAxis(ax.xaxis,samples)
        
        cb.set_label('[PROPAXIS]')
        ax.set_yticks(yticks)
        ax.set_yticklabels(yticklabels)

    ax.set_xlabel('Time')
    ax.set_ylabel('Asset')

    #Save this report out.
    report.Save()
