import os
import sys

sys.path.insert(0,os.path.dirname(os.path.dirname(os.path.dirname(__file__))))

import datetime
import traceback
import mplreport
import matplotlib as mpl
import numpy as np
from matplotlib.patches import Patch

@mplreport.ardireport("[NAME]")
def CreateReport(report,args):       
    #Figure out the number of samples we are going to need (in this case, 10-second samples).
    samples = 500
    propertyname = "[PROPERTY]"

    #Our AQL query goes here
    query = "('[ASSET]') ASSET '[RELATIONSHIP]' RELATIONSHIP 'downi' RELATED ('" + propertyname + "') PROPERTYEX VALUES"       

    #Get the pandas data-frame with the results.
    rdata = report.FetchHistory(query,samples=samples)
    df = rdata.data

    value = rdata.GetValueMap(df.columns[0])
    colour = rdata.GetColourMap(df.columns[0])        
    
    fig,ax = report.CreatePage(1)
    report.Title()
    
    yticks = []
    yticklabels = []

    lastrow = None
    lastindex = None    
    offset = -1
    for indx,rw in df.iterrows():
        if lastrow is None:
            lastrow = rw
            lastindex = indx

            lastvalue = {}
            lastdate = {}
            for n in df.columns:
                lastvalue[n] = lastrow[n]
                lastdate[n] = indx
            continue

        offset = 0
        for n in df.columns:
            if lastvalue[n] != rw[n]:
                ax.broken_barh([(lastdate[n],indx - lastdate[n])],(offset-0.5,1),facecolor=colour[lastvalue[n]])
                lastvalue[n] = rw[n]
                lastdate[n] = indx
            offset += 1

    offset = 0
    for n in df.columns:
        if lastdate[n] != indx:
            ax.broken_barh([(lastdate[n],indx - lastdate[n])],(offset-0.5,1),facecolor=colour[lastvalue[n]])            
        offset += 1

    indx = -1
    for c in df.columns:
        indx += 1
        yticks.append(indx)
        if indx == 0 or indx == len(df.columns)-1:
            yticklabels.append(c.replace(propertyname,"").strip())
        else:
            yticklabels.append("")

    yticklabels = report.SimplifyTicks(yticklabels)    
        
    ax.margins(x=0,y=0)
    report.TimeAxis(ax.xaxis)

    ax.set_xlabel('Time')
    ax.set_ylabel('Asset')    
    ax.set_yticks(yticks)
    ax.set_yticklabels(yticklabels)

    #Custom Legend
    legend_elements = report.GetDiscreteLegend(rdata,df.columns[0])[0]

    ax.legend(handles=legend_elements)

    #Save this report out.
    report.Save()
