import os
import sys

sys.path.insert(0,os.path.dirname(os.path.dirname(os.path.dirname(__file__))))

import datetime
import traceback
import mplreport

@mplreport.ardireport("[NAME]")
def CreateReport(report,args):       
    #Figure out the number of samples we are going to need (in this case, 10-second samples).
    samples = 1000
    propertyname = "[PROPERTY]"

    #Our AQL query goes here
    query = "('[ASSET]') ASSET '[RELATIONSHIP]' RELATIONSHIP 'downi' RELATED ('" + propertyname + "') PROPERTYEX VALUES"       

    #Get the pandas data-frame with the results.
    df = report.GetHistory(query,samples=samples)    

    fig,ax = report.CreatePage(1)
    report.Title()
    
    for col in df.columns:
        ax.plot(df[col],label=col.replace(propertyname,"").strip())

    report.Grid(ax)
    ax.legend()    
    ax.margins(x=0)
    report.Grid(ax)
    report.TimeAxis(ax.xaxis)

    ax.set_xlabel('Time')
    ax.set_ylabel('[PROPAXIS]')

    #Save this report out.
    report.Save()