<?php

if (!function_exists('DrawHeader'))
{
	function DrawHeader($name,$code)
	{
		echo '<tr><td><h3>'.$name.'</h3></td></tr>';	
		echo '<tr><td><a href="index?method=types">Types Only</a>&nbsp;&nbsp;&nbsp;<a href="index">All Tests</a></td></tr>';				
		//echo '<tr><td><a href="#" onclick="CheckMatching(\'.'.$code.'.checkbox\'); return false;">Check</a>&nbsp;&nbsp;&nbsp;<a href="#" onclick="UncheckMatching(\'.'.$code.'.checkbox\'); return false;">Uncheck</a><br/><hr/></td></tr>';
	}
}
$method = "report";
if (!isset($_REQUEST['mode']))
	$mode = "query";
else
	$mode = $_REQUEST['mode'];

include_once($installfolder.'/model/property.php');


$allprops = Properties::GetAllProperties();

if ($mode == "query")
{
	//Get practical property usage figures...
	$alltypelist = array();
	$query = $db->query("SELECT id,name FROM assets WHERE type=1");
				
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		$alltypelist[] = $row['id'];
	}
		
	$typelist = array();	
	$qry = "SELECT DISTINCT parentasset FROM assetrelationships WHERE relationship=3 AND childasset NOT IN (".implode(',',$alltypelist).")";	
	$query = $db->query($qry);
				
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		$typelist[] = $row['parentasset'];
	}
	
	$storage = $sitefolder.'/firstsite';
	if (!file_exists($storage))
		@mkdir($storage);
	
	$header = "";
	$touched = array();
	DrawHeader("Types","type");
	foreach($typelist as $t)
	{
		//echo 'Type ID: '.$t;
		$asx = new Asset($t);				
		
		$qry = "SELECT DISTINCT name,id FROM assetrelationships JOIN assets ON (assets.id = assetrelationships.childasset) WHERE relationship=3 AND parentasset=".$t." ORDER BY name ASC";	
		$query = $db->query($qry);
					
		while($row = $query->fetch(PDO::FETCH_ASSOC)) 
		{
			if (in_array($row['id'],$touched))
				continue;
			
			if ($header != $asx->name)
			{
				echo '<tr><td><strong>'.$asx->name.'</strong></td></tr>';
				$header = $asx->name;
			}
			
			//Check for AI file...			
			$clas = 'statusline';
			$filename = 'type_'.$t.'_'.$row['id'].'.json';
			$filename = $storage.'/'.$filename;
			
			//echo 'Checking '.$filename;
			if (!file_exists($filename))
				$clas = 'deadline';					
			
			$touched[] = $row['id'];
			echo '<tr><td><div class="'.$clas.' unknown"id="type_'.$t.'_'.$row['id'].'" name="type_'.$t.'_'.$row['id'].'"';				
			echo '><div class="status unknown"></div><a target="_blank" href="type?mode=report&param0=type&param1='.$t.'&param2='.$row['id'].'">'.$row['name'].'</a></div></td></tr>';
		}
		
	}
	
}

if ($mode == "aitraining")
{
	$activetype = filter_var($_REQUEST['param1'],FILTER_VALIDATE_INT);
	$activeasset = filter_var($_REQUEST['param2'],FILTER_VALIDATE_INT);
	$typeasset = new Asset($activetype);
	
	$alist = array();	
	$qry = "SELECT DISTINCT childasset FROM assetrelationships WHERE relationship=3 AND parentasset=".$activetype;
	//echo $qry;
	$query = $db->query($qry);
				
	while($row = $query->fetch(PDO::FETCH_ASSOC)) 
	{
		$alist[] = $row['childasset'];
	}
	
	$title = "";
	$overall = "OK";
	
	$resultsets = array();
	$issues = array();
	$markups = array();
	
	global $sitefolder;
	
	$storage = $sitefolder.'/firstsite';
	if (!file_exists($storage))
		@mkdir($storage);

	$filename = 'type_'.$activetype.'_'.$activeasset.'.json';
	$filename = $storage.'/'.$filename;
	
	//echo 'Checking '.$filename;

	$results = array();
	//echo 'AI Training Data..';
	if (file_exists($filename))
	{				
		$jitter = 0.05;
		
		$items = json_decode(file_get_contents($filename),true);
		foreach($items as $vx)
		{			
			$result = array();			
			$result['scaled'] = array();
			foreach($vx as $v)
			{
				if ($v['rawvalue'] == '^') $v['rawvalue'] = 0;
				$result['scaled'][] = floatval($v['rawvalue']);
			}
			$results[] = $result;
		}		
		
		if (!isset($_REQUEST['jitter'])) {
			//This time with added jitter
			foreach($items as $vx)
			{			
				$result = array();				
				$result['scaled'] = array();
				foreach($vx as $v)
				{
					if ($v['rawvalue'] == '^') $v['rawvalue'] = 0;					
					$result['scaled'][] = floatval($v['rawvalue'])+$jitter;					
				}
				$results[] = $result;
			}
			
			//This time with removed jitter
			foreach($items as $vx)
			{			
				$result = array();				
				$result['scaled'] = array();
				foreach($vx as $v)
				{
					if ($v['rawvalue'] == '^') $v['rawvalue'] = 0;
					$result['scaled'][] = floatval($v['rawvalue'])-$jitter;					
				}
				$results[] = $result;
			}
		}
					
	}
	header('Content-Type: application/json');
	echo json_encode($results);
	exit();
}

if (($mode == "process") || ($mode == "report") || ($mode == 'aicurrent'))
{	
	$activetype = filter_var($_REQUEST['param1'],FILTER_VALIDATE_INT);
	$activeasset = filter_var($_REQUEST['param2'],FILTER_VALIDATE_INT);
	
	$storage = $sitefolder.'/firstsite';
	if (!file_exists($storage))
		@mkdir($storage);

	$filename = 'type';

	$param = 1;
	$parameters = array();
	$parameters[0] = $_REQUEST['param1'];
	$parameters[1] = $_REQUEST['param2'];

	$filename .= '_'.implode('_',array_values($parameters)).'.json';

	$filename = $storage.'/'.$filename;
	
	if (!file_exists($filename))
	{
		if ($mode == "process")
		{
			echo 'unknown';
			exit;
		}
	}
	
	
	$typeasset = new Asset($activetype);
	
	$alist = array();	
	
	$alist[] = $activeasset;
	
	$title = "";
	$overall = "OK";
	
	$resultsets = array();
	$issues = array();
	$markups = array();
	
	global $sitefolder;
	
	foreach($alist as $assid)
	{
		$ass = new Asset($assid);
		$query = "'".$ass->name."' AIPOINTS VALUES";
		$queryurl = 'http://localhost/'.$siteroot.'/aql/api/query?query='.urlencode($query);	
		$resp = file_get_contents($queryurl);	
		
		$value = json_decode($resp,true);
		$values = $value['results'][0]['value'];
		
		$attime = "";
		if (isset($_REQUEST['at']))
		{
			$attime = $_REQUEST['at'];
			if (is_numeric($attime))
			{
				//Parse a UTC datetime...
				$attime = gmdate('Y-m-d H:i:s',intval($attime/1000));					
			}
		}
		
		if ($attime != "")
		{
			$dt = DateTimeImmutable::createFromFormat("Y-m-d H:i:s",$attime);
			$en = $dt->add(new DateInterval("PT10S"));
			$en = $en->format("Y-m-d H:i:s");
			
			$histquery = "'".$ass->name."' AIPOINTS VALUES {\"start\": \"".$attime."\",\"end\": \"".$en."\",\"grain\": -10} GETHISTORY";
			$queryurl = 'http://localhost/'.$siteroot.'/aql/api/table?query='.urlencode($histquery)."&format=csv";	
			$table = file_get_contents($queryurl);
			$history = explode("\n",$table);	
			
			$headers = explode(',',$history[0]);
			$dta = explode(',',$history[1]);
			
			//print_r($table);
					
			//Load historical values into the active value list...
			for($x=0;$x<count($headers);$x++)
			{
				$vx = -1;
				foreach($values as $v)
				{
					$vx++;
					$nm = $v['name'].' '.$v['propname'];
					if ($nm == $headers[$x])
					{
						$values[$vx]['rawvalue'] = round(floatval($dta[$x]),3);
						//echo 'Replacing Value '.$values[$vx]['rawvalue'];
						break;
					}
				}
			}		
			
			//exit();
			
			unset($history);
		}
		
		for($x=0;$x<count($values);$x++)
		{
			$scl = $values[$x]['rawvalue'];		
			if ($values[$x]['rawvalue'] == '^') 
				$scl = 0;
			else
			{
				if (isset($values[$x]['min']))
				{
					$scl = ($scl - floatval($values[$x]['min'])) / (floatval($values[$x]['max']) - floatval($values[$x]['min']));
				}
				else
				{
					$mn = FALSE;
					$mx = FALSE;					
					foreach($values[$x]['map'] as $k => $v)
					{
						if (($mn === FALSE) || ($mn > $k))
						{
							$mn = $k;
						}
						if (($mx === FALSE) || ($mx < $k))
						{
							$mx = $k;
						}						
					}
					if (($mx - $mn) == 0)
					{
						$scl = 0;
					}
					else
						$scl = ($scl - $mn) / ($mx - $mn);
				}
			}		
			$values[$x]['rawvalue'] = $scl;		
		}
		
		$resultsets[$assid] = $values;
		
		break;
	}
	
	
	//print_r($values);
	
	if ($mode == 'aicurrent')
	{
		$results = array();
		$results['scaled'] = array();
		foreach($values as $v)
		{
			$results['scaled'][] = floatval($v['rawvalue']);
		}
		
		header('Content-Type: application/json');
		echo json_encode($results);
		exit();
	}
	
	if ($mode == 'process')
	{
		$p1 = filter_var($_REQUEST['param1'],FILTER_VALIDATE_INT);
		$p2 = filter_var($_REQUEST['param2'],FILTER_VALIDATE_INT);
		$cmd = '"'.PythonPath().'" "'.$installfolder.'/addons/firstsite/python/aicompare.py" "127.0.0.1'.$siteroot.'" "'.$sitefolder.'/firstsite" type '.$p1.' '.$p2.' -p';
		//echo $cmd;
		//$res = exec($cmd);
		$descriptorspec = array(
		   0 => array("pipe", "r"),  // stdin is a pipe that the child will read from
		   1 => array("pipe", "w"),  // stdout is a pipe that the child will write to
		   2 => array("pipe", "w") // stderr is a file to write to
		);
		$valueset = array();
		foreach($values as $v)
		{
			$valueset[] = $v['rawvalue'];
		}
		$process = proc_open($cmd, $descriptorspec, $pipes);
		if (is_resource($process))
		{
			fwrite($pipes[0],json_encode($valueset));
			fclose($pipes[0]);
			
			$res = stream_get_contents($pipes[1]);
			$err = stream_get_contents($pipes[2]);
			$rval = proc_close($process);
		}
		$res = trim($res);
		if (($res != "OK") && ($res != "OK*"))
			echo 'WARNING ('.$res.')';
		else
			echo str_replace("*","",$res);
		exit;
	}
	
	
	$title = $typeasset->name." FirstSite Analysis";
	
	include($installfolder.'/include/tmpl.php');
	
	
	?>

		<script src="/addons/dexplore/d3v7.js"></script>
		<style>
		
.results 
{
	display: block;
	padding: 10px;
	border-radius: 5px;
	border: 1px solid black;
	color: black;
	font-size: 20px;
	font-weight: bold;
	width: auto;
	margin-bottom: 0.5em;
}

.results.OK
{
	background-color: green;
	color: white;
}

.results.WARNING
{
	background-color: yellow;
	color: black;
}

.results.ERROR
{
	background-color: red;
	color: white;
}

.results.EMPTY
{
	background-color: #777777;
	color: white;
}

.tick
{

}	

.axis line
{
	stroke: silver;
}

.axis path
{
	stroke: silver;
}

.axis text
{
	fill: black;
	font-size: 8px;
}

.xaxis text
{
	fill: none;
	font-size: 8px;
}

.legend
{
	font-size: 5px;
}
		</style>
		<script src="firstsite.js"></script>
		<script>
function RadarChart(id, data, options) {
	var cfg = {
	 w: 600,				//Width of the circle
	 h: 600,				//Height of the circle
	 x: 0,
	 y: 0,
	 margin: {top: 20, right: 20, bottom: 20, left: 20}, //The margins of the SVG
	 levels: 3,				//How many levels or inner circles should there be drawn
	 maxValue: 0, 			//What is the value that the biggest circle will represent
	 labelFactor: 1.25, 	//How much farther than the radius of the outer circle should the labels be placed
	 wrapWidth: 60, 		//The number of pixels after which a label needs to be given a new line
	 opacityArea: 0.35, 	//The opacity of the area of the blob
	 dotRadius: 4, 			//The size of the colored circles of each blog
	 opacityCircles: 0.1, 	//The opacity of the circles of each blob
	 strokeWidth: 2, 		//The width of the stroke around each blob
	 roundStrokes: false,	//If true the area and stroke will follow a round path (cardinal-closed)
	 color: d3.scaleOrdinal(d3.schemeCategory10),	//Color function
	 update: false,
	 animtime: 1000
	};
	

	
	//Put all of the options into a variable called cfg
	if('undefined' !== typeof options){
	  for(var i in options){
		if('undefined' !== typeof options[i]){ cfg[i] = options[i]; }
	  }//for i
	}//if
	
	var ew = cfg.w - (cfg.margin.left + cfg.margin.right);
	var eh = cfg.h - (cfg.margin.top + cfg.margin.bottom);
	
	//If the supplied maxValue is smaller than the actual one, replace by the max in the data
	var maxValue = cfg.maxValue;//Math.max(cfg.maxValue, d3.max(data, function(i){return d3.max(i.map(function(o){return o.value;}))}));
		
	var allAxis = (data[0].map(function(i, j){return i.axis})),	//Names of each axis
		total = allAxis.length,					//The number of different axes
		radius = Math.min(ew/3, eh/3), 	//Radius of the outermost circle
		Format = d3.format(''),			 	//Percentage formatting
		angleSlice = Math.PI * 2 / total;		//The width in radians of each "slice"
	
	//Scale for the radius
	var rScale = d3.scaleLinear()
		.range([0, radius])
		.domain([0, maxValue]);
		
	/////////////////////////////////////////////////////////
	//////////// Create the container SVG and g /////////////
	/////////////////////////////////////////////////////////

	//Remove whatever chart with the same id/class was present before
	//d3.select(id).select("svg").remove();
	
	if (cfg.update == false) {
		//Initiate the radar chart SVG
		var svg = d3.select(id).append("svg")
				.attr("width",  cfg.w)
				.attr("height", cfg.h)
				.attr("class", "radar"+id);
				
		
		
		//Append a g element		
		var g = svg.append("g")
				.attr("transform", "translate(" + (ew/2 + cfg.margin.left) + "," + (eh/2 + cfg.margin.top) + ")")
				.attr("class","group");
		
		/////////////////////////////////////////////////////////
		////////// Glow filter for some extra pizzazz ///////////
		/////////////////////////////////////////////////////////
		
		//Filter for the outside glow
		var filter = g.append('defs').append('filter').attr('id','glow'),
			feGaussianBlur = filter.append('feGaussianBlur').attr('stdDeviation','2.5').attr('result','coloredBlur'),
			feMerge = filter.append('feMerge'),
			feMergeNode_1 = feMerge.append('feMergeNode').attr('in','coloredBlur'),
			feMergeNode_2 = feMerge.append('feMergeNode').attr('in','SourceGraphic');

		/////////////////////////////////////////////////////////
		/////////////// Draw the Circular grid //////////////////
		/////////////////////////////////////////////////////////
		
		//Wrapper for the grid & axes
		var axisGrid = g.append("g").attr("class", "axisWrapper");
		
		//Draw the background circles
		axisGrid.selectAll(".levels")
		   .data(d3.range(1,(cfg.levels+1)).reverse())
		   .enter()
			.append("circle")
			.attr("class", "gridCircle")
			.attr("r", function(d, i){return radius/cfg.levels*d;})
			.style("fill", "#CDCDCD")
			.style("stroke", "#CDCDCD")
			.style("fill-opacity", cfg.opacityCircles)
			.style("filter" , "url(#glow)");

		//Text indicating at what % each level is
		axisGrid.selectAll(".axisLabel")
		   .data(d3.range(1,(cfg.levels+1)).reverse())
		   .enter().append("text")
		   .attr("class", "axisLabel")
		   .attr("x", 4)
		   .attr("y", function(d){return -d*radius/cfg.levels;})
		   .attr("dy", "0.4em")
		   .style("font-size", "10px")
		   .attr("fill", "#737373")
		   .text(function(d,i) { 
				return Format(maxValue * d/cfg.levels); 
			});

		/////////////////////////////////////////////////////////
		//////////////////// Draw the axes //////////////////////
		/////////////////////////////////////////////////////////
		
		//Create the straight lines radiating outward from the center
		var axis = axisGrid.selectAll(".axis")
			.data(allAxis)
			.enter()
			.append("g")
			.attr("class", "axis");
		//Append the lines
		axis.append("line")
			.attr("x1", 0)
			.attr("y1", 0)
			.attr("x2", function(d, i){ return rScale(maxValue*1.1) * Math.cos(angleSlice*i - Math.PI/2); })
			.attr("y2", function(d, i){ return rScale(maxValue*1.1) * Math.sin(angleSlice*i - Math.PI/2); })
			.attr("class", "line")
			.style("stroke", "white")
			.style("stroke-width", "2px");

		//Append the labels at each axis
		axis.append("text")
			.attr("class", "legend")
			.style("font-size", "6px")
			.attr("text-anchor", "middle")
			.attr("dy", "0.35em")
			.attr("x", function(d, i){ return rScale(maxValue * cfg.labelFactor) * Math.cos(angleSlice*i - Math.PI/2); })
			.attr("y", function(d, i){ return rScale(maxValue * cfg.labelFactor) * Math.sin(angleSlice*i - Math.PI/2); })
			.text(function(d){return d})
			.call(wrap, cfg.wrapWidth);
	}
	else
	{
		var svg = d3.select(id).select("svg");
				
		var g = svg.select(".group");
				
	}
	/////////////////////////////////////////////////////////
	///////////// Draw the radar chart blobs ////////////////
	/////////////////////////////////////////////////////////
	
	//The radial line function
	var radarLine = d3.lineRadial()		
		.radius(function(d) { return rScale(d.value); })
		.angle(function(d,i) {	return i*angleSlice; })
		.curve(d3.curveCardinalClosed);
		
	if(cfg.roundStrokes) {
		radarLine.curve(d3.curveCardinalClosed);
	}
				
	svg.selectAll(".radarWrapper").remove();
				
	//Create a wrapper for the blobs	
	var blobWrapper = g.selectAll(".radarWrapper")
		.data(data)
		.enter()
			.append("g")
				.attr("class", "radarWrapper");
			
	//Append the backgrounds	
	var blobArea = g.selectAll(".radarArea").data(data)
		.join(
			enter => enter.append("path")
				.attr("d", function(d,i) { return radarLine(d); })
				.attr("class", "radarArea")
				.attr("d", function(d,i) { return radarLine(d); })
				.style("fill", function(d,i) { return cfg.color(i); })
				.style("fill-opacity", cfg.opacityArea)
				.on('mouseover', function (d,i){
					//Dim all blobs
					d3.selectAll(".radarArea")
						.transition().duration(200)
						.style("fill-opacity", 0.1); 
					//Bring back the hovered over blob
					d3.select(this)
						.transition().duration(200)
						.style("fill-opacity", 0.7);	
				})
				.on('mouseout', function(){
					//Bring back all blobs
					d3.selectAll(".radarArea")
						.transition().duration(200)
						.style("fill-opacity", cfg.opacityArea);
				}),
			update => update
				.transition()
				.duration(cfg.animtime)
				.ease(d3.easeLinear)
				.attr("d", function(d,i) { return radarLine(d); })
		  )		
		
	//Create the outlines	
	var blobOutline = g.selectAll(".radarStroke").data(data)
		.join(
			enter => enter.append("path")
				.attr("class", "radarStroke")
				.attr("d", function(d,i) { return radarLine(d); })
				.style("stroke-width", cfg.strokeWidth + "px")
				.style("stroke", function(d,i) { return cfg.color(i); })
				.style("fill", "none")
				.style("filter" , "url(#glow)"),			
			update => update
				.transition()
				.duration(cfg.animtime)
				.ease(d3.easeLinear)
				.attr("d", function(d,i) { return radarLine(d); })
		);				
	
	//Append the circles
	//blobWrapper.selectAll(".radarCircle")
	var blobCircles = g.selectAll(".radarCircle").data(data[0]).join(
			enter => enter.append("circle")
				.attr("class", "radarCircle")
				.attr("r", cfg.dotRadius)
				.attr("cx", function(d,i){ 
					return rScale(d.value) * Math.cos(angleSlice*i - Math.PI/2); 
				})
				.attr("cy", function(d,i){ 
					return rScale(d.value) * Math.sin(angleSlice*i - Math.PI/2); 
				})
				.style("fill", function(d,i,j) { return cfg.color(j); })
				.style("fill-opacity", 0.8),
			update => update
				.transition()
				.duration(cfg.animtime)
				.ease(d3.easeLinear)
				.attr("cx",function(d,i){ return rScale(d.value) * Math.cos(angleSlice*i - Math.PI/2); })
				.attr("cy", function(d,i){ return rScale(d.value) * Math.sin(angleSlice*i - Math.PI/2); }));

	/////////////////////////////////////////////////////////
	//////// Append invisible circles for tooltip ///////////
	/////////////////////////////////////////////////////////
	
	//Wrapper for the invisible circles on top
	var blobCircleWrapper = g.selectAll(".radarCircleWrapper")
		.data(data)
		.enter().append("g")
		.attr("class", "radarCircleWrapper");
		
	//Append a set of invisible circles on top for the mouseover pop-up
	blobCircleWrapper.selectAll(".radarInvisibleCircle")
		.data(function(d,i) { return d; })
		.enter().append("circle")
		.attr("class", "radarInvisibleCircle")
		.attr("r", cfg.dotRadius*1.5)
		.attr("cx", function(d,i){ return rScale(d.value) * Math.cos(angleSlice*i - Math.PI/2); })
		.attr("cy", function(d,i){ return rScale(d.value) * Math.sin(angleSlice*i - Math.PI/2); })
		.style("fill", "none")
		.style("pointer-events", "all")
		.on("mouseover", function(d,i) {
			newX =  parseFloat(d3.select(this).attr('cx')) - 10;
			newY =  parseFloat(d3.select(this).attr('cy')) - 10;
					
			tooltip
				.attr('x', newX)
				.attr('y', newY)
				.text(d.currentTarget.__data__.axis + ": " + Format(d.currentTarget.__data__.value.toFixed(2)) + "%")
				.transition().duration(200)
				.style('opacity', 1);
		})
		.on("mouseout", function(){
			tooltip.transition().duration(200)
				.style("opacity", 0);
		});
		
	//Set up the small tooltip for when you hover over a circle
	var tooltip = g.append("text")
		.attr("class", "tooltip")
		.attr("fill", "green")
		.style("opacity", 0);
	
	/////////////////////////////////////////////////////////
	/////////////////// Helper Function /////////////////////
	/////////////////////////////////////////////////////////

	//Taken from http://bl.ocks.org/mbostock/7555321
	//Wraps SVG text	
	function wrap(text, width) {
	  text.each(function() {
		var text = d3.select(this),
			words = text.text().split(/\s+/).reverse(),
			word,
			line = [],
			lineNumber = 0,
			lineHeight = 1.4, // ems
			y = text.attr("y"),
			x = text.attr("x"),
			dy = parseFloat(text.attr("dy")),
			tspan = text.text(null).append("tspan").attr("x", x).attr("y", y).attr("dy", dy + "em");
			
		while (word = words.pop()) {
		  line.push(word);
		  tspan.text(line.join(" "));
		  if (tspan.node().getComputedTextLength() > width) {
			line.pop();
			tspan.text(line.join(" "));
			line = [word];
			tspan = text.append("tspan").attr("x", x).attr("y", y).attr("dy", ++lineNumber * lineHeight + dy + "em").text(word);
		  }
		}
	  });
	}//wrap	
	
}//RadarChart		
		
var data = [];
var markups = [];
		
<?php foreach($resultsets as $k => $v)
{
?>
data = <?php echo json_encode($v); ?>;
<?php
}
?>

function ResetAI()
{
	if (window.confirm('Are you sure you want to remove all AI training data for this FirstSite category?') == true)
	{
		<?php if (count($values) > 0)
		{?>
		ClearResults(data,'type',<?php echo $activetype;?>,0);<?php }; ?>
	}
}

function DrawReports()
{
	var margin = {top: 20, bottom: 20, left: 60, right: 40};		
	var svg = d3.select('#vis');

	var width =	700;
	var height = 500;
	
	var dt = [];
	for(var x=0;x<data.length;x++)
	{			
		dt.push({"axis": data[x].name + " " + data[x].propname, "value": parseFloat(data[x].rawvalue)*100});
	}
	this.dtx = [dt];
	
	var radarChartOptions = {
		  w: width,
		  h: height,			  
		  margin: margin,
		  maxValue: 1,
		  levels: 5,
		  roundStrokes: true,
		  color:  d3.scaleOrdinal().range(["purple"]),
		  minValue: 0,
		  maxValue: 100,
		  update: false,
		  animtime: 200
		};
		
	//Call function to draw the Radar chart
	RadarChart("#vis", this.dtx, radarChartOptions);
}

<?php
//};

foreach($markups as $mu)
{?>
markups.push({'style': '<?php echo $mu[0];?>', 'location': '<?php echo $mu[1];?>'});
<?php } ?>
	
		</script>
<?php		

SS('head');
?>
DrawReports();
<?php
SS('onload');


T('header-basic','title='.$title);

ST('section','class=content');
	
		//Get AI Analysis...		
		ST('row');	
			ST('full');
				ST('box');
				$showfocus = false;
					if (file_exists($filename))
					{
						//echo '<h3>AI Results</h3>';						
						//echo '<div class="airesp" style="font-weight: bold; font-size: larger;">';
						$p1 = filter_var($_REQUEST['param1'],FILTER_VALIDATE_INT);
						$p2 = filter_var($_REQUEST['param2'],FILTER_VALIDATE_INT);
						$cmd = '"'.PythonPath().'" "'.$installfolder.'/addons/firstsite/python/aicompare.py" "127.0.0.1'.$siteroot.'" "'.$sitefolder.'/firstsite" type '.$p1.' '.$p2.' -p';
						//echo $cmd;
						//$res = exec($cmd);
						$descriptorspec = array(
						   0 => array("pipe", "r"),  // stdin is a pipe that the child will read from
						   1 => array("pipe", "w"),  // stdout is a pipe that the child will write to
						   2 => array("pipe", "w") // stderr is a file to write to
						);
						$valueset = array();
						foreach($values as $v)
						{
							$valueset[] = $v['rawvalue'];
						}
						$process = proc_open($cmd, $descriptorspec, $pipes);
						if (is_resource($process))
						{
							fwrite($pipes[0],json_encode($valueset));
							fclose($pipes[0]);
							
							$res = stream_get_contents($pipes[1]);
							$err = stream_get_contents($pipes[2]);
							$rval = proc_close($process);
						}
						
						echo '<div class="results '.str_replace("*","",$res).'">'.$res.'</div>';
						
						$rx = str_replace("*","",trim($res));						
						if ($rx != "OK")
						{
							$showfocus = true;
						}
						else
							$showfocus = true;
						?>
						<br/><button type="button" class="btn btn-success" onclick="SubmitResults(data,'type',<?php echo $activetype;?>,<?php echo $activeasset;?>);" style="margin-right: 1em;">This Is Normal</button><button type="button" class="btn btn-warning" onclick="ResetAI();">Reset AI Training Data</button><?php
						//echo $cmd;
					}
					else
					{
						echo '<h3>AI Results Not Available</h3>';
						echo '<p>You need to train the AI using the <strong>This Is Normal</strong> button to prepare an AI</p>';?>
						<br/><button type="button" class="btn btn-success" onclick="SubmitResults(data,'type',<?php echo $activetype;?>,<?php echo $activeasset;?>);">This Is Normal</button><br/><?php
					}
				ET();
			ET();			
		ET();
ET();?>
	
	
			<svg id="vis" class="vis" style="max-height: 800px; text-align: center;" viewBox="0 0 700 500">
			
			</svg><?php
	ST('row');	
		ST('full');
			ST('full');
				if ($showfocus == true)
				{
				ST('box');
					//Pull training data	
					$filename = 'type_'.$activetype.'_'.$activeasset.'.json';
					$filename = $storage.'/'.$filename;
					
					//echo 'Checking '.$filename;

					//$results = array();
					$bestmatch = "";
					$bestmatchoffset = 9999;
					if (file_exists($filename))
					{
						$indx = -1;
						$items = json_decode(file_get_contents($filename),true);
						foreach($items as $vx)
						{			
							$indx++;
							$matchsize = 0;							
							$fitdata = array();
							for($x=0;$x<count($values);$x++)
							{
								$diff = abs($values[$x]['rawvalue'] - $vx[$x]['rawvalue']);
								$clr = "#009900";
								
								if ($diff >= 0.005)
									$clr = "#009999";
								
								if ($diff > 0.01)
									$clr = "#990000";
								
								$fitdata[$values[$x]['name'].' '.$values[$x]['propname']] = round($diff*100,2);//$ex .= '<label style="color: '.$clr.'">'.$values[$x]['name'].' '.$values[$x]['propname'].':</label> '.round($diff*100,2)."%<br/>";
								if ($diff > $matchsize)
								{
									$matchsize = $diff;									
								}								
							}
							if ($bestmatchoffset > $matchsize)
							{
								//echo 'New Best Match';
								$bestmatch = $fitdata;
								$bestmatchoffset = $matchsize;
							}		
						}
						?>
						<h3>Differences to Closest Training Data</h3><hr/>
						<?php
						$keys = array_keys($bestmatch);
						sort($keys);
						
						foreach($keys as $k)
						{
							$clr = "#009900";
							$v = $bestmatch[$k];
							if ($v > 0.5) $clr = '#009999';
							if ($v > 2) $clr = '#990000';
							echo '<label style="color: '.$clr.'">'.$k.'</label>: '.round($v,2).'%<br/>';
						}
															
					}						
				ET();
				}
			ET();
		ET();
	ET();
	
}

?>
<div class="tooltip" id="internal_tooltip" style="display: none; pointer-events: none; color: black; position: absolute; font-size: small; background-color: white; max-width: 200px; border: 1px solid black; border-radius: 5px; padding: 5px;opacity: 1; ">
			
		</div>