<?php

header('Content-Type: application/json');
$entityBody = file_get_contents("php://input");
//echo $entityBody;
$content = json_decode($entityBody,true);

function ParseTimestamp($st)
{
	$bits = explode('T',$st);
	$final = $bits[0];
	$indx = strpos($bits[1],'.');
	$final .= " ".substr($bits[1],0,$indx);
	
	//print_r($final);
	//echo '<br/>';
	
	$dt = DateTime::createFromFormat("Y-m-d H:i:s",$final);
	//print_r($dt);
	//echo '<br/>';
	return $dt;
}

$from = ParseTimestamp($content['range']['from']);
$to = ParseTimestamp($content['range']['to']);
$query = $content['annotation']['query'];

$searchsources = FALSE;
$search = FALSE;
$count = 100;
$offset = 0;

function ToJSTime($dt)
{
	return $dt->format('U') * 1000;
}

$ft = $from->format("Y-m-d H:i:s");
$tt = $to->format("Y-m-d H:i:s");

$searchsources = FALSE;
$options = explode(',',$query);
foreach($options as $opt)
{
	if (trim($opt) == "") continue;
	if ($opt == "*") continue;
	
	$bits = explode('=',$opt);
	if ($bits[0] == 'source')
	{	
		$negate = "";
		if ($bits[1][0] == '-')
		{
			$negate = "-";
			$bits[1] = substr($bits[1],1);
		}
		
		/*$query = $db->query("SELECT assetid,address,driver,assets.name,gatewayport FROM datasources JOIN assets ON (datasources.assetid = assets.id) WHERE mode=4 ORDER BY assets.name ASC");
				
		if ($query !== FALSE)
		{
			while($row = $query->fetch(PDO::FETCH_ASSOC)) 
			{
				if (strtolower($row['name']) == strtolower($bits[1]))
				{
					if ($searchsources === FALSE)
					{
						$searchsources = array();
						$searchsources[] = $negate.$row['assetid'];
					}
					else
					{
						$searchsources[] = $negate.$row['assetid'];
					}
				}
			}
		}*/
		if ($searchsources === FALSE)
		{
			$searchsources = explode(':',$bits[1]);
			//print_r($searchsources);
		}
	}
	if ($bits[0] == 'search')
	{
		$search = $bits[1];
	}
}

include($installfolder.'/model/events.php');
if ((isset($search)) && (trim($search) != ""))
{
	$eventset = Events::GetEvents($ft,$tt,$searchsources,$count,$offset,$search);
}
else
{
	$eventset = Events::GetEvents($ft,$tt,$searchsources,$count,$offset);
}
?>
[
	<?php
	$indx = 0;
	foreach($eventset as $ev)
	{
		$indx++;
		$start = ToJSTime($ev->start);
		$end = $start;
		if ($ev->instant == false)
		{
			$end = ToJSTime($ev->end);
		}
		$tagging = [$ev->source];
		foreach($ev->properties as $k => $v)
		{
			if (strpos(strtolower($k),"start")!==FALSE) continue;
			if (strpos(strtolower($k),"end")!==FALSE) continue;
			if (strpos(strtolower($k),"name")!==FALSE) continue;
			
			$tagging[] = $k.'='.strval($v);
		}
		$tagging = json_encode($tagging);
		if ($indx > 1) echo ',';
		echo '{"id":'.$indx.',"alertId":0,"alertName":"","created":'.$start.',"updated":'.$start.',"time":'.$start.',"timeEnd":'.$end.',"text":"'.$ev->name.'","tags":'.$tagging.',"data":{}}';
	}
	?>
]