<?php

OnlyShowIf(CheckAdmin());

$pagesize = 10;
$pagestart = 0;

$title = "Grafana Dashboard Builder";

include($installfolder.'/include/tmpl.php');

T('header-basic','title='.$title);

$msg = "";

include($installfolder.'/model/property.php');
$allprops = Properties::GetAllProperties();

include($installfolder.'/model/relationship.php');
$allrels = Relationships::GetAllRelationships();

ST('section','class=content');
	ST('row');
		ST('half');
			ST('box','title=Live Values (Unordered)');?>
        
					<h3>'Live' Analogue Property Values (Random Order)</h3>
					<?php
					
					foreach($allprops as $px)
					{
						if ($px->type == "MEASUREMENT")
						{
							echo '<a href="'.$siteroot.'/grafana/builder/liveprop?id='.$px->id.'">'.$px->name.'</a><br/>';
						}
						if (($px->type == "STATUS") || ($px->type == "ENUM"))
						{
							echo '<a href="'.$siteroot.'/grafana/builder/livepropdiscrete?id='.$px->id.'">'.$px->name.'</a><br/>';
						}
					}
					?>
					<br/><a href="<?php echo $siteroot;?>" class="btn btn-default">Close</a>
					<?php
				
			ET();
			ST('box','title=Trends (Unordered)');?>
        
					<h3>Trends (Unordered)</h3>
					<?php
					
					foreach($allprops as $px)
					{
						if ($px->type == "MEASUREMENT")
						{
							echo '<a href="'.$siteroot.'/grafana/builder/proptrend?id='.$px->id.'">'.$px->name.'</a><br/>';
						}
					}
					?>
					<br/><a href="<?php echo $siteroot;?>" class="btn btn-default">Close</a>
					<?php
				
			ET();
			ST('box','title=Heatmaps (Unordered)');?>
        
					<h3>Heatmaps (Unordered)</h3>
					<?php
					
					foreach($allprops as $px)
					{
						if ($px->type == "MEASUREMENT")
						{
							echo '<a href="'.$siteroot.'/grafana/builder/propheatmap?id='.$px->id.'">'.$px->name.'</a><br/>';
						}
					}
					?>
					<br/><a href="<?php echo $siteroot;?>" class="btn btn-default">Close</a>
					<?php
				
			ET();
			ST('box','title=Types');?>
        
					<h3>Types</h3>
					<?php
					
					$query = $db->query("SELECT id,name FROM assets WHERE type=1 ORDER BY name");
							
					while($row = $query->fetch(PDO::FETCH_ASSOC)) 
					{
						echo '<a href="'.$siteroot.'/grafana/builder/assettype?id='.$row['id'].'">'.$row['name'].'</a><br/>';
					}		
					?>
					<br/><a href="<?php echo $siteroot;?>" class="btn btn-default">Close</a>
					<?php
				
			ET();
		ET();
	ET();	
ET();

?>
