<?php

$id = $_REQUEST['id'];

include($installfolder.'/model/property.php');

$allprops = Properties::GetAllProperties();
foreach($allprops as $px)
{
	if ($px->id == $id)
	{
		$activeprop = $px;
		break;
	}
}

function generateRandomString($length = 8) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[random_int(0, $charactersLength - 1)];
    }
    return $randomString;
}

$friendlyname = $activeprop->name;

$pieces = explode(" - ",$friendlyname);
if (count($pieces) > 1)
{
	$friendlyname = $pieces[0].' '.$pieces[1];
}

header('Content-Type: application/json');
header('Content-Disposition: attachment; filename="'.$activeprop->name.' Current Value Grafana Dashboard.json"');
?>
{
  "__inputs": [
    {
      "name": "DS_ARDI_SERVER",
      "label": "ARDI Server",
      "description": "",
      "type": "datasource",
      "pluginId": "ardi-grafana-source",
      "pluginName": "ARDI"
    }
  ],
  "__elements": {},
  "__requires": [
    {
      "type": "datasource",
      "id": "ardi-grafana-source",
      "name": "ARDI",
      "version": "0.1.5"
    },
    {
      "type": "grafana",
      "id": "grafana",
      "name": "Grafana",
      "version": "9.2.2"
    },
    {
      "type": "panel",
      "id": "stat",
      "name": "Stat",
      "version": ""
    }
  ],
  "annotations": {
    "list": [
      {
        "builtIn": 1,
        "datasource": {
          "type": "grafana",
          "uid": "-- Grafana --"
        },
        "enable": true,
        "hide": true,
        "iconColor": "rgba(0, 211, 255, 1)",
        "name": "Annotations & Alerts",
        "target": {
          "limit": 100,
          "matchAny": false,
          "tags": [],
          "type": "dashboard"
        },
        "type": "dashboard"
      }
    ]
  },
  "editable": true,
  "fiscalYearStartMonth": 0,
  "graphTooltip": 0,
  "id": null,
  "links": [],
  "liveNow": false,
  "refresh": "10s",
  "panels": [
    {
      "datasource": {
        "type": "ardi-grafana-source",
        "uid": "${DS_ARDI_SERVER}"
      },
      "description": "",
      "fieldConfig": {
        "defaults": {
          "color": {
            "mode": "thresholds"
          },
          "mappings": [
            {
              "options": 
				  <?php

$cmap = array();
$cmap[0] = '#2222EE';
$cmap[1] = '#9999FF';

$xmlfile = $sitefolder.'/cache/display/properties/'.$activeprop->id.'.xml';
if (file_exists($xmlfile))
{		
	$xml=simplexml_load_file($xmlfile);
				
	$cmap = array();
	
	if (property_exists($xml,'colours'))
	{							
		//echo 'Colours Found!';
		$attrs = $xml->colours->attributes();
		$z = "".$attrs['zero'];
		$o = "".$attrs['one'];
		if (($z == "")) $z = 'blue';
		if (($o == "")) $o = 'cyan';							
		$cmap[0] = trim($z);
		$cmap[1] = trim($o);							
	}	

	if (property_exists($xml,'value'))
	{														
		foreach($xml->value as $vl)
		{
			$attrs = $vl->attributes();
			$pieces = explode('-',$attrs['value']);
			if ($pieces[0] == "")
			{
				unset($pieces[0]);
				$pieces = array_values($pieces);
				$pieces[0] = '-'.$pieces[0];
			}								
			if (count($pieces) > 1)
			{
				for($x=0;$x<count($pieces);$x++)
				{
					$cmap[$pieces[$x]] = "".$attrs['colour'];
				}
			}
			else
			{
				$cmap["".$attrs['value']] = "".$attrs['colour'];
			}
		}	
	}	
}	
		
$indx = 0;		
$mapping = array();				  
$map = $activeprop->GetValueMap();
foreach($map as $k => $v)
{	
	$dd = array();
	$dd['color'] = $cmap[$k];
	$dd['index'] = $indx;
	$dd['text'] = $v;
	$mx[$k] = $dd;	
	
	$indx++;
}
				 
echo json_encode($mx);
?>			  
                ,
              "type": "value"
            }
          ],
          "thresholds": {
            "mode": "absolute",
            "steps": [
              {
                "color": "green",
                "value": null
              },
              {
                "color": "red",
                "value": 80
              }
            ]
          }
        },
        "overrides": []
      },
      "gridPos": {
        "h": 23,
        "w": 24,
        "x": 0,
        "y": 0
      },
      "id": 2,
      "options": {
        "colorMode": "background",
        "graphMode": "none",
        "justifyMode": "center",
        "orientation": "auto",
        "reduceOptions": {
          "calcs": [
            "lastNotNull"
          ],
          "fields": "",
          "values": true
        },
        "textMode": "auto"
      },
      "pluginVersion": "9.2.2",
      "targets": [
        {
          "asset": "",
          "context": "Actual",
          "datasource": {
            "type": "ardi-grafana-source",
            "uid": "${DS_ARDI_SERVER}"
          },
          "property": "",
          "query": "'<?php echo $activeprop->name;?>' PROPERTY ALLPOINTS",
          "refId": "A",
          "seriesname": "",
          "timeoffset": 0,
          "type": "Query",
          "xaxis": "Profile",
          "yaxis": "None"
        }
      ],
      "title": "<?php echo $friendlyname;?>",
      "transformations": [
        {
          "id": "limit",
          "options": {
            "limitField": 1
          }
        }
      ],
      "type": "stat"
    }
  ],
  "schemaVersion": 37,
  "style": "dark",
  "tags": [],
  "templating": {
    "list": []
  },
  "time": {
    "from": "now-6h",
    "to": "now"
  },
  "timepicker": {},
  "timezone": "",
  "title": "<?php echo $friendlyname;?>",
  "uid": "<?php echo generateRandomString(9);?>",
  "version": 2,
  "weekStart": ""
}
