<?php

$id = $_REQUEST['id'];

include($installfolder.'/model/property.php');

$allprops = Properties::GetAllProperties();
foreach($allprops as $px)
{
	if ($px->id == $id)
	{
		$activeprop = $px;
		break;
	}
}

function generateRandomString($length = 8) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[random_int(0, $charactersLength - 1)];
    }
    return $randomString;
}

$friendlyname = $activeprop->name;

$pieces = explode(" - ",$friendlyname);
if (count($pieces) > 1)
{
	$friendlyname = $pieces[0].' '.$pieces[1];
}

header('Content-Type: application/json');
header('Content-Disposition: attachment; filename="'.$activeprop->name.' Heatmap Grafana Dashboard.json"');
?>
{
  "__inputs": [
    {
      "name": "DS_ARDI_SERVER",
      "label": "ARDI Server",
      "description": "",
      "type": "datasource",
      "pluginId": "ardi-grafana-source",
      "pluginName": "ARDI"
    }
  ],
  "__elements": {},
  "__requires": [
    {
      "type": "datasource",
      "id": "ardi-grafana-source",
      "name": "ARDI",
      "version": "0.1.5"
    },
    {
      "type": "grafana",
      "id": "grafana",
      "name": "Grafana",
      "version": "9.2.2"
    },
    {
      "type": "panel",
      "id": "heatmap",
      "name": "Heatmap",
      "version": ""
    }
  ],
  "annotations": {
    "list": [
      {
        "builtIn": 1,
        "datasource": {
          "type": "grafana",
          "uid": "-- Grafana --"
        },
        "enable": true,
        "hide": true,
        "iconColor": "rgba(0, 211, 255, 1)",
        "name": "Annotations & Alerts",
        "target": {
          "limit": 100,
          "matchAny": false,
          "tags": [],
          "type": "dashboard"
        },
        "type": "dashboard"
      }
    ]
  },
  "editable": true,
  "fiscalYearStartMonth": 0,
  "graphTooltip": 0,
  "id": null,
  "links": [],
  "liveNow": false,
  "panels": [
    {
      "datasource": {
        "type": "ardi-grafana-source",
        "uid": "${DS_ARDI_SERVER}"
      },
      "description": "",
      "fieldConfig": {
        "defaults": {
          "custom": {
            "hideFrom": {
              "legend": false,
              "tooltip": false,
              "viz": false
            },
            "scaleDistribution": {
              "type": "linear"
            }
          }
        },
        "overrides": []
      },
      "gridPos": {
        "h": 23,
        "w": 24,
        "x": 0,
        "y": 0
      },
      "id": 2,
      "options": {
        "calculate": false,
        "cellGap": 0,
        "color": {
          "exponent": 0.5,
          "fill": "dark-orange",
          "mode": "scheme",
          "reverse": false,
          "scale": "exponential",
          "scheme": "Viridis",
          "steps": 64
        },
        "exemplars": {
          "color": "rgba(255,0,255,0.7)"
        },
        "filterValues": {
          "le": 1e-9
        },
        "legend": {
          "show": true
        },
        "rowsFrame": {
          "layout": "auto"
        },
        "tooltip": {
          "show": true,
          "yHistogram": false
        },
        "yAxis": {
          "axisPlacement": "hidden",
          "reverse": false
        }
      },
      "pluginVersion": "9.2.2",
      "targets": [
        {
          "asset": "",
          "context": "Actual",
          "datasource": {
            "type": "ardi-grafana-source",
            "uid": "${DS_ARDI_SERVER}"
          },
          "property": "",
          "query": "'<?php echo $activeprop->name;?>' ALLPOINTS {%%,\"grain\":-400} GETHISTORY",
          "refId": "A",
          "seriesname": "",
          "timeoffset": 0,
          "type": "Query",
          "xaxis": "Profile",
          "yaxis": "None"
        }
      ],
      "title": "<?php echo $friendlyname;?> Heatmap",
      "transformations": [],
      "type": "heatmap"
    }
  ],
  "refresh": "1m",
  "schemaVersion": 37,
  "style": "dark",
  "tags": [],
  "templating": {
    "list": []
  },
  "time": {
    "from": "now-1h",
    "to": "now"
  },
  "timepicker": {},
  "timezone": "",
  "title": "<?php echo $friendlyname;?> Heatmap",
  "uid": "<?php echo generateRandomString(9);?>",
  "version": 2,
  "weekStart": ""
}