<?php

$id = $_REQUEST['id'];

include($installfolder.'/model/property.php');

$allprops = Properties::GetAllProperties();
foreach($allprops as $px)
{
	if ($px->id == $id)
	{
		$activeprop = $px;
		break;
	}
}

function generateRandomString($length = 8) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[random_int(0, $charactersLength - 1)];
    }
    return $randomString;
}

$friendlyname = $activeprop->name;

$pieces = explode(" - ",$friendlyname);
if (count($pieces) > 1)
{
	$friendlyname = $pieces[0].' '.$pieces[1];
}

header('Content-Type: application/json');
header('Content-Disposition: attachment; filename="'.$activeprop->name.' Trend Grafana Dashboard.json"');
?>
{
  "__inputs": [
    {
      "name": "DS_ARDI_SERVER",
      "label": "ARDI Server",
      "description": "",
      "type": "datasource",
      "pluginId": "ardi-grafana-source",
      "pluginName": "ARDI"
    }
  ],
  "__elements": {},
  "__requires": [
    {
      "type": "datasource",
      "id": "ardi-grafana-source",
      "name": "ARDI",
      "version": "0.1.5"
    },
    {
      "type": "grafana",
      "id": "grafana",
      "name": "Grafana",
      "version": "9.2.2"
    },
    {
      "type": "panel",
      "id": "heatmap",
      "name": "Heatmap",
      "version": ""
    }
  ],
  "annotations": {
    "list": [
      {
        "builtIn": 1,
        "datasource": {
          "type": "grafana",
          "uid": "-- Grafana --"
        },
        "enable": true,
        "hide": true,
        "iconColor": "rgba(0, 211, 255, 1)",
        "name": "Annotations & Alerts",
        "target": {
          "limit": 100,
          "matchAny": false,
          "tags": [],
          "type": "dashboard"
        },
        "type": "dashboard"
      }
    ]
  },
  "editable": true,
  "fiscalYearStartMonth": 0,
  "graphTooltip": 0,
  "id": null,
  "links": [],
  "liveNow": false,
  "panels": [
    {
      "datasource": {
        "type": "ardi-grafana-source",
        "uid": "${DS_ARDI_SERVER}"
      },
      "description": "",
      "fieldConfig": {
        "defaults": {
          "color": {
            "mode": "palette-classic"
          },
          "custom": {
            "axisCenteredZero": false,
            "axisColorMode": "text",
            "axisLabel": "",
            "axisPlacement": "auto",
            "barAlignment": 0,
            "drawStyle": "line",
            "fillOpacity": 0,
            "gradientMode": "none",
            "hideFrom": {
              "legend": false,
              "tooltip": false,
              "viz": false
            },
            "lineInterpolation": "linear",
            "lineWidth": 1,
            "pointSize": 5,
            "scaleDistribution": {
              "type": "linear"
            },
            "showPoints": "auto",
            "spanNulls": false,
            "stacking": {
              "group": "A",
              "mode": "none"
            },
            "thresholdsStyle": {
              "mode": "off"
            }
          },
          "mappings": [],
          "thresholds": {
            "mode": "absolute",
            "steps": [
              {
                "color": "green",
                "value": null
              },
              {
                "color": "red",
                "value": 80
              }
            ]
          }
        },
        "overrides": []
      },
      "gridPos": {
        "h": 23,
        "w": 24,
        "x": 0,
        "y": 0
      },
      "id": 2,
      "options": {
        "legend": {
          "calcs": [],
          "displayMode": "list",
          "placement": "bottom",
          "showLegend": true
        },
        "tooltip": {
          "mode": "single",
          "sort": "none"
        }
      },
      "targets": [
        {
          "asset": "",
          "context": "Actual",
          "datasource": {
            "type": "ardi-grafana-source",
            "uid": "${DS_ARDI_SERVER}"
          },
          "property": "",
          "query": "'<?php echo $activeprop->name;?>' ALLPOINTS {} GETHISTORY",
          "refId": "A",
          "seriesname": "",
          "timeoffset": 0,
          "type": "Query",
          "xaxis": "Profile",
          "yaxis": "None"
        }
      ],
      "title": "<?php echo $friendlyname;?>",
      "type": "timeseries"
    }
  ],
  "refresh": "1m",
  "schemaVersion": 37,
  "style": "dark",
  "tags": [],
  "templating": {
    "list": []
  },
  "time": {
    "from": "now-1h",
    "to": "now"
  },
  "timepicker": {},
  "timezone": "",
  "title": "<?php echo $friendlyname;?> Heatmap",
  "uid": "<?php echo generateRandomString(9);?>",
  "version": 2,
  "weekStart": ""
}