<?php

$for = strtolower($_REQUEST['value']);

$hits = array();

$path = $sitefolder.'/addons';
if (!file_exists($path))
{
	mkdir($path);
}
$path .= '/grafana.txt';

$apikey = "";

if (file_exists($path))
{
	$url = file_get_contents($path);
	$bits = explode('|',$url);
	$url = $bits[0];
	if (count($bits) > 1)
		$apikey = $bits[1];
}

if ($apikey == "")
{
	header('Content-Type: application/json');
	echo json_encode($hits);
}

$apiurl = $url.'/api/search?query='.urlencode($for);
//echo 'Requesting '.$apiurl;

$options = [
	"http" => [
		"method" => "GET",
		"header" => "Authorization: Bearer ".$apikey."\r\n"
	]
];

$context = stream_context_create($options);

//Send a request to the Grafana server...
$content = file_get_contents($apiurl,false,$context);
//print("Response: ".$content);

if ($content != null)
{
	$content = json_decode($content,true);
	foreach($content as $res)
	{
		if ($res['type'] == 'dash-db')
		{
			$ht = array();
			$ht['score'] = 400;
			$ht['method'] = 'Grafana Dashboard';
			$ht['url'] = $url.'/d/'.$res['uid'];
			$ht['name'] = $res['title'];
			$hits[] = $ht;
		}
	}
}

header('Content-Type: application/json');
echo json_encode($hits);

?>